/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import net.yacy.document.parser.html.ContentScraper;
import net.yacy.document.parser.html.Scraper;
import net.yacy.kelondro.io.CharBuffer;

public final class TransformerWriter
extends Writer {
    public static final char lb = '<';
    public static final char rb = '>';
    public static final char dash = '-';
    public static final char excl = '!';
    public static final char singlequote = '\'';
    public static final char doublequote = '\"';
    private final OutputStream outStream;
    private OutputStreamWriter out;
    private CharBuffer buffer;
    private Stack<ContentScraper.Tag> tagStack;
    private final Scraper scraper;
    private boolean inSingleQuote;
    private boolean inDoubleQuote;
    private boolean inComment;
    private boolean binaryUnsuspect;
    private final boolean passbyIfBinarySuspect;

    public TransformerWriter(OutputStream outStream, Charset charSet, Scraper scraper, boolean passbyIfBinarySuspect) {
        this(outStream, charSet, scraper, passbyIfBinarySuspect, 64);
    }

    public TransformerWriter(OutputStream outStream, Charset charSet, Scraper scraper, boolean passbyIfBinarySuspect, int initialBufferSize) {
        this.outStream = outStream;
        this.scraper = scraper;
        this.buffer = new CharBuffer(0x2800000, initialBufferSize);
        this.tagStack = new Stack();
        this.inSingleQuote = false;
        this.inDoubleQuote = false;
        this.inComment = false;
        this.binaryUnsuspect = true;
        this.passbyIfBinarySuspect = passbyIfBinarySuspect;
        if (this.outStream != null) {
            this.out = new OutputStreamWriter(this.outStream, charSet == null ? Charset.defaultCharset() : charSet);
        }
    }

    public static char[] genTag0raw(String tagname, boolean opening, char[] tagopts) {
        CharBuffer bb = new CharBuffer(0x2800000, tagname.length() + tagopts.length + 3);
        bb.append('<');
        if (!opening) {
            bb.append('/');
        }
        bb.append(tagname);
        if (tagopts.length > 0) {
            bb.append(tagopts);
        }
        bb.append('>');
        char[] result = bb.getChars();
        bb.close();
        return result;
    }

    public static char[] genTag1raw(String tagname, char[] tagopts, char[] text) {
        CharBuffer bb = new CharBuffer(0x2800000, 2 * tagname.length() + tagopts.length + text.length + 5);
        bb.append('<').append(tagname);
        if (tagopts.length > 0) {
            bb.append(tagopts);
        }
        bb.append('>');
        bb.append(text);
        bb.append('<').append('/').append(tagname).append('>');
        char[] result = bb.getChars();
        bb.close();
        return result;
    }

    public static char[] genTag0(String tagname, Properties tagopts, char quotechar) {
        char[] tagoptsx = tagopts.isEmpty() ? null : TransformerWriter.genOpts(tagopts, quotechar);
        CharBuffer bb = new CharBuffer(0x2800000, tagname.length() + (tagoptsx == null ? 0 : tagoptsx.length + 1) + tagname.length() + 2);
        bb.append('<').append(tagname);
        if (tagoptsx != null) {
            bb.appendSpace();
            bb.append(tagoptsx);
        }
        bb.append('>');
        char[] result = bb.getChars();
        bb.close();
        return result;
    }

    public static char[] genTag1(String tagname, Properties tagopts, char[] text, char quotechar) {
        char[] gt0 = TransformerWriter.genTag0(tagname, tagopts, quotechar);
        CharBuffer cb = new CharBuffer(0x2800000, gt0, gt0.length + text.length + tagname.length() + 3);
        cb.append(text).append('<').append('/').append(tagname).append('>');
        char[] result = cb.getChars();
        cb.close();
        return result;
    }

    public static char[] genOpts(Properties prop, char quotechar) {
        Enumeration<?> e = prop.propertyNames();
        CharBuffer bb = new CharBuffer(0x2800000, prop.size() * 40);
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            bb.appendSpace().append(key).append('=').append(quotechar);
            bb.append(prop.getProperty(key));
            bb.append(quotechar);
        }
        char[] result = bb.length() > 0 ? bb.getChars(1) : bb.getChars();
        bb.close();
        return result;
    }

    private char[] tokenProcessor(char[] in, char quotechar) {
        if (in.length == 0) {
            return in;
        }
        if (in.length <= 2 || in[0] != '<') {
            return this.filterTag(in);
        }
        if (in[1] == '/') {
            int tagend = TransformerWriter.tagEnd(in, 2);
            String tag = new String(in, 2, tagend - 2).toLowerCase(Locale.ROOT);
            char[] text = new char[in.length - tagend - 1];
            System.arraycopy(in, tagend, text, 0, in.length - tagend - 1);
            return this.filterTag(text, quotechar, tag, false);
        }
        if (this.tagStack.size() > 0 && ((ContentScraper.Tag)this.tagStack.lastElement()).name.equals(ContentScraper.TagName.script.name())) {
            return new char[0];
        }
        int tagend = TransformerWriter.tagEnd(in, 1);
        String tag = new String(in, 1, tagend - 1).toLowerCase(Locale.ROOT);
        char[] text = new char[in.length - tagend - 1];
        System.arraycopy(in, tagend, text, 0, in.length - tagend - 1);
        return this.filterTag(text, quotechar, tag, true);
    }

    private char[] filterTag(char[] content) {
        if (this.tagStack.size() == 0) {
            if (this.scraper != null && content.length > 0) {
                this.scraper.scrapeText(content, null);
            }
            return content;
        }
        if (this.scraper != null) {
            this.scraper.scrapeText(content, (ContentScraper.Tag)this.tagStack.lastElement());
        }
        ((ContentScraper.Tag)this.tagStack.lastElement()).content.append(content);
        return new char[0];
    }

    private char[] filterTag(char[] content, char quotechar, String tagname, boolean opening) {
        assert (tagname != null);
        if (this.tagStack.size() == 0) {
            if (opening) {
                return this.filterTagOpening(tagname, content);
            }
            return TransformerWriter.genTag0raw(tagname, false, content);
        }
        if (tagname.equals("!")) {
            this.filterTag(content);
        }
        if (opening) {
            ((ContentScraper.Tag)this.tagStack.lastElement()).content.append(this.filterTagOpening(tagname, content));
            return new char[0];
        }
        if (!tagname.equalsIgnoreCase(((ContentScraper.Tag)this.tagStack.lastElement()).name)) {
            ((ContentScraper.Tag)this.tagStack.lastElement()).content.append(TransformerWriter.genTag0raw(tagname, opening, content));
            return new char[0];
        }
        return this.filterTagCloseing(quotechar);
    }

    private char[] filterTagOpening(String tagname, char[] content) {
        CharBuffer charBuffer = new CharBuffer(0x2800000, content);
        ContentScraper.Tag tag = new ContentScraper.Tag(tagname, this.scraper.defaultValency(), charBuffer.propParser());
        charBuffer.close();
        ContentScraper.Tag parentTag = this.tagStack.size() > 0 ? (ContentScraper.Tag)this.tagStack.lastElement() : null;
        if (this.scraper != null) {
            tag.setValency(this.scraper.tagValency(tag, parentTag));
        }
        if (this.scraper != null) {
            this.scraper.scrapeAnyTagOpening(tag);
        }
        if (this.scraper != null && this.scraper.isTag0(tagname)) {
            this.scraper.scrapeTag0(tag);
        }
        if (this.scraper != null && this.scraper.isTag1(tagname)) {
            this.tagStack.push(tag);
            return new char[0];
        }
        return TransformerWriter.genTag0raw(tagname, true, content);
    }

    private char[] filterTagCloseing(char quotechar) {
        ContentScraper.Tag tag = (ContentScraper.Tag)this.tagStack.lastElement();
        if (this.scraper != null) {
            this.scraper.scrapeTag1(tag);
        }
        char[] ret = TransformerWriter.genTag1(tag.name, tag.opts, tag.content.getChars(), quotechar);
        if (this.scraper != null && this.scraper.isTag1(tag.name)) {
            this.tagStack.pop();
            if (this.tagStack.size() > 0) {
                ((ContentScraper.Tag)this.tagStack.lastElement()).content.append(ret);
            }
        }
        return ret;
    }

    private char[] filterFinalize(char quotechar) {
        if (this.tagStack.size() == 0) {
            return new char[0];
        }
        if (this.scraper != null) {
            this.scraper.scrapeTag1((ContentScraper.Tag)this.tagStack.lastElement());
        }
        char[] ret = TransformerWriter.genTag1(((ContentScraper.Tag)this.tagStack.lastElement()).name, ((ContentScraper.Tag)this.tagStack.lastElement()).opts, ((ContentScraper.Tag)this.tagStack.lastElement()).content.getChars(), quotechar);
        this.tagStack.pop();
        return ret;
    }

    private static int tagEnd(char[] tag, int start) {
        for (int i = start; i < tag.length; ++i) {
            char c = tag[i];
            if (c == '!' || c == '-' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return i;
        }
        return tag.length - 1;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.binaryUnsuspect && TransformerWriter.binaryHint((char)c)) {
            this.binaryUnsuspect = false;
            if (this.passbyIfBinarySuspect) {
                this.close();
            }
        }
        if (this.binaryUnsuspect || !this.passbyIfBinarySuspect) {
            if (this.inSingleQuote) {
                this.buffer.append(c);
                if (c == 39) {
                    this.inSingleQuote = false;
                }
                if (c == 62 && this.buffer.length() > 0 && this.buffer.charAt(0) == '<') {
                    this.inSingleQuote = false;
                    char[] filtered = this.tokenProcessor(this.buffer.getChars(), '\'');
                    if (this.out != null) {
                        this.out.write(filtered);
                    }
                    this.buffer.reset();
                }
            } else if (this.inDoubleQuote) {
                this.buffer.append(c);
                if (c == 34) {
                    this.inDoubleQuote = false;
                }
                if (c == 62 && this.buffer.length() > 0 && this.buffer.charAt(0) == '<') {
                    this.inDoubleQuote = false;
                    char[] filtered = this.tokenProcessor(this.buffer.getChars(), '\"');
                    if (this.out != null) {
                        this.out.write(filtered);
                    }
                    this.buffer.reset();
                }
            } else if (this.inComment) {
                this.buffer.append(c);
                if (c == 62 && this.buffer.length() > 6 && this.buffer.charAt(this.buffer.length() - 3) == '-') {
                    this.inComment = false;
                    char[] comment = this.buffer.getChars();
                    if (this.scraper != null) {
                        this.scraper.scrapeComment(comment);
                    }
                    if (this.out != null) {
                        this.out.write(comment);
                    }
                    this.buffer.reset();
                }
            } else if (this.buffer.isEmpty()) {
                if (c == 62) {
                    if (this.out != null) {
                        this.out.write(c);
                    }
                } else {
                    this.buffer.append(c);
                }
            } else if (this.buffer.length() > 0 && this.buffer.charAt(0) == '<') {
                if (c == 39) {
                    this.inSingleQuote = true;
                }
                if (c == 34) {
                    this.inDoubleQuote = true;
                }
                if (this.buffer.length() >= 3 && this.buffer.charAt(1) == '!' && this.buffer.charAt(2) == '-' && c == 45) {
                    this.inComment = true;
                    this.buffer.append(c);
                } else if (c == 62) {
                    this.buffer.append(c);
                    char[] filtered = this.tokenProcessor(this.buffer.getChars(), '\"');
                    if (this.out != null) {
                        this.out.write(filtered);
                    }
                    this.buffer.reset();
                } else if (c == 60) {
                    if (this.buffer.length() > 0) {
                        char[] filtered = this.tokenProcessor(this.buffer.getChars(), '\"');
                        if (this.out != null) {
                            this.out.write(filtered);
                        }
                    }
                    this.buffer.reset();
                    this.buffer.append(c);
                } else {
                    this.buffer.append(c);
                }
            } else if (c == 60) {
                if (this.buffer.length() > 0) {
                    char[] filtered = this.tokenProcessor(this.buffer.getChars(), '\"');
                    if (this.out != null) {
                        this.out.write(filtered);
                    }
                }
                this.buffer.reset();
                this.buffer.append(c);
            } else {
                this.buffer.append(c);
            }
        } else {
            this.out.write(c);
        }
    }

    @Override
    public void write(char[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(char[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = off; i < len - off; ++i) {
            this.write(b[i]);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.scraper != null) {
            this.scraper.finish();
        }
    }

    @Override
    public void close() throws IOException {
        char quotechar;
        this.flush();
        char c = quotechar = this.inSingleQuote ? (char)'\'' : '\"';
        if (this.buffer != null) {
            if (this.buffer.length() > 0) {
                char[] filtered = this.tokenProcessor(this.buffer.getChars(), quotechar);
                if (this.out != null) {
                    this.out.write(filtered);
                }
            }
            this.buffer.close();
            this.buffer = null;
        }
        char[] finalized = this.filterFinalize(quotechar);
        if (this.out != null) {
            if (finalized != null) {
                this.out.write(finalized);
            }
            this.out.flush();
            this.out.close();
        }
        this.tagStack.clear();
        this.tagStack = null;
        if (this.scraper != null) {
            this.scraper.finish();
        }
    }

    private static boolean binaryHint(char c) {
        if (c > '\u001f') {
            return false;
        }
        return c <= '\u0007' || c > '\r';
    }

    public boolean binarySuspect() {
        return !this.binaryUnsuspect;
    }
}

