/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.html;

import java.util.Comparator;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;

public class ImageEntry
implements Comparable<ImageEntry>,
Comparator<ImageEntry> {
    private final DigestURL imageurl;
    private AnchorURL linkurl;
    private final String alt;
    private final int width;
    private final int height;
    private final long fileSize;

    public ImageEntry(DigestURL imageurl, String alt, int width, int height, long fileSize) {
        assert (imageurl != null);
        this.imageurl = imageurl;
        this.linkurl = null;
        this.alt = alt;
        this.width = width;
        this.height = height;
        this.fileSize = fileSize;
    }

    public DigestURL url() {
        return this.imageurl;
    }

    public void setLinkurl(AnchorURL linkurl) {
        this.linkurl = linkurl;
    }

    public AnchorURL linkurl() {
        return this.linkurl;
    }

    public String alt() {
        return this.alt;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public String toString() {
        return "<img url=\"" + this.imageurl.toNormalform(false) + "\"" + (String)(this.alt != null && this.alt.length() > 0 ? " alt=\"" + this.alt + "\"" : "") + (String)(this.width >= 0 ? " width=\"" + this.width + "\"" : "") + (String)(this.height >= 0 ? " height=\"" + this.height + "\"" : "") + ">";
    }

    public int hashCode() {
        if (this.width < 0 || this.height < 0) {
            return this.imageurl.hashCode() & 0xFFFF;
        }
        return Short.MAX_VALUE - (this.width * this.height >> 9 & Short.MAX_VALUE) << 16 | this.imageurl.hashCode() & 0xFFFF;
    }

    @Override
    public int compareTo(ImageEntry h) {
        int ohc;
        assert (this.imageurl != null);
        if (this.imageurl.toNormalform(true).equals(h.imageurl.toNormalform(true))) {
            return 0;
        }
        int thc = this.hashCode();
        if (thc < (ohc = h.hashCode())) {
            return -1;
        }
        if (thc > ohc) {
            return 1;
        }
        return this.imageurl.toNormalform(true).compareTo(h.imageurl.toNormalform(true));
    }

    @Override
    public int compare(ImageEntry o1, ImageEntry o2) {
        return o1.compareTo(o2);
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof ImageEntry) {
            return this.compareTo((ImageEntry)o) == 0;
        }
        return super.equals(o);
    }
}

