/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Set;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.TagValency;
import org.apache.commons.compress.compressors.CompressorInputStream;

public abstract class AbstractCompressorParser
extends AbstractParser
implements Parser {
    protected static final int DEFAULT_DEPTH = 999;

    public AbstractCompressorParser(String name) {
        super(name);
    }

    protected abstract CompressorInputStream createDecompressStream(InputStream var1) throws IOException;

    protected abstract String getUncompressedFilename(String var1);

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        return this.parseWithLimits(location, mimeType, charset, scraper, timezoneOffset, source, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    public Document[] parseWithLimits(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes) throws Parser.Failure {
        Document maindoc;
        CompressorInputStream compressedInStream;
        try {
            compressedInStream = this.createDecompressStream(source);
        }
        catch (IOException | RuntimeException e) {
            throw new Parser.Failure("Unexpected error while parsing compressed file. " + e.getMessage(), location);
        }
        try {
            maindoc = AbstractCompressorParser.createMainDocument(location, mimeType, charset, this);
            Document[] docs = this.parseCompressedInputStream(location, null, defaultValency, valencySwitchTagNames, timezoneOffset, 999, compressedInStream, maxLinks, maxBytes);
            if (docs != null) {
                maindoc.addSubDocuments(docs);
                if (docs.length > 0 && docs[0].isPartiallyParsed()) {
                    maindoc.setPartiallyParsed(true);
                }
            }
        }
        catch (Parser.Failure e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new Parser.Failure("Unexpected error while parsing compressed file. " + e.getMessage(), location);
        }
        return new Document[]{maindoc};
    }

    protected static Document createMainDocument(DigestURL location, String mimeType, String charset, AbstractCompressorParser parser) {
        String filename = location.getFileName();
        return new Document(location, mimeType, charset, parser, null, null, AbstractParser.singleList(filename.isEmpty() ? location.toTokens() : MultiProtocolURL.unescape(filename)), null, null, null, null, 0.0, 0.0, null, null, null, null, false, new Date());
    }

    protected Document[] parseCompressedInputStream(DigestURL location, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, int timezoneOffset, int depth, CompressorInputStream compressedInStream, int maxLinks, long maxBytes) throws Parser.Failure {
        String compressedFileName = location.getFileName();
        String contentfilename = this.getUncompressedFilename(compressedFileName);
        String mime = TextParser.mimeOf(MultiProtocolURL.getFileExtension(contentfilename));
        try {
            String locationPath = location.getPath();
            String contentPath = locationPath.substring(0, locationPath.length() - compressedFileName.length()) + contentfilename;
            DigestURL contentLocation = new DigestURL(location.getProtocol(), location.getHost(), location.getPort(), contentPath);
            return TextParser.parseWithLimits(contentLocation, mime, charset, defaultValency, valencySwitchTagNames, timezoneOffset, depth, -1L, (InputStream)compressedInStream, maxLinks, maxBytes);
        }
        catch (MalformedURLException e) {
            throw new Parser.Failure("Unexpected error while parsing compressed file. " + e.getMessage(), location);
        }
    }

    @Override
    public boolean isParseWithLimitsSupported() {
        return true;
    }
}

