/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.language;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import java.util.ArrayList;
import net.yacy.cora.util.ConcurrentLog;

public final class Identificator {
    private Detector detector;
    private Language language;

    public Identificator() {
        try {
            this.detector = DetectorFactory.create();
        }
        catch (LangDetectException e) {
            ConcurrentLog.logException(e);
        }
    }

    public void add(String word) {
        if (word == null || this.detector == null) {
            return;
        }
        this.detector.append(" " + word);
    }

    public String getLanguage() {
        if (this.detector != null) {
            try {
                ArrayList probabilities = this.detector.getProbabilities();
                if (probabilities.isEmpty()) {
                    return null;
                }
                this.language = (Language)this.detector.getProbabilities().get(0);
            }
            catch (LangDetectException e) {
                return null;
            }
            if (this.language.prob > 0.3) {
                if (this.language.lang.length() == 2) {
                    return this.language.lang;
                }
                return this.language.lang.substring(0, 2);
            }
        }
        return null;
    }

    public double getProbability() {
        if (this.language != null) {
            return this.language.prob;
        }
        return 0.0;
    }
}

