/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.TagValency;

public abstract class AbstractParser
implements Parser {
    public static final ConcurrentLog log = new ConcurrentLog("PARSER");
    protected final Set<String> SUPPORTED_MIME_TYPES = new LinkedHashSet<String>();
    protected final Set<String> SUPPORTED_EXTENSIONS = new HashSet<String>();
    private final String name;

    public AbstractParser(String name) {
        this.name = name;
    }

    @Override
    public Document[] parse(DigestURL url, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        return this.parse(url, mimeType, charset, TagValency.EVAL, new HashSet<String>(), scraper, timezoneOffset, source);
    }

    @Override
    public Document[] parse(DigestURL url, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        return this.parse(url, mimeType, charset, scraper, timezoneOffset, source);
    }

    @Override
    public Document[] parseWithLimits(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes) throws UnsupportedOperationException, Parser.Failure, InterruptedException {
        return this.parseWithLimits(location, mimeType, charset, TagValency.EVAL, new HashSet<String>(), scraper, timezoneOffset, source, maxLinks, maxBytes);
    }

    @Override
    public Document[] parseWithLimits(DigestURL location, String mimeType, String charset, TagValency defaultValency, Set<String> valencySwitchTagNames, VocabularyScraper scraper, int timezoneOffset, InputStream source, int maxLinks, long maxBytes) throws Parser.Failure, InterruptedException, UnsupportedOperationException {
        return this.parseWithLimits(location, mimeType, charset, scraper, timezoneOffset, source, maxLinks, maxBytes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> supportedMimeTypes() {
        return this.SUPPORTED_MIME_TYPES;
    }

    @Override
    public Set<String> supportedExtensions() {
        return this.SUPPORTED_EXTENSIONS;
    }

    @Override
    public boolean equals(Object o) {
        return this.getName().equals(((Parser)o).getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public static List<String> singleList(String t) {
        ArrayList<String> c = new ArrayList<String>(1);
        if (t != null) {
            c.add(t);
        }
        return c;
    }

    @Override
    public boolean isParseWithLimitsSupported() {
        return false;
    }
}

