/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data.wiki;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.yacy.data.wiki.AbstractWikiParser;
import net.yacy.data.wiki.WikiParser;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.server.serverCore;

public class WikiCode
extends AbstractWikiParser
implements WikiParser {
    private static final String EMPTY = "";
    private static final String PIPE_ESCAPED = "&#124;";
    private static final Pattern REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private static final String HTML_OPEN_DEFINITION_DESCRIPTION = "<dd>";
    private static final String HTML_CLOSE_DEFINITION_DESCRIPTION = "</dd>";
    private static final String HTML_OPEN_DEFINITION_ITEM = "<dt>";
    private static final String HTML_CLOSE_DEFINITION_ITEM = "</dt>";
    private static final String HTML_OPEN_DEFINITION_LIST = "<dl>";
    private static final String HTML_CLOSE_DEFINITION_LIST = "</dl>";
    private static final String HTML_OPEN_UNORDERED_LIST = "<ul>";
    private static final String HTML_CLOSE_UNORDERED_LIST = "</ul>";
    private static final String HTML_CLOSE_BLOCKQUOTE = "</blockquote>";
    private static final String HTML_CLOSE_LIST_ELEMENT = "</li>";
    private static final String HTML_CLOSE_ORDERED_LIST = "</ol>";
    private static final String HTML_OPEN_BLOCKQUOTE = "<blockquote>";
    private static final String HTML_OPEN_LIST_ELEMENT = "<li>";
    private static final String HTML_OPEN_ORDERED_LIST = "<ol>";
    private static final String WIKI_CLOSE_LINK = "]]";
    private static final String WIKI_OPEN_LINK = "[[";
    private static final String WIKI_CLOSE_METADATA = "}}";
    private static final String WIKI_OPEN_METADATA = "{{";
    private static final String WIKI_CLOSE_EXTERNAL_LINK = "]";
    private static final String WIKI_OPEN_EXTERNAL_LINK = "[";
    private static final String WIKI_CLOSE_PRE_ESCAPED = "&lt;/pre&gt;";
    private static final String WIKI_HR_LINE = "----";
    private static final String WIKI_IMAGE = "Image:";
    private static final String WIKI_VIDEO_YOUTUBE = "Youtube:";
    private static final String WIKI_VIDEO_VIMEO = "Vimeo:";
    private static final String WIKI_OPEN_PRE_ESCAPED = "&lt;pre&gt;";
    private static final char ASTERISK = '*';
    private static final char ONE = '1';
    private static final char TWO = '2';
    private static final char THREE = '3';
    private static final char FOUR = '4';
    private static final char FIVE = '5';
    private static final char SIX = '6';
    private static final char WIKI_FORMATTED = ' ';
    private static final char WIKI_INDENTION = ':';
    private static final char WIKI_METADATA_PARAMETER_SEPARATOR = '|';
    private static final int LEN_WIKI_CLOSE_PRE_ESCAPED = "&lt;/pre&gt;".length();
    private static final int LEN_WIKI_OPEN_PRE_ESCAPED = "&lt;pre&gt;".length();
    private static final int LEN_WIKI_OPEN_LINK = "[[".length();
    private static final int LEN_WIKI_CLOSE_LINK = "]]".length();
    private static final int LEN_WIKI_IMAGE = "Image:".length();
    private static final int LEN_WIKI_VIDEO_YOUTUBE = "Youtube:".length();
    private static final int LEN_WIKI_VIDEO_VIMEO = "Vimeo:".length();
    private static final int LEN_WIKI_OPEN_EXTERNAL_LINK = "[".length();
    private static final int LEN_WIKI_CLOSE_EXTERNAL_LINK = "]".length();
    private static final int LEN_WIKI_HR_LINE = "----".length();
    private static final int LEN_PIPE_ESCAPED = "&#124;".length();
    private static final int LEN_WIKI_OPEN_METADATA = "{{".length();
    private static final int LEN_WIKI_CLOSE_METADATA = "}}".length();
    private static final String[] TABLE_PROPERTIES = new String[]{"rowspan", "colspan", "vspace", "hspace", "cellspacing", "cellpadding", "border"};
    private static final Map<String, String[]> PROPERTY_VALUES = new HashMap<String, String[]>();
    private static final String[] HEADLINE_TAGS = new String[]{Tags.HEADLINE_6.openWiki, Tags.HEADLINE_5.openWiki, Tags.HEADLINE_4.openWiki, Tags.HEADLINE_3.openWiki, Tags.HEADLINE_2.openWiki, Tags.HEADLINE_1.openWiki};
    private static final char[] HEADLINE_LEVEL = new char[]{'1', '2', '3', '4', '5', '6'};
    private final String tableStart = "&#123;&#124;";
    private final String newLine = "&#124;-";
    private final String cellDivider = "&#124;&#124;";
    private final String tableEnd = "&#124;&#125;";
    private final String attribDivider = "&#124;";
    private final int lenTableStart = this.tableStart.length();
    private final int lenCellDivider = this.cellDivider.length();
    private final int lenTableEnd = this.tableEnd.length();
    private final int lenAttribDivider = this.attribDivider.length();
    private String orderedListLevel = "";
    private String unorderedListLevel = "";
    private String defListLevel = "";
    private boolean processingCell = false;
    private boolean processingDefList = false;
    private final boolean escape = false;
    private final boolean escaped = false;
    private boolean newRowStart = false;
    private boolean noList = false;
    private boolean processingPreformattedText = false;
    private boolean preformattedSpanning = false;
    private boolean replacedHtmlAlready = false;
    private boolean processingTable = false;
    private int preindented = 0;
    private final TableOfContent tableOfContents = new TableOfContent();

    @Override
    protected String transform(String hostport, BufferedReader reader, int length) throws IOException {
        String line;
        StringBuilder out = new StringBuilder(length);
        while ((line = reader.readLine()) != null) {
            out.append(this.processLineOfWikiCode(hostport, line)).append(serverCore.CRLF_STRING);
        }
        out.insert(0, this.createTableOfContents());
        this.tableOfContents.clear();
        return out.toString();
    }

    private void processHeadline(StringBuilder input, int firstPosition, Tags tags, int secondPosition, String direlem) {
        direlem = input.substring(firstPosition + tags.openWikiLength, secondPosition);
        if (direlem != null) {
            int doubles = 0;
            Iterator<String> iterator = this.tableOfContents.iterator();
            while (iterator.hasNext()) {
                String element = iterator.next();
                assert (element != null);
                if (!element.substring(1).equals(direlem)) continue;
                ++doubles;
            }
            Object anchor = REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(direlem).replaceAll("_")).replaceAll(EMPTY);
            if (doubles > 0) {
                anchor = (String)anchor + "_" + (doubles + 1);
            }
            StringBuilder link = new StringBuilder();
            link.append("<a name=\"");
            link.append((String)anchor);
            link.append("\"></a>");
            link.append(tags.openHTML);
            link.append(direlem);
            link.append(tags.closeHTML);
            input.replace(firstPosition, secondPosition + tags.closeWikiLength, link.toString());
            if (Arrays.binarySearch(HEADLINE_TAGS, tags.openWiki) >= 0) {
                this.tableOfContents.add(tags.openWikiLength - 1 + direlem);
            }
        }
    }

    private String processTable(String line) {
        StringBuilder out = new StringBuilder();
        if (line.startsWith(this.tableStart) && !this.processingTable) {
            this.processingTable = true;
            this.newRowStart = true;
            out.append("<table");
            if (line.trim().length() > this.lenTableStart) {
                out.append((CharSequence)WikiCode.filterTableProperties(line.substring(this.lenTableStart).trim()));
            }
            out.append(">");
        } else if (line.startsWith(this.newLine) && this.processingTable) {
            if (!this.newRowStart) {
                out.append("\t</tr>\n");
            } else {
                this.newRowStart = false;
            }
            out.append("\t<tr>");
        } else if (line.startsWith(this.cellDivider) && this.processingTable) {
            out.append("\t\t<td");
            int cellEnd = line.indexOf(this.cellDivider, this.lenCellDivider) > 0 ? line.indexOf(this.cellDivider, this.lenCellDivider) : line.length();
            int propEnd = line.indexOf(this.attribDivider, this.lenCellDivider);
            int occImage = line.indexOf("[[Image:", this.lenCellDivider);
            int occEscape = line.indexOf("[=", this.lenCellDivider);
            propEnd = !(propEnd <= this.lenCellDivider || occImage <= propEnd && occImage >= 0 || occEscape <= propEnd && occEscape >= 0) ? line.indexOf(this.attribDivider, this.lenCellDivider) + this.lenAttribDivider : cellEnd;
            if (propEnd == cellEnd) {
                propEnd = this.lenCellDivider;
            } else {
                out.append((CharSequence)WikiCode.filterTableProperties(line.substring(this.lenCellDivider, propEnd - this.lenAttribDivider).trim()));
            }
            if (propEnd > cellEnd) {
                propEnd = this.lenCellDivider;
            }
            this.processingTable = false;
            this.processingCell = true;
            out.append(">");
            out.append(this.processTable(line.substring(propEnd, cellEnd).trim()));
            out.append("</td>");
            this.processingTable = true;
            this.processingCell = false;
            if (cellEnd < line.length()) {
                out.append("\n");
                out.append(this.processTable(line.substring(cellEnd)));
            }
        } else if (line.startsWith(this.tableEnd) && this.processingTable) {
            this.processingTable = false;
            out.append("\t</tr>\n</table>");
            out.append(line.substring(this.lenTableEnd));
        } else {
            out.append(line);
        }
        return out.toString();
    }

    private static StringBuilder filterTableProperties(String properties) {
        String[] values = properties.replaceAll("&quot;", EMPTY).split("[= ]");
        StringBuilder stringBuilder = new StringBuilder(properties.length());
        int numberOfValues = values.length;
        for (int i = 0; i < numberOfValues; ++i) {
            Object[] posVals;
            String key = values[i].trim();
            if ("nowrap".equals(key)) {
                WikiCode.appendKeyValuePair("nowrap", "nowrap", stringBuilder);
                continue;
            }
            if (i + 1 >= numberOfValues) continue;
            String value = values[++i].trim();
            if (!("summary".equals(key) || "bgcolor".equals(key) && value.matches("#{0,1}[0-9a-fA-F]{1,6}|[a-zA-Z]{3,}") || ("width".equals(key) || "height".equals(key)) && value.matches("\\d+%{0,1}") || (posVals = PROPERTY_VALUES.get(key)) != null && Arrays.binarySearch(posVals, value) >= 0) && (Arrays.binarySearch(TABLE_PROPERTIES, key) < 0 || !value.matches("\\d+"))) continue;
            WikiCode.appendKeyValuePair(key, value, stringBuilder);
        }
        return stringBuilder;
    }

    private static StringBuilder appendKeyValuePair(String key, String value, StringBuilder stringBuilder) {
        return stringBuilder.append(" ").append(key).append("=\"").append(value).append("\"");
    }

    private String processOrderedList(String line) {
        return this.processList(line, ListType.ORDERED);
    }

    private String processUnorderedList(String line) {
        return this.processList(line, ListType.UNORDERED);
    }

    private String processList(String line, ListType listType) {
        String ret;
        if (!this.noList) {
            String htmlCloseList;
            String htmlOpenList;
            char symbol;
            Object listLevel;
            if (ListType.ORDERED.equals((Object)listType)) {
                listLevel = this.orderedListLevel;
                symbol = '#';
                htmlOpenList = HTML_OPEN_ORDERED_LIST;
                htmlCloseList = HTML_CLOSE_ORDERED_LIST;
            } else if (ListType.UNORDERED.equals((Object)listType)) {
                listLevel = this.unorderedListLevel;
                symbol = '*';
                htmlOpenList = HTML_OPEN_UNORDERED_LIST;
                htmlCloseList = HTML_CLOSE_UNORDERED_LIST;
            } else {
                throw new IllegalArgumentException("Unknown list type " + listType);
            }
            if (line.startsWith((String)listLevel + symbol)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(htmlOpenList);
                stringBuilder.append(serverCore.CRLF_STRING);
                stringBuilder.append(HTML_OPEN_LIST_ELEMENT);
                stringBuilder.append(line.substring(((String)listLevel).length() + 1).trim());
                stringBuilder.append(HTML_CLOSE_LIST_ELEMENT);
                ret = stringBuilder.toString();
                listLevel = (String)listLevel + symbol;
            } else if (!((String)listLevel).isEmpty() && line.startsWith((String)listLevel)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(HTML_OPEN_LIST_ELEMENT);
                stringBuilder.append(line.substring(((String)listLevel).length()).trim());
                stringBuilder.append(HTML_CLOSE_LIST_ELEMENT);
                ret = stringBuilder.toString();
            } else if (!((String)listLevel).isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder tmp = new StringBuilder();
                int i = ((String)listLevel).length();
                while (!line.startsWith(((String)listLevel).substring(0, i))) {
                    tmp.append(htmlCloseList);
                    --i;
                }
                int startOfContent = ((String)(listLevel = ((String)listLevel).substring(0, i))).length();
                if (startOfContent > 0) {
                    stringBuilder.append((CharSequence)tmp);
                    stringBuilder.append(HTML_OPEN_LIST_ELEMENT);
                    stringBuilder.append(line.substring(startOfContent).trim());
                    stringBuilder.append(HTML_CLOSE_LIST_ELEMENT);
                } else {
                    stringBuilder.append((CharSequence)tmp);
                    stringBuilder.append(line.substring(startOfContent).trim());
                }
                ret = stringBuilder.toString();
            } else {
                ret = line;
            }
            if (ListType.ORDERED.equals((Object)listType)) {
                this.orderedListLevel = listLevel;
            } else if (ListType.UNORDERED.equals((Object)listType)) {
                this.unorderedListLevel = listLevel;
            }
        } else {
            ret = line;
        }
        return ret;
    }

    private String processDefinitionList(String line) {
        String ret;
        if (!this.noList) {
            if (line.startsWith(this.defListLevel + ";")) {
                String copyOfLine = line.substring(this.defListLevel.length() + 1);
                int positionOfOpeningTag = copyOfLine.indexOf(58, 0);
                if (positionOfOpeningTag > 0) {
                    String definitionItem = copyOfLine.substring(0, positionOfOpeningTag);
                    String definitionDescription = copyOfLine.substring(positionOfOpeningTag + 1);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(HTML_OPEN_DEFINITION_LIST);
                    stringBuilder.append(HTML_OPEN_DEFINITION_ITEM);
                    stringBuilder.append(definitionItem);
                    stringBuilder.append(HTML_CLOSE_DEFINITION_ITEM);
                    stringBuilder.append(HTML_OPEN_DEFINITION_DESCRIPTION);
                    stringBuilder.append(definitionDescription);
                    this.processingDefList = true;
                    ret = stringBuilder.toString();
                } else {
                    ret = line;
                }
                this.defListLevel = this.defListLevel + ";";
            } else if (!this.defListLevel.isEmpty() && line.startsWith(this.defListLevel)) {
                String copyOfLine = line.substring(this.defListLevel.length());
                int positionOfOpeningTag = copyOfLine.indexOf(58, 0);
                if (positionOfOpeningTag > 0) {
                    String definitionItem = copyOfLine.substring(0, positionOfOpeningTag);
                    String definitionDescription = copyOfLine.substring(positionOfOpeningTag + 1);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(HTML_OPEN_DEFINITION_ITEM);
                    stringBuilder.append(definitionItem);
                    stringBuilder.append(HTML_CLOSE_DEFINITION_ITEM);
                    stringBuilder.append(HTML_OPEN_DEFINITION_DESCRIPTION);
                    stringBuilder.append(definitionDescription);
                    this.processingDefList = true;
                    ret = stringBuilder.toString();
                } else {
                    ret = line;
                }
            } else if (!this.defListLevel.isEmpty()) {
                int i = this.defListLevel.length();
                String tmp = EMPTY;
                while (!line.startsWith(this.defListLevel.substring(0, i))) {
                    tmp = "</dd></dl>";
                    --i;
                }
                this.defListLevel = this.defListLevel.substring(0, i);
                int positionOfOpeningTag = this.defListLevel.length();
                if (!this.defListLevel.isEmpty()) {
                    String copyOfLine = line.substring(positionOfOpeningTag);
                    if ((positionOfOpeningTag = copyOfLine.indexOf(58, 0)) > 0) {
                        String definitionItem = copyOfLine.substring(0, positionOfOpeningTag);
                        String definitionDescription = copyOfLine.substring(positionOfOpeningTag + 1);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(tmp);
                        stringBuilder.append(HTML_OPEN_DEFINITION_ITEM);
                        stringBuilder.append(definitionItem);
                        stringBuilder.append(HTML_CLOSE_DEFINITION_ITEM);
                        stringBuilder.append(HTML_OPEN_DEFINITION_DESCRIPTION);
                        stringBuilder.append(definitionDescription);
                        this.processingDefList = true;
                        ret = stringBuilder.toString();
                    } else {
                        ret = line;
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(tmp);
                    stringBuilder.append(line.substring(positionOfOpeningTag));
                    ret = stringBuilder.toString();
                }
            } else {
                ret = line;
            }
        } else {
            ret = line;
        }
        return ret;
    }

    private static String processLinksAndImages(String hostport, String line) {
        int p;
        String kv;
        Object kl;
        int positionOfClosingTag;
        int positionOfOpeningTag;
        int fromIndex = 0;
        while ((positionOfOpeningTag = ((String)line).indexOf(WIKI_OPEN_LINK, fromIndex)) >= 0 && (positionOfClosingTag = ((String)line).indexOf(WIKI_CLOSE_LINK, positionOfOpeningTag + LEN_WIKI_OPEN_LINK)) > positionOfOpeningTag) {
            kl = ((String)line).substring(positionOfOpeningTag + LEN_WIKI_OPEN_LINK, positionOfClosingTag);
            if (((String)kl).startsWith(WIKI_IMAGE)) {
                Object alt = EMPTY;
                Object align = EMPTY;
                kv = EMPTY;
                p = ((String)(kl = ((String)kl).substring(LEN_WIKI_IMAGE))).indexOf(PIPE_ESCAPED);
                if (p > 0) {
                    kv = ((String)kl).substring(p + LEN_WIKI_IMAGE);
                    kl = ((String)kl).substring(0, p);
                    p = kv.indexOf(PIPE_ESCAPED);
                    if (p > 0) {
                        align = kv.substring(0, p);
                        align = "bottom".equals(align) || "center".equals(align) || "left".equals(align) || "middle".equals(align) || "right".equals(align) || "top".equals(align) ? " align=\"" + (String)align + "\"" : EMPTY;
                        alt = " alt=\"" + kv.substring(p + LEN_WIKI_IMAGE) + "\"";
                    } else {
                        alt = " alt=\"" + kv + "\"";
                    }
                }
                if (((String)kl).indexOf("://", 0) < 1 && hostport != null && !hostport.isEmpty()) {
                    kl = "http://" + hostport + "/" + (String)kl;
                }
                line = ((String)line).substring(0, positionOfOpeningTag) + "<img src=\"" + (String)kl + "\"" + (String)align + (String)alt + ">" + ((String)line).substring(positionOfClosingTag + LEN_WIKI_CLOSE_LINK);
                fromIndex = positionOfClosingTag + LEN_WIKI_CLOSE_LINK;
                continue;
            }
            if (((String)kl).startsWith(WIKI_VIDEO_YOUTUBE)) {
                kl = ((String)kl).substring(LEN_WIKI_VIDEO_YOUTUBE);
                line = ((String)line).substring(0, positionOfOpeningTag) + "<object width=\"425\" height=\"350\"><param name=\"movie\" value=\"http://www.youtube.com/v/" + (String)kl + "\"></param><param name=\"wmode\" value=\"transparent\"></param><embed src=\"http://www.youtube.com/v/" + (String)kl + "\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" width=\"425\" height=\"350\"></embed></object>";
                break;
            }
            if (((String)kl).startsWith(WIKI_VIDEO_VIMEO)) {
                kl = ((String)kl).substring(LEN_WIKI_VIDEO_VIMEO);
                line = ((String)line).substring(0, positionOfOpeningTag) + "<iframe src=\"http://player.vimeo.com/video/" + (String)kl + "\" width=\"425\" height=\"350\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>";
                break;
            }
            p = ((String)kl).indexOf(PIPE_ESCAPED);
            if (p > 0) {
                kv = ((String)kl).substring(p + LEN_PIPE_ESCAPED);
                kl = ((String)kl).substring(0, p);
            } else {
                kv = kl;
            }
            line = ((String)line).substring(0, positionOfOpeningTag) + "<a class=\"known\" href=\"Wiki.html?page=" + (String)kl + "\">" + kv + "</a>" + ((String)line).substring(positionOfClosingTag + LEN_WIKI_CLOSE_LINK);
            fromIndex = positionOfClosingTag + LEN_WIKI_CLOSE_LINK;
        }
        fromIndex = 0;
        while ((positionOfOpeningTag = ((String)line).indexOf(WIKI_OPEN_EXTERNAL_LINK, fromIndex)) >= 0 && (positionOfClosingTag = ((String)line).indexOf(WIKI_CLOSE_EXTERNAL_LINK, positionOfOpeningTag + LEN_WIKI_OPEN_EXTERNAL_LINK)) > positionOfOpeningTag) {
            kl = ((String)line).substring(positionOfOpeningTag + LEN_WIKI_OPEN_EXTERNAL_LINK, positionOfClosingTag);
            p = ((String)kl).indexOf(32, 0);
            if (p > 0) {
                kv = ((String)kl).substring(p + 1);
                kl = ((String)kl).substring(0, p);
            } else {
                kv = kl;
            }
            if (((String)kl).indexOf("://", 0) < 1 && hostport != null && !hostport.isEmpty()) {
                kl = "http://" + hostport + "/" + (String)kl;
            }
            line = ((String)line).substring(0, positionOfOpeningTag) + "<a class=\"extern\" href=\"" + (String)kl + "\">" + kv + "</a>" + ((String)line).substring(positionOfClosingTag + LEN_WIKI_CLOSE_EXTERNAL_LINK);
            fromIndex = positionOfClosingTag + LEN_WIKI_CLOSE_EXTERNAL_LINK;
        }
        return line;
    }

    private String processPreformattedText(String hostport, String line) {
        Objects.requireNonNull(this);
        int positionOfOpeningTag = ((String)line).indexOf(WIKI_OPEN_PRE_ESCAPED);
        int positionOfClosingTag = ((String)line).indexOf(WIKI_CLOSE_PRE_ESCAPED);
        if (positionOfOpeningTag >= 0 && positionOfClosingTag > 0) {
            if (positionOfOpeningTag < positionOfClosingTag) {
                StringBuilder preformattedText = new StringBuilder();
                preformattedText.append("<pre style=\"border:dotted;border-width:thin;\">");
                preformattedText.append(((String)line).substring(positionOfOpeningTag + LEN_WIKI_OPEN_PRE_ESCAPED, positionOfClosingTag));
                preformattedText.append("</pre>");
                line = this.processLineOfWikiCode(hostport, ((String)line).substring(0, positionOfOpeningTag).replaceAll("!pre!", "!pre!!") + "!pre!txt!" + ((String)line).substring(positionOfClosingTag + LEN_WIKI_CLOSE_PRE_ESCAPED).replaceAll("!pre!", "!pre!!"));
                line = ((String)line).replace("!pre!txt!", preformattedText.toString().replaceAll("!pre!", "!pre!!"));
                line = ((String)line).replaceAll("!pre!!", "!pre!");
            } else {
                this.processingPreformattedText = true;
                String temp1 = this.processLineOfWikiCode(hostport, ((String)line).substring(0, positionOfOpeningTag - 1).replaceAll("!tmp!", "!tmp!!") + "!tmp!txt!");
                this.noList = true;
                String temp2 = this.processLineOfWikiCode(hostport, ((String)line).substring(positionOfOpeningTag));
                this.noList = false;
                line = temp1.replaceAll("!tmp!txt!", temp2);
                line = ((String)line).replaceAll("!tmp!!", "!tmp!");
                this.processingPreformattedText = false;
            }
        } else if (positionOfOpeningTag >= 0 && !this.preformattedSpanning) {
            this.processingPreformattedText = true;
            StringBuilder openBlockQuoteTags = new StringBuilder();
            Object preformattedText = "<pre style=\"border:dotted;border-width:thin;\">" + ((String)line).substring(positionOfOpeningTag + LEN_WIKI_OPEN_PRE_ESCAPED);
            preformattedText = ((String)preformattedText).replaceAll("!pre!", "!pre!!");
            while (this.preindented < positionOfOpeningTag && positionOfOpeningTag < ((String)line).length() && ((String)line).substring(this.preindented, positionOfOpeningTag).charAt(0) == ':') {
                ++this.preindented;
                openBlockQuoteTags.append(HTML_OPEN_BLOCKQUOTE);
            }
            line = this.processLineOfWikiCode(hostport, ((String)line).substring(this.preindented, positionOfOpeningTag).replaceAll("!pre!", "!pre!!") + "!pre!txt!");
            line = openBlockQuoteTags + ((String)line).replace("!pre!txt!", (CharSequence)preformattedText);
            line = ((String)line).replaceAll("!pre!!", "!pre!");
            this.preformattedSpanning = true;
        } else if (positionOfClosingTag >= 0 && this.preformattedSpanning) {
            this.preformattedSpanning = false;
            StringBuilder endBlockQuoteTags = new StringBuilder();
            Object preformattedText = ((String)line).substring(0, positionOfClosingTag) + "</pre>";
            preformattedText = ((String)preformattedText).replaceAll("!pre!", "!pre!!");
            while (this.preindented > 0) {
                endBlockQuoteTags.append(HTML_CLOSE_BLOCKQUOTE);
                --this.preindented;
            }
            line = this.processLineOfWikiCode(hostport, "!pre!txt!" + ((String)line).substring(positionOfClosingTag + LEN_WIKI_CLOSE_PRE_ESCAPED).replaceAll("!pre!", "!pre!!"));
            line = ((String)line).replace("!pre!txt!", (CharSequence)preformattedText) + endBlockQuoteTags;
            line = ((String)line).replaceAll("!pre!!", "!pre!");
            this.processingPreformattedText = false;
        } else if (positionOfOpeningTag >= 0 && !this.preformattedSpanning) {
            int posTag;
            while ((posTag = ((String)line).indexOf(WIKI_CLOSE_PRE_ESCAPED)) >= 0) {
                line = ((String)line).substring(0, posTag) + ((String)line).substring(posTag + LEN_WIKI_CLOSE_PRE_ESCAPED);
            }
            line = this.processLineOfWikiCode(hostport, (String)line);
        }
        return line;
    }

    private StringBuilder createTableOfContents() {
        StringBuilder directory = new StringBuilder();
        int s = 0;
        int level = 1;
        int level1 = 0;
        int level2 = 0;
        int level3 = 0;
        int level4 = 0;
        int level5 = 0;
        int level6 = 0;
        int doubles = 0;
        Object anchorext = EMPTY;
        s = this.tableOfContents.size();
        if (s > 2) {
            directory.append("<table><tr><td><div class=\"WikiTOCBox\">\n");
            for (int i = 0; i < s && i < this.tableOfContents.size(); ++i) {
                Object element = this.tableOfContents.get(i);
                if (element == null) continue;
                doubles = 0;
                for (int j = 0; j < i && j < this.tableOfContents.size(); ++j) {
                    String b;
                    String a;
                    String d = this.tableOfContents.get(j);
                    if (d == null || d.isEmpty() || !(a = REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(d.substring(1)).replaceAll("_")).replaceAll(EMPTY)).equals(b = REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(((String)element).substring(1)).replaceAll("_")).replaceAll(EMPTY))) continue;
                    ++doubles;
                }
                if (doubles > 0) {
                    anchorext = "_" + (doubles + 1);
                }
                char l = ((String)element).charAt(0);
                String temp = EMPTY;
                if (Arrays.binarySearch(HEADLINE_LEVEL, l) >= 0 && !((String)element).isEmpty()) {
                    switch (l) {
                        case '6': {
                            if (level < 6) {
                                level = 6;
                                level6 = 0;
                            }
                            temp = ((String)element).substring(1);
                            element = level1 + "." + level2 + "." + level3 + "." + level4 + "." + level5 + "." + ++level6 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '5': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = ((String)element).substring(1);
                            element = level1 + "." + level2 + "." + level3 + "." + level4 + "." + ++level5 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '4': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = ((String)element).substring(1);
                            element = level1 + "." + level2 + "." + level3 + "." + ++level4 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '3': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = ((String)element).substring(1);
                            element = level1 + "." + level2 + "." + ++level3 + " " + temp;
                            directory.append("&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '2': {
                            if (level == 1) {
                                level2 = 0;
                                level = 2;
                            }
                            if (level == 3) {
                                level = 2;
                            }
                            temp = ((String)element).substring(1);
                            element = level1 + "." + ++level2 + " " + temp;
                            directory.append("&nbsp;&nbsp;<a href=\"#");
                            break;
                        }
                        case '1': {
                            if (level > 1) {
                                level = 1;
                                level2 = 0;
                                level3 = 0;
                                level4 = 0;
                                level5 = 0;
                                level6 = 0;
                            }
                            temp = ((String)element).substring(1);
                            element = ++level1 + ". " + temp;
                            directory.append("<a href=\"#");
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("illegal headline level: " + l);
                        }
                    }
                    directory.append(REGEX_NOT_CHAR_NUM_OR_UNDERSCORE_PATTERN.matcher(SPACE_PATTERN.matcher(temp).replaceAll("_")).replaceAll(EMPTY));
                    directory.append((String)anchorext);
                    directory.append("\" class=\"WikiTOC\">");
                    directory.append((String)element);
                    directory.append("</a><br />\n");
                }
                anchorext = EMPTY;
            }
            directory.append("</div></td></tr></table>\n");
        }
        return directory;
    }

    private String tagReplace(String input, Tags tags) {
        String direlem = null;
        StringBuilder stringBuilder = new StringBuilder(input);
        int firstPosition = 0;
        int secondPosition = 0;
        while ((firstPosition = stringBuilder.indexOf(tags.openWiki, secondPosition)) >= 0 && (secondPosition = stringBuilder.indexOf(tags.closeWiki, firstPosition + tags.openWikiLength)) >= 0) {
            if (Arrays.binarySearch(HEADLINE_TAGS, tags.openWiki) >= 0) {
                boolean beginsWith = true;
                for (int i = 0; i < firstPosition; ++i) {
                    if (stringBuilder.charAt(i) <= ' ') continue;
                    beginsWith = false;
                    break;
                }
                if (!beginsWith) continue;
                this.processHeadline(stringBuilder, firstPosition, tags, secondPosition, direlem);
                continue;
            }
            int oldLength = stringBuilder.length();
            stringBuilder.replace(firstPosition, firstPosition + tags.openWikiLength, tags.openHTML);
            stringBuilder.replace(secondPosition += stringBuilder.length() - oldLength, secondPosition + tags.closeWikiLength, tags.closeHTML);
        }
        return stringBuilder.toString();
    }

    private String processLineOfWikiCode(String hostport, String line) {
        line = WikiCode.processMetadata((String)line);
        if ((!this.replacedHtmlAlready || this.preformattedSpanning) && ((String)line).indexOf(WIKI_CLOSE_PRE_ESCAPED) < 0) {
            line = CharacterCoding.unicode2html((String)line, true);
            this.replacedHtmlAlready = true;
        }
        if (((String)line).indexOf(WIKI_OPEN_PRE_ESCAPED) >= 0 || ((String)line).indexOf(WIKI_CLOSE_PRE_ESCAPED) >= 0 || this.preformattedSpanning) {
            line = this.processPreformattedText(hostport, (String)line);
        } else {
            if (!((String)(line = this.processTable((String)line))).isEmpty() && ((String)line).charAt(0) == ' ') {
                line = "<tt>" + ((String)line).substring(1) + "</tt>";
            }
            if (((String)line).startsWith(WIKI_HR_LINE)) {
                line = "<hr />" + ((String)line).substring(LEN_WIKI_HR_LINE);
            }
            if (!((String)line).isEmpty() && ((String)line).charAt(0) == ':') {
                StringBuilder head = new StringBuilder();
                StringBuilder tail = new StringBuilder();
                while (!((String)line).isEmpty() && ((String)line).charAt(0) == ':') {
                    head.append(HTML_OPEN_BLOCKQUOTE);
                    tail.append(HTML_CLOSE_BLOCKQUOTE);
                    line = ((String)line).substring(1);
                }
                line = head + (String)line + tail;
            }
            line = this.tagReplace((String)line, Tags.HEADLINE_6);
            line = this.tagReplace((String)line, Tags.HEADLINE_5);
            line = this.tagReplace((String)line, Tags.HEADLINE_4);
            line = this.tagReplace((String)line, Tags.HEADLINE_3);
            line = this.tagReplace((String)line, Tags.HEADLINE_2);
            line = this.tagReplace((String)line, Tags.HEADLINE_1);
            line = this.tagReplace((String)line, Tags.EMPHASIZE_3);
            line = this.tagReplace((String)line, Tags.EMPHASIZE_2);
            line = this.tagReplace((String)line, Tags.EMPHASIZE_1);
            line = this.tagReplace((String)line, Tags.STRIKE);
            line = this.tagReplace((String)line, Tags.UNDERLINE);
            line = this.processUnorderedList((String)line);
            line = this.processOrderedList((String)line);
            line = this.processDefinitionList((String)line);
            line = WikiCode.processLinksAndImages(hostport, (String)line);
        }
        if (!this.processingPreformattedText) {
            this.replacedHtmlAlready = false;
        }
        if (!((String)line).endsWith(HTML_CLOSE_LIST_ELEMENT) && !this.processingDefList) {
            Objects.requireNonNull(this);
            if (!(this.processingPreformattedText || this.processingTable || this.processingCell)) {
                line = (String)line + "<br />";
            }
        }
        return line;
    }

    protected static String processMetadata(String line) {
        int closeIndex;
        int openIndex;
        StringBuilder processedLine = new StringBuilder(line);
        int fromIndex = 0;
        while ((openIndex = processedLine.indexOf(WIKI_OPEN_METADATA, fromIndex)) >= 0) {
            closeIndex = processedLine.indexOf(WIKI_CLOSE_METADATA, openIndex + LEN_WIKI_OPEN_METADATA);
            int nextOpenIndex = processedLine.indexOf(WIKI_OPEN_METADATA, openIndex + LEN_WIKI_OPEN_METADATA);
            while (nextOpenIndex >= 0 && nextOpenIndex < closeIndex && (closeIndex = processedLine.indexOf(WIKI_CLOSE_METADATA, closeIndex + LEN_WIKI_CLOSE_METADATA)) >= 0) {
                nextOpenIndex = processedLine.indexOf(WIKI_OPEN_METADATA, nextOpenIndex + LEN_WIKI_OPEN_METADATA);
            }
            if (closeIndex > 0) {
                String processedContent;
                String content = processedLine.substring(openIndex + LEN_WIKI_OPEN_METADATA, closeIndex);
                if (content.toLowerCase(Locale.ROOT).startsWith("coordinate")) {
                    String[] b = content.split("\\|");
                    float lon = Float.NaN;
                    float lat = Float.NaN;
                    float lonm = 0.0f;
                    float latm = 0.0f;
                    String lono = "E";
                    String lato = "N";
                    String name = EMPTY;
                    try {
                        for (String c : b) {
                            float l;
                            String[] d;
                            if (c.toLowerCase(Locale.ROOT).startsWith("name=")) {
                                name = c.substring(5);
                            }
                            if (c.toUpperCase().startsWith("NS=")) {
                                d = c.substring(3).split("/");
                                if (d.length == 1) {
                                    l = Float.parseFloat(d[0]);
                                    if (l < 0.0f) {
                                        lato = "S";
                                        l = -l;
                                    }
                                    lat = (float)Math.floor(l);
                                    latm = 60.0f * (l - lat);
                                } else if (d.length > 1) {
                                    lat = Float.parseFloat(d[0]);
                                    if (!d[1].isEmpty()) {
                                        latm = Float.parseFloat(d[1]);
                                    }
                                    if (d.length >= 3 && !d[2].isEmpty()) {
                                        latm += Float.parseFloat(d[2]) / 60.0f;
                                    }
                                    if (d[d.length - 1].toUpperCase().equals("S")) {
                                        lato = "S";
                                    }
                                }
                            }
                            if (!c.toUpperCase().startsWith("EW=")) continue;
                            d = c.substring(3).split("/");
                            if (d.length == 1) {
                                l = Float.parseFloat(d[0]);
                                if (l < 0.0f) {
                                    lono = "W";
                                    l = -l;
                                }
                                lon = (float)Math.floor(l);
                                lonm = 60.0f * (l - lon);
                                continue;
                            }
                            if (d.length <= 1) continue;
                            lon = Float.parseFloat(d[0]);
                            if (!d[1].isEmpty()) {
                                lonm = Float.parseFloat(d[1]);
                            }
                            if (d.length >= 3 && !d[2].isEmpty()) {
                                lonm += Float.parseFloat(d[2]) / 60.0f;
                            }
                            if (!d[d.length - 1].toUpperCase().equals("W")) continue;
                            lono = "W";
                        }
                    }
                    catch (NumberFormatException nsExcept) {
                        processedLine.delete(closeIndex, closeIndex + LEN_WIKI_CLOSE_METADATA);
                        processedLine.delete(openIndex, openIndex + LEN_WIKI_OPEN_METADATA);
                        fromIndex = openIndex;
                        continue;
                    }
                    if (!Float.isNaN(lon) && !Float.isNaN(lat)) {
                        String htmlCoord = (String)(name.length() > 0 ? " " + name : EMPTY) + " <nobr> " + lato + " " + lat + "\u00b0 " + latm + "'</nobr><nobr>" + lono + " " + lon + "\u00b0 " + lonm + "'</nobr> ";
                        processedLine.replace(openIndex, closeIndex + LEN_WIKI_CLOSE_METADATA, htmlCoord);
                        fromIndex = openIndex;
                        continue;
                    }
                    fromIndex = closeIndex;
                    continue;
                }
                int nestedOpenTagIndex = content.indexOf(WIKI_OPEN_METADATA);
                int lastNestedCloseTagIndex = content.lastIndexOf(WIKI_CLOSE_METADATA);
                if (nestedOpenTagIndex >= 0 && lastNestedCloseTagIndex > 0) {
                    processedContent = " " + content.substring(0, nestedOpenTagIndex).replace('|', ' ').replace('=', ' ') + content.substring(nestedOpenTagIndex, lastNestedCloseTagIndex) + content.substring(lastNestedCloseTagIndex).replace('|', ' ').replace('=', ' ') + " ";
                    fromIndex = openIndex;
                } else {
                    processedContent = " " + content.replace('|', ' ').replace('=', ' ') + " ";
                    fromIndex = openIndex + processedContent.length();
                }
                processedLine.replace(openIndex, closeIndex + LEN_WIKI_CLOSE_METADATA, processedContent);
                continue;
            }
            int nestedOpenTagIndex = processedLine.indexOf(WIKI_OPEN_METADATA, openIndex + LEN_WIKI_OPEN_METADATA);
            if (nestedOpenTagIndex >= 0) {
                processedLine.replace(openIndex, nestedOpenTagIndex, " " + processedLine.substring(openIndex + LEN_WIKI_OPEN_METADATA, nestedOpenTagIndex).replace('|', ' ').replace('=', ' '));
                fromIndex = openIndex;
                continue;
            }
            processedLine.replace(openIndex, processedLine.length(), " " + processedLine.substring(openIndex + LEN_WIKI_OPEN_METADATA).replace('|', ' ').replace('=', ' '));
            break;
        }
        fromIndex = 0;
        while ((closeIndex = processedLine.indexOf(WIKI_CLOSE_METADATA, fromIndex)) >= 0) {
            processedLine.replace(fromIndex, closeIndex, processedLine.substring(fromIndex, closeIndex).replace('|', ' ').replace('=', ' '));
            processedLine.delete(closeIndex, closeIndex + LEN_WIKI_CLOSE_METADATA);
            fromIndex = closeIndex;
        }
        String result = processedLine.toString();
        if (result.matches("^\\s*\\|\\s*[^\\-\\}\\|].*")) {
            result = result.replace('|', ' ').replace('=', ' ');
        }
        return result;
    }

    static {
        Arrays.sort(HEADLINE_LEVEL);
        Arrays.sort(HEADLINE_TAGS);
        Arrays.sort(TABLE_PROPERTIES);
        Object[] array = new String[]{"void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("frame", (String[])array);
        array = new String[]{"none", "groups", "rows", "cols", "all"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("rules", (String[])array);
        array = new String[]{"top", "middle", "bottom", "baseline"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("valign", (String[])array);
        array = new String[]{"left", "right", "center"};
        Arrays.sort(array);
        PROPERTY_VALUES.put("align", (String[])array);
    }

    private class TableOfContent {
        private final List<String> toc = new ArrayList<String>();

        private TableOfContent() {
        }

        int size() {
            return this.toc.size();
        }

        String get(int index2) {
            return this.toc.get(index2);
        }

        synchronized boolean add(String element) {
            return this.toc.add(element);
        }

        Iterator<String> iterator() {
            return this.toc.iterator();
        }

        void clear() {
            this.toc.clear();
        }
    }

    private static enum Tags {
        HEADLINE_1("=", "<h1>", "</h1>"),
        HEADLINE_2("==", "<h2>", "</h2>"),
        HEADLINE_3("===", "<h3>", "</h3>"),
        HEADLINE_4("====", "<h4>", "</h4>"),
        HEADLINE_5("=====", "<h5>", "</h5>"),
        HEADLINE_6("======", "<h6>", "</h6>"),
        EMPHASIZE_1("''", "<i>", "</i>"),
        EMPHASIZE_2("'''", "<b>", "</b>"),
        EMPHASIZE_3("'''''", "<b><i>", "</i></b>"),
        STRIKE("&lt;s&gt;", "&lt;/s&gt;", "<span class=\"strike\">", "</span>"),
        UNDERLINE("&lt;u&gt;", "&lt;/u&gt;", "<span class=\"underline\">", "</span>");

        final String openHTML;
        final String closeHTML;
        final String openWiki;
        final String closeWiki;
        final int openWikiLength;
        final int closeWikiLength;

        private Tags(String openWiki, String closeWiki, String openHTML, String closeHTML) {
            if (openHTML == null || closeHTML == null || openWiki == null || closeWiki == null) {
                throw new IllegalArgumentException("Parameter may not be null.");
            }
            this.openHTML = openHTML;
            this.closeHTML = closeHTML;
            this.openWiki = openWiki;
            this.closeWiki = closeWiki;
            this.openWikiLength = openWiki.length();
            this.closeWikiLength = closeWiki.length();
        }

        private Tags(String wiki, String openHTML, String closeHTML) {
            this(wiki, wiki, openHTML, closeHTML);
        }
    }

    private static enum ListType {
        ORDERED,
        UNORDERED;

    }
}

