/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Tables;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.rwi.IndexCell;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import org.apache.http.Header;
import org.apache.http.entity.mime.content.ContentBody;

public class WorkTables
extends Tables {
    public static final String TABLE_API_NAME = "api";
    public static final String TABLE_API_TYPE_STEERING = "steering";
    public static final String TABLE_API_TYPE_CONFIGURATION = "configuration";
    public static final String TABLE_API_TYPE_CRAWLER = "crawler";
    public static final String TABLE_API_TYPE_DELETION = "deletion";
    public static final String TABLE_API_TYPE_DUMP = "dump";
    public static final String TABLE_API_COL_TYPE = "type";
    public static final String TABLE_API_COL_COMMENT = "comment";
    public static final String TABLE_API_COL_DATE_RECORDING = "date_recording";
    public static final String TABLE_API_COL_DATE_LAST_EXEC = "date_last_exec";
    public static final String TABLE_API_COL_DATE_NEXT_EXEC = "date_next_exec";
    public static final String TABLE_API_COL_DATE = "date";
    public static final String TABLE_API_COL_URL = "url";
    public static final String TABLE_API_COL_APICALL_PK = "apicall_pk";
    public static final String TABLE_API_COL_APICALL_COUNT = "apicall_count";
    public static final String TABLE_API_COL_APICALL_SCHEDULE_TIME = "apicall_schedule_time";
    public static final String TABLE_API_COL_APICALL_SCHEDULE_UNIT = "apicall_schedule_unit";
    public static final String TABLE_API_COL_APICALL_EVENT_KIND = "apicall_event_kind";
    public static final String TABLE_API_COL_APICALL_EVENT_ACTION = "apicall_event_action";
    public static final String TABLE_ROBOTS_NAME = "robots";
    public static final String TABLE_ACTIVECRAWLS_NAME = "crawljobsActive";
    public static final String TABLE_PASSIVECRAWLS_NAME = "crawljobsPassive";
    static final long hour = 3600000L;
    static final long day = 86400000L;

    public WorkTables(File workPath) {
        super(workPath, 12);
    }

    public static String generateRecordedURL(serverObjects post, String servletName) {
        String transactionToken = post != null ? post.get("transactionToken") : null;
        if (transactionToken != null && post != null) {
            post.put("transactionToken", "");
        }
        String apiurl = "/" + servletName;
        if (post != null) {
            apiurl = apiurl + "?" + post.toString();
        }
        if (post != null) {
            if (transactionToken != null) {
                post.put("transactionToken", transactionToken);
            } else {
                post.remove("transactionToken");
            }
        }
        return apiurl;
    }

    public static Tables.Row selectLastExecutedApiCall(String servletName, serverObjects post, Switchboard sb) {
        Tables.Row lastRecordedCall = null;
        if (servletName != null && sb != null && sb.tables != null) {
            try {
                if (post != null && post.containsKey(TABLE_API_COL_APICALL_PK)) {
                    lastRecordedCall = sb.tables.select(TABLE_API_NAME, UTF8.getBytes(post.get(TABLE_API_COL_APICALL_PK)));
                } else {
                    String apiURL = WorkTables.generateRecordedURL(post, servletName);
                    Iterator<Tables.Row> rowsIt = sb.tables.iterator(TABLE_API_NAME, TABLE_API_COL_URL, UTF8.getBytes(apiURL));
                    while (rowsIt.hasNext()) {
                        Date currentLastExec;
                        Tables.Row currentRow = rowsIt.next();
                        if (currentRow == null || (currentLastExec = currentRow.get(TABLE_API_COL_DATE_LAST_EXEC, (Date)null)) == null) continue;
                        if (lastRecordedCall == null) {
                            lastRecordedCall = currentRow;
                            continue;
                        }
                        if (!lastRecordedCall.get(TABLE_API_COL_DATE_LAST_EXEC, (Date)null).before(currentLastExec)) continue;
                        lastRecordedCall = currentRow;
                    }
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        return lastRecordedCall;
    }

    public byte[] recordAPICall(serverObjects post, String servletName, String type, String comment) {
        String[] pks = post.remove(TABLE_API_COL_APICALL_PK);
        byte[] pk = pks == null ? null : UTF8.getBytes(pks[0]);
        String apiurl = WorkTables.generateRecordedURL(post, servletName);
        Tables.Row row = null;
        try {
            row = pk == null ? null : super.select(TABLE_API_NAME, pk);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        try {
            if (row == null) {
                Tables.Data data = new Tables.Data();
                data.put(TABLE_API_COL_TYPE, UTF8.getBytes(type));
                data.put(TABLE_API_COL_COMMENT, UTF8.getBytes(comment));
                byte[] date = UTF8.getBytes(GenericFormatter.SHORT_MILSEC_FORMATTER.format());
                data.put(TABLE_API_COL_DATE_RECORDING, date);
                data.put(TABLE_API_COL_DATE_LAST_EXEC, date);
                data.put(TABLE_API_COL_URL, UTF8.getBytes(apiurl));
                data.put(TABLE_API_COL_APICALL_COUNT, "1");
                pk = super.insert(TABLE_API_NAME, data);
            } else {
                row.put(TABLE_API_COL_DATE_LAST_EXEC, UTF8.getBytes(GenericFormatter.SHORT_MILSEC_FORMATTER.format()));
                if (!row.containsKey(TABLE_API_COL_DATE_RECORDING)) {
                    row.put(TABLE_API_COL_DATE_RECORDING, (byte[])row.get(TABLE_API_COL_DATE));
                }
                row.remove(TABLE_API_COL_DATE);
                row.put(TABLE_API_COL_APICALL_COUNT, row.get(TABLE_API_COL_APICALL_COUNT, 1) + 1);
                WorkTables.calculateAPIScheduler(row, false);
                super.update(TABLE_API_NAME, row);
                assert (pk != null);
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        ConcurrentLog.info("APICALL", apiurl);
        return pk;
    }

    public byte[] recordAPICall(serverObjects post, String servletName, String type, String comment, int time, String unit) {
        if (post.containsKey(TABLE_API_COL_APICALL_PK)) {
            return this.recordAPICall(post, servletName, type, comment);
        }
        if (time < 0 || unit == null || unit.isEmpty() || "minutes,hours,days".indexOf(unit) < 0) {
            time = 0;
            unit = "";
        } else if (unit.equals("minutes") && time < 10) {
            time = 10;
        }
        String transactionToken = post.get("transactionToken");
        if (transactionToken != null) {
            post.put("transactionToken", "");
        }
        String apiurl = "/" + servletName + "?" + post.toString();
        if (transactionToken != null) {
            post.put("transactionToken", transactionToken);
        } else {
            post.remove("transactionToken");
        }
        byte[] pk = null;
        try {
            Tables.Data data = new Tables.Data();
            data.put(TABLE_API_COL_TYPE, UTF8.getBytes(type));
            data.put(TABLE_API_COL_COMMENT, UTF8.getBytes(comment));
            byte[] date = ASCII.getBytes(GenericFormatter.SHORT_MILSEC_FORMATTER.format());
            data.put(TABLE_API_COL_DATE_RECORDING, date);
            data.put(TABLE_API_COL_DATE_LAST_EXEC, date);
            data.put(TABLE_API_COL_URL, UTF8.getBytes(apiurl));
            data.put(TABLE_API_COL_APICALL_COUNT, UTF8.getBytes("1"));
            data.put(TABLE_API_COL_APICALL_SCHEDULE_TIME, ASCII.getBytes(Integer.toString(time)));
            data.put(TABLE_API_COL_APICALL_SCHEDULE_UNIT, UTF8.getBytes(unit));
            WorkTables.calculateAPIScheduler(data, false);
            pk = super.insert(TABLE_API_NAME, data);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        ConcurrentLog.info("APICALL", apiurl);
        return pk;
    }

    public Map<String, Integer> execAPICalls(String host, int port, Collection<String> pks, String username, String pass) {
        LinkedHashMap<String, Integer> l = new LinkedHashMap<String, Integer>();
        try (HTTPClient client = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
            client.setTimout(120000);
            for (String pk : pks) {
                Tables.Row row = null;
                try {
                    row = this.select(TABLE_API_NAME, UTF8.getBytes(pk));
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
                if (row == null) continue;
                String theapicall = UTF8.String((byte[])row.get(TABLE_API_COL_URL)) + "&apicall_pk=" + UTF8.String(row.getPK());
                try {
                    MultiProtocolURL url = new MultiProtocolURL("http", host, port, theapicall);
                    Map<String, String> attributes = url.getAttributes();
                    boolean isTokenProtectedAPI = attributes.containsKey("transactionToken");
                    if (theapicall.length() > 1000 || isTokenProtectedAPI) {
                        this.execPostAPICall(host, port, username, pass, client, l, url, isTokenProtectedAPI);
                        continue;
                    }
                    ConcurrentLog.info("WorkTables", "executing url: " + url.toNormalform(true));
                    try {
                        client.GETbytes(url, username, pass, false);
                        if (client.getStatusCode() == 405) {
                            this.execPostAPICall(host, port, username, pass, client, l, url, true);
                            continue;
                        }
                        l.put(url.toNormalform(true), client.getStatusCode());
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                        l.put(url.toString(), -1);
                    }
                }
                catch (MalformedURLException ex) {
                    ConcurrentLog.warn("APICALL", "wrong url in apicall " + theapicall);
                }
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return l;
    }

    private void execPostAPICall(String host, int port, String username, String pass, HTTPClient client, LinkedHashMap<String, Integer> results, MultiProtocolURL apiURL, boolean isTokenProtectedAPI) throws MalformedURLException {
        HashMap<String, ContentBody> post = new HashMap<String, ContentBody>();
        for (Map.Entry<String, String> a : apiURL.getAttributes().entrySet()) {
            post.put(a.getKey(), (ContentBody)UTF8.StringBody(a.getValue()));
        }
        MultiProtocolURL url = new MultiProtocolURL("http", host, port, apiURL.getPath());
        try {
            if (isTokenProtectedAPI) {
                client.GETbytes(url, username, pass, false);
                if (client.getStatusCode() != 200) {
                    ConcurrentLog.warn("APICALL", "Could not retrieve a transaction token for " + apiURL.toNormalform(true));
                } else {
                    Header transactionTokenHeader = client.getHttpResponse().getFirstHeader("X-YaCy-Transaction-Token");
                    if (transactionTokenHeader == null) {
                        ConcurrentLog.warn("APICALL", "Could not retrieve a transaction token for " + apiURL.toNormalform(true));
                    } else {
                        post.put("transactionToken", (ContentBody)UTF8.StringBody(transactionTokenHeader.getValue()));
                    }
                }
            }
            client.POSTbytes(url, "localhost", post, username, pass, false, false);
            results.put(apiURL.toNormalform(true), client.getStatusCode());
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            results.put(apiURL.toNormalform(true), -1);
        }
    }

    public static int execGetAPICall(String host, int port, String path, byte[] pk, String username, String pass) {
        int n;
        String url = "http://" + host + ":" + port + path;
        if (pk != null) {
            url = url + "&apicall_pk=" + UTF8.String(pk);
        }
        HTTPClient client = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);
        try {
            client.setTimout(120000);
            client.GETbytes(url, username, pass, false);
            n = client.getStatusCode();
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return -1;
            }
        }
        client.close();
        return n;
    }

    public int execAPICall(String pk, String host, int port, String username, String pass) {
        ArrayList<String> pks = new ArrayList<String>();
        pks.add(pk);
        Map<String, Integer> m = this.execAPICalls(host, port, pks, username, pass);
        if (m.isEmpty()) {
            return -1;
        }
        return m.values().iterator().next();
    }

    public static void calculateAPIScheduler(Tables.Data row, boolean update) {
        Date date = row.containsKey(TABLE_API_COL_DATE) ? row.get(TABLE_API_COL_DATE, (Date)null) : null;
        Date date2 = date = update ? row.get(TABLE_API_COL_DATE_NEXT_EXEC, date) : row.get(TABLE_API_COL_DATE_LAST_EXEC, date);
        if (date == null) {
            return;
        }
        long d = 0L;
        String kind = row.get(TABLE_API_COL_APICALL_EVENT_KIND, "off");
        if ("off".equals(kind)) {
            int time = row.get(TABLE_API_COL_APICALL_SCHEDULE_TIME, -1);
            if (time <= 0) {
                row.put(TABLE_API_COL_DATE_NEXT_EXEC, "");
                return;
            }
            String unit = row.get(TABLE_API_COL_APICALL_SCHEDULE_UNIT, "days");
            if (unit.equals("minutes")) {
                d = 60000L * (long)Math.max(10, time);
            }
            if (unit.equals("hours")) {
                d = 3600000L * (long)time;
            }
            if (unit.equals("days")) {
                d = 86400000L * (long)time;
            }
            d = d + date.getTime() < System.currentTimeMillis() ? (d += System.currentTimeMillis()) : (d += date.getTime());
            d -= d % 60000L;
        } else {
            String action = row.get(TABLE_API_COL_APICALL_EVENT_ACTION, "startup");
            if (!"startup".equals(action)) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                    d = dateFormat.parse(dateFormat.format(new Date()).substring(0, 8) + action).getTime();
                    if (d < System.currentTimeMillis()) {
                        d += 86400000L;
                    }
                }
                catch (ParseException parseException) {}
            } else {
                row.put(TABLE_API_COL_DATE_NEXT_EXEC, "");
                return;
            }
        }
        row.put(TABLE_API_COL_DATE_NEXT_EXEC, new Date(d));
    }

    public void failURLsRegisterMissingWord(IndexCell<WordReference> indexCell, DigestURL url, HandleSet queryHashes) {
        if (indexCell != null) {
            for (byte[] word : queryHashes) {
                indexCell.removeDelayed(word, url.hash());
            }
        }
    }

    public static Map<byte[], String> commentCache(Switchboard sb) {
        TreeMap<byte[], String> comments = new TreeMap<byte[], String>(Base64Order.enhancedCoder);
        try {
            Iterator<Tables.Row> i = sb.tables.iterator(TABLE_API_NAME);
            while (i.hasNext()) {
                Tables.Row row = i.next();
                comments.put(row.getPK(), UTF8.String((byte[])row.get(TABLE_API_COL_COMMENT)));
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return comments;
    }
}

