/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.UUID;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.BadTransactionException;
import net.yacy.http.servlets.DisallowedMethodException;
import net.yacy.http.servlets.TemplateMissingParameterException;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class TransactionManager {
    public static final String TRANSACTION_TOKEN_PARAM = "transactionToken";
    private static final String SIGNING_KEY = UUID.randomUUID().toString();
    private static final String TOKEN_SEED = UUID.randomUUID().toString();

    private static String getUserName(RequestHeader header) {
        Switchboard sb;
        String userName = header.getRemoteUser();
        if (userName == null) {
            userName = "admin";
        }
        if ((sb = Switchboard.getSwitchboard()) != null) {
            String adminAccountBase64MD5 = sb.getConfig("adminAccountBase64MD5", "");
            String adminAccountUserName = sb.getConfig("adminAccountUserName", "admin");
            if (header.accessFromLocalhost()) {
                if (sb.getConfigBool("adminAccountForLocalhost", false)) {
                    userName = adminAccountUserName;
                } else {
                    String realmValue;
                    String pass = Base64Order.standardCoder.encodeString(adminAccountUserName + ":" + adminAccountBase64MD5);
                    String realmProp = header.get("Authorization", "").trim();
                    String string = realmValue = realmProp.isEmpty() ? null : realmProp.substring(6);
                    if (pass.equals(realmValue)) {
                        userName = adminAccountUserName;
                    }
                }
            }
        }
        return userName;
    }

    public static String getTransactionToken(RequestHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("Missing required header parameter");
        }
        return TransactionManager.getTransactionToken(header, header.getPathInfo());
    }

    public static String getTransactionToken(RequestHeader header, String path) {
        if (header == null) {
            throw new IllegalArgumentException("Missing required header parameter");
        }
        String userName = TransactionManager.getUserName(header);
        if (userName == null) {
            throw new IllegalArgumentException("User is not authenticated");
        }
        String token = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, SIGNING_KEY).hmacHex(TOKEN_SEED + userName + path);
        return token;
    }

    public static void checkPostTransaction(RequestHeader header, serverObjects post) {
        if (header == null) {
            throw new IllegalArgumentException("Missing required header parameters.");
        }
        if (header.accessFromLocalhost()) {
            return;
        }
        if (post == null) {
            throw new IllegalArgumentException("Missing required post parameters.");
        }
        if (!"POST".equals(header.getMethod())) {
            throw new DisallowedMethodException("HTTP POST method is the only one authorized.");
        }
        String userName = TransactionManager.getUserName(header);
        if (userName == null) {
            throw new BadTransactionException("User is not authenticated.");
        }
        String transactionToken = post.get(TRANSACTION_TOKEN_PARAM);
        if (transactionToken == null) {
            throw new TemplateMissingParameterException("Missing transaction token.");
        }
        String token = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, SIGNING_KEY).hmacHex(TOKEN_SEED + userName + header.getPathInfo());
        if (!MessageDigest.isEqual(token.getBytes(StandardCharsets.UTF_8), transactionToken.getBytes(StandardCharsets.UTF_8))) {
            throw new BadTransactionException("Invalid transaction token.");
        }
    }
}

