/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.MapHeap;

public class MessageBoard {
    private static final int categoryLength = 12;
    private static final String dateFormat = "yyyyMMddHHmmss";
    private static final SimpleDateFormat SimpleFormatter = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    private MapHeap database = null;
    private int sn = 0;

    public MessageBoard(File path) throws IOException {
        new File(path.getParent()).mkdir();
        if (this.database == null) {
            this.database = new MapHeap(path, 12 + dateFormat.length() + 2, NaturalOrder.naturalOrder, 65536, 500, '_');
        }
        this.sn = 0;
    }

    public int size() {
        return this.database.size();
    }

    public synchronized void close() {
        this.database.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String dateString() {
        SimpleDateFormat simpleDateFormat = SimpleFormatter;
        synchronized (simpleDateFormat) {
            return SimpleFormatter.format(new Date());
        }
    }

    String snString() {
        Object s = Integer.toString(this.sn);
        if (((String)s).length() == 1) {
            s = "0" + (String)s;
        }
        ++this.sn;
        if (this.sn > 99) {
            this.sn = 0;
        }
        return s;
    }

    public entry newEntry(String category, String authorName, String authorHash, String recName, String recHash, String subject, byte[] message2) {
        return new entry(category, authorName, authorHash, recName, recHash, subject, message2);
    }

    public String write(entry message2) {
        try {
            this.database.insert(UTF8.getBytes(message2.key), message2.record);
            return message2.key;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public entry read(String key) {
        Map<String, String> record;
        try {
            record = this.database.get(UTF8.getBytes(key));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        return new entry(key, record);
    }

    public void remove(String key) {
        try {
            this.database.delete(UTF8.getBytes(key));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Iterator<String> keys(String category, boolean up) throws IOException {
        return new catIter(category, up);
    }

    static {
        SimpleFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public class entry {
        String key;
        Map<String, String> record;

        public entry(String category, String authorName, String authorHash, String recName, String recHash, String subject, byte[] message2) {
            this.record = new HashMap<String, String>();
            this.key = category;
            if (this.key.length() > 12) {
                this.key = this.key.substring(0, 12);
            }
            while (this.key.length() < 12) {
                this.key = this.key + "_";
            }
            this.key = this.key + MessageBoard.dateString() + MessageBoard.this.snString();
            this.record.put("author", authorName != null && !authorName.isEmpty() ? authorName : "anonymous");
            this.record.put("recipient", recName != null && !recName.isEmpty() ? recName : "anonymous");
            this.record.put("ahash", authorHash != null ? authorHash : "");
            this.record.put("rhash", recHash != null ? recHash : "");
            this.record.put("subject", subject != null ? subject : "");
            this.record.put("message", message2 == null ? "" : Base64Order.enhancedCoder.encode(message2));
            this.record.put("read", "false");
        }

        entry(String key, Map<String, String> record) {
            this.key = key;
            this.record = record;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date date() {
            try {
                String c = this.key.substring(12);
                c = c.substring(0, c.length() - 2);
                SimpleDateFormat simpleDateFormat = SimpleFormatter;
                synchronized (simpleDateFormat) {
                    return SimpleFormatter.parse(c);
                }
            }
            catch (ParseException e) {
                return new Date();
            }
        }

        public String category() {
            String c = this.key.substring(0, 12);
            while (c.endsWith("_")) {
                c = c.substring(0, c.length() - 1);
            }
            return c;
        }

        public String author() {
            String a = this.record.get("author");
            if (a == null) {
                return "anonymous";
            }
            return a;
        }

        public String recipient() {
            String a = this.record.get("recipient");
            if (a == null) {
                return "anonymous";
            }
            return a;
        }

        public String authorHash() {
            String a = this.record.get("ahash");
            return a;
        }

        public String recipientHash() {
            String a = this.record.get("rhash");
            return a;
        }

        public String subject() {
            String s = this.record.get("subject");
            if (s == null) {
                return "";
            }
            return s;
        }

        public byte[] message() {
            String m = this.record.get("message");
            if (m == null) {
                return new byte[0];
            }
            this.record.put("read", "true");
            return Base64Order.enhancedCoder.decode(m);
        }

        public boolean read() {
            String r = this.record.get("read");
            if (r == null) {
                return false;
            }
            return !r.equals("false");
        }
    }

    public class catIter
    implements Iterator<String> {
        private Iterator<byte[]> allIter = null;
        private String nextKey = null;
        private String category = "";

        public catIter(String category, boolean up) throws IOException {
            this.allIter = MessageBoard.this.database.keys(up, false);
            this.category = category;
            this.findNext();
        }

        public void findNext() {
            while (this.allIter.hasNext()) {
                this.nextKey = UTF8.String(this.allIter.next());
                if (this.category != null && !this.nextKey.startsWith(this.category)) continue;
                return;
            }
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public String next() {
            String next = this.nextKey;
            this.findNext();
            return next;
        }

        @Override
        public void remove() {
        }
    }
}

