/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.BookmarksDB;
import net.yacy.data.ListManager;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.ContentScraper;
import net.yacy.document.parser.html.TagValency;
import net.yacy.document.parser.html.TransformerWriter;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookmarkHelper {
    public static String cleanTagsString(String tagsString) {
        while (tagsString.length() > 0 && tagsString.charAt(0) == ',') {
            tagsString = tagsString.substring(1);
        }
        while (tagsString.endsWith(",")) {
            tagsString = tagsString.substring(0, tagsString.length() - 1);
        }
        while (tagsString.contains(",,")) {
            tagsString = tagsString.replaceAll(",,", ",");
        }
        while (tagsString.endsWith("/")) {
            tagsString = tagsString.substring(0, tagsString.length() - 1);
        }
        while (tagsString.contains("/,")) {
            tagsString = tagsString.replaceAll("/,", ",");
        }
        while (tagsString.contains("//")) {
            tagsString = tagsString.replaceAll("//", "/");
        }
        tagsString = tagsString.replaceAll(",\\s+", ",");
        return tagsString;
    }

    public static String tagHash(String tagName) {
        return ASCII.String(Word.word2hash(tagName.toLowerCase()));
    }

    public static int importFromBookmarks(BookmarksDB db, DigestURL baseURL, String input, String tag, boolean importPublic) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(UTF8.getBytes(input));
        InputStreamReader reader = new InputStreamReader((InputStream)byteIn, StandardCharsets.UTF_8);
        return BookmarkHelper.importFromBookmarks(db, baseURL, reader, tag, importPublic);
    }

    private static int importFromBookmarks(BookmarksDB db, DigestURL baseURL, InputStreamReader input, String tag, boolean importPublic) {
        int importCount = 0;
        List<Object> links = new ArrayList();
        Set<String> tags = ListManager.string2set(tag);
        try {
            ContentScraper scraper = new ContentScraper(baseURL, 10000, new HashSet<String>(), TagValency.EVAL, new VocabularyScraper(), 0);
            TransformerWriter writer = new TransformerWriter(null, null, scraper, false);
            FileUtils.copy(input, (Writer)writer);
            ((Writer)writer).close();
            links = scraper.getAnchors();
        }
        catch (IOException e) {
            ConcurrentLog.warn("BOOKMARKS", "error during load of links: " + e.getClass() + " " + e.getMessage());
        }
        for (AnchorURL url : links) {
            String title = url.getNameProperty();
            ConcurrentLog.info("BOOKMARKS", "links.get(url)");
            if ("".equals(title)) {
                title = url.toNormalform(false);
            }
            BookmarksDB bookmarksDB = db;
            Objects.requireNonNull(bookmarksDB);
            BookmarksDB.Bookmark bm = new BookmarksDB.Bookmark(bookmarksDB, url);
            bm.setProperty("bookmarkTitle", title);
            bm.setTags(tags);
            bm.setPublic(importPublic);
            db.saveBookmark(bm);
            ++importCount;
        }
        return importCount;
    }

    public static int importFromXML(BookmarksDB db, String input, boolean importPublic) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(UTF8.getBytes(input));
        return BookmarkHelper.importFromXML(db, byteIn, importPublic);
    }

    private static int importFromXML(BookmarksDB db, InputStream input, boolean importPublic) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(input);
            return BookmarkHelper.parseXMLimport(db, doc, importPublic);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    private static int parseXMLimport(BookmarksDB db, Node doc, boolean importPublic) {
        NodeList children;
        int importCount = 0;
        if ("post".equals(doc.getNodeName())) {
            BookmarksDB.Bookmark bm;
            NamedNodeMap attributes = doc.getAttributes();
            String url = attributes.getNamedItem("href").getNodeValue();
            if ("".equals(url)) {
                return 0;
            }
            try {
                BookmarksDB bookmarksDB = db;
                Objects.requireNonNull(bookmarksDB);
                bm = new BookmarksDB.Bookmark(bookmarksDB, url);
            }
            catch (MalformedURLException e1) {
                return 0;
            }
            String tagsString = "";
            String title = "";
            String description = "";
            String time = "";
            if (attributes.getNamedItem("tag") != null) {
                tagsString = attributes.getNamedItem("tag").getNodeValue();
            }
            if (attributes.getNamedItem("description") != null) {
                title = attributes.getNamedItem("description").getNodeValue();
            }
            if (attributes.getNamedItem("extended") != null) {
                description = attributes.getNamedItem("extended").getNodeValue();
            }
            if (attributes.getNamedItem("time") != null) {
                time = attributes.getNamedItem("time").getNodeValue();
            }
            Set<String> tags = new HashSet<String>();
            if (title != null) {
                bm.setProperty("bookmarkTitle", title);
            }
            if (tagsString != null) {
                tags = ListManager.string2set(tagsString.replace(' ', ','));
            }
            bm.setTags(tags, true);
            if (time != null) {
                Date parsedDate = null;
                try {
                    parsedDate = ISO8601Formatter.FORMATTER.parse(time, 0).getTime();
                }
                catch (ParseException e) {
                    parsedDate = new Date();
                }
                bm.setTimeStamp(parsedDate.getTime());
            }
            if (description != null) {
                bm.setProperty("bookmarkDesc", description);
            }
            bm.setPublic(importPublic);
            db.saveBookmark(bm);
            ++importCount;
        }
        if ((children = doc.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                importCount += BookmarkHelper.parseXMLimport(db, children.item(i), importPublic);
            }
        }
        return importCount;
    }

    public static Iterator<String> getFolderList(String root, Iterator<BookmarksDB.Tag> tagIterator) {
        TreeSet<String> folders = new TreeSet<String>();
        String path = "";
        while (tagIterator.hasNext()) {
            BookmarksDB.Tag tag = tagIterator.next();
            if (!tag.getFriendlyName().startsWith((String)("/".equals(root) ? root : root + "/"))) continue;
            path = tag.getFriendlyName();
            path = BookmarkHelper.cleanTagsString(path);
            while (path.length() > 0 && !path.equals(root)) {
                folders.add(path);
                path = path.replaceAll("(/.[^/]*$)", "");
            }
        }
        if (!"/".equals(root)) {
            folders.add(root);
        }
        folders.add("\uffff");
        return folders.iterator();
    }
}

