/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.robots;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.robots.RobotsTxt;

public class RobotsTxtEntry {
    private static final String HOST_NAME = "hostname";
    private static final String ALLOW_PATH_LIST = "allow";
    private static final String DISALLOW_PATH_LIST = "disallow";
    private static final String SITEMAP_LIST = "sitemap";
    private static final String LOADED_DATE = "date";
    private static final String MOD_DATE = "modDate";
    private static final String ETAG = "etag";
    private static final String CRAWL_DELAY = "crawlDelay";
    private static final String CRAWL_DELAY_MILLIS = "crawlDelayMillis";
    private static final String AGENT_NAME = "agentname";
    private final Map<String, byte[]> mem;
    private final List<String> allowPathList;
    private final List<String> denyPathList;
    private final List<String> sitemapList;
    private final String hostName;
    private final String agentName;
    private String info;

    protected RobotsTxtEntry(String hostName, Map<String, byte[]> mem) {
        this.hostName = hostName.toLowerCase(Locale.ROOT);
        this.mem = mem;
        this.info = "";
        this.denyPathList = new LinkedList<String>();
        this.fillMultiValue(this.denyPathList, DISALLOW_PATH_LIST);
        this.allowPathList = new LinkedList<String>();
        this.fillMultiValue(this.allowPathList, ALLOW_PATH_LIST);
        this.sitemapList = new LinkedList<String>();
        this.fillMultiValue(this.sitemapList, SITEMAP_LIST);
        this.agentName = this.mem.containsKey(AGENT_NAME) ? UTF8.String(this.mem.get(AGENT_NAME)) : null;
    }

    private void fillMultiValue(List<String> list2, String listName) {
        String[] pathArray;
        String csPl;
        if (this.mem.containsKey(listName) && (csPl = UTF8.String(this.mem.get(listName))).length() > 0 && (pathArray = csPl.split(";")) != null && pathArray.length > 0) {
            list2.addAll(Arrays.asList(pathArray));
        }
    }

    protected RobotsTxtEntry(MultiProtocolURL theURL, List<String> allowPathList, List<String> disallowPathList, Date loadedDate, Date modDate, String eTag, List<String> sitemapList, long crawlDelayMillis, String agentName) {
        if (theURL == null) {
            throw new IllegalArgumentException("The url is missing");
        }
        this.hostName = RobotsTxt.getHostPort(theURL).toLowerCase(Locale.ROOT);
        this.allowPathList = new LinkedList<String>();
        this.denyPathList = new LinkedList<String>();
        this.sitemapList = new LinkedList<String>();
        this.agentName = agentName;
        this.mem = new LinkedHashMap<String, byte[]>(10);
        this.mem.put(HOST_NAME, UTF8.getBytes(this.hostName));
        if (loadedDate != null) {
            this.mem.put(LOADED_DATE, ASCII.getBytes(Long.toString(loadedDate.getTime())));
        }
        if (modDate != null) {
            this.mem.put(MOD_DATE, ASCII.getBytes(Long.toString(modDate.getTime())));
        }
        if (eTag != null) {
            this.mem.put(ETAG, UTF8.getBytes(eTag));
        }
        if (crawlDelayMillis > 0L) {
            this.mem.put(CRAWL_DELAY_MILLIS, ASCII.getBytes(Long.toString(crawlDelayMillis)));
        }
        if (agentName != null) {
            this.mem.put(AGENT_NAME, UTF8.getBytes(agentName));
        }
        this.readMultiValue(allowPathList, this.allowPathList, ALLOW_PATH_LIST);
        this.readMultiValue(disallowPathList, this.denyPathList, DISALLOW_PATH_LIST);
        this.readMultiValue(sitemapList, this.sitemapList, SITEMAP_LIST);
    }

    private void readMultiValue(List<String> externallist, List<String> internallist, String listName) {
        if (externallist != null && !externallist.isEmpty()) {
            internallist.addAll(externallist);
            StringBuilder pathListStr = new StringBuilder(externallist.size() * 30);
            for (String element : externallist) {
                pathListStr.append(element).append(";");
            }
            this.mem.put(listName, UTF8.getBytes(pathListStr.substring(0, pathListStr.length() - 1)));
        }
    }

    protected String getHostName() {
        return this.hostName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    protected Map<String, byte[]> getMem() {
        if (!this.mem.containsKey(HOST_NAME)) {
            this.mem.put(HOST_NAME, UTF8.getBytes(this.hostName));
        }
        return this.mem;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(6000);
        str.append(this.hostName == null ? "null" : this.hostName).append(": ");
        if (this.mem != null) {
            str.append('{');
            for (Map.Entry<String, byte[]> entry2 : this.mem.entrySet()) {
                str.append(entry2.getKey());
                str.append('=');
                str.append(UTF8.String(entry2.getValue()));
                str.append(',');
            }
            str.append('}');
        }
        return str.toString();
    }

    public List<String> getSitemaps() {
        return this.sitemapList;
    }

    protected Date getLoadedDate() {
        if (this.mem.containsKey(LOADED_DATE)) {
            return new Date(ByteArray.parseDecimal(this.mem.get(LOADED_DATE)));
        }
        return null;
    }

    protected void setLoadedDate(Date newLoadedDate) {
        if (newLoadedDate != null) {
            this.mem.put(LOADED_DATE, ASCII.getBytes(Long.toString(newLoadedDate.getTime())));
        }
    }

    protected Date getModDate() {
        if (this.mem.containsKey(MOD_DATE)) {
            return new Date(ByteArray.parseDecimal(this.mem.get(MOD_DATE)));
        }
        return null;
    }

    protected String getETag() {
        if (this.mem.containsKey(ETAG)) {
            return ASCII.String(this.mem.get(ETAG));
        }
        return null;
    }

    public int getCrawlDelayMillis() {
        if (this.mem.containsKey(CRAWL_DELAY_MILLIS)) {
            try {
                return (int)ByteArray.parseDecimal(this.mem.get(CRAWL_DELAY_MILLIS));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        if (this.mem.containsKey(CRAWL_DELAY)) {
            try {
                return 1000 * (int)ByteArray.parseDecimal(this.mem.get(CRAWL_DELAY));
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public boolean isDisallowed(MultiProtocolURL subpathURL) {
        String path = subpathURL.getFile();
        if (this.mem == null) {
            this.info = "no robots file available";
            return false;
        }
        if (this.denyPathList.isEmpty()) {
            this.info = "no entry in robots.txt";
            return false;
        }
        if (path == null || path.isEmpty()) {
            path = "/";
        } else {
            try {
                path = UTF8.decodeURL(path);
            }
            catch (Exception e) {
                ConcurrentLog.warn(RobotsTxtEntry.class.getName(), "Could not decode path : " + path);
            }
            path = RobotsTxt.ROBOTS_DB_PATH_SEPARATOR_MATCHER.matcher(path).replaceAll("%3B");
        }
        for (String element : this.denyPathList) {
            if (!path.startsWith(element)) continue;
            this.info = "path '" + path + "' starts with '" + element + "' from deny path list = " + this.denyPathList.toString();
            return true;
        }
        this.info = "path '" + path + "' does not start with any element from deny path list";
        return false;
    }

    public String getInfo() {
        return this.info;
    }
}

