/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.protocol.ftp.FTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.StrictLimitInputStream;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.crawler.retrieval.StreamResponse;
import net.yacy.document.TextParser;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;

public class FileLoader {
    public static final int DEFAULT_MAXFILESIZE = 100000000;
    private final Switchboard sb;
    private final ConcurrentLog log;
    private final int maxFileSize;

    public FileLoader(Switchboard sb, ConcurrentLog log) {
        this.sb = sb;
        this.log = log;
        this.maxFileSize = sb.getConfigInt("crawler.file.maxFileSize", 100000000);
    }

    public Response load(Request request, boolean acceptOnlyParseable) throws IOException {
        StreamResponse streamResponse = this.openInputStream(request, acceptOnlyParseable);
        byte[] content = FileUtils.read(streamResponse.getContentStream());
        Response response = streamResponse.getResponse();
        response.setContent(content);
        return response;
    }

    public StreamResponse openInputStream(Request request, boolean acceptOnlyParseable, int maxBytes) throws IOException {
        long size;
        String ur;
        DigestURL url = request.url();
        if (!url.getProtocol().equals("file")) {
            throw new IOException("wrong protocol for FileLoader: " + url.getProtocol());
        }
        RequestHeader requestHeader = null;
        if (request.referrerhash() != null && (ur = this.sb.getURL(request.referrerhash())) != null) {
            requestHeader = new RequestHeader();
            requestHeader.put("Referer", ur);
        }
        String[] l = null;
        try {
            l = url.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (l != null) {
            String u = url.toNormalform(true);
            ArrayList<String> list2 = new ArrayList<String>();
            for (String s : l) {
                list2.add(u + (u.endsWith("/") || u.endsWith("\\") ? "" : "/") + s);
            }
            StringBuilder content = FTPClient.dirhtml(u, null, null, null, list2, true);
            ResponseHeader responseHeader = new ResponseHeader(200);
            responseHeader.put("Last-Modified", HeaderFramework.formatRFC1123(new Date(url.lastModified())));
            responseHeader.put("Content-Type", "text/html");
            CrawlProfile profile2 = this.sb.crawler.get(ASCII.getBytes(request.profileHandle()));
            Response response = new Response(request, requestHeader, responseHeader, profile2, false, null);
            return new StreamResponse(response, new ByteArrayInputStream(UTF8.getBytes(content.toString())));
        }
        String mime = Classification.ext2mime(MultiProtocolURL.getFileExtension(url.getFileName()));
        ResponseHeader responseHeader = new ResponseHeader(200);
        responseHeader.put("Last-Modified", HeaderFramework.formatRFC1123(new Date(url.lastModified())));
        responseHeader.put("Content-Type", mime);
        try {
            size = url.length();
            responseHeader.put("Content-Length", Long.toString(size));
        }
        catch (Exception e) {
            size = -1L;
        }
        String parserError = null;
        if (acceptOnlyParseable && (parserError = TextParser.supports(url, mime)) != null || size > (long)maxBytes && maxBytes >= 0) {
            if (parserError != null) {
                this.log.info("No parser available in File crawler: '" + parserError + "' for URL " + request.url().toNormalform(false) + ": parsing only metadata");
            } else {
                this.log.info("Too big file in File crawler with size = " + size + " Bytes for URL " + request.url().toNormalform(false) + ": parsing only metadata");
            }
            responseHeader.put("Content-Type", "text/plain");
            CrawlProfile profile3 = this.sb.crawler.get(ASCII.getBytes(request.profileHandle()));
            Response response = new Response(request, requestHeader, responseHeader, profile3, false, null);
            return new StreamResponse(response, new ByteArrayInputStream(UTF8.getBytes(url.toTokens())));
        }
        InputStream is = url.getInputStream(ClientIdentification.yacyInternetCrawlerAgent);
        if (size < 0L && maxBytes >= 0) {
            is = new StrictLimitInputStream(is, maxBytes, "Too big file in File crawler for URL " + request.url().toString());
        }
        CrawlProfile profile4 = this.sb.crawler.get(ASCII.getBytes(request.profileHandle()));
        Response response = new Response(request, requestHeader, responseHeader, profile4, false, null);
        return new StreamResponse(response, is);
    }

    public StreamResponse openInputStream(Request request, boolean acceptOnlyParseable) throws IOException {
        return this.openInputStream(request, acceptOnlyParseable, this.maxFileSize);
    }
}

