/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.ReverseMapIterator;

public final class ResultURLs {
    private static final Map<EventOrigin, Map<String, InitExecEntry>> resultStacks = new ConcurrentHashMap<EventOrigin, Map<String, InitExecEntry>>();
    private static final Map<EventOrigin, ScoreMap<String>> resultDomains = new ConcurrentHashMap<EventOrigin, ScoreMap<String>>();

    public static void stack(String urlhash, String hostname, byte[] initiatorHash, byte[] executorHash, EventOrigin stackType) {
        assert (executorHash != null);
        if (urlhash == null || hostname == null) {
            return;
        }
        try {
            Map<String, InitExecEntry> resultStack = ResultURLs.getStack(stackType);
            if (resultStack != null) {
                resultStack.put(urlhash, new InitExecEntry(initiatorHash, executorHash));
            }
        }
        catch (Exception ex) {
            ConcurrentLog.warn("CRAWLER", "INTERNAL ERROR in newEntry/2: " + ex.toString());
            return;
        }
        try {
            ScoreMap<String> domains = ResultURLs.getDomains(stackType);
            if (domains != null) {
                domains.inc(hostname);
            }
        }
        catch (Exception ex) {
            ConcurrentLog.warn("CRAWLER", "INTERNAL ERROR in newEntry/3: " + ex.toString());
            return;
        }
    }

    public static int getStackSize(EventOrigin stack) {
        Map<String, InitExecEntry> resultStack = ResultURLs.getStack(stack);
        if (resultStack == null) {
            return 0;
        }
        return resultStack.size();
    }

    public static int getDomainListSize(EventOrigin stack) {
        ScoreMap<String> domains = ResultURLs.getDomains(stack);
        if (domains == null) {
            return 0;
        }
        return domains.size();
    }

    public static Iterator<Map.Entry<String, InitExecEntry>> results(EventOrigin stack) {
        Map<String, InitExecEntry> resultStack = ResultURLs.getStack(stack);
        if (resultStack == null) {
            return new LinkedHashMap().entrySet().iterator();
        }
        return new ReverseMapIterator<String, InitExecEntry>(resultStack);
    }

    public static Iterator<String> domains(EventOrigin stack) {
        assert (ResultURLs.getDomains(stack) != null) : "getDomains(" + stack + ") = null";
        return ResultURLs.getDomains(stack).keys(false);
    }

    public static int deleteDomain(EventOrigin stack, String host) {
        assert (host != null) : "host = null";
        assert (ResultURLs.getDomains(stack) != null) : "getDomains(" + stack + ") = null";
        return ResultURLs.getDomains(stack).delete(host);
    }

    public static int domainCount(EventOrigin stack, String domain) {
        assert (domain != null) : "domain = null";
        assert (ResultURLs.getDomains(stack) != null) : "getDomains(" + stack + ") = null";
        return ResultURLs.getDomains(stack).get(domain);
    }

    private static Map<String, InitExecEntry> getStack(EventOrigin stack) {
        return resultStacks.get((Object)stack);
    }

    private static ScoreMap<String> getDomains(EventOrigin stack) {
        return resultDomains.get((Object)stack);
    }

    public static void clearStacks() {
        for (EventOrigin origin : EventOrigin.values()) {
            ResultURLs.clearStack(origin);
        }
    }

    public static void clearStack(EventOrigin stack) {
        ScoreMap<String> resultDomains;
        Map<String, InitExecEntry> resultStack = ResultURLs.getStack(stack);
        if (resultStack != null) {
            resultStack.clear();
        }
        if ((resultDomains = ResultURLs.getDomains(stack)) != null) {
            resultDomains.shrinkToMaxSize(100);
            resultDomains.shrinkToMinScore(2);
        }
    }

    public static boolean remove(String urlHash) {
        if (urlHash == null) {
            return false;
        }
        for (EventOrigin origin : EventOrigin.values()) {
            Map<String, InitExecEntry> resultStack = ResultURLs.getStack(origin);
            if (resultStack == null) continue;
            resultStack.remove(urlHash);
        }
        return true;
    }

    static {
        for (EventOrigin origin : EventOrigin.values()) {
            resultStacks.put(origin, new LinkedHashMap());
            resultDomains.put(origin, new ClusteredScoreMap(true));
        }
    }

    public static enum EventOrigin {
        UNKNOWN(0),
        REMOTE_RECEIPTS(1),
        QUERIES(2),
        DHT_TRANSFER(3),
        PROXY_LOAD(4),
        LOCAL_CRAWLING(5),
        GLOBAL_CRAWLING(6),
        SURROGATES(7);

        protected int code;
        private static final EventOrigin[] list;

        private EventOrigin(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static final EventOrigin getEvent(int key) {
            return list[key];
        }

        static {
            list = new EventOrigin[]{UNKNOWN, REMOTE_RECEIPTS, QUERIES, DHT_TRANSFER, PROXY_LOAD, LOCAL_CRAWLING, GLOBAL_CRAWLING, SURROGATES};
        }
    }

    public static class InitExecEntry {
        public byte[] initiatorHash;
        public byte[] executorHash;

        public InitExecEntry(byte[] initiatorHash, byte[] executorHash) {
            this.initiatorHash = initiatorHash;
            this.executorHash = executorHash;
        }
    }
}

