/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol.ftp;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.util.ConcurrentLog;

public class FTPClient {
    public static final String ANONYMOUS = "anonymous";
    private static final ConcurrentLog log = new ConcurrentLog("FTPClient");
    private static final String vDATE = "20161222";
    private boolean glob = true;
    private static final char transferType = 'i';
    private static final int blockSize = 1024;
    private Socket ControlSocket = null;
    private static final int ControlSocketTimeout = 10000;
    private int DataSocketTimeout = 0;
    private ServerSocket DataSocketActive = null;
    private Socket DataSocketPassive = null;
    private boolean DataSocketPassiveMode = true;
    private BufferedReader clientInput = null;
    private DataOutputStream clientOutput = null;
    private String prompt = "ftp [local]>";
    String[] cmd;
    File currentLocalPath;
    String account;
    String password;
    String host;
    String remotemessage;
    String remotegreeting;
    String remotesystem;
    int port;
    private final Map<String, entryInfo> infoCache = new HashMap<String, entryInfo>();
    private static final SimpleDateFormat lsDateFormat = new SimpleDateFormat("MMM d y H:m", Locale.forLanguageTag("en"));
    private static final Pattern lsStyle = Pattern.compile("^([-\\w]{10}).\\s*\\d+\\s+[-\\w]+\\s+[-\\w]+\\s+(\\d+)\\s+(\\w{3})\\s+(\\d+)\\s+(\\d+:?\\d*)\\s+(.*)$");
    public static final entryInfo POISON_entryInfo = new entryInfo();

    public FTPClient() {
        this.currentLocalPath = new File(System.getProperty("user.dir"));
        try {
            this.currentLocalPath = new File(this.currentLocalPath.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.account = null;
        this.password = null;
        this.host = null;
        this.port = -1;
        this.remotemessage = null;
        this.remotegreeting = null;
        this.remotesystem = null;
    }

    public boolean exec(String command, boolean promptIt) {
        if (command == null || command.isEmpty()) {
            return true;
        }
        boolean ret = true;
        while (command.length() > 0) {
            String com;
            int pos = command.indexOf(59, 0);
            if (pos < 0) {
                pos = command.indexOf("\n", 0);
            }
            if (pos < 0) {
                com = command;
                command = "";
            } else {
                com = command.substring(0, pos);
                command = command.substring(pos + 1);
            }
            if (promptIt) {
                log.info(this.prompt + com);
            }
            this.cmd = this.line2args(com);
            try {
                ret = (Boolean)this.getClass().getMethod(this.cmd[0].toUpperCase(), (Class[])Array.newInstance(Class.class, 0)).invoke((Object)this, (Object[])Array.newInstance(Object.class, 0));
            }
            catch (InvocationTargetException e) {
                if (e.getMessage() == null) continue;
                if (this.notConnected()) {
                    log.warn("not connected. no effect.", e);
                } else {
                    log.warn("ftp internal exception: target exception " + e);
                }
                return ret;
            }
            catch (IllegalAccessException e) {
                log.warn("ftp internal exception: wrong access " + e);
                return ret;
            }
            catch (NoSuchMethodException e) {
                if (this.notConnected()) {
                    try {
                        this.javaexec(this.cmd);
                    }
                    catch (Exception ee) {
                        log.warn("Command '" + this.cmd[0] + "' not supported. Try 'HELP'.");
                    }
                } else {
                    this.exec("java " + com, false);
                }
                return ret;
            }
        }
        return ret;
    }

    private String[] line2args(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        Object line1 = "";
        boolean quoted = false;
        for (int i = 0; i < line.length(); ++i) {
            if (quoted) {
                if (line.charAt(i) == '\"') {
                    quoted = false;
                    continue;
                }
                line1 = (String)line1 + line.charAt(i);
                continue;
            }
            if (line.charAt(i) == '\"') {
                quoted = true;
                continue;
            }
            line1 = line.charAt(i) == ' ' ? (String)line1 + "|" : (String)line1 + line.charAt(i);
        }
        return ((String)line1).split("\\|");
    }

    private void javaexec(String[] inArgs) {
        String obj = inArgs[0];
        String[] args = new String[inArgs.length - 1];
        System.arraycopy(inArgs, 1, args, 0, inArgs.length - 1);
        Object[] argList = new Object[]{args};
        Properties pr = System.getProperties();
        String origPath = (String)pr.get("java.class.path");
        try {
            pr.put("user.dir", this.currentLocalPath.toString());
            System.setProperties(pr);
            Class<?> c = new cl().loadClass(obj);
            Class[] parameterType = (Class[])Array.newInstance(Class.class, 1);
            parameterType[0] = Class.forName("[Ljava.lang.String;");
            Method m = c.getMethod("main", parameterType);
            Object result = m.invoke(null, argList);
            m = null;
            if (result != null) {
                log.info("returns " + result);
            }
            this.currentLocalPath = new File((String)pr.get("user.dir"));
        }
        catch (ClassNotFoundException e) {
            log.warn("Command '" + obj + "' not supported. Try 'HELP'.");
        }
        catch (NoSuchMethodException e) {
            log.warn("no \"public static main(String args[])\" in " + obj);
        }
        catch (InvocationTargetException e) {
            Throwable orig = e.getTargetException();
            if (orig.getMessage() != null) {
                log.warn("Exception from " + obj + ": " + orig.getMessage(), orig);
            }
        }
        catch (IllegalAccessException e) {
            log.warn("Illegal access for " + obj + ": class is probably not declared as public", e);
        }
        catch (NullPointerException e) {
            log.warn("main(String args[]) is not defined as static for " + obj);
        }
        catch (Exception e) {
            log.warn("Exception caught: ", e);
        }
        pr.put("java.class.path", origPath);
    }

    public boolean ASCII() {
        if (this.cmd.length != 1) {
            log.warn("Syntax: ASCII  (no parameter)");
            return true;
        }
        try {
            this.literal("TYPE A");
        }
        catch (IOException e) {
            log.warn("Error: ASCII transfer type not supported by server.");
        }
        return true;
    }

    public boolean BINARY() {
        if (this.cmd.length != 1) {
            log.warn("Syntax: BINARY  (no parameter)");
            return true;
        }
        try {
            this.literal("TYPE I");
        }
        catch (IOException e) {
            log.warn("Error: BINARY transfer type not supported by server.");
        }
        return true;
    }

    public boolean BYE() {
        return this.QUIT();
    }

    public boolean CD() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: CD <path>");
            return true;
        }
        if (this.notConnected()) {
            return this.LCD();
        }
        try {
            this.send("CWD " + this.cmd[1]);
            String reply = this.receive();
            if (this.isNotPositiveCompletion(reply)) {
                throw new IOException(reply);
            }
        }
        catch (IOException e) {
            log.warn("Error: change of working directory to path " + this.cmd[1] + " failed.");
        }
        return true;
    }

    public boolean CLOSE() {
        return this.DISCONNECT();
    }

    private void rmForced(String path) throws IOException {
        this.send("DELE " + path);
        String reply1 = this.receive();
        if (this.isNotPositiveCompletion(reply1)) {
            this.send("RMD " + path);
            String reply2 = this.receive();
            if (this.isNotPositiveCompletion(reply2)) {
                if (this.isFolder(path)) {
                    throw new IOException(reply2);
                }
                throw new IOException(reply1);
            }
        }
    }

    public Date entryDate(String path) {
        entryInfo info = this.fileInfo(path);
        Date date = null;
        if (info != null) {
            date = info.date;
        }
        return date;
    }

    public boolean DEL() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: DEL <file>");
            return true;
        }
        if (this.notConnected()) {
            return this.LDEL();
        }
        try {
            this.rmForced(this.cmd[1]);
        }
        catch (IOException e) {
            log.warn("Error: deletion of file " + this.cmd[1] + " failed.");
        }
        return true;
    }

    public boolean RM() {
        return this.DEL();
    }

    public boolean DIR() {
        if (this.cmd.length > 2) {
            log.warn("Syntax: DIR [<path>|<file>]");
            return true;
        }
        if (this.notConnected()) {
            return this.LDIR();
        }
        try {
            List<String> l = this.cmd.length == 2 ? this.list(this.cmd[1], false) : this.list(".", false);
            this.printElements(l);
        }
        catch (IOException e) {
            log.warn("Error: remote list not available (1): " + e.getMessage());
        }
        return true;
    }

    public boolean DISCONNECT() {
        try {
            this.quit();
            log.info("---- Connection closed.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.closeConnection();
        }
        catch (IOException e) {
            this.ControlSocket = null;
            this.DataSocketActive = null;
            this.DataSocketPassive = null;
            this.clientInput = null;
            this.clientOutput = null;
        }
        this.prompt = "ftp [local]>";
        return true;
    }

    private String quit() throws IOException {
        this.send("QUIT");
        String reply = this.receive();
        if (this.isNotPositiveCompletion(reply)) {
            throw new IOException(reply);
        }
        this.closeConnection();
        return reply;
    }

    public boolean EXIT() {
        return this.QUIT();
    }

    public boolean GET() {
        if (this.cmd.length < 2 || this.cmd.length > 3) {
            log.warn("Syntax: GET <remote-file> [<local-file>]");
            return true;
        }
        String remote = this.cmd[1];
        boolean withoutLocalFile = this.cmd.length == 2;
        String localFilename = withoutLocalFile ? remote : this.cmd[2];
        File local = this.absoluteLocalFile(localFilename);
        if (local.exists()) {
            log.warn("Error: local file " + local.toString() + " already exists.\n               File " + remote + " not retrieved. Local file unchanged.");
        } else if (withoutLocalFile) {
            this.retrieveFilesRecursively(remote, false);
        } else {
            try {
                this.get(local.getAbsolutePath(), remote);
            }
            catch (IOException e) {
                log.warn("Error: retrieving file " + remote + " failed. (" + e.getMessage() + ")");
            }
        }
        return true;
    }

    private File absoluteLocalFile(String localFilename) {
        File l = new File(localFilename);
        File local = l.isAbsolute() ? l : new File(this.currentLocalPath, localFilename);
        return local;
    }

    private void retrieveFilesRecursively(String remote, boolean delete) {
        File local = this.absoluteLocalFile(remote);
        try {
            this.get(local.getAbsolutePath(), remote);
            try {
                if (delete) {
                    this.rmForced(remote);
                }
            }
            catch (IOException eee) {
                log.warn("Warning: remote file or path " + remote + " cannot be removed.");
            }
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("550")) {
                if (this.isFolder(remote)) {
                    this.exec("cd \"" + remote + "\";lmkdir \"" + remote + "\";lcd \"" + remote + "\"", true);
                    try {
                        for (String element : this.list(".", false)) {
                            this.retrieveFilesRecursively(element, delete);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.exec("cd ..;lcd ..", true);
                    try {
                        if (delete) {
                            this.rmForced(remote);
                        }
                    }
                    catch (IOException eee) {
                        log.warn("Warning: remote file or path " + remote + " cannot be removed.");
                    }
                }
                log.warn("Error: remote file or path " + remote + " does not exist.");
            }
            log.warn("Error: retrieving file " + remote + " failed. (" + e.getMessage() + ")");
        }
    }

    public boolean isFolder(String path) {
        try {
            entryInfo info = this.fileInfo(path);
            if (info != null) {
                return info.type == filetype.directory;
            }
            String currentFolder = this.pwd();
            this.send("CWD " + path);
            String reply = this.receive();
            if (this.isNotPositiveCompletion(reply)) {
                throw new IOException(reply);
            }
            String changedPath = this.pwd();
            if (!changedPath.equals(path) && !changedPath.equals(currentFolder + (currentFolder.endsWith("/") ? "" : "/") + path)) {
                throw new IOException("folder is '" + changedPath + "' should be '" + path + "'");
            }
            this.send("CWD " + currentFolder);
            this.receive();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean GLOB() {
        if (this.cmd.length != 1) {
            log.warn("Syntax: GLOB  (no parameter)");
            return true;
        }
        this.glob = !this.glob;
        log.info("---- globbing is now turned " + (this.glob ? "ON" : "OFF"));
        return true;
    }

    public boolean HASH() {
        log.warn("no games implemented");
        return true;
    }

    public boolean JJENCODE() {
        File newPath;
        if (this.cmd.length != 2) {
            log.warn("Syntax: JJENCODE <path>");
            return true;
        }
        String path = this.cmd[1];
        File dir = new File(path);
        File file = newPath = dir.isAbsolute() ? dir : new File(this.currentLocalPath, path);
        if (newPath.exists()) {
            if (newPath.isDirectory()) {
                String[] l;
                Object s = "";
                for (String element : l = newPath.list()) {
                    s = (String)s + " \"" + element + "\"";
                }
                this.exec("cd \"" + path + "\";jar -cfM0 ../\"" + path + ".jar\"" + (String)s, true);
                this.exec("cd ..;jar -cfM \"" + path + ".jj\" \"" + path + ".jar\"", true);
                this.exec("rm \"" + path + ".jar\"", true);
            } else {
                log.warn("Error: local path " + newPath.toString() + " denotes not to a directory.");
            }
        } else {
            log.warn("Error: local path " + newPath.toString() + " does not exist.");
        }
        return true;
    }

    public boolean JJDECODE() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: JJENCODE <path>");
            return true;
        }
        String path = this.cmd[1];
        File dir = new File(path);
        File newPath = dir.isAbsolute() ? dir : new File(this.currentLocalPath, path);
        File newFolder = new File(newPath.toString() + ".dir");
        if (newPath.exists()) {
            if (!newPath.isDirectory()) {
                if (!newFolder.mkdir()) {
                    this.exec("mkdir \"" + path + ".dir\"", true);
                } else {
                    log.warn("Error: target dir " + newFolder.toString() + " cannot be created");
                }
            } else {
                log.warn("Error: local path " + newPath.toString() + " must denote to jar/jar file");
            }
        } else {
            log.warn("Error: local path " + newPath.toString() + " does not exist.");
        }
        return true;
    }

    private static String[] argList2StringArray(String argList) {
        return argList.split("\\s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean JOIN(String[] args) {
        String dest_name = args[1];
        File dest_file = new File(dest_name);
        if (dest_file.exists()) {
            log.warn("join: destination file " + dest_name + " already exists");
            return true;
        }
        int pc = -1;
        pc = 0;
        Object source_name = dest_name + ".000";
        Object argString = "";
        File source_file = new File((String)source_name);
        while (source_file.exists() && source_file.isFile() && source_file.canRead()) {
            argString = (String)argString + " " + (String)source_name;
            source_name = dest_name + (++pc < 10 ? ".00" + pc : (pc < 100 ? ".0" + pc : "." + pc));
            source_file = new File((String)source_name);
        }
        args = FTPClient.argList2StringArray(((String)argString).substring(1));
        FileOutputStream dest = null;
        FileInputStream source = null;
        int bytes_read = 0;
        try {
            dest = new FileOutputStream(dest_file);
            byte[] buffer = new byte[1024];
            for (pc = 0; pc < args.length; ++pc) {
                source_name = args[pc];
                source_file = new File((String)source_name);
                source = new FileInputStream(source_file);
                while ((bytes_read = source.read(buffer)) != -1) {
                    dest.write(buffer, 0, bytes_read);
                }
                try {
                    source.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                dest.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (pc = 0; pc < args.length; ++pc) {
                try {
                    if (new File(args[pc]).delete()) continue;
                    log.warn("join: unable to delete file " + args[pc]);
                    continue;
                }
                catch (SecurityException e) {
                    log.warn("join: no permission to delete file " + args[pc]);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            log.warn("join created output from " + args.length + " source files");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean COPY(String[] args) {
        File dest_file = new File(args[2]);
        if (dest_file.exists()) {
            log.warn("copy: destination file " + args[2] + " already exists");
            return true;
        }
        int bytes_read = 0;
        FileOutputStream dest = null;
        FileInputStream source = null;
        try {
            dest = new FileOutputStream(dest_file);
            byte[] buffer = new byte[1024];
            File source_file = new File(args[1]);
            source = new FileInputStream(source_file);
            while ((bytes_read = source.read(buffer)) != -1) {
                dest.write(buffer, 0, bytes_read);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public boolean JAVA() {
        Object s = "JAVA";
        for (int i = 1; i < this.cmd.length; ++i) {
            s = (String)s + " " + this.cmd[i];
        }
        try {
            this.send((String)s);
            this.receive();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean LCD() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: LCD <path>");
            return true;
        }
        String path = this.cmd[1];
        File dir = new File(path);
        File newPath = dir.isAbsolute() ? dir : new File(this.currentLocalPath, path);
        try {
            newPath = new File(newPath.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newPath.exists()) {
            if (newPath.isDirectory()) {
                this.currentLocalPath = newPath;
                log.info("---- New local path: " + this.currentLocalPath.toString());
            } else {
                log.warn("Error: local path " + newPath.toString() + " denotes not a directory.");
            }
        } else {
            log.warn("Error: local path " + newPath.toString() + " does not exist.");
        }
        return true;
    }

    public boolean LDEL() {
        return this.LRM();
    }

    public boolean LDIR() {
        String[] name;
        if (this.cmd.length != 1) {
            log.warn("Syntax: LDIR  (no parameter)");
            return true;
        }
        for (String element : name = this.currentLocalPath.list()) {
            log.info(this.ls(new File(this.currentLocalPath, element)));
        }
        return true;
    }

    public entryInfo fileInfo(String path) {
        if (this.infoCache.containsKey(path)) {
            return this.infoCache.get(path);
        }
        try {
            int endCode;
            this.send("STAT " + path);
            String reply = this.receive();
            if (this.isNotPositiveCompletion(reply)) {
                throw new IOException(reply);
            }
            String[] lines = reply.split("\\r\\n");
            if (lines.length < 3) {
                throw new IOException(reply);
            }
            int startCode = this.getStatusCode(lines[0]);
            if (startCode != (endCode = this.getStatusCode(lines[lines.length - 1]))) {
                throw new IOException(reply);
            }
            entryInfo info = null;
            int endFor = lines.length - 1;
            for (int i = 1; i < endFor; ++i) {
                info = FTPClient.parseListData(lines[i]);
                if (info == null) continue;
                this.infoCache.put(path, info);
                break;
            }
            return info;
        }
        catch (IOException e) {
            return null;
        }
    }

    private int getStatus(String reply) {
        return Integer.parseInt(reply.substring(0, 1));
    }

    private int getStatusCode(String reply) {
        return Integer.parseInt(reply.substring(0, 3));
    }

    private boolean isNotPositiveCompletion(String reply) {
        return this.getStatus(reply) != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static entryInfo parseListData(String line) {
        Matcher tokens = lsStyle.matcher(line);
        if (tokens.matches() && tokens.groupCount() == 6) {
            Date date;
            String year;
            String time;
            filetype type = filetype.file;
            if (tokens.group(1).startsWith("d")) {
                type = filetype.directory;
            }
            if (tokens.group(1).startsWith("l")) {
                type = filetype.link;
            }
            long size = -1L;
            try {
                size = Long.parseLong(tokens.group(2));
            }
            catch (NumberFormatException e) {
                log.warn("not a number in list-entry: ", e);
                return null;
            }
            if (tokens.group(5).contains(":")) {
                time = tokens.group(5);
                year = String.valueOf(Calendar.getInstance().get(1));
            } else {
                time = "00:00";
                year = tokens.group(5);
            }
            String dateString = tokens.group(3) + " " + tokens.group(4) + " " + year + " " + time;
            try {
                SimpleDateFormat simpleDateFormat = lsDateFormat;
                synchronized (simpleDateFormat) {
                    date = lsDateFormat.parse(dateString);
                }
            }
            catch (ParseException e) {
                log.warn("---- Error: not ls date-format '" + dateString, e);
                date = new Date();
            }
            String filename = tokens.group(6);
            return new entryInfo(type, size, date, filename);
        }
        return null;
    }

    private String ls(File inode) {
        if (inode == null || !inode.exists()) {
            return "";
        }
        Object s = "";
        s = inode.isDirectory() ? (String)s + "d" : (inode.isFile() ? (String)s + "-" : (String)s + "?");
        s = inode.canRead() ? (String)s + "r" : (String)s + "-";
        s = inode.canWrite() ? (String)s + "w" : (String)s + "-";
        s = (String)s + " " + this.lenformatted(Long.toString(inode.length()), 9);
        DateFormat df = DateFormat.getDateTimeInstance();
        s = (String)s + " " + df.format(new Date(inode.lastModified()));
        s = (String)s + " " + inode.getName();
        if (inode.isDirectory()) {
            s = (String)s + "/";
        }
        return s;
    }

    private String lenformatted(String s, int l) {
        l -= ((String)s).length();
        while (l > 0) {
            s = " " + (String)s;
            --l;
        }
        return s;
    }

    public boolean LITERAL() {
        if (this.cmd.length == 1) {
            log.warn("Syntax: LITERAL <ftp-command> [<command-argument>]   (see RFC959)");
            return true;
        }
        Object s = "";
        for (int i = 1; i < this.cmd.length; ++i) {
            s = (String)s + " " + this.cmd[i];
        }
        try {
            this.literal(((String)s).substring(1));
        }
        catch (IOException e) {
            log.warn("Error: Syntax of FTP-command wrong. See RFC959 for details.");
        }
        return true;
    }

    public boolean LLS() {
        return this.LDIR();
    }

    public boolean LMD() {
        return this.LMKDIR();
    }

    public boolean LMKDIR() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: LMKDIR <folder-name>");
            return true;
        }
        File f = new File(this.currentLocalPath, this.cmd[1]);
        if (f.exists()) {
            log.warn("Error: local file/folder " + this.cmd[1] + " already exists");
        } else if (!f.mkdir()) {
            log.warn("Error: creation of local folder " + this.cmd[1] + " failed");
        }
        return true;
    }

    public boolean LMV() {
        if (this.cmd.length != 3) {
            log.warn("Syntax: LMV <from> <to>");
            return true;
        }
        File from = new File(this.cmd[1]);
        File to = new File(this.cmd[2]);
        if (!to.exists()) {
            if (from.renameTo(to)) {
                log.info("---- \"" + from.toString() + "\" renamed to \"" + to.toString() + "\"");
            } else {
                log.warn("rename failed");
            }
        } else {
            log.warn("\"" + to.toString() + "\" already exists");
        }
        return true;
    }

    public boolean LPWD() {
        if (this.cmd.length != 1) {
            log.warn("Syntax: LPWD  (no parameter)");
            return true;
        }
        log.info("---- Local path: " + this.currentLocalPath.toString());
        return true;
    }

    public boolean LRD() {
        return this.LMKDIR();
    }

    public boolean LRMDIR() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: LRMDIR <folder-name>");
            return true;
        }
        File f = new File(this.currentLocalPath, this.cmd[1]);
        if (!f.exists()) {
            log.warn("Error: local folder " + this.cmd[1] + " does not exist");
        } else if (!f.delete()) {
            log.warn("Error: deletion of local folder " + this.cmd[1] + " failed");
        }
        return true;
    }

    public boolean LRM() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: LRM <file-name>");
            return true;
        }
        File f = new File(this.currentLocalPath, this.cmd[1]);
        if (!f.exists()) {
            log.warn("Error: local file " + this.cmd[1] + " does not exist");
        } else if (!f.delete()) {
            log.warn("Error: deletion of file " + this.cmd[1] + " failed");
        }
        return true;
    }

    public boolean LS() {
        if (this.cmd.length > 2) {
            log.warn("Syntax: LS [<path>|<file>]");
            return true;
        }
        if (this.notConnected()) {
            return this.LLS();
        }
        try {
            List<String> l = this.cmd.length == 2 ? this.list(this.cmd[1], true) : this.list(".", true);
            this.printElements(l);
        }
        catch (IOException e) {
            log.warn("Error: remote list not available (2): " + e.getMessage());
        }
        return true;
    }

    private void printElements(List<String> list2) {
        log.info("---- v---v---v---v---v---v---v---v---v---v---v---v---v---v---v---v---v---v---v");
        for (String element : list2) {
            log.info(element);
        }
        log.info("---- ^---^---^---^---^---^---^---^---^---^---^---^---^---^---^---^---^---^---^");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> list(String path, boolean extended) throws IOException {
        this.createDataSocket();
        this.send("CWD " + path);
        String reply = this.receive();
        int status = this.getStatus(reply);
        if (status > 2) {
            throw new IOException(reply);
        }
        if (extended) {
            this.send("LIST");
        } else {
            this.send("NLST");
        }
        reply = this.receive();
        status = this.getStatus(reply);
        if (status != 1) {
            throw new IOException(reply);
        }
        Socket dataSocket = this.getDataSocket();
        BufferedReader dataStream = new BufferedReader(new InputStreamReader(dataSocket.getInputStream()));
        ArrayList<String> files = new ArrayList<String>();
        try {
            String line;
            while ((line = dataStream.readLine()) != null) {
                if (line.startsWith("total ")) continue;
                files.add(line);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                dataStream.close();
                this.closeDataSocket();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        reply = this.receive();
        files.trimToSize();
        return files;
    }

    public boolean MDIR() {
        return this.MKDIR();
    }

    public boolean MKDIR() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: MKDIR <folder-name>");
            return true;
        }
        if (this.notConnected()) {
            return this.LMKDIR();
        }
        try {
            this.send("MKD " + this.cmd[1]);
            String reply = this.receive();
            if (this.isNotPositiveCompletion(reply)) {
                throw new IOException(reply);
            }
        }
        catch (IOException e) {
            log.warn("Error: creation of folder " + this.cmd[1] + " failed");
        }
        return true;
    }

    public boolean MGET() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: MGET <file-pattern>");
            return true;
        }
        try {
            this.mget(this.cmd[1], false);
        }
        catch (IOException e) {
            log.warn("Error: mget failed (" + e.getMessage() + ")");
        }
        return true;
    }

    private void mget(String pattern, boolean remove) throws IOException {
        List<String> l = this.list(".", false);
        for (String remote : l) {
            if (!this.matches(remote, pattern)) continue;
            File local = new File(this.currentLocalPath, remote);
            if (local.exists()) {
                log.warn("Warning: local file " + local.toString() + " overwritten.");
                if (!local.delete()) {
                    log.warn("Warning: local file " + local.toString() + " could not be deleted.");
                }
            }
            this.retrieveFilesRecursively(remote, remove);
        }
    }

    public boolean MOVEDOWN() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: MOVEDOWN <file-pattern>");
            return true;
        }
        try {
            this.mget(this.cmd[1], true);
        }
        catch (IOException e) {
            log.warn("Error: movedown failed (" + e.getMessage() + ")");
        }
        return true;
    }

    public boolean MV() {
        if (this.cmd.length != 3) {
            log.warn("Syntax: MV <from> <to>");
            return true;
        }
        if (this.notConnected()) {
            return this.LMV();
        }
        try {
            this.send("RNFR " + this.cmd[1]);
            String reply = this.receive();
            if (this.isNotPositiveCompletion(reply)) {
                throw new IOException(reply);
            }
            this.send("RNTO " + this.cmd[2]);
            reply = this.receive();
            if (this.isNotPositiveCompletion(reply)) {
                throw new IOException(reply);
            }
        }
        catch (IOException e) {
            log.warn("Error: rename of " + this.cmd[1] + " to " + this.cmd[2] + " failed.");
        }
        return true;
    }

    public boolean NOOP() {
        if (this.cmd.length != 1) {
            log.warn("Syntax: NOOP  (no parameter)");
            return true;
        }
        try {
            this.literal("NOOP");
        }
        catch (IOException e) {
            log.warn("Error: server does not know how to do nothing");
        }
        return true;
    }

    public boolean OPEN() {
        if (this.cmd.length < 2 || this.cmd.length > 3) {
            log.warn("Syntax: OPEN <host> [<port>]");
            return true;
        }
        int port = 21;
        if (this.cmd.length == 3) {
            try {
                port = Integer.parseInt(this.cmd[2]);
            }
            catch (NumberFormatException e) {
                port = 21;
            }
        }
        if (this.cmd[1].indexOf(58, 0) > 0) {
            port = Integer.parseInt(this.cmd[1].substring(this.cmd[1].indexOf(58, 0) + 1));
            this.cmd[1] = this.cmd[1].substring(0, this.cmd[1].indexOf(58, 0));
        }
        try {
            this.open(this.cmd[1], port);
            log.info("---- Connection to " + this.cmd[1] + " established.");
            this.prompt = "ftp [" + this.cmd[1] + "]>";
        }
        catch (IOException e) {
            log.warn("Error: connecting " + this.cmd[1] + " on port " + port + " failed: " + e.getMessage());
        }
        return true;
    }

    public void open(String host, int port) throws IOException {
        if (this.ControlSocket != null) {
            this.exec("close", false);
        }
        try {
            this.ControlSocket = new Socket();
            this.ControlSocket.setSoTimeout(this.getTimeout());
            this.ControlSocket.setKeepAlive(true);
            this.ControlSocket.setTcpNoDelay(true);
            this.ControlSocket.setSoLinger(false, this.getTimeout());
            this.ControlSocket.setSendBufferSize(1440);
            this.ControlSocket.setReceiveBufferSize(1440);
            this.ControlSocket.connect(new InetSocketAddress(host, port), 1000);
            this.clientInput = new BufferedReader(new InputStreamReader(this.ControlSocket.getInputStream()));
            this.clientOutput = new DataOutputStream(new BufferedOutputStream(this.ControlSocket.getOutputStream()));
            this.host = host;
            this.port = port;
            this.remotemessage = this.receive();
            if (this.remotemessage != null && this.remotemessage.length() > 3) {
                this.remotemessage = this.remotemessage.substring(4);
            }
        }
        catch (IOException e) {
            this.closeConnection();
            throw new IOException(e.getMessage());
        }
    }

    public boolean notConnected() {
        return this.ControlSocket == null;
    }

    private void closeConnection() throws IOException {
        if (this.clientOutput != null) {
            this.clientOutput.close();
        }
        if (this.clientInput != null) {
            this.clientInput.close();
        }
        if (this.ControlSocket != null) {
            this.ControlSocket.close();
        }
        if (this.DataSocketActive != null) {
            this.DataSocketActive.close();
        }
        if (this.DataSocketPassive != null) {
            this.DataSocketPassive.close();
        }
    }

    public boolean PROMPT() {
        log.warn("prompt is always off");
        return true;
    }

    public boolean PUT() {
        String remote;
        if (this.cmd.length < 2 || this.cmd.length > 3) {
            log.warn("Syntax: PUT <local-file> [<remote-file>]");
            return true;
        }
        File local = new File(this.currentLocalPath, this.cmd[1]);
        String string = remote = this.cmd.length == 2 ? local.getName() : this.cmd[2];
        if (!local.exists()) {
            log.warn("Error: local file " + local.toString() + " does not exist.");
            log.warn("            Remote file " + remote + " not overwritten.");
        } else {
            try {
                this.put(local.getAbsolutePath(), remote);
            }
            catch (IOException e) {
                log.warn("Error: transmitting file " + local.toString() + " failed.");
            }
        }
        return true;
    }

    public boolean PWD() {
        if (this.cmd.length > 1) {
            log.warn("Syntax: PWD  (no parameter)");
            return true;
        }
        if (this.notConnected()) {
            return this.LPWD();
        }
        try {
            log.info("---- Current remote path is: " + this.pwd());
        }
        catch (IOException e) {
            log.warn("Error: remote path not available");
        }
        return true;
    }

    private String pwd() throws IOException {
        this.send("PWD");
        String reply = this.receive();
        if (this.isNotPositiveCompletion(reply)) {
            throw new IOException(reply);
        }
        return reply.substring(5, reply.lastIndexOf(34));
    }

    public boolean REMOTEHELP() {
        if (this.cmd.length != 1) {
            log.warn("Syntax: REMOTEHELP  (no parameter)");
            return true;
        }
        try {
            this.literal("HELP");
        }
        catch (IOException e) {
            log.warn("Error: remote help not supported by server.");
        }
        return true;
    }

    public boolean RMDIR() {
        if (this.cmd.length != 2) {
            log.warn("Syntax: RMDIR <folder-name>");
            return true;
        }
        if (this.notConnected()) {
            return this.LRMDIR();
        }
        try {
            this.rmForced(this.cmd[1]);
        }
        catch (IOException e) {
            log.warn("Error: deletion of folder " + this.cmd[1] + " failed.");
        }
        return true;
    }

    public boolean QUIT() {
        if (!this.notConnected()) {
            this.exec("close", false);
        }
        return false;
    }

    public boolean RECV() {
        return this.GET();
    }

    public long fileSize(String path) {
        long size;
        block2: {
            size = -1L;
            try {
                size = this.size(path);
            }
            catch (IOException e) {
                entryInfo info = this.fileInfo(path);
                if (info == null) break block2;
                size = info.size;
            }
        }
        return size;
    }

    public int size(String path) throws IOException {
        this.send("SIZE " + path);
        String reply = this.receive();
        if (this.getStatusCode(reply) != 213) {
            throw new IOException(reply);
        }
        try {
            return Integer.parseInt(reply.substring(4));
        }
        catch (NumberFormatException e) {
            throw new IOException(reply);
        }
    }

    public boolean USER() {
        if (this.cmd.length != 3) {
            log.warn("Syntax: USER <user-name> <password>");
            return true;
        }
        try {
            this.login(this.cmd[1], this.cmd[2]);
            log.info("---- Granted access for user " + this.cmd[1] + ".");
        }
        catch (IOException e) {
            log.warn("Error: authorization of user " + this.cmd[1] + " failed: " + e.getMessage());
        }
        return true;
    }

    public boolean APPEND() {
        log.warn("not yet supported");
        return true;
    }

    public boolean HELP() {
        log.info("---- ftp HELP ----");
        log.info("");
        log.info("This ftp client shell can act as command shell for the local host as well for the");
        log.info("remote host. Commands that point to the local host are preceded by 'L'.");
        log.info("");
        log.info("Supported Commands:");
        log.info("ASCII");
        log.info("   switch remote server to ASCII transfer mode");
        log.info("BINARY");
        log.info("   switch remote server to BINARY transfer mode");
        log.info("BYE");
        log.info("   quit the command shell (same as EXIT)");
        log.info("CD <path>");
        log.info("   change remote path");
        log.info("CLOSE");
        log.info("   close connection to remote host (same as DISCONNECT)");
        log.info("DEL <file>");
        log.info("   delete file on remote server (same as RM)");
        log.info("RM <file>");
        log.info("   remove file from remote server (same as DEL)");
        log.info("DIR [<path>|<file>] ");
        log.info("   print file information for remote directory or file");
        log.info("DISCONNECT");
        log.info("   disconnect from remote server (same as CLOSE)");
        log.info("EXIT");
        log.info("   quit the command shell (same as BYE)");
        log.info("GET <remote-file> [<local-file>]");
        log.info("   load <remote-file> from remote server and store it locally,");
        log.info("   optionally to <local-file>. if the <remote-file> is a directory,");
        log.info("   then all files in that directory are retrieved,");
        log.info("   including recursively all subdirectories.");
        log.info("GLOB");
        log.info("   toggles globbing: matching with wild cards or not");
        log.info("COPY");
        log.info("   copies local files");
        log.info("LCD <path>");
        log.info("   local directory change");
        log.info("LDEL <file>");
        log.info("   local file delete");
        log.info("LDIR");
        log.info("   shows local directory content");
        log.info("LITERAL <ftp-command> [<command-argument>]");
        log.info("   Sends FTP commands as documented in RFC959");
        log.info("LLS");
        log.info("   as LDIR");
        log.info("LMD");
        log.info("   as LMKDIR");
        log.info("LMV <local-from> <local-to>");
        log.info("   copies local files");
        log.info("LPWD");
        log.info("   prints local path");
        log.info("LRD");
        log.info("   as LMKDIR");
        log.info("LRMD <folder-name>");
        log.info("   deletes local directory <folder-name>");
        log.info("LRM <file-name>");
        log.info("   deletes local file <file-name>");
        log.info("LS [<path>|<file>]");
        log.info("   prints list of remote directory <path> or information of file <file>");
        log.info("MDIR");
        log.info("   as MKDIR");
        log.info("MGET <file-pattern>");
        log.info("   copies files from remote server that fits into the");
        log.info("   pattern <file-pattern> to the local path.");
        log.info("MOVEDOWN <file-pattern>");
        log.info("   copies files from remote server as with MGET");
        log.info("   and deletes them afterwards on the remote server");
        log.info("MV <from> <to>");
        log.info("   moves or renames files on the local host");
        log.info("NOOP");
        log.info("   sends the NOOP command to the remote server (which does nothing)");
        log.info("   This command is usually used to measure the speed of the remote server.");
        log.info("OPEN <host[':'port]> [<port>]");
        log.info("   connects the ftp shell to the remote server <host>. Optionally,");
        log.info("   a port number can be given, the default port number is 21.");
        log.info("   Example: OPEN localhost:2121 or OPEN 192.168.0.1 2121");
        log.info("PROMPT");
        log.info("   compatibility command, that usually toggles beween prompting on or off.");
        log.info("   ftp has prompting switched off by default and cannot switched on.");
        log.info("PUT <local-file> [<remote-file>]");
        log.info("   copies the <local-file> to the remote server to the current remote path or");
        log.info("   optionally to the given <remote-file> path.");
        log.info("PWD");
        log.info("   prints current path on the remote server.");
        log.info("REMOTEHELP");
        log.info("   asks the remote server to print the help text of the remote server");
        log.info("RMDIR <folder-name>");
        log.info("   removes the directory <folder-name> on the remote server");
        log.info("QUIT");
        log.info("   exits the ftp application");
        log.info("RECV");
        log.info("   as GET");
        log.info("USER <user-name> <password>");
        log.info("   logs into the remote server with the user <user-name>");
        log.info("   and the password <password>");
        log.info("");
        log.info("");
        log.info("EXAMPLE:");
        log.info("a standard sessions looks like this");
        log.info(">open 192.168.0.1:2121");
        log.info(">user anonymous bob");
        log.info(">pwd");
        log.info(">ls");
        log.info(">.....");
        log.info("");
        log.info("");
        return true;
    }

    public boolean QUOTE() {
        log.warn("not yet supported");
        return true;
    }

    public boolean BELL() {
        log.warn("not yet supported");
        return true;
    }

    public boolean MDELETE() {
        log.warn("not yet supported");
        return true;
    }

    public boolean SEND() {
        log.warn("not yet supported");
        return true;
    }

    public boolean DEBUG() {
        log.warn("not yet supported");
        return true;
    }

    public boolean MLS() {
        log.warn("not yet supported");
        return true;
    }

    public boolean TRACE() {
        log.warn("not yet supported");
        return true;
    }

    public boolean MPUT() {
        log.warn("not yet supported");
        return true;
    }

    public boolean TYPE() {
        log.warn("not yet supported");
        return true;
    }

    public boolean CREATE() {
        log.warn("not yet supported");
        return true;
    }

    private boolean matches(String name, String pattern) {
        if (!this.glob) {
            return name.equals(pattern);
        }
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.length() > 0 && pattern.charAt(0) == '*' && pattern.endsWith("*")) {
            return this.matches(name, pattern.substring(1)) || this.matches(name, pattern.substring(0, pattern.length() - 1));
        }
        try {
            int i = pattern.indexOf(63, 0);
            if (i >= 0) {
                if (!this.matches(name.substring(0, i), pattern.substring(0, i))) {
                    return false;
                }
                return this.matches(name.substring(i + 1), pattern.substring(i + 1));
            }
            i = pattern.indexOf(42, 0);
            if (i >= 0) {
                if (!name.substring(0, i).equals(pattern.substring(0, i))) {
                    return false;
                }
                if (pattern.length() == i + 1) {
                    return true;
                }
                return this.matches(this.reverse(name.substring(i)), this.reverse(pattern.substring(i + 1)) + "*");
            }
            return name.equals(pattern);
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
    }

    private String reverse(String s) {
        if (s.length() < 2) {
            return s;
        }
        return this.reverse(s.substring(1)) + s.charAt(0);
    }

    private void send(String buf) throws IOException {
        if (this.clientOutput == null) {
            return;
        }
        byte[] b = buf.getBytes(StandardCharsets.UTF_8);
        this.clientOutput.write(b, 0, b.length);
        this.clientOutput.write(13);
        this.clientOutput.write(10);
        this.clientOutput.flush();
        if (buf.startsWith("PASS")) {
            log.info("> PASS ********");
        } else {
            log.info("> " + buf);
        }
    }

    private String receive() throws IOException {
        String reply;
        do {
            if (this.clientInput == null) {
                throw new IOException("Server has presumably shut down the connection.");
            }
            reply = this.clientInput.readLine();
            if (reply == null) {
                throw new IOException("Server has presumably shut down the connection.");
            }
            log.info("< " + reply);
        } while (reply.length() < 4 || !Character.isDigit(reply.charAt(0)) || !Character.isDigit(reply.charAt(1)) || !Character.isDigit(reply.charAt(2)) || reply.charAt(3) != ' ');
        return reply;
    }

    private void sendTransferType(char type) throws IOException {
        this.send("TYPE " + type);
        String reply = this.receive();
        if (this.isNotPositiveCompletion(reply)) {
            throw new IOException(reply);
        }
    }

    private Socket getDataSocket() throws IOException {
        Socket data;
        if (this.isPassive()) {
            if (this.DataSocketPassive == null) {
                this.createDataSocket();
            }
            data = this.DataSocketPassive;
        } else {
            if (this.DataSocketActive == null) {
                this.createDataSocket();
            }
            data = this.DataSocketActive.accept();
        }
        return data;
    }

    private void createDataSocket() throws IOException {
        if (this.isPassive()) {
            try {
                this.createPassiveDataPort();
            }
            catch (IOException e) {
                this.createActiveDataPort();
            }
        } else {
            try {
                this.createActiveDataPort();
            }
            catch (IOException e) {
                this.createPassiveDataPort();
            }
        }
    }

    private boolean isPassive() {
        return this.DataSocketPassiveMode;
    }

    private void createActiveDataPort() throws IOException {
        this.DataSocketActive = new ServerSocket(0);
        this.DataSocketActive.setSoTimeout(this.getTimeout());
        this.DataSocketActive.setReceiveBufferSize(1440);
        this.applyDataSocketTimeout();
        int DataPort = this.DataSocketActive.getLocalPort();
        byte[] b = Domains.myPublicIPv4().iterator().next().getAddress();
        short[] s = new short[4];
        for (int i = 0; i < 4; ++i) {
            s[i] = b[i];
            if (s[i] >= 0) continue;
            int n = i;
            s[n] = (short)(s[n] + 256);
        }
        this.send("PORT " + s[0] + "," + s[1] + "," + s[2] + "," + s[3] + "," + ((DataPort & 0xFF00) >> 8) + "," + (DataPort & 0xFF));
        String reply = this.receive();
        if (this.isNotPositiveCompletion(reply)) {
            throw new IOException(reply);
        }
        this.DataSocketPassiveMode = false;
    }

    private void createPassiveDataPort() throws IOException {
        int pos;
        this.send("PASV");
        String reply = this.receive();
        if (this.getStatusCode(reply) != 227) {
            throw new IOException(reply);
        }
        for (pos = 4; pos < reply.length() && (reply.charAt(pos) < '0' || reply.charAt(pos) > '9'); ++pos) {
        }
        if (pos >= reply.length()) {
            throw new IOException(reply + " [could not parse return code]");
        }
        reply = reply.substring(pos);
        for (pos = reply.length() - 1; pos >= 0 && (reply.charAt(pos) < '0' || reply.charAt(pos) > '9'); --pos) {
        }
        if (pos < 0) {
            throw new IOException("[could not parse return code: no numbers]");
        }
        StringTokenizer st = new StringTokenizer(reply = reply.substring(0, pos + 1), ",");
        if (st.countTokens() != 6) {
            throw new IOException("[could not parse return code: wrong number of numbers]");
        }
        int a = Integer.parseInt(st.nextToken());
        int b = Integer.parseInt(st.nextToken());
        int c = Integer.parseInt(st.nextToken());
        int d = Integer.parseInt(st.nextToken());
        InetAddress datahost = Domains.dnsResolve(a + "." + b + "." + c + "." + d);
        int high = Integer.parseInt(st.nextToken());
        int low = Integer.parseInt(st.nextToken());
        if (high < 0 || high > 255 || low < 0 || low > 255) {
            throw new IOException("[could not parse return code: syntax error]");
        }
        int dataport = (high << 8) + low;
        this.DataSocketPassive = new Socket(datahost, dataport);
        this.applyDataSocketTimeout();
        this.DataSocketPassiveMode = true;
    }

    private void closeDataSocket() throws IOException {
        if (this.isPassive()) {
            if (this.DataSocketPassive != null) {
                this.DataSocketPassive.close();
                this.DataSocketPassive = null;
            }
        } else if (this.DataSocketActive != null) {
            this.DataSocketActive.close();
            this.DataSocketActive = null;
        }
    }

    private void applyDataSocketTimeout() throws SocketException {
        if (this.isPassive()) {
            if (this.DataSocketPassive != null) {
                this.DataSocketPassive.setSoTimeout(this.DataSocketTimeout * 1000);
            }
        } else if (this.DataSocketActive != null) {
            this.DataSocketActive.setSoTimeout(this.DataSocketTimeout * 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(String fileDest, String fileName) throws IOException {
        long start = System.currentTimeMillis();
        this.createDataSocket();
        this.sendTransferType('i');
        this.send("RETR " + fileName);
        String reply = this.receive();
        int status = this.getStatus(reply);
        if (status == 1) {
            Socket data = null;
            InputStream ClientStream = null;
            RandomAccessFile outFile = null;
            int length = 0;
            try {
                int numRead;
                data = this.getDataSocket();
                ClientStream = data.getInputStream();
                outFile = fileDest == null ? new RandomAccessFile(fileName, "rw") : new RandomAccessFile(fileDest, "rw");
                byte[] block = new byte[1024];
                while ((numRead = ClientStream.read(block)) != -1) {
                    outFile.write(block, 0, numRead);
                    length += numRead;
                }
            }
            finally {
                if (outFile != null) {
                    outFile.close();
                }
                if (ClientStream != null) {
                    ClientStream.close();
                }
                this.closeDataSocket();
            }
            this.receive();
            long stop = System.currentTimeMillis();
            log.info(" ---- downloaded " + (length < 2048 ? length + " bytes" : length / 1024 + " kbytes") + " in " + (stop - start < 2000L ? stop - start + " milliseconds" : (int)((stop - start) / 100L) / 10 + " seconds"));
            if (start == stop) {
                log.warn("start == stop");
            } else {
                log.info(" (" + (long)(length * 1000 / 1024) / (stop - start) + " kbytes/second)");
            }
        } else {
            throw new IOException(reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String fileName) throws IOException {
        this.createDataSocket();
        this.sendTransferType('i');
        this.send("RETR " + fileName);
        String reply = this.receive();
        int status = this.getStatus(reply);
        if (status == 1) {
            Socket data = null;
            InputStream ClientStream = null;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int length = 0;
            try {
                int numRead;
                data = this.getDataSocket();
                ClientStream = data.getInputStream();
                byte[] block = new byte[1024];
                while ((numRead = ClientStream.read(block)) != -1) {
                    os.write(block, 0, numRead);
                    length += numRead;
                }
            }
            finally {
                if (ClientStream != null) {
                    ClientStream.close();
                }
                this.closeDataSocket();
            }
            this.receive();
            return os.toByteArray();
        }
        throw new IOException(reply);
    }

    private void put(String fileName, String fileDest) throws IOException {
        this.createDataSocket();
        this.sendTransferType('i');
        if (fileDest == null) {
            this.send("STOR " + fileName);
        } else {
            this.send("STOR " + fileDest);
        }
        String reply = this.receive();
        if (this.getStatus(reply) == 1) {
            boolean success;
            int numRead;
            Socket data = this.getDataSocket();
            OutputStream ClientStream = data.getOutputStream();
            RandomAccessFile inFile = new RandomAccessFile(fileName, "r");
            byte[] block = new byte[1024];
            while ((numRead = inFile.read(block)) >= 0) {
                ClientStream.write(block, 0, numRead);
            }
            inFile.close();
            ClientStream.close();
            data.close();
            reply = this.receive();
            boolean bl = success = this.getStatus(reply) == 2;
            if (!success) {
                throw new IOException(reply);
            }
        } else {
            throw new IOException(reply);
        }
    }

    public void login(String account, String password) throws IOException {
        this.unsetLoginData();
        this.send("USER " + account);
        String reply = this.receive();
        switch (this.getStatus(reply)) {
            case 2: {
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                throw new IOException(reply);
            }
            default: {
                this.send("PASS " + password);
                reply = this.receive();
                if (!this.isNotPositiveCompletion(reply)) break;
                throw new IOException(reply);
            }
        }
        this.setLoginData(account, password, reply);
    }

    public boolean isLoggedIn() {
        return this.account != null && this.password != null && this.remotegreeting != null;
    }

    private void setLoginData(String account, String password, String reply) {
        this.account = account;
        this.password = password;
        this.remotegreeting = reply;
    }

    private void unsetLoginData() {
        this.account = null;
        this.password = null;
        this.remotegreeting = null;
    }

    public void sys() throws IOException {
        this.send("SYST");
        String systemType = this.receive();
        if (this.isNotPositiveCompletion(systemType)) {
            throw new IOException(systemType);
        }
        this.remotesystem = systemType.substring(4);
    }

    private void literal(String commandLine) throws IOException {
        this.send(commandLine);
        String reply = this.receive();
        if (this.getStatus(reply) == 5) {
            throw new IOException(reply);
        }
    }

    public int getTimeout() {
        return 10000;
    }

    public void setDataSocketTimeout(int timeout) {
        this.DataSocketTimeout = timeout;
        try {
            this.applyDataSocketTimeout();
        }
        catch (SocketException e) {
            log.warn("setDataSocketTimeout: " + e.getMessage());
        }
    }

    public static List<String> dir(String host, String remotePath, String account, String password, boolean extended) {
        try {
            FTPClient c = new FTPClient();
            c.cmd = new String[]{"open", host};
            c.OPEN();
            c.cmd = new String[]{"user", account, password};
            c.USER();
            c.cmd = new String[]{"ls"};
            List<String> v = c.list(remotePath, extended);
            c.cmd = new String[]{"close"};
            c.CLOSE();
            c.cmd = new String[]{"exit"};
            c.EXIT();
            return v;
        }
        catch (IOException | SecurityException e) {
            return null;
        }
    }

    private static void dir(String host, String remotePath, String account, String password) {
        try {
            FTPClient c = new FTPClient();
            c.exec("open " + host, false);
            c.exec("user " + account + " " + password, false);
            c.exec("cd " + remotePath, false);
            c.exec("ls", true);
            c.exec("close", false);
            c.exec("exit", false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static BlockingQueue<entryInfo> sitelist(String host, int port, String user, String pw, final String path, final int depth) throws IOException {
        final FTPClient ftpClient = new FTPClient();
        ftpClient.open(host, port);
        ftpClient.login(user, pw);
        final LinkedBlockingQueue<entryInfo> queue = new LinkedBlockingQueue<entryInfo>();
        new Thread("FTP.sitelist(" + host + ":" + port + ")"){

            @Override
            public void run() {
                try {
                    FTPClient.sitelist(ftpClient, path, queue, depth);
                    ftpClient.quit();
                }
                catch (Exception exception) {
                }
                finally {
                    queue.add(POISON_entryInfo);
                }
            }
        }.start();
        return queue;
    }

    private static void sitelist(FTPClient ftpClient, String path, LinkedBlockingQueue<entryInfo> queue, int depth) {
        entryInfo info;
        List<String> list2;
        try {
            list2 = ftpClient.list((String)path, true);
        }
        catch (IOException e) {
            if (!((String)path).endsWith("/")) {
                entryInfo info2 = ftpClient.fileInfo((String)path);
                if (info2 != null) {
                    queue.add(info2);
                } else {
                    info2 = new entryInfo();
                    info2.name = path;
                    queue.add(info2);
                }
            } else {
                ConcurrentLog.logException(e);
            }
            return;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        for (String line : list2) {
            info = FTPClient.parseListData(line);
            if (info == null || info.type != filetype.file || info.name.endsWith(".") || info.name.startsWith(".")) continue;
            if (!info.name.startsWith("/")) {
                info.name = (String)path + info.name;
            }
            queue.add(info);
        }
        if (depth > 0) {
            for (String line : list2) {
                int q;
                info = FTPClient.parseListData(line);
                if (info == null || info.name.endsWith(".") || info.name.startsWith(".")) continue;
                if (info.type == filetype.directory) {
                    FTPClient.sitelist(ftpClient, (String)path + info.name, queue, depth - 1);
                    continue;
                }
                if (info.type != filetype.link || (q = info.name.indexOf("->", 0)) < 0 || info.name.indexOf("..", q) >= 0) continue;
                info.name = info.name.substring(0, q).trim();
                FTPClient.sitelist(ftpClient, (String)path + info.name, queue, depth - 1);
            }
        }
    }

    public StringBuilder dirhtml(String remotePath) throws IOException {
        if (this.isFolder((String)remotePath) && '/' != ((String)remotePath).charAt(((String)remotePath).length() - 1)) {
            remotePath = (String)remotePath + "/";
        }
        String pwd = this.pwd();
        List<String> list2 = this.list((String)remotePath, true);
        if (this.remotesystem == null) {
            try {
                this.sys();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String base = "ftp://" + (String)(this.account.equals(ANONYMOUS) ? "" : this.account + ":" + this.password + "@") + this.host + (String)(this.port == 21 ? "" : ":" + this.port) + (String)(((String)remotePath).length() > 0 && ((String)remotePath).charAt(0) == '/' ? "" : pwd + "/") + (String)remotePath;
        return FTPClient.dirhtml(base, this.remotemessage, this.remotegreeting, this.remotesystem, list2, true);
    }

    private static StringBuilder dirhtml(String host, int port, String remotePath, String account, String password) throws IOException {
        FTPClient c = new FTPClient();
        c.open(host, port);
        c.login(account, password);
        c.sys();
        StringBuilder page = c.dirhtml(remotePath);
        c.quit();
        return page;
    }

    public static StringBuilder dirhtml(String base, String servermessage, String greeting, String system, List<String> list2, boolean metaRobotNoindex) {
        StringBuilder page = new StringBuilder(1024);
        String title = "Index of " + base;
        page.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n");
        page.append("<html><head>\n");
        page.append("  <title>").append(title).append("</title>\n");
        page.append("  <meta name=\"generator\" content=\"YaCy directory listing\">\n");
        if (metaRobotNoindex) {
            page.append("  <meta name=\"robots\" content=\"noindex\">\n");
        }
        page.append("  <base href=\"").append(base).append("\">\n");
        page.append("</head><body>\n");
        page.append("  <h1>").append(title).append("</h1>\n");
        if (servermessage != null && greeting != null) {
            page.append("  <p><pre>Server \"").append(servermessage).append("\" responded:\n");
            page.append("  \n");
            page.append(greeting);
            page.append("\n");
            page.append("  </pre></p>\n");
        }
        page.append("  <hr>\n");
        page.append("  <pre>\n");
        for (String line : list2) {
            entryInfo info = FTPClient.parseListData(line);
            if (info != null) {
                int nameStart = line.indexOf(info.name);
                page.append(line.substring(0, nameStart));
                page.append("<a href=\"").append(base).append(info.name).append(info.type == filetype.directory ? "/" : "").append("\">").append(info.name).append("</a>");
                int nameEnd = nameStart + info.name.length();
                if (line.length() > nameEnd) {
                    page.append(line.substring(nameEnd));
                }
            } else if (line.startsWith("http://") || line.startsWith("ftp://") || line.startsWith("smb://") || line.startsWith("file://")) {
                page.append("<a href=\"").append(line).append("\">").append(line).append("</a>");
            } else {
                page.append(line);
            }
            page.append('\n');
        }
        page.append("  </pre>\n");
        page.append("  <hr>\n");
        if (system != null) {
            page.append("  <pre>System info: \"").append(system).append("\"</pre>\n");
        }
        page.append("</body></html>\n");
        return page;
    }

    public static String put(String host, File localFile, String remotePath, String remoteName, String account, String password) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(berr);
        FTPClient c = new FTPClient();
        c.exec("open " + host, false);
        c.exec("user " + account + " " + password, false);
        if (remotePath != null) {
            remotePath = remotePath.replace('\\', '/');
            c.exec("cd " + remotePath, false);
        }
        c.exec("binary", false);
        if (localFile.isAbsolute()) {
            c.exec("lcd \"" + localFile.getParent() + "\"", false);
            localFile = new File(localFile.getName());
        }
        c.exec("put " + localFile.toString() + (String)(remoteName.isEmpty() ? "" : " " + remoteName), false);
        c.exec("close", false);
        c.exec("exit", false);
        out.close();
        err.close();
        String outLog = bout.toString();
        bout.close();
        String errLog = berr.toString();
        berr.close();
        if (errLog.length() > 0) {
            throw new IOException("Ftp put failed:\n" + errLog);
        }
        return outLog;
    }

    public static void get(String host, String remoteFile, File localPath, String account, String password) {
        try {
            FTPClient c = new FTPClient();
            if (remoteFile.isEmpty()) {
                remoteFile = "/";
            }
            c.exec("open " + host, false);
            c.exec("user " + account + " " + password, false);
            c.exec("lcd " + localPath.getAbsolutePath(), false);
            c.exec("binary", false);
            c.exec("get " + remoteFile + " " + localPath.getAbsoluteFile().toString(), false);
            c.exec("close", false);
            c.exec("exit", false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void getAnonymous(String host, String remoteFile, File localPath) {
        FTPClient.get(host, remoteFile, localPath, ANONYMOUS, "anomic");
    }

    public static Thread putAsync(String host, File localFile, String remotePath, String remoteName, String account, String password) {
        Thread t = new Thread((Runnable)new pt(host, localFile, remotePath, remoteName, account, password), "ftp to " + host);
        t.start();
        return t;
    }

    private static void printHelp() {
        System.out.println("FTPClient help");
        System.out.println("----------");
        System.out.println();
        System.out.println("The following commands are supported");
        System.out.println("java net.yacy.cora.protocol.ftp.FTPClient -h  -- prints this help");
        System.out.println("java net.yacy.cora.protocol.ftp.FTPClient -dir <host>[':'<port>] <path> [<account> <password>]");
        System.out.println("java net.yacy.cora.protocol.ftp.FTPClient -htmldir <host> <path>");
        System.out.println("java net.yacy.cora.protocol.ftp.FTPClient -get <host>[':'<port>] <remoteFile> <localPath> [<account> <password>]");
        System.out.println("java net.yacy.cora.protocol.ftp.FTPClient -put <host>[':'<port>] <localFile> <remotePath> <account> <password>");
        System.out.println("java net.yacy.cora.protocol.ftp.FTPClient -sitelist <host> <port> <depth>");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block37: {
            try {
                System.out.println("WELCOME TO THE ANOMIC FTP CLIENT v20161222");
                System.out.println("Visit http://www.anomic.de and support shareware!");
                System.out.println("try -h for command line options");
                System.out.println();
                if (args.length == 1) {
                    if (args[0].equals("-h")) {
                        FTPClient.printHelp();
                    }
                    break block37;
                }
                if (args.length == 2) {
                    FTPClient.printHelp();
                    break block37;
                }
                if (args.length == 3) {
                    if (args[0].equals("-dir")) {
                        FTPClient.dir(args[1], args[2], ANONYMOUS, "anomic@");
                        break block37;
                    }
                    if (args[0].equals("-htmldir")) {
                        File file = new File("dirindex.html");
                        try (FileOutputStream fos = new FileOutputStream(file);){
                            StringBuilder page = FTPClient.dirhtml(args[1], 21, args[2], ANONYMOUS, "anomic@");
                            fos.write(UTF8.getBytes(page.toString()));
                            break block37;
                        }
                        catch (FileNotFoundException e) {
                            log.warn(e);
                        }
                        catch (IOException e) {
                            log.warn(e);
                        }
                        break block37;
                    }
                    FTPClient.printHelp();
                    break block37;
                }
                if (args.length == 4) {
                    if (args[0].equals("-get")) {
                        FTPClient.getAnonymous(args[1], args[2], new File(args[3]));
                        break block37;
                    }
                    if (args[0].equals("-sitelist")) {
                        try {
                            entryInfo entry2;
                            BlockingQueue<entryInfo> q = FTPClient.sitelist(args[1], Integer.parseInt(args[2]), ANONYMOUS, "anomic", "/", Integer.parseInt(args[3]));
                            while ((entry2 = q.take()) != POISON_entryInfo) {
                                System.out.println(entry2.toString());
                            }
                            break block37;
                        }
                        catch (FileNotFoundException e) {
                            log.warn(e);
                            break block37;
                        }
                        catch (IOException e) {
                            log.warn(e);
                            break block37;
                        }
                        catch (InterruptedException e) {
                            log.warn(e);
                            break block37;
                        }
                    }
                    FTPClient.printHelp();
                    break block37;
                }
                if (args.length == 5) {
                    if (args[0].equals("-dir")) {
                        FTPClient.dir(args[1], args[2], args[3], args[4]);
                    } else {
                        FTPClient.printHelp();
                    }
                } else if (args.length == 6) {
                    if (args[0].equals("-get")) {
                        FTPClient.get(args[1], args[2], new File(args[3]), args[4], args[5]);
                    } else if (args[0].equals("-put")) {
                        try {
                            FTPClient.put(args[1], new File(args[2]), args[3], "", args[4], args[5]);
                        }
                        catch (IOException e) {
                            log.warn(e.getMessage(), e);
                        }
                    } else {
                        FTPClient.printHelp();
                    }
                } else {
                    FTPClient.printHelp();
                }
            }
            finally {
                ConcurrentLog.shutdown();
            }
        }
    }

    static class cl
    extends ClassLoader {
        @Override
        public synchronized Class<?> loadClass(String classname, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(classname);
            if (c == null) {
                try {
                    c = this.findSystemClass(classname);
                }
                catch (ClassNotFoundException e) {
                    File f = new File(System.getProperty("user.dir"), classname + ".class");
                    int length = (int)f.length();
                    byte[] classbytes = new byte[length];
                    FilterInputStream in = null;
                    try {
                        in = new DataInputStream(new FileInputStream(f));
                        ((DataInputStream)in).readFully(classbytes);
                        c = this.defineClass(classname, classbytes, 0, classbytes.length);
                    }
                    catch (FileNotFoundException ee) {
                        throw new ClassNotFoundException();
                    }
                    catch (IOException ee) {
                        throw new ClassNotFoundException();
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            log.warn("Could not close input stream on file " + f);
                        }
                    }
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    public static class entryInfo {
        public final filetype type;
        public final long size;
        public final Date date;
        public String name;

        public entryInfo() {
            this.type = filetype.file;
            this.size = -1L;
            this.date = null;
            this.name = null;
        }

        public entryInfo(filetype type, long size, Date date, String name) {
            this.type = type;
            this.size = size;
            this.date = date;
            this.name = name;
        }

        public String toString() {
            StringBuilder info = new StringBuilder(100);
            info.append(this.name);
            info.append(" (type=");
            info.append(this.type.name());
            info.append(", size=");
            info.append(this.size);
            info.append(", ");
            info.append(this.date);
            info.append(")");
            return info.toString();
        }
    }

    public static enum filetype {
        file,
        link,
        directory;

    }

    static class pt
    implements Runnable {
        String host;
        File localFile;
        String remotePath;
        String remoteName;
        String account;
        String password;

        public pt(String h, File l, String rp, String rn, String a, String p) {
            this.host = h;
            this.localFile = l;
            this.remotePath = rp;
            this.remoteName = rn;
            this.account = a;
            this.password = p;
        }

        @Override
        public final void run() {
            try {
                Thread.currentThread().setName("FTP.pt(" + this.host + ")");
                FTPClient.put(this.host, this.localFile, this.remotePath, this.remoteName, this.account, this.password);
            }
            catch (IOException e) {
                log.warn(e.getMessage(), e);
            }
        }
    }
}

