/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.plugin.ClassProvider;
import net.yacy.cora.protocol.tld.GenericTLD;
import net.yacy.cora.protocol.tld.InternationalizedCountryCodeTLD;
import net.yacy.cora.protocol.tld.SponsoredTLD;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.ConcurrentARC;
import net.yacy.cora.storage.KeyList;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.NamePrefixThreadFactory;

public class Domains {
    private static final ConcurrentLog log = new ConcurrentLog(Domains.class.getName());
    public static final String LOCALHOST = "localhost";
    private static String LOCALHOST_NAME = "localhost";
    private static Class<?> InetAddressLocatorClass;
    private static Method InetAddressLocatorGetLocaleInetAddressMethod;
    private static final Set<String> ccSLD_TLD;
    private static final String PRESENT = "";
    private static final String LOCALHOST_IPv4_PATTERN = "(127\\..*)";
    private static final String LOCALHOST_IPv6_PATTERN = "((\\[?fe80\\:.*)|(\\[?0\\:0\\:0\\:0\\:0\\:0\\:0\\:1.*)|(\\[?\\:\\:1))(/.*|%.*|\\z)";
    private static final String INTRANET_IPv4_PATTERN = "(10\\..*)|(172\\.(1[6-9]|2[0-9]|3[0-1])\\..*)|(169\\.254\\..*)|(192\\.168\\..*)";
    private static final String INTRANET_IPv6_PATTERN = "(\\[?(fc|fd).*\\:.*)";
    private static final Pattern LOCALHOST_PATTERNS;
    private static final Pattern INTRANET_PATTERNS;
    private static final int MAX_NAME_CACHE_HIT_SIZE = 10000;
    private static final int MAX_NAME_CACHE_MISS_SIZE = 1000;
    private static final int CONCURRENCY_LEVEL;
    private static final ARC<String, InetAddress> NAME_CACHE_HIT;
    private static final ARC<String, String> NAME_CACHE_MISS;
    private static final ConcurrentHashMap<String, Object> LOOKUP_SYNC;
    private static List<Pattern> nameCacheNoCachingPatterns;
    public static long cacheHit_Hit;
    public static long cacheHit_Miss;
    public static long cacheHit_Insert;
    public static long cacheMiss_Hit;
    public static long cacheMiss_Miss;
    public static long cacheMiss_Insert;
    private static AtomicLong dnsRequests;
    private static Set<InetAddress> myHostAddresses;
    private static Set<InetAddress> localHostAddresses;
    private static Set<InetAddress> publicIPv4HostAddresses;
    private static Set<InetAddress> publicIPv6HostAddresses;
    private static Set<String> localHostNames;
    private static Thread domaininit;
    private static final String[] TLD_NorthAmericaOceania;
    private static final String[] TLD_MiddleSouthAmerica;
    private static final String[] TLD_EuropeRussia;
    private static final String[] TLD_MiddleEastWestAsia;
    private static final String[] TLD_SouthEastAsia;
    private static final String[] TLD_Africa;
    private static final String[] TLD_Infrastructure;
    private static final String[] TLD_GenericRestricted;
    private static final String[] TLD_RecentCountryCodes;
    private static final String[] TLD_OpenNIC;
    private static final String[] ccSLD_TLD_list;
    private static Map<String, Integer> TLDID;
    public static final int TLD_EuropeRussia_ID = 0;
    public static final int TLD_MiddleSouthAmerica_ID = 1;
    public static final int TLD_SouthEastAsia_ID = 2;
    public static final int TLD_MiddleEastWestAsia_ID = 3;
    public static final int TLD_NorthAmericaOceania_ID = 4;
    public static final int TLD_Africa_ID = 5;
    public static final int TLD_Generic_ID = 6;
    public static final int TLD_Local_ID = 7;
    private static KeyList globalHosts;
    private static boolean noLocalCheck;
    private static final ExecutorService getByNameService;
    private static final TimeLimiter timeLimiter;

    private static void insertTLDProps(String[] TLDList, int id) {
        Integer ID = id;
        for (String TLDelement : TLDList) {
            int p = TLDelement.indexOf(61);
            if (p <= 0) continue;
            String tld = TLDelement.substring(0, p).toLowerCase(Locale.ROOT);
            TLDID.put(tld, ID);
        }
    }

    public static void init(File globalHostsnameCache) {
        if (globalHostsnameCache == null) {
            globalHosts = null;
        } else {
            try {
                globalHosts = new KeyList(globalHostsnameCache);
                log.info("loaded globalHosts cache of hostnames, size = " + globalHosts.size());
            }
            catch (IOException e) {
                globalHosts = null;
            }
        }
    }

    public static void setNoLocalCheck(boolean v) {
        noLocalCheck = v;
    }

    public static synchronized void close() {
        if (globalHosts != null) {
            try {
                globalHosts.close();
            }
            catch (IOException e) {
                log.warn(e);
            }
        }
        if (getByNameService != null) {
            getByNameService.shutdownNow();
        }
    }

    public static InetAddress dnsResolveFromCache(String host) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            return null;
        }
        InetAddress ip = NAME_CACHE_HIT.get(host = host.toLowerCase(Locale.ROOT).trim());
        if (ip != null) {
            ++cacheHit_Hit;
            return ip;
        }
        ++cacheHit_Miss;
        if (NAME_CACHE_MISS.containsKey(host)) {
            ++cacheMiss_Hit;
            return null;
        }
        ++cacheMiss_Miss;
        throw new UnknownHostException("host not in cache");
    }

    public static void setNoCachingPatterns(String patternList) throws PatternSyntaxException {
        nameCacheNoCachingPatterns = Domains.makePatterns(patternList);
    }

    public static List<Pattern> makePatterns(String patternList) throws PatternSyntaxException {
        String[] entries2 = patternList != null ? CommonPattern.COMMA.split(patternList) : new String[]{};
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(entries2.length);
        for (String entry2 : entries2) {
            patterns.add(Pattern.compile(entry2.trim()));
        }
        return patterns;
    }

    public static boolean matchesList(String obj, List<Pattern> patterns) {
        for (Pattern nextPattern : patterns) {
            if (!nextPattern.matcher(obj).matches()) continue;
            return true;
        }
        return false;
    }

    public static String getHostName(InetAddress i) {
        Collection<String> hosts = NAME_CACHE_HIT.getKeys(i);
        if (!hosts.isEmpty()) {
            return hosts.iterator().next();
        }
        String host = i.getHostName();
        NAME_CACHE_HIT.insertIfAbsent(host, i);
        ++cacheHit_Insert;
        return host;
    }

    public static void setHostName(InetAddress i, String host) {
        NAME_CACHE_HIT.insertIfAbsent(host, i);
        ++cacheHit_Insert;
    }

    public static String stripToHostName(String target) {
        if (target == null || target.isEmpty()) {
            return null;
        }
        int p = (target = target.toLowerCase(Locale.ROOT).trim()).indexOf("://");
        if (p > 0) {
            target = target.substring(p + 3);
        }
        if ((p = target.indexOf(47)) > 0) {
            target = target.substring(0, p);
        }
        if ((p = target.lastIndexOf(58)) < 0) {
            p = target.lastIndexOf(37);
            if (p > 0) {
                target = target.substring(0, p);
            }
            return target;
        }
        if (p > target.lastIndexOf(93)) {
            target = target.substring(0, p);
        }
        if (target.charAt(0) == '[') {
            target = target.substring(1);
        }
        if (target.charAt(target.length() - 1) == ']') {
            target = target.substring(0, target.length() - 1);
        }
        if ((p = target.lastIndexOf(37)) > 0) {
            target = target.substring(0, p);
        }
        return target;
    }

    public static int stripToPort(String target) {
        int port = 80;
        if (target == null || target.isEmpty()) {
            return port;
        }
        int p = (target = target.toLowerCase(Locale.ROOT).trim()).indexOf("://");
        if (p > 0) {
            String protocol = target.substring(0, p);
            target = target.substring(p + 3);
            if ("https".equals(protocol)) {
                port = 443;
            }
            if ("ftp".equals(protocol)) {
                port = 21;
            }
            if ("smb".equals(protocol)) {
                port = 445;
            }
        }
        if ((p = target.indexOf(47)) > 0) {
            target = target.substring(0, p);
        }
        if ((p = target.lastIndexOf(58)) < 0) {
            return port;
        }
        if (target.lastIndexOf(93) < p) {
            port = Integer.parseInt(target.substring(p + 1));
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetAddress dnsResolve(String host0) {
        if (host0 == null || host0.isEmpty()) {
            return null;
        }
        final String host = host0.toLowerCase(Locale.ROOT).trim();
        if (MemoryControl.shortStatus()) {
            NAME_CACHE_HIT.clear();
            NAME_CACHE_MISS.clear();
        }
        if (host0.endsWith(".yacyh")) {
            return null;
        }
        InetAddress ip = NAME_CACHE_HIT.get(host);
        if (ip != null) {
            ++cacheHit_Hit;
            return ip;
        }
        ++cacheHit_Miss;
        if (NAME_CACHE_MISS.containsKey(host)) {
            ++cacheMiss_Hit;
            return null;
        }
        ++cacheMiss_Miss;
        Object sync_obj_new = new Object();
        Object sync_obj = LOOKUP_SYNC.putIfAbsent(host, sync_obj_new);
        if (sync_obj == null) {
            sync_obj = sync_obj_new;
        }
        Object object = sync_obj;
        synchronized (object) {
            block28: {
                ip = NAME_CACHE_HIT.get(host);
                if (ip != null) {
                    LOOKUP_SYNC.remove(host);
                    ++cacheHit_Hit;
                    return ip;
                }
                ++cacheHit_Miss;
                if (NAME_CACHE_MISS.containsKey(host)) {
                    LOOKUP_SYNC.remove(host);
                    ++cacheMiss_Hit;
                    return null;
                }
                ++cacheMiss_Miss;
                try {
                    String oldName = Thread.currentThread().getName();
                    Thread.currentThread().setName("Domains: DNS resolve of '" + host + "'");
                    if (InetAddresses.isInetAddress((String)host)) {
                        try {
                            ip = InetAddresses.forString((String)host);
                            log.info("using guava for host resolution:" + host);
                        }
                        catch (IllegalArgumentException e) {
                            ip = null;
                        }
                    }
                    Thread.currentThread().setName(oldName);
                    if (ip != null) break block28;
                    long activeRequests = dnsRequests.incrementAndGet();
                    if (activeRequests > 50L) {
                        try {
                            Thread.sleep(10L * (activeRequests - 50L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        ip = (InetAddress)timeLimiter.callWithTimeout((Callable)new Callable<InetAddress>(){

                            @Override
                            public InetAddress call() throws Exception {
                                return InetAddress.getByName(host);
                            }
                        }, 3000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | TimeoutException e) {
                        LOOKUP_SYNC.remove(host);
                        InetAddress inetAddress = null;
                        return inetAddress;
                    }
                    finally {
                        dnsRequests.decrementAndGet();
                    }
                }
                catch (Throwable e) {
                    NAME_CACHE_MISS.insertIfAbsent(host, PRESENT);
                    ++cacheMiss_Insert;
                    LOOKUP_SYNC.remove(host);
                    return null;
                }
            }
            if (ip == null) {
                NAME_CACHE_MISS.insertIfAbsent(host, PRESENT);
                ++cacheMiss_Insert;
                LOOKUP_SYNC.remove(host);
                return null;
            }
            if (!ip.isLoopbackAddress() && !Domains.matchesList(host, nameCacheNoCachingPatterns)) {
                boolean localp;
                NAME_CACHE_HIT.insertIfAbsent(host, ip);
                ++cacheHit_Insert;
                boolean bl = localp = ip.isAnyLocalAddress() || ip.isLinkLocalAddress() || ip.isSiteLocalAddress();
                if (!localp && globalHosts != null) {
                    try {
                        globalHosts.add(host);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            LOOKUP_SYNC.remove(host);
            return ip;
        }
    }

    public static void clear() {
        try {
            globalHosts.clear();
            NAME_CACHE_HIT.clear();
            NAME_CACHE_MISS.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int nameCacheHitSize() {
        return NAME_CACHE_HIT.size();
    }

    public static int nameCacheMissSize() {
        return NAME_CACHE_MISS.size();
    }

    public static int nameCacheNoCachingPatternsSize() {
        return nameCacheNoCachingPatterns.size();
    }

    public static InetAddress myPublicLocalIP() {
        if (publicIPv4HostAddresses.size() > 0) {
            return publicIPv4HostAddresses.iterator().next();
        }
        if (publicIPv6HostAddresses.size() > 0) {
            return publicIPv6HostAddresses.iterator().next();
        }
        return null;
    }

    public static Set<String> myPublicIPs() {
        LinkedHashSet<String> h = new LinkedHashSet<String>(publicIPv4HostAddresses.size() + publicIPv6HostAddresses.size());
        for (InetAddress i : publicIPv4HostAddresses) {
            h.add(i.getHostAddress());
        }
        for (InetAddress i : publicIPv6HostAddresses) {
            h.add(i.getHostAddress());
        }
        return h;
    }

    public static Set<InetAddress> myPublicIPv4() {
        return publicIPv4HostAddresses;
    }

    public static Set<InetAddress> myPublicIPv6() {
        return publicIPv6HostAddresses;
    }

    public static Set<InetAddress> myIntranetIPs() {
        while (domaininit == null || domaininit.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return localHostAddresses;
    }

    public static Set<InetAddress> myIPv4IntranetIPs() {
        HashSet<InetAddress> in = new HashSet<InetAddress>();
        for (InetAddress a : Domains.myIntranetIPs()) {
            if (!(a instanceof Inet4Address)) continue;
            in.add(a);
        }
        return in;
    }

    public static Set<InetAddress> myIPv4IntranetNonLocalhostIPs() {
        HashSet<InetAddress> in = new HashSet<InetAddress>();
        for (InetAddress a : Domains.myIPv4IntranetIPs()) {
            if (((Inet4Address)a).getAddress()[0] == 127) continue;
            in.add(a);
        }
        return in;
    }

    public static boolean isThisHostIP(String hostName) {
        if (hostName == null || hostName.isEmpty()) {
            return false;
        }
        if (hostName.indexOf(58) > 0) {
            return false;
        }
        return Domains.isThisHostIP(Domains.dnsResolve(hostName));
    }

    public static boolean isThisHostIP(Set<String> hostNames) {
        if (hostNames == null || hostNames.isEmpty()) {
            return false;
        }
        for (String hostName : hostNames) {
            if (hostName.indexOf(58) > 0) {
                return false;
            }
            if (!Domains.isThisHostIP(Domains.dnsResolve(hostName))) continue;
            return true;
        }
        return false;
    }

    public static boolean isThisHostIP(InetAddress clientAddress) {
        if (clientAddress == null) {
            return false;
        }
        if (clientAddress.isAnyLocalAddress() || clientAddress.isLoopbackAddress()) {
            return true;
        }
        return myHostAddresses.contains(clientAddress);
    }

    public static int getDomainID(String host, InetAddress hostaddress) {
        if (host == null || host.isEmpty()) {
            return 7;
        }
        int p = host.lastIndexOf(46);
        String tld = p > 0 ? host.substring(p + 1) : PRESENT;
        Integer i = TLDID.get(tld);
        if (i != null) {
            return i;
        }
        return Domains.isLocal(host, hostaddress) ? 7 : 6;
    }

    public static String chopZoneID(String ip) {
        int i = ip.indexOf(37);
        return i < 0 ? ip : ip.substring(0, i);
    }

    public static boolean isLocalhost(String host) {
        if (host == null) {
            return true;
        }
        return LOCALHOST_PATTERNS.matcher(host = Domains.chopZoneID(host)).matches() || localHostNames.contains(host);
    }

    public static boolean isIntranet(String host) {
        return noLocalCheck || host == null || INTRANET_PATTERNS.matcher(host).matches() || localHostNames.contains(host);
    }

    public static boolean isLocal(String host, InetAddress hostaddress) {
        return Domains.isLocal(host, hostaddress, true);
    }

    private static boolean isLocal(String host, InetAddress hostaddress, boolean recursive) {
        if (noLocalCheck || host == null || host.isEmpty()) {
            return true;
        }
        if (Domains.isIntranet(host)) {
            return true;
        }
        if (hostaddress != null && (Domains.isIntranet(hostaddress.getHostAddress()) || Domains.isLocal(hostaddress))) {
            return true;
        }
        if (localHostNames.contains(host)) {
            return true;
        }
        if (globalHosts != null && globalHosts.contains(host)) {
            return false;
        }
        int p = host.lastIndexOf(46);
        String tld = p > 0 ? host.substring(p + 1) : PRESENT;
        Integer i = TLDID.get(tld);
        if (i != null) {
            return false;
        }
        if (!recursive) {
            return false;
        }
        if (hostaddress == null) {
            hostaddress = Domains.dnsResolve(host);
        }
        return Domains.isLocal(hostaddress);
    }

    private static boolean isLocal(InetAddress a) {
        boolean localp = noLocalCheck || a == null || a.isAnyLocalAddress() || a.isLinkLocalAddress() || a.isLoopbackAddress() || a.isSiteLocalAddress();
        return localp;
    }

    public static Locale getLocale(String host) {
        if (host == null) {
            return null;
        }
        Locale locale = Domains.getLocale(Domains.dnsResolve(host));
        if (locale != null && locale.getCountry() != null && locale.getCountry().length() > 0) {
            return locale;
        }
        return null;
    }

    public static Locale getLocale(InetAddress address) {
        if (InetAddressLocatorGetLocaleInetAddressMethod == null) {
            return null;
        }
        if (address == null) {
            return null;
        }
        if (Domains.isLocal(address.getHostAddress(), address, false)) {
            return null;
        }
        try {
            return (Locale)InetAddressLocatorGetLocaleInetAddressMethod.invoke(null, address);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public static String getDNC(String host) {
        if (host == null || host.length() == 0) {
            return PRESENT;
        }
        int p0 = host.lastIndexOf(46);
        if (p0 < 0) {
            return host.toLowerCase(Locale.ROOT);
        }
        int p1 = host.lastIndexOf(46, p0 - 1);
        if (p1 < 0) {
            return host.substring(p0 + 1).toLowerCase(Locale.ROOT);
        }
        String ccSLDTLD = host.substring(p1 + 1).toLowerCase(Locale.ROOT);
        return ccSLD_TLD.contains(ccSLDTLD) ? ccSLDTLD : host.substring(p0 + 1).toLowerCase(Locale.ROOT);
    }

    public static String getSmartSLD(String host) {
        if (host == null || host.length() == 0) {
            return PRESENT;
        }
        int p0 = host.lastIndexOf(46);
        if (p0 < 0) {
            return host.toLowerCase(Locale.ROOT);
        }
        int p1 = host.lastIndexOf(46, p0 - 1);
        if (p1 < 0) {
            return host.substring(0, p0).toLowerCase(Locale.ROOT);
        }
        String ccSLDTLD = host.substring(p1 + 1).toLowerCase(Locale.ROOT);
        if (!ccSLD_TLD.contains(ccSLDTLD)) {
            return host.substring(p1 + 1, p0).toLowerCase(Locale.ROOT);
        }
        int p2 = host.lastIndexOf(46, p1 - 1);
        if (p2 < 0) {
            return host.substring(0, p1).toLowerCase(Locale.ROOT);
        }
        return host.substring(p2 + 1, p1);
    }

    public static void main(String[] args) {
        InetAddress a = Domains.dnsResolve("yacy.net");
        System.out.println(a);
        a = Domains.dnsResolve("kaskelix.de");
        System.out.println(a);
        a = Domains.dnsResolve("yacy.net");
        System.out.println(a);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("myPublicLocalIP: " + Domains.myPublicLocalIP());
        for (InetAddress b : Domains.myIntranetIPs()) {
            System.out.println("Intranet IP: " + b);
        }
    }

    static {
        ccSLD_TLD = new HashSet<String>();
        LOCALHOST_PATTERNS = Pattern.compile("(localhost)|(127\\..*)|((\\[?fe80\\:.*)|(\\[?0\\:0\\:0\\:0\\:0\\:0\\:0\\:1.*)|(\\[?\\:\\:1))(/.*|%.*|\\z)", 2);
        INTRANET_PATTERNS = Pattern.compile(LOCALHOST_PATTERNS.pattern() + "|(10\\..*)|(172\\.(1[6-9]|2[0-9]|3[0-1])\\..*)|(169\\.254\\..*)|(192\\.168\\..*)|(\\[?(fc|fd).*\\:.*)", 2);
        CONCURRENCY_LEVEL = Runtime.getRuntime().availableProcessors() * 2;
        NAME_CACHE_HIT = new ConcurrentARC<String, InetAddress>(10000, CONCURRENCY_LEVEL);
        NAME_CACHE_MISS = new ConcurrentARC<String, String>(1000, CONCURRENCY_LEVEL);
        LOOKUP_SYNC = new ConcurrentHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors() * 2);
        nameCacheNoCachingPatterns = Collections.synchronizedList(new LinkedList());
        cacheHit_Hit = 0L;
        cacheHit_Miss = 0L;
        cacheHit_Insert = 0L;
        cacheMiss_Hit = 0L;
        cacheMiss_Miss = 0L;
        cacheMiss_Insert = 0L;
        dnsRequests = new AtomicLong(0L);
        myHostAddresses = new HashSet<InetAddress>();
        localHostAddresses = new HashSet<InetAddress>();
        publicIPv4HostAddresses = new HashSet<InetAddress>();
        publicIPv6HostAddresses = new HashSet<InetAddress>();
        localHostNames = new HashSet<String>();
        domaininit = null;
        localHostNames.add(LOCALHOST);
        try {
            LOCALHOST_NAME = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        localHostNames.add(LOCALHOST_NAME);
        try {
            InetAddress localHostAddress = InetAddress.getLocalHost();
            if (localHostAddress != null) {
                myHostAddresses.add(localHostAddress);
            }
        }
        catch (UnknownHostException localHostAddress) {
            // empty catch block
        }
        try {
            InetAddress[] moreAddresses = InetAddress.getAllByName(LOCALHOST_NAME);
            if (moreAddresses != null) {
                myHostAddresses.addAll(Arrays.asList(moreAddresses));
            }
        }
        catch (UnknownHostException moreAddresses) {
            // empty catch block
        }
        for (InetAddress a : myHostAddresses) {
            if (!a.isAnyLocalAddress() && !a.isLinkLocalAddress() && !a.isLoopbackAddress() && !a.isSiteLocalAddress()) continue;
            localHostAddresses.add(a);
        }
        domaininit = new Thread("Domains: init"){

            @Override
            public void run() {
                try {
                    Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                    while (nis.hasMoreElements()) {
                        NetworkInterface ni = nis.nextElement();
                        Enumeration<InetAddress> addrs = ni.getInetAddresses();
                        while (addrs.hasMoreElements()) {
                            InetAddress addr = addrs.nextElement();
                            if (addr == null) continue;
                            myHostAddresses.add(addr);
                        }
                    }
                }
                catch (SocketException nis) {
                    // empty catch block
                }
                try {
                    InetAddress[] moreAddresses = InetAddress.getAllByName(LOCALHOST_NAME);
                    if (moreAddresses != null) {
                        myHostAddresses.addAll(Arrays.asList(moreAddresses));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                for (InetAddress a : myHostAddresses) {
                    String hostaddressP = Domains.chopZoneID(a.getHostAddress());
                    LinkedHashSet<String> hns = new LinkedHashSet<String>();
                    if (hostaddressP.indexOf("::") < 0) {
                        hns.add(hostaddressP.replaceFirst(":0:0:0:0:0:0:", "::"));
                        hns.add(hostaddressP.replaceFirst(":0:0:0:0:0:", "::"));
                        hns.add(hostaddressP.replaceFirst(":0:0:0:0:", "::"));
                        hns.add(hostaddressP.replaceFirst(":0:0:0:", "::"));
                        hns.add(hostaddressP.replaceFirst(":0:0:", "::"));
                        hns.add(hostaddressP.replaceFirst(":0:", "::"));
                    }
                    hns.add(hostaddressP);
                    String hostname = Domains.getHostName(a);
                    for (String hostaddress : hns) {
                        if (hostaddress.contains("::0:") || hostaddress.contains(":0::")) continue;
                        boolean isAnyLocalAddress = a.isAnyLocalAddress();
                        boolean isLinkLocalAddress = a.isLinkLocalAddress();
                        boolean isLoopbackAddress = a.isLoopbackAddress();
                        boolean isSiteLocalAddress = a.isSiteLocalAddress();
                        if (isAnyLocalAddress || isLinkLocalAddress || isLoopbackAddress || isSiteLocalAddress) {
                            ConcurrentLog.info("Domain Init", "local host address: " + hostaddress + " (local)");
                            localHostAddresses.add(a);
                            if (hostname == null) continue;
                            localHostNames.add(Domains.chopZoneID(hostname));
                            localHostNames.add(Domains.chopZoneID(hostaddress));
                            continue;
                        }
                        ConcurrentLog.info("Domain Init", "local host address: " + hostaddress + " (public)");
                        if (a instanceof Inet4Address) {
                            publicIPv4HostAddresses.add(a);
                            continue;
                        }
                        publicIPv6HostAddresses.add(a);
                    }
                }
                ConcurrentLog.info("Domain Init", "finished");
            }
        };
        domaininit.start();
        TLD_NorthAmericaOceania = new String[]{"EDU=US Educational", "GOV=US Government", "MIL=US Military", "NET=Network", "ORG=Non-Profit Organization", "AN=Netherlands Antilles", "AS=American Samoa", "AG=Antigua and Barbuda", "AI=Anguilla", "AU=Australia", "BB=Barbados", "BZ=Belize", "BM=Bermuda", "BS=Bahamas", "CA=Canada", "CC=Cocos (Keeling) Islands", "CK=Cook Islands", "CX=Christmas Island", "DM=Dominica", "FM=Micronesia", "FJ=Fiji", "GD=Grenada", "GP=Guadeloupe", "GS=South Georgia and the South Sandwich Islands", "GU=Guam", "HM=Heard and McDonald Islands", "HT=Haiti", "IO=British Indian Ocean Territory", "KI=Kiribati", "KN=Saint Kitts and Nevis", "KY=Cayman Islands", "LC=Saint Lucia", "MF=Saint Martin (French part)", "MH=Marshall Islands", "MP=Northern Mariana Islands", "NC=New Caledonia", "NF=Norfolk Island", "NR=Nauru", "NU=Niue", "NZ=New Zealand (Aotearoa)", "PG=Papua New Guinea", "PN=Pitcairn", "PR=Puerto Rico", "PW=Palau", "SB=Solomon Islands", "TC=Turks and Caicos Islands", "TK=Tokelau", "TO=Tonga", "TT=Trinidad and Tobago", "TV=Tuvalu", "UM=US Minor Outlying Islands", "US=United States", "VC=Saint Vincent and the Grenadines", "VG=Virgin Islands (British)", "VI=Virgin Islands (U.S.)", "VU=Vanuatu", "WF=Wallis and Futuna Islands", "WS=Samoa"};
        TLD_MiddleSouthAmerica = new String[]{"AR=Argentina", "AW=Aruba", "BR=Brazil", "BO=Bolivia", "CL=Chile", "CO=Colombia", "CR=Costa Rica", "CU=Cuba", "DO=Dominican Republic", "EC=Ecuador", "FK=Falkland Islands (Malvinas)", "GF=French Guiana", "GT=Guatemala", "GY=Guyana", "HN=Honduras", "JM=Jamaica", "MX=Mexico", "NI=Nicaragua", "PA=Panama", "PE=Peru", "PY=Paraguay", "SR=Suriname", "SV=El Salvador", "UY=Uruguay", "VE=Venezuela"};
        TLD_EuropeRussia = new String[]{"AD=Andorra", "AL=Albania", "AQ=Antarctica", "AT=Austria", "AX=Aaland Islands", "BA=Bosnia and Herzegovina", "BE=Belgium", "BG=Bulgaria", "BV=Bouvet Island", "BY=Belarus", "CAT=Catalan", "CH=Switzerland", "CS=Czechoslovakia (former)", "CZ=Czech Republic", "CY=Cyprus", "DE=Germany", "DK=Denmark", "ES=Spain", "EE=Estonia", "EU=Europe", "FI=Finland", "FO=Faroe Islands", "FR=France", "FX=France, Metropolitan", "GB=Great Britain (UK)", "GG=Guernsey", "GI=Gibraltar", "GL=Greenland", "GR=Greece", "HR=Croatia (Hrvatska)", "HU=Hungary", "IE=Ireland", "IM=Isle of Man", "IS=Iceland", "IT=Italy", "JE=Jersey", "LI=Liechtenstein", "LT=Lithuania", "LU=Luxembourg", "LV=Latvia", "MC=Monaco", "MD=Moldova", "ME=Montenegro", "MK=Macedonia", "MN=Mongolia", "MS=Montserrat", "MT=Malta", "MQ=Martinique", "NATO=Nato field", "NL=Netherlands", "NO=Norway", "PF=French Polynesia", "PL=Poland", "PM=St. Pierre and Miquelon", "PT=Portugal", "RO=Romania", "RS=Serbia", "RU=Russia", "SE=Sweden", "SI=Slovenia", "SJ=Svalbard and Jan Mayen Islands", "SM=San Marino", "SK=Slovak Republic", "SU=USSR (former)", "TF=French Southern Territories", "UK=United Kingdom", "UA=Ukraine", "VA=Vatican City State (Holy See)", "YU=Yugoslavia"};
        TLD_MiddleEastWestAsia = new String[]{"AE=United Arab Emirates", "AF=Afghanistan", "AM=Armenia", "AZ=Azerbaijan", "BH=Bahrain", "GE=Georgia", "IL=Israel", "IQ=Iraq", "IR=Iran", "JO=Jordan", "KG=Kyrgyzstan", "KZ=Kazakhstan", "KW=Kuwait", "LB=Lebanon", "PS=Palestinian Territory", "OM=Oman", "QA=Qatar", "SA=Saudi Arabia", "SY=Syria", "TJ=Tajikistan", "TM=Turkmenistan", "PK=Pakistan", "TR=Turkey", "UZ=Uzbekistan", "YE=Yemen"};
        TLD_SouthEastAsia = new String[]{"ASIA=The Pan-Asia and Asia Pacific community", "BD=Bangladesh", "BN=Brunei Darussalam", "BT=Bhutan", "CN=China", "HK=Hong Kong", "ID=Indonesia", "IN=India", "LA=Laos", "NP=Nepal", "JP=Japan", "KH=Cambodia", "KP=Korea (North)", "KR=Korea (South)", "LK=Sri Lanka", "MY=Malaysia", "MM=Myanmar", "MO=Macau", "MV=Maldives", "PH=Philippines", "SG=Singapore", "TP=East Timor", "TH=Thailand", "TL=Timor-Leste", "TW=Taiwan", "VN=Viet Nam"};
        TLD_Africa = new String[]{"AC=Ascension Island", "AO=Angola", "BF=Burkina Faso", "BI=Burundi", "BJ=Benin", "BW=Botswana", "CD=Democratic Republic of the Congo", "CF=Central African Republic", "CG=Congo", "CI=Cote D'Ivoire (Ivory Coast)", "CM=Cameroon", "CV=Cape Verde", "DJ=Djibouti", "DZ=Algeria", "EG=Egypt", "EH=Western Sahara", "ER=Eritrea", "ET=Ethiopia", "GA=Gabon", "GH=Ghana", "GM=Gambia", "GN=Guinea", "GQ=Equatorial Guinea", "GW=Guinea-Bissau", "KE=Kenya", "KM=Comoros", "LR=Liberia", "LS=Lesotho", "LY=Libya", "MA=Morocco", "MG=Madagascar", "ML=Mali", "MR=Mauritania", "MU=Mauritius", "MW=Malawi", "MZ=Mozambique", "NA=Namibia", "NE=Niger", "NG=Nigeria", "RE=Reunion", "RW=Rwanda", "SC=Seychelles", "SD=Sudan", "SH=St. Helena", "SL=Sierra Leone", "SN=Senegal", "SO=Somalia", "ST=Sao Tome and Principe", "SZ=Swaziland", "TD=Chad", "TG=Togo", "TN=Tunisia", "TZ=Tanzania", "UG=Uganda", "ZA=South Africa", "ZM=Zambia", "ZR=Zaire", "ZW=Zimbabwe", "YT=Mayotte"};
        TLD_Infrastructure = new String[]{"ARPA=operationally-critical infrastructural identifier spaces"};
        TLD_GenericRestricted = new String[]{"BIZ=Business", "NAME=Individuals", "PRO=Credentialed professionals"};
        TLD_RecentCountryCodes = new String[]{"cw=Cura\u00e7ao", "sx=Sint Maarten"};
        TLD_OpenNIC = new String[]{"GLUE=OpenNIC Internal Architectural use", "BBS=OpenNIC Bulletin Board System servers", "FREE=OpenNIC NAMESPACE, CERT AUTH", "FUR=OpenNIC Furries, Furry Fandom and other Anthropormorphic interest", "GEEK=OpenNIC Geek-oriented sites", "INDY=OpenNIC independent media and arts", "NULL=OpenNIC the DNS version of Usenet's alt. hierarchy", "OSS=OpenNIC reserved exclusively for Open Source Software projects", "PARODY=OpenNIC non-commercial parody work", "DNY=OpenNIC", "ING=OpenNIC", "GOPHER=OpenNIC", "MICRO=OpenNIC"};
        ccSLD_TLD_list = new String[]{"com.ac", "net.ac", "gov.ac", "org.ac", "mil.ac", "co.ae", "net.ae", "gov.ae", "ac.ae", "sch.ae", "org.ae", "mil.ae", "pro.ae", "name.ae", "com.af", "edu.af", "gov.af", "net.af", "org.af", "com.al", "edu.al", "gov.al", "mil.al", "net.al", "org.al", "ed.ao", "gv.ao", "og.ao", "co.ao", "pb.ao", "it.ao", "com.ar", "edu.ar", "gob.ar", "gov.ar", "int.ar", "mil.ar", "net.ar", "org.ar", "tur.ar", "gv.at", "ac.at", "co.at", "or.at", "com.au", "net.au", "org.au", "edu.au", "gov.au", "csiro.au", "asn.au", "id.au", "org.ba", "net.ba", "edu.ba", "gov.ba", "mil.ba", "unsa.ba", "untz.ba", "unmo.ba", "unbi.ba", "unze.ba", "co.ba", "com.ba", "rs.ba", "co.bb", "com.bb", "net.bb", "org.bb", "gov.bb", "edu.bb", "info.bb", "store.bb", "tv.bb", "biz.bb", "com.bh", "info.bh", "cc.bh", "edu.bh", "biz.bh", "net.bh", "org.bh", "gov.bh", "com.bn", "edu.bn", "gov.bn", "net.bn", "org.bn", "com.bo", "net.bo", "org.bo", "tv.bo", "mil.bo", "int.bo", "gob.bo", "gov.bo", "edu.bo", "adm.br", "adv.br", "agr.br", "am.br", "arq.br", "art.br", "ato.br", "b.br", "bio.br", "blog.br", "bmd.br", "cim.br", "cng.br", "cnt.br", "com.br", "coop.br", "ecn.br", "edu.br", "eng.br", "esp.br", "etc.br", "eti.br", "far.br", "flog.br", "fm.br", "fnd.br", "fot.br", "fst.br", "g12.br", "ggf.br", "gov.br", "imb.br", "ind.br", "inf.br", "jor.br", "jus.br", "lel.br", "mat.br", "med.br", "mil.br", "mus.br", "net.br", "nom.br", "not.br", "ntr.br", "odo.br", "org.br", "ppg.br", "pro.br", "psc.br", "psi.br", "qsl.br", "rec.br", "slg.br", "srv.br", "tmp.br", "trd.br", "tur.br", "tv.br", "vet.br", "vlog.br", "wiki.br", "zlg.br", "com.bs", "net.bs", "org.bs", "edu.bs", "gov.bs", "com.bz", "edu.bz", "gov.bz", "net.bz", "org.bz", "om.bz", "du.bz", "ov.bz", "et.bz", "rg.bz", "ab.ca", "bc.ca", "mb.ca", "nb.ca", "nf.ca", "nl.ca", "ns.ca", "nt.ca", "nu.ca", "on.ca", "pe.ca", "qc.ca", "sk.ca", "yk.ca", "co.ck", "org.ck", "edu.ck", "gov.ck", "net.ck", "gen.ck", "biz.ck", "info.ck", "ac.cn", "com.cn", "edu.cn", "gov.cn", "mil.cn", "net.cn", "org.cn", "ah.cn", "bj.cn", "cq.cn", "fj.cn", "gd.cn", "gs.cn", "gz.cn", "gx.cn", "ha.cn", "hb.cn", "he.cn", "hi.cn", "hl.cn", "hn.cn", "jl.cn", "js.cn", "jx.cn", "ln.cn", "nm.cn", "nx.cn", "qh.cn", "sc.cn", "sd.cn", "sh.cn", "sn.cn", "sx.cn", "tj.cn", "tw.cn", "xj.cn", "xz.cn", "yn.cn", "zj.cn", "com.co", "org.co", "edu.co", "gov.co", "net.co", "mil.co", "nom.co", "ac.cr", "co.cr", "ed.cr", "fi.cr", "go.cr", "or.cr", "sa.cr", "cr", "ac.cy", "net.cy", "gov.cy", "org.cy", "pro.cy", "name.cy", "ekloges.cy", "tm.cy", "ltd.cy", "biz.cy", "press.cy", "parliament.cy", "com.cy", "edu.do", "gob.do", "gov.do", "com.do", "sld.do", "org.do", "net.do", "web.do", "mil.do", "art.do", "com.dz", "org.dz", "net.dz", "gov.dz", "edu.dz", "asso.dz", "pol.dz", "art.dz", "com.ec", "info.ec", "net.ec", "fin.ec", "med.ec", "pro.ec", "org.ec", "edu.ec", "gov.ec", "mil.ec", "com.eg", "edu.eg", "eun.eg", "gov.eg", "mil.eg", "name.eg", "net.eg", "org.eg", "sci.eg", "com.er", "edu.er", "gov.er", "mil.er", "net.er", "org.er", "ind.er", "rochest.er", "w.er", "com.es", "nom.es", "org.es", "gob.es", "edu.es", "com.et", "gov.et", "org.et", "edu.et", "net.et", "biz.et", "name.et", "info.et", "ac.fj", "biz.fj", "com.fj", "info.fj", "mil.fj", "name.fj", "net.fj", "org.fj", "pro.fj", "co.fk", "org.fk", "gov.fk", "ac.fk", "nom.fk", "net.fk", "fr", "tm.fr", "asso.fr", "nom.fr", "prd.fr", "presse.fr", "com.fr", "gouv.fr", "co.gg", "net.gg", "org.gg", "com.gh", "edu.gh", "gov.gh", "org.gh", "mil.gh", "com.gn", "ac.gn", "gov.gn", "org.gn", "net.gn", "com.gr", "edu.gr", "net.gr", "org.gr", "gov.gr", "mil.gr", "com.gt", "edu.gt", "net.gt", "gob.gt", "org.gt", "mil.gt", "ind.gt", "com.gu", "net.gu", "gov.gu", "org.gu", "edu.gu", "com.hk", "edu.hk", "gov.hk", "idv.hk", "net.hk", "org.hk", "ac.id", "co.id", "net.id", "or.id", "web.id", "sch.id", "mil.id", "go.id", "war.net.id", "ac.il", "co.il", "org.il", "net.il", "k12.il", "gov.il", "muni.il", "idf.il", "in", "co.in", "firm.in", "net.in", "org.in", "gen.in", "ind.in", "ac.in", "edu.in", "res.in", "ernet.in", "gov.in", "mil.in", "nic.in", "iq", "gov.iq", "edu.iq", "com.iq", "mil.iq", "org.iq", "net.iq", "ir", "ac.ir", "co.ir", "gov.ir", "id.ir", "net.ir", "org.ir", "sch.ir", "dnssec.ir", "gov.it", "edu.it", "co.je", "net.je", "org.je", "com.jo", "net.jo", "gov.jo", "edu.jo", "org.jo", "mil.jo", "name.jo", "sch.jo", "ac.jp", "ad.jp", "co.jp", "ed.jp", "go.jp", "gr.jp", "lg.jp", "ne.jp", "or.jp", "co.ke", "or.ke", "ne.ke", "go.ke", "ac.ke", "sc.ke", "me.ke", "mobi.ke", "info.ke", "per.kh", "com.kh", "edu.kh", "gov.kh", "mil.kh", "net.kh", "org.kh", "com.ki", "biz.ki", "de.ki", "net.ki", "info.ki", "org.ki", "gov.ki", "edu.ki", "mob.ki", "tel.ki", "km", "com.km", "coop.km", "asso.km", "nom.km", "presse.km", "tm.km", "medecin.km", "notaires.km", "pharmaciens.km", "veterinaire.km", "edu.km", "gouv.km", "mil.km", "net.kn", "org.kn", "edu.kn", "gov.kn", "kr", "co.kr", "ne.kr", "or.kr", "re.kr", "pe.kr", "go.kr", "mil.kr", "ac.kr", "hs.kr", "ms.kr", "es.kr", "sc.kr", "kg.kr", "seoul.kr", "busan.kr", "daegu.kr", "incheon.kr", "gwangju.kr", "daejeon.kr", "ulsan.kr", "gyeonggi.kr", "gangwon.kr", "chungbuk.kr", "chungnam.kr", "jeonbuk.kr", "jeonnam.kr", "gyeongbuk.kr", "gyeongnam.kr", "jeju.kr", "edu.kw", "com.kw", "net.kw", "org.kw", "gov.kw", "com.ky", "org.ky", "net.ky", "edu.ky", "gov.ky", "com.kz", "edu.kz", "gov.kz", "mil.kz", "net.kz", "org.kz", "com.lb", "edu.lb", "gov.lb", "net.lb", "org.lb", "gov.lk", "sch.lk", "net.lk", "int.lk", "com.lk", "org.lk", "edu.lk", "ngo.lk", "soc.lk", "web.lk", "ltd.lk", "assn.lk", "grp.lk", "hotel.lk", "com.lr", "edu.lr", "gov.lr", "org.lr", "net.lr", "com.lv", "edu.lv", "gov.lv", "org.lv", "mil.lv", "id.lv", "net.lv", "asn.lv", "conf.lv", "com.ly", "net.ly", "gov.ly", "plc.ly", "edu.ly", "sch.ly", "med.ly", "org.ly", "id.ly", "ma", "net.ma", "ac.ma", "org.ma", "gov.ma", "press.ma", "co.ma", "tm.mc", "asso.mc", "co.me", "net.me", "org.me", "edu.me", "ac.me", "gov.me", "its.me", "priv.me", "org.mg", "nom.mg", "gov.mg", "prd.mg", "tm.mg", "edu.mg", "mil.mg", "com.mg", "com.mk", "org.mk", "net.mk", "edu.mk", "gov.mk", "inf.mk", "name.mk", "pro.mk", "com.ml", "net.ml", "org.ml", "edu.ml", "gov.ml", "presse.ml", "gov.mn", "edu.mn", "org.mn", "com.mo", "edu.mo", "gov.mo", "net.mo", "org.mo", "com.mt", "org.mt", "net.mt", "edu.mt", "gov.mt", "aero.mv", "biz.mv", "com.mv", "coop.mv", "edu.mv", "gov.mv", "info.mv", "int.mv", "mil.mv", "museum.mv", "name.mv", "net.mv", "org.mv", "pro.mv", "ac.mw", "co.mw", "com.mw", "coop.mw", "edu.mw", "gov.mw", "int.mw", "museum.mw", "net.mw", "org.mw", "com.mx", "net.mx", "org.mx", "edu.mx", "gob.mx", "com.my", "net.my", "org.my", "gov.my", "edu.my", "sch.my", "mil.my", "name.my", "com.nf", "net.nf", "arts.nf", "store.nf", "web.nf", "firm.nf", "info.nf", "other.nf", "per.nf", "rec.nf", "com.ng", "org.ng", "gov.ng", "edu.ng", "net.ng", "sch.ng", "name.ng", "mobi.ng", "biz.ng", "mil.ng", "gob.ni", "co.ni", "com.ni", "ac.ni", "edu.ni", "org.ni", "nom.ni", "net.ni", "mil.ni", "com.np", "edu.np", "gov.np", "org.np", "mil.np", "net.np", "edu.nr", "gov.nr", "biz.nr", "info.nr", "net.nr", "org.nr", "com.nr", "com.om", "co.om", "edu.om", "ac.om", "sch.om", "gov.om", "net.om", "org.om", "mil.om", "museum.om", "biz.om", "pro.om", "med.om", "edu.pe", "gob.pe", "nom.pe", "mil.pe", "sld.pe", "org.pe", "com.pe", "net.pe", "com.ph", "net.ph", "org.ph", "mil.ph", "ngo.ph", "i.ph", "gov.ph", "edu.ph", "com.pk", "net.pk", "edu.pk", "org.pk", "fam.pk", "biz.pk", "web.pk", "gov.pk", "gob.pk", "gok.pk", "gon.pk", "gop.pk", "gos.pk", "pwr.pl", "com.pl", "biz.pl", "net.pl", "art.pl", "edu.pl", "org.pl", "ngo.pl", "gov.pl", "info.pl", "mil.pl", "waw.pl", "warszawa.pl", "wroc.pl", "wroclaw.pl", "krakow.pl", "katowice.pl", "poznan.pl", "lodz.pl", "gda.pl", "gdansk.pl", "slupsk.pl", "radom.pl", "szczecin.pl", "lublin.pl", "bialystok.pl", "olsztyn.pl", "torun.pl", "gorzow.pl", "zgora.pl", "biz.pr", "com.pr", "edu.pr", "gov.pr", "info.pr", "isla.pr", "name.pr", "net.pr", "org.pr", "pro.pr", "est.pr", "prof.pr", "ac.pr", "com.ps", "net.ps", "org.ps", "edu.ps", "gov.ps", "plo.ps", "sec.ps", "co.pw", "ne.pw", "or.pw", "ed.pw", "go.pw", "belau.pw", "arts.ro", "com.ro", "firm.ro", "info.ro", "nom.ro", "nt.ro", "org.ro", "rec.ro", "store.ro", "tm.ro", "www.ro", "co.rs", "org.rs", "edu.rs", "ac.rs", "gov.rs", "in.rs", "com.sb", "net.sb", "edu.sb", "org.sb", "gov.sb", "com.sc", "net.sc", "edu.sc", "gov.sc", "org.sc", "co.sh", "com.sh", "org.sh", "gov.sh", "edu.sh", "net.sh", "nom.sh", "com.sl", "net.sl", "org.sl", "edu.sl", "gov.sl", "gov.st", "saotome.st", "principe.st", "consulado.st", "embaixada.st", "org.st", "edu.st", "net.st", "com.st", "store.st", "mil.st", "co.st", "edu.sv", "gob.sv", "com.sv", "org.sv", "red.sv", "co.sz", "ac.sz", "org.sz", "com.tr", "gen.tr", "org.tr", "biz.tr", "info.tr", "av.tr", "dr.tr", "pol.tr", "bel.tr", "tsk.tr", "bbs.tr", "k12.tr", "edu.tr", "name.tr", "net.tr", "gov.tr", "web.tr", "tel.tr", "tv.tr", "co.tt", "com.tt", "org.tt", "net.tt", "biz.tt", "info.tt", "pro.tt", "int.tt", "coop.tt", "jobs.tt", "mobi.tt", "travel.tt", "museum.tt", "aero.tt", "cat.tt", "tel.tt", "name.tt", "mil.tt", "edu.tt", "gov.tt", "edu.tw", "gov.tw", "mil.tw", "com.tw", "net.tw", "org.tw", "idv.tw", "game.tw", "ebiz.tw", "club.tw", "com.mu", "gov.mu", "net.mu", "org.mu", "ac.mu", "co.mu", "or.mu", "ac.mz", "co.mz", "edu.mz", "org.mz", "gov.mz", "com.na", "co.na", "ac.nz", "co.nz", "cri.nz", "geek.nz", "gen.nz", "govt.nz", "health.nz", "iwi.nz", "maori.nz", "mil.nz", "net.nz", "org.nz", "parliament.nz", "school.nz", "abo.pa", "ac.pa", "com.pa", "edu.pa", "gob.pa", "ing.pa", "med.pa", "net.pa", "nom.pa", "org.pa", "sld.pa", "com.pt", "edu.pt", "gov.pt", "int.pt", "net.pt", "nome.pt", "org.pt", "publ.pt", "com.py", "edu.py", "gov.py", "mil.py", "net.py", "org.py", "com.qa", "edu.qa", "gov.qa", "mil.qa", "net.qa", "org.qa", "asso.re", "com.re", "nom.re", "ac.ru", "adygeya.ru", "altai.ru", "amur.ru", "arkhangelsk.ru", "astrakhan.ru", "bashkiria.ru", "belgorod.ru", "bir.ru", "bryansk.ru", "buryatia.ru", "cbg.ru", "chel.ru", "chelyabinsk.ru", "chita.ru", "chukotka.ru", "chuvashia.ru", "com.ru", "dagestan.ru", "e-burg.ru", "edu.ru", "gov.ru", "grozny.ru", "int.ru", "irkutsk.ru", "ivanovo.ru", "izhevsk.ru", "jar.ru", "joshkar-ola.ru", "kalmykia.ru", "kaluga.ru", "kamchatka.ru", "karelia.ru", "kazan.ru", "kchr.ru", "kemerovo.ru", "khabarovsk.ru", "khakassia.ru", "khv.ru", "kirov.ru", "koenig.ru", "komi.ru", "kostroma.ru", "kranoyarsk.ru", "kuban.ru", "kurgan.ru", "kursk.ru", "lipetsk.ru", "magadan.ru", "mari.ru", "mari-el.ru", "marine.ru", "mil.ru", "mordovia.ru", "mosreg.ru", "msk.ru", "murmansk.ru", "nalchik.ru", "net.ru", "nnov.ru", "nov.ru", "novosibirsk.ru", "nsk.ru", "omsk.ru", "orenburg.ru", "org.ru", "oryol.ru", "penza.ru", "perm.ru", "pp.ru", "pskov.ru", "ptz.ru", "rnd.ru", "ryazan.ru", "sakhalin.ru", "samara.ru", "saratov.ru", "simbirsk.ru", "smolensk.ru", "spb.ru", "stavropol.ru", "stv.ru", "surgut.ru", "tambov.ru", "tatarstan.ru", "tom.ru", "tomsk.ru", "tsaritsyn.ru", "tsk.ru", "tula.ru", "tuva.ru", "tver.ru", "tyumen.ru", "udm.ru", "udmurtia.ru", "ulan-ude.ru", "vladikavkaz.ru", "vladimir.ru", "vladivostok.ru", "volgograd.ru", "vologda.ru", "voronezh.ru", "vrn.ru", "vyatka.ru", "yakutia.ru", "yamal.ru", "yekaterinburg.ru", "yuzhno-sakhalinsk.ru", "ac.rw", "co.rw", "com.rw", "edu.rw", "gouv.rw", "gov.rw", "int.rw", "mil.rw", "net.rw", "com.sa", "edu.sa", "gov.sa", "med.sa", "net.sa", "org.sa", "pub.sa", "sch.sa", "com.sd", "edu.sd", "gov.sd", "info.sd", "med.sd", "net.sd", "org.sd", "tv.sd", "a.se", "ac.se", "b.se", "bd.se", "c.se", "d.se", "e.se", "f.se", "g.se", "h.se", "i.se", "k.se", "l.se", "m.se", "n.se", "o.se", "org.se", "p.se", "parti.se", "pp.se", "press.se", "r.se", "s.se", "t.se", "tm.se", "u.se", "w.se", "x.se", "y.se", "z.se", "com.sg", "edu.sg", "gov.sg", "idn.sg", "net.sg", "org.sg", "per.sg", "art.sn", "com.sn", "edu.sn", "gouv.sn", "org.sn", "perso.sn", "univ.sn", "com.sy", "edu.sy", "gov.sy", "mil.sy", "net.sy", "news.sy", "org.sy", "ac.th", "co.th", "go.th", "in.th", "mi.th", "net.th", "or.th", "ac.tj", "biz.tj", "co.tj", "com.tj", "edu.tj", "go.tj", "gov.tj", "info.tj", "int.tj", "mil.tj", "name.tj", "net.tj", "nic.tj", "org.tj", "test.tj", "web.tj", "agrinet.tn", "com.tn", "defense.tn", "edunet.tn", "ens.tn", "fin.tn", "gov.tn", "ind.tn", "info.tn", "intl.tn", "mincom.tn", "nat.tn", "net.tn", "org.tn", "perso.tn", "rnrt.tn", "rns.tn", "rnu.tn", "tourism.tn", "ac.tz", "co.tz", "go.tz", "ne.tz", "or.tz", "biz.ua", "cherkassy.ua", "chernigov.ua", "chernovtsy.ua", "ck.ua", "cn.ua", "co.ua", "com.ua", "crimea.ua", "cv.ua", "dn.ua", "dnepropetrovsk.ua", "donetsk.ua", "dp.ua", "edu.ua", "gov.ua", "if.ua", "in.ua", "ivano-frankivsk.ua", "kh.ua", "kharkov.ua", "kherson.ua", "khmelnitskiy.ua", "kiev.ua", "kirovograd.ua", "km.ua", "kr.ua", "ks.ua", "kv.ua", "lg.ua", "lugansk.ua", "lutsk.ua", "lviv.ua", "me.ua", "mk.ua", "net.ua", "nikolaev.ua", "od.ua", "odessa.ua", "org.ua", "pl.ua", "poltava.ua", "pp.ua", "rovno.ua", "rv.ua", "sebastopol.ua", "sumy.ua", "te.ua", "ternopil.ua", "uzhgorod.ua", "vinnica.ua", "vn.ua", "zaporizhzhe.ua", "zhitomir.ua", "zp.ua", "zt.ua", "ac.ug", "co.ug", "go.ug", "ne.ug", "or.ug", "org.ug", "sc.ug", "ac.uk", "bl.uk", "british-library.uk", "co.uk", "cym.uk", "gov.uk", "govt.uk", "icnet.uk", "jet.uk", "lea.uk", "ltd.uk", "me.uk", "mil.uk", "mod.uk", "national-library-scotland.uk", "nel.uk", "net.uk", "nhs.uk", "nic.uk", "nls.uk", "org.uk", "orgn.uk", "parliament.uk", "plc.uk", "police.uk", "sch.uk", "scot.uk", "soc.uk", "dni.us", "fed.us", "isa.us", "kids.us", "nsn.us", "com.uy", "edu.uy", "gub.uy", "mil.uy", "net.uy", "org.uy", "co.ve", "com.ve", "edu.ve", "gob.ve", "info.ve", "mil.ve", "net.ve", "org.ve", "web.ve", "co.vi", "com.vi", "k12.vi", "net.vi", "org.vi", "ac.vn", "biz.vn", "com.vn", "edu.vn", "gov.vn", "health.vn", "info.vn", "int.vn", "name.vn", "net.vn", "org.vn", "pro.vn", "co.ye", "com.ye", "gov.ye", "ltd.ye", "me.ye", "net.ye", "org.ye", "plc.ye", "ac.yu", "co.yu", "edu.yu", "gov.yu", "org.yu", "ac.za", "agric.za", "alt.za", "bourse.za", "city.za", "co.za", "cybernet.za", "db.za", "ecape.school.za", "edu.za", "fs.school.za", "gov.za", "gp.school.za", "grondar.za", "iaccess.za", "imt.za", "inca.za", "kzn.school.za", "landesign.za", "law.za", "lp.school.za", "mil.za", "mpm.school.za", "ncape.school.za", "net.za", "ngo.za", "nis.za", "nom.za", "nw.school.za", "olivetti.za", "org.za", "pix.za", "school.za", "tm.za", "wcape.school.za", "web.za", "ac.zm", "co.zm", "com.zm", "edu.zm", "gov.zm", "net.zm", "org.zm", "sch.zm", "e164.arpa", "au.com", "br.com", "cn.com", "de.com", "eu.com", "gb.com", "hu.com", "no.com", "qc.com", "ru.com", "sa.com", "se.com", "uk.com", "us.com", "uy.com", "za.com", "de.net", "gb.net", "uk.net", "dk.org", "eu.org", "edu.ac", "com.ae", "com.ai", "edu.ai", "gov.ai", "org.ai", "uba.ar", "esc.edu.ar", "priv.at", "conf.au", "info.au", "otc.au", "oz.au", "telememo.au", "com.az", "net.az", "org.az", "ac.be", "belgie.be", "dns.be", "fgov.be", "com.bm", "edu.bm", "gov.bm", "net.bm", "org.bm", "sp.br", "hk.cn", "mo.cn", "arts.co", "firm.co", "info.co", "int.co", "rec.co", "store.co", "web.co", "com.cu", "net.cu", "org.cu", "co.dk", "ass.dz", "k12.ec", "gov.fj", "id.fj", "school.fj", "com.fk", "aeroport.fr", "assedic.fr", "avocat.fr", "avoues.fr", "barreau.fr", "cci.fr", "chambagri.fr", "chirurgiens-dentistes.fr", "experts-comptables.fr", "geometre-expert.fr", "greta.fr", "huissier-justice.fr", "medecin.fr", "notaires.fr", "pharmacien.fr", "port.fr", "veterinaire.fr", "com.ge", "edu.ge", "gov.ge", "mil.ge", "net.ge", "org.ge", "pvt.ge", "ac.gg", "alderney.gg", "gov.gg", "guernsey.gg", "ind.gg", "ltd.gg", "sark.gg", "sch.gg", "mil.gu", "2000.hu", "agrar.hu", "bolt.hu", "casino.hu", "city.hu", "co.hu", "erotica.hu", "erotika.hu", "film.hu", "forum.hu", "games.hu", "hotel.hu", "info.hu", "ingatlan.hu", "jogasz.hu", "konyvelo.hu", "lakas.hu", "media.hu", "news.hu", "org.hu", "priv.hu", "reklam.hu", "sex.hu", "shop.hu", "sport.hu", "suli.hu", "szex.hu", "tm.hu", "tozsde.hu", "utazas.hu", "video.hu", "ac.im", "co.im", "gov.im", "net.im", "nic.im", "org.im", "ac.je", "gov.je", "ind.je", "jersey.je", "ltd.je", "sch.je", "aichi.jp", "akita.jp", "aomori.jp", "chiba.jp", "ehime.jp", "fukui.jp", "fukuoka.jp", "fukushima.jp", "gifu.jp", "gov.jp", "gunma.jp", "hiroshima.jp", "hokkaido.jp", "hyogo.jp", "ibaraki.jp", "ishikawa.jp", "iwate.jp", "kagawa.jp", "kagoshima.jp", "kanagawa.jp", "kanazawa.jp", "kawasaki.jp", "kitakyushu.jp", "kobe.jp", "kochi.jp", "kumamoto.jp", "kyoto.jp", "matsuyama.jp", "mie.jp", "miyagi.jp", "miyazaki.jp", "nagano.jp", "nagasaki.jp", "nagoya.jp", "nara.jp", "net.jp", "niigata.jp", "oita.jp", "okayama.jp", "okinawa.jp", "org.jp", "osaka.jp", "saga.jp", "saitama.jp", "sapporo.jp", "sendai.jp", "shiga.jp", "shimane.jp", "shizuoka.jp", "takamatsu.jp", "tochigi.jp", "tokushima.jp", "tokyo.jp", "tottori.jp", "toyama.jp", "utsunomiya.jp", "wakayama.jp", "yamagata.jp", "yamaguchi.jp", "yamanashi.jp", "yokohama.jp", "kyonggi.kr", "com.la", "net.la", "org.la", "mil.lb", "com.lc", "edu.lc", "gov.lc", "net.lc", "org.lc", "com.mm", "edu.mm", "gov.mm", "net.mm", "org.mm", "tm.mt", "uu.mt", "alt.na", "cul.na", "edu.na", "net.na", "org.na", "telecom.na", "unam.na", "com.nc", "net.nc", "org.nc", "ac.ng", "tel.no", "fax.nr", "mob.nr", "mobil.nr", "mobile.nr", "tel.nr", "tlf.nr", "mod.om", "ac.pg", "com.pg", "net.pg", "agro.pl", "aid.pl", "atm.pl", "auto.pl", "gmina.pl", "gsm.pl", "mail.pl", "media.pl", "miasta.pl", "nieruchomosci.pl", "nom.pl", "pc.pl", "powiat.pl", "priv.pl", "realestate.pl", "rel.pl", "sex.pl", "shop.pl", "sklep.pl", "sos.pl", "szkola.pl", "targi.pl", "tm.pl", "tourism.pl", "travel.pl", "turystyka.pl", "sch.sd", "mil.sh", "mil.tr", "at.tt", "au.tt", "be.tt", "ca.tt", "de.tt", "dk.tt", "es.tt", "eu.tt", "fr.tt", "it.tt", "nic.tt", "se.tt", "uk.tt", "us.tt", "co.tv", "gove.tw", "edu.uk", "arts.ve", "bib.ve", "firm.ve", "gov.ve", "int.ve", "nom.ve", "rec.ve", "store.ve", "tec.ve", "ch.vu", "com.vu", "de.vu", "edu.vu", "fr.vu", "net.vu", "org.vu", "com.ws", "edu.ws", "gov.ws", "net.ws", "org.ws", "edu.ye", "mil.ye", "ac.zw", "co.zw", "gov.zw", "org.zw"};
        InetAddressLocatorClass = ClassProvider.load("net.sf.javainetlocator.InetAddressLocator", new File("lib/InetAddressLocator.jar"));
        Class[] args = (Class[])Array.newInstance(Class.class, 1);
        args[0] = InetAddress.class;
        InetAddressLocatorGetLocaleInetAddressMethod = ClassProvider.getStaticMethod(InetAddressLocatorClass, "getLocale", args);
        ccSLD_TLD.addAll(Arrays.asList(ccSLD_TLD_list));
        TLDID = new ConcurrentHashMap<String, Integer>();
        Domains.insertTLDProps(TLD_EuropeRussia, 0);
        Domains.insertTLDProps(TLD_MiddleSouthAmerica, 1);
        Domains.insertTLDProps(TLD_SouthEastAsia, 2);
        Domains.insertTLDProps(TLD_MiddleEastWestAsia, 3);
        Domains.insertTLDProps(TLD_NorthAmericaOceania, 4);
        Domains.insertTLDProps(TLD_Africa, 5);
        for (GenericTLD genericTLD : GenericTLD.values()) {
            TLDID.put(genericTLD.getDomainName(), 6);
        }
        Domains.insertTLDProps(TLD_RecentCountryCodes, 6);
        for (Enum enum_ : InternationalizedCountryCodeTLD.values()) {
            TLDID.put(((InternationalizedCountryCodeTLD)enum_).getDomainName(), 6);
        }
        Domains.insertTLDProps(TLD_GenericRestricted, 6);
        Domains.insertTLDProps(TLD_Infrastructure, 6);
        for (Enum enum_ : SponsoredTLD.values()) {
            TLDID.put(((SponsoredTLD)enum_).getDomainName(), 6);
        }
        Domains.insertTLDProps(TLD_OpenNIC, 6);
        globalHosts = null;
        noLocalCheck = false;
        getByNameService = Executors.newCachedThreadPool(new NamePrefixThreadFactory("InetAddress.getByName"));
        timeLimiter = SimpleTimeLimiter.create((ExecutorService)getByNameService);
    }
}

