/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.federate.solr.responsewriter.EmbeddedSolrResponseWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FlatJSONResponseWriter
implements QueryResponseWriter,
EmbeddedSolrResponseWriter {
    private static final char lb = '\n';

    public String getContentType(SolrQueryRequest arg0, SolrQueryResponse arg1) {
        return "application/json; charset=UTF-8";
    }

    public void init(NamedList arg0) {
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse rsp) throws IOException {
        NamedList values = rsp.getValues();
        DocList response = ((ResultContext)values.get("response")).getDocList();
        FlatJSONResponseWriter.writeDocs(writer, request, response);
    }

    private static final void writeDocs(Writer writer, SolrQueryRequest request, DocList response) throws IOException {
        boolean includeScore = false;
        int sz = response.size();
        SolrIndexSearcher searcher = request.getSearcher();
        DocIterator iterator = response.iterator();
        includeScore = includeScore && response.hasScores();
        IndexSchema schema2 = request.getSchema();
        for (int i = 0; i < sz; ++i) {
            int id = iterator.nextDoc();
            Document doc = searcher.doc(id);
            FlatJSONResponseWriter.writeDoc(writer, schema2, doc.getFields());
        }
    }

    private static final void writeDoc(Writer writer, IndexSchema schema2, List<IndexableField> fields) throws IOException {
        JSONObject json = new JSONObject();
        int sz = fields.size();
        int fidx1 = 0;
        int fidx2 = 0;
        while (fidx1 < sz) {
            SchemaField sf;
            IndexableField value = fields.get(fidx1);
            String fieldName = value.name();
            for (fidx2 = fidx1 + 1; fidx2 < sz && fieldName.equals(fields.get(fidx2).name()); ++fidx2) {
            }
            SchemaField schemaField = sf = schema2 == null ? null : schema2.getFieldOrNull(fieldName);
            if (sf == null) {
                sf = new SchemaField(fieldName, (FieldType)new TextField());
            }
            FieldType type = sf.getType();
            try {
                String sv;
                JSONArray a;
                if (fidx1 + 1 == fidx2) {
                    if (sf.multiValued()) {
                        a = new JSONArray();
                        json.put(fieldName, a);
                        JSONObject j = new JSONObject();
                        sv = value.stringValue();
                        FlatJSONResponseWriter.setValue(j, type.getTypeName(), "x", sv);
                        a.put(j.opt("x"));
                    } else {
                        FlatJSONResponseWriter.setValue(json, type.getTypeName(), value.name(), value.stringValue());
                    }
                } else {
                    a = new JSONArray();
                    json.put(fieldName, a);
                    for (int i = fidx1; i < fidx2; ++i) {
                        sv = fields.get(i).stringValue();
                        JSONObject j = new JSONObject();
                        FlatJSONResponseWriter.setValue(j, type.getTypeName(), "x", sv);
                        a.put(j.opt("x"));
                    }
                }
                fidx1 = fidx2;
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage());
            }
        }
        writer.write(json.toString());
        writer.write(10);
    }

    private static void setValue(JSONObject json, String typeName, String name, String value) throws JSONException {
        if (typeName.equals(SolrType.text_general.printName()) || typeName.equals(SolrType.string.printName()) || typeName.equals(SolrType.text_en_splitting_tight.printName())) {
            json.put(name, value);
        } else if (typeName.equals(SolrType.bool.printName())) {
            json.put(name, !"F".equals(value));
        } else if (typeName.equals(SolrType.num_integer.printName())) {
            json.put(name, Long.parseLong(value));
        } else if (typeName.equals(SolrType.num_long.printName())) {
            json.put(name, Long.parseLong(value));
        } else if (typeName.equals(SolrType.date.printName())) {
            json.put(name, new Date(Long.parseLong(value)).toInstant().toString());
        } else if (typeName.equals(SolrType.num_float.printName())) {
            json.put(name, Double.parseDouble(value));
        } else if (typeName.equals(SolrType.num_double.printName())) {
            json.put(name, Double.parseDouble(value));
        }
    }

    public static final void writeDoc(Writer writer, SolrDocument doc) throws IOException {
        JSONObject json = new JSONObject();
        Map fields = doc.getFieldValueMap();
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-DD'T'hh:mm:ssZ");
        for (String key : fields.keySet()) {
            if (key == null) continue;
            Object value = doc.get((Object)key);
            try {
                if (value == null) continue;
                if (value instanceof Collection) {
                    JSONArray a = new JSONArray();
                    json.put(key, a);
                    for (Object o : (Collection)value) {
                        a.put(o instanceof Date ? sdf.format((Date)o) : o);
                    }
                    continue;
                }
                json.put(key, value instanceof Date ? sdf.format((Date)value) : value);
            }
            catch (IllegalArgumentException | NullPointerException | JSONException e) {
                throw new IOException(e.getMessage());
            }
        }
        writer.write(json.toString());
        writer.write(10);
    }
}

