/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.AbstractFederateSearchConnector;
import net.yacy.cora.federate.SolrFederateSearchConnector;
import net.yacy.cora.federate.opensearch.OpenSearchConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.storage.Configuration;
import net.yacy.cora.storage.Files;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.robots.RobotsTxtEntry;
import net.yacy.document.parser.xml.opensearchdescriptionReader;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.schema.WebgraphSchema;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class FederateSearchManager {
    private static final ConcurrentLog LOG = new ConcurrentLog(FederateSearchManager.class.getName());
    private final int accessDelay = 15000;
    private File confFile = null;
    private HashSet<AbstractFederateSearchConnector> conlist = new HashSet();
    protected Configuration cfg;
    private Switchboard switchboard;
    private static FederateSearchManager manager = null;

    public FederateSearchManager(Switchboard sb) {
        if (sb == null) {
            return;
        }
        this.switchboard = sb;
        this.confFile = new File(sb.getDataPath(), "DATA/SETTINGS/heuristicopensearch.conf");
        if (!this.confFile.exists()) {
            try {
                Files.copy(new File(sb.appPath, "defaults/heuristicopensearch.conf"), this.confFile);
                File defdir = new File(sb.dataPath, "DATA/SETTINGS/federatecfg");
                if (!defdir.exists()) {
                    Files.copy(new File(sb.appPath, "defaults/federatecfg"), defdir);
                }
            }
            catch (IOException defdir) {
                // empty catch block
            }
        }
        if (this.confFile.exists()) {
            try {
                this.cfg = new Configuration(this.confFile);
                Iterator<Configuration.Entry> it = this.cfg.entryIterator();
                while (it.hasNext()) {
                    Configuration.Entry cfgentry = it.next();
                    String url = cfgentry.getValue();
                    if (!cfgentry.enabled() || url == null || url.isEmpty()) continue;
                    String name = cfgentry.key();
                    if (url.startsWith("cfgfile:")) {
                        String[] parts = url.split(":");
                        if (parts[1].equalsIgnoreCase("solrconnector")) {
                            SolrFederateSearchConnector sfc = new SolrFederateSearchConnector();
                            if (!sfc.init(name, sb.getDataPath() + "/DATA/SETTINGS/federatecfg/" + parts[2])) continue;
                            this.conlist.add(sfc);
                            continue;
                        }
                        LOG.config("Error in configuration of: " + url);
                        continue;
                    }
                    OpenSearchConnector osc = new OpenSearchConnector(url);
                    if (!osc.init(name, sb.getDataPath() + "/DATA/SETTINGS/federatecfg/" + OpenSearchConnector.htmlMappingFileName(name))) continue;
                    this.conlist.add(osc);
                }
            }
            catch (IOException ex) {
                LOG.config("Unexpected error when reading configuration file : " + this.confFile, ex);
            }
        }
        manager = this;
    }

    public static FederateSearchManager getManager() {
        if (manager == null) {
            manager = new FederateSearchManager(Switchboard.getSwitchboard());
        }
        return manager;
    }

    public void search(SearchEvent theSearch) {
        if (theSearch != null && !theSearch.query.isLocal() && !MemoryControl.shortStatus()) {
            Set<AbstractFederateSearchConnector> picklist = this.getBest();
            for (AbstractFederateSearchConnector fsc : picklist) {
                fsc.search(theSearch);
            }
        }
    }

    public List<URIMetadataNode> query(QueryParams query2) {
        if (!query2.isLocal() && !MemoryControl.shortStatus()) {
            ArrayList<URIMetadataNode> sdl = new ArrayList<URIMetadataNode>();
            Set<AbstractFederateSearchConnector> picklist = this.getBest();
            for (AbstractFederateSearchConnector fsc : picklist) {
                sdl.addAll(fsc.query(query2));
            }
            return sdl;
        }
        return null;
    }

    public List<URIMetadataNode> query(String querystr) {
        QueryGoal qg = new QueryGoal(querystr);
        Bitfield filter = new Bitfield();
        QueryParams query2 = new QueryParams(qg, new QueryModifier(0), Integer.MAX_VALUE, "", Classification.ContentDomain.ALL, "", 0, null, CacheStrategy.IFFRESH, 100, 0, ".*", null, null, QueryParams.Searchdom.LOCAL, filter, false, null, 255, "", false, this.switchboard.index, this.switchboard.getRanking(), "", 0.0, 0.0, 0.0, new HashSet<String>());
        return this.query(query2);
    }

    public boolean addOpenSearchTarget(String name, String urlTemplate, boolean active, String comment) {
        block6: {
            if (this.confFile == null) {
                return false;
            }
            try {
                Configuration conf = new Configuration(this.confFile);
                if (name == null || name.isEmpty()) break block6;
                conf.add(name, null, active);
                Configuration.Entry e = (Configuration.Entry)conf.get(name);
                e.setValue(urlTemplate);
                e.setEnable(active);
                e.setComment(comment);
                conf.put(name, e);
                try {
                    String htmlMappingFile;
                    OpenSearchConnector osd;
                    conf.commit();
                    if (active && (osd = new OpenSearchConnector(urlTemplate)).init(name, htmlMappingFile = this.switchboard.getDataPath() + "/DATA/SETTINGS/federatecfg/" + OpenSearchConnector.htmlMappingFileName(name))) {
                        this.conlist.add(osd);
                    }
                }
                catch (IOException ex) {
                    LOG.warn("config file write error");
                }
                return true;
            }
            catch (IOException e1) {
                LOG.severe("Unexpected error when writing configuration file : " + this.confFile, e1);
                return false;
            }
        }
        return false;
    }

    public int getSize() {
        return this.conlist.size();
    }

    protected Set<AbstractFederateSearchConnector> getBest() {
        HashSet<AbstractFederateSearchConnector> retset = new HashSet<AbstractFederateSearchConnector>();
        long currentTime = System.currentTimeMillis();
        for (AbstractFederateSearchConnector fsc : this.conlist) {
            long l = fsc.lastaccesstime;
            Objects.requireNonNull(this);
            if (l + 15000L >= currentTime || fsc.lastaccesstime >= currentTime) continue;
            retset.add(fsc);
        }
        return retset;
    }

    public boolean discoverFromSolrIndex(final Switchboard sb) {
        long numfound;
        boolean metafieldavailable;
        if (sb == null) {
            return false;
        }
        if (!sb.index.fulltext().useWebgraph()) {
            LOG.severe("Error on connecting to embedded Solr webgraph index");
            return false;
        }
        final SolrConnector connector = sb.index.fulltext().getWebgraphConnector();
        boolean bl = metafieldavailable = sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_rel_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_protocol_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_urlstub_s.name()) && sb.getConfigBool("core.service.webgraph.tmp", false);
        if (!metafieldavailable) {
            LOG.warn("webgraph option and webgraph Schema fields target_rel_s, target_protocol_s and target_urlstub_s must be switched on");
            return false;
        }
        final String webgraphquerystr = WebgraphSchema.target_rel_s.getSolrFieldName() + ":search";
        final String[] webgraphqueryfields = new String[]{WebgraphSchema.target_protocol_s.getSolrFieldName(), WebgraphSchema.target_urlstub_s.getSolrFieldName()};
        try {
            SolrDocumentList docList = connector.getDocumentListByQuery(webgraphquerystr, null, 0, 1, webgraphqueryfields);
            numfound = docList.getNumFound();
            if (numfound == 0L) {
                LOG.info("no results found, abort discover job");
                return true;
            }
            LOG.info("start checking " + Long.toString(numfound) + " found index results");
        }
        catch (IOException ex) {
            LOG.severe("Error on Solr webgraph core query", ex);
            return false;
        }
        final long stoptime = System.currentTimeMillis() + 3600000L;
        Thread job = new Thread(FederateSearchManager.class.getSimpleName() + ".discoverFromSolrIndex"){

            @Override
            public void run() {
                try {
                    boolean doloop = true;
                    int loopnr = 0;
                    HashSet<String> dblmem = new HashSet<String>();
                    while (doloop) {
                        LOG.info("start Solr query loop at " + Integer.toString(loopnr * 20) + " of " + Long.toString(numfound));
                        SolrDocumentList docList = connector.getDocumentListByQuery(webgraphquerystr, null, loopnr * 20, 20, webgraphqueryfields);
                        ++loopnr;
                        if (stoptime < System.currentTimeMillis()) {
                            doloop = false;
                            LOG.info("long running discover task aborted");
                        }
                        if (docList != null && docList.size() > 0) {
                            for (SolrDocument sdoc : docList) {
                                URL url;
                                String hrefurltxt = sdoc.getFieldValue(WebgraphSchema.target_protocol_s.getSolrFieldName()) + "://" + sdoc.getFieldValue(WebgraphSchema.target_urlstub_s.getSolrFieldName());
                                try {
                                    url = new URI(hrefurltxt).toURL();
                                }
                                catch (MalformedURLException | URISyntaxException ex) {
                                    LOG.warn("OpenSearch description URL is malformed : " + hrefurltxt);
                                    continue;
                                }
                                if (!dblmem.add(url.getAuthority())) continue;
                                opensearchdescriptionReader os = new opensearchdescriptionReader(hrefurltxt);
                                if (os.getRSSorAtomUrl() != null) {
                                    MultiProtocolURL templateURL;
                                    RobotsTxtEntry robotsEntry = null;
                                    try {
                                        templateURL = new MultiProtocolURL(os.getRSSorAtomUrl());
                                    }
                                    catch (MalformedURLException ex) {
                                        LOG.warn("OpenSearch description URL is malformed : " + hrefurltxt);
                                        continue;
                                    }
                                    if (sb.robots != null) {
                                        robotsEntry = sb.robots.getEntry(templateURL, ClientIdentification.yacyInternetCrawlerAgent);
                                    }
                                    if (robotsEntry != null && robotsEntry.isDisallowed(templateURL)) {
                                        LOG.info("OpenSearch description template URL is disallowed by robots.xt");
                                        continue;
                                    }
                                    FederateSearchManager.this.addOpenSearchTarget(os.getShortName(), os.getRSSorAtomUrl(), false, os.getItem("LongName"));
                                    LOG.info("added " + os.getShortName() + " " + hrefurltxt);
                                    continue;
                                }
                                LOG.info("osd.xml check failed (no RSS or Atom support) for " + hrefurltxt);
                            }
                            continue;
                        }
                        doloop = false;
                    }
                    LOG.info("finisched Solr query (checked " + Integer.toString(dblmem.size()) + " unique opensearchdescription links found in " + Long.toString(numfound) + " results)");
                }
                catch (IOException ex) {
                    LOG.severe("Unexpected error", ex);
                }
            }
        };
        job.start();
        return true;
    }

    public boolean init(String cfgFileName) {
        this.confFile = new File(cfgFileName);
        if (this.confFile.exists()) {
            try {
                this.cfg = new Configuration(this.confFile);
                if (!this.conlist.isEmpty()) {
                    this.conlist.clear();
                }
                Iterator<Configuration.Entry> it = this.cfg.entryIterator();
                while (it.hasNext()) {
                    Configuration.Entry cfgentry = it.next();
                    if (!cfgentry.enabled()) continue;
                    String name = cfgentry.key();
                    String url = cfgentry.getValue();
                    if (url == null || url.isEmpty()) continue;
                    if (url.startsWith("cfgfile:")) {
                        String[] parts = url.split(":");
                        if (parts[1].equalsIgnoreCase("solrconnector")) {
                            SolrFederateSearchConnector sfc = new SolrFederateSearchConnector();
                            if (!sfc.init(name, this.confFile.getParent() + "/federatecfg/" + parts[2])) continue;
                            this.conlist.add(sfc);
                            continue;
                        }
                        LOG.config("Init error in configuration of: " + url);
                        continue;
                    }
                    OpenSearchConnector osd = new OpenSearchConnector(url);
                    if (!osd.init(name, this.confFile.getParent() + "/federatecfg/" + OpenSearchConnector.htmlMappingFileName(name))) continue;
                    this.conlist.add(osd);
                }
            }
            catch (IOException ex) {
                LOG.config("Unexpected error when reading configuration file : " + cfgFileName);
            }
        }
        return true;
    }
}

