/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.update.processor.Lookup3Signature;

public class EnhancedTextProfileSignature
extends Lookup3Signature {
    private float quantRate = 0.01f;
    private int minTokenLen = 2;
    private StringBuilder evalText = new StringBuilder(120);

    public void init(SolrParams params) {
        this.quantRate = params.getFloat("quantRate", 0.01f);
        this.minTokenLen = params.getInt("minTokenLen", 2);
    }

    public byte[] getSignature() {
        return super.getSignature();
    }

    public StringBuilder getSignatureText() {
        return this.evalText;
    }

    public void add(String content) {
        HashMap<String, Token> tokens = new HashMap<String, Token>();
        StringBuilder curToken = new StringBuilder();
        int maxFreq = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                curToken.append(Character.toLowerCase(c));
                continue;
            }
            if (curToken.length() <= 0) continue;
            if (curToken.length() > this.minTokenLen) {
                String s = curToken.toString();
                Token tok = (Token)tokens.get(s);
                if (tok == null) {
                    tok = new Token(0, s);
                    tokens.put(s, tok);
                }
                ++tok.cnt;
                if (tok.cnt > maxFreq) {
                    maxFreq = tok.cnt;
                }
            }
            curToken.setLength(0);
        }
        if (curToken.length() > this.minTokenLen) {
            String s = curToken.toString();
            Token tok = (Token)tokens.get(s);
            if (tok == null) {
                tok = new Token(0, s);
                tokens.put(s, tok);
            }
            ++tok.cnt;
            if (tok.cnt > maxFreq) {
                maxFreq = tok.cnt;
            }
        }
        Iterator<Object> it = tokens.values().iterator();
        ArrayList<Token> profile2 = new ArrayList<Token>();
        int quant = Math.round((float)maxFreq * this.quantRate);
        if (quant < 2) {
            quant = maxFreq > 1 ? 2 : 1;
        }
        while (it.hasNext()) {
            Token t = (Token)it.next();
            t.qcnt = t.cnt / quant * quant;
            if (t.qcnt < quant) continue;
            profile2.add(t);
        }
        Collections.sort(profile2, new TokenComparator());
        StringBuilder newText = new StringBuilder(120);
        for (Token t : profile2) {
            if (newText.length() > 0) {
                newText.append(' ');
                this.evalText.append(' ');
            }
            newText.append('(').append(t.val).append('-').append(t.qcnt).append(')');
            this.evalText.append('(').append(t.val).append('-').append(t.cnt).append('-').append(t.qcnt).append(')');
        }
        super.add(newText.toString());
    }

    public static long getSignatureLong(String text) {
        Lookup3Signature sig = new Lookup3Signature();
        sig.add(text);
        return EnhancedTextProfileSignature.getSignatureLong(sig);
    }

    public static long getSignatureLong(String[] texts) {
        Lookup3Signature sig = new Lookup3Signature();
        for (String s : texts) {
            sig.add(s);
        }
        return EnhancedTextProfileSignature.getSignatureLong(sig);
    }

    public static long getSignatureLong(Lookup3Signature sig) {
        byte[] hash = sig.getSignature();
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = (l << 8) + (long)(hash[i] & 0xFF);
        }
        return l;
    }

    private static class Token {
        public int cnt;
        public int qcnt;
        public String val;

        public Token(int cnt, String val) {
            this.cnt = cnt;
            this.val = val;
        }

        public String toString() {
            return this.val + " " + this.cnt;
        }
    }

    private static class TokenComparator
    implements Comparator<Token> {
        private TokenComparator() {
        }

        @Override
        public int compare(Token t1, Token t2) {
            return t2.cnt - t1.cnt;
        }
    }
}

