/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.date;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.yacy.cora.date.AbstractFormatter;
import net.yacy.cora.date.DateFormatter;
import net.yacy.cora.util.NumberTools;

public class GenericFormatter
extends AbstractFormatter
implements DateFormatter {
    public static final String PATTERN_SHORT_DAY = "yyyyMMdd";
    public static final String PATTERN_SHORT_MINUTE = "yyyyMMddHHmm";
    public static final String PATTERN_SHORT_SECOND = "yyyyMMddHHmmss";
    public static final String PATTERN_SHORT_MILSEC = "yyyyMMddHHmmssSSS";
    public static final String PATTERN_RFC1123_SHORT = "EEE, dd MMM yyyy";
    public static final String PATTERN_ANSIC = "EEE MMM d HH:mm:ss yyyy";
    public static final String PATTERN_SIMPLE = "yyyy/MM/dd HH:mm:ss";
    public static final String PATTERN_SIMPLE_REGEX = "[0-9]{4}/(0[1-9]|1[012])/(0[1-9]|1[0-9]|2[0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3])(:[0-5][0-9]){2}";
    public static final DateTimeFormatter FORMAT_SHORT_DAY = DateTimeFormatter.ofPattern("yyyyMMdd".replace("yyyy", "uuuu"), Locale.US).withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter FORMAT_SHORT_MINUTE = DateTimeFormatter.ofPattern("yyyyMMddHHmm".replace("yyyy", "uuuu"), Locale.US).withZone(ZoneId.systemDefault());
    public static final DateTimeFormatter FORMAT_SHORT_SECOND = DateTimeFormatter.ofPattern("yyyyMMddHHmmss".replace("yyyy", "uuuu"), Locale.US).withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter FORMAT_SHORT_MILSEC = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmssSSS".replace("yyyy", "uuuu").replaceAll("SSS", "")).appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter().withLocale(Locale.US).withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter FORMAT_RFC1123_SHORT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy".replace("yyyy", "uuuu"), Locale.US).withZone(ZoneId.systemDefault());
    public static final DateTimeFormatter FORMAT_ANSIC = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy".replace("yyyy", "uuuu"), Locale.US).withZone(ZoneId.systemDefault());
    public static final DateTimeFormatter FORMAT_SIMPLE = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss".replace("yyyy", "uuuu"), Locale.US).withZone(ZoneId.systemDefault());
    public static final long time_second = 1000L;
    public static final long time_minute = 60000L;
    public static final long time_hour = 3600000L;
    public static final long time_day = 86400000L;
    public static final GenericFormatter SHORT_DAY_FORMATTER = new GenericFormatter(GenericFormatter.newShortDayFormat(), 60000L);
    public static final GenericFormatter SHORT_MINUTE_FORMATTER = new GenericFormatter(GenericFormatter.newShortMinuteFormat(), 1000L);
    public static final GenericFormatter SHORT_SECOND_FORMATTER = new GenericFormatter(GenericFormatter.newShortSecondFormat(), 1000L);
    public static final GenericFormatter SHORT_MILSEC_FORMATTER = new GenericFormatter(GenericFormatter.newShortMilsecFormat(), 1L);
    public static final GenericFormatter RFC1123_SHORT_FORMATTER = new GenericFormatter(GenericFormatter.newRfc1123ShortFormat(), 60000L);
    public static final GenericFormatter ANSIC_FORMATTER = new GenericFormatter(GenericFormatter.newAnsicFormat(), 1000L);
    public static final GenericFormatter SIMPLE_FORMATTER = new GenericFormatter(GenericFormatter.newSimpleDateFormat(), 1000L);
    private final SimpleDateFormat dateFormat;
    private final long maxCacheDiff;
    private static final DecimalFormat D2 = new DecimalFormat("00");

    public static SimpleDateFormat newShortDayFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(PATTERN_SHORT_DAY, Locale.US);
        dateFormat.setTimeZone(UTCtimeZone);
        return dateFormat;
    }

    public static SimpleDateFormat newShortMinuteFormat() {
        return new SimpleDateFormat(PATTERN_SHORT_MINUTE, Locale.US);
    }

    public static SimpleDateFormat newShortSecondFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(PATTERN_SHORT_SECOND, Locale.US);
        dateFormat.setTimeZone(UTCtimeZone);
        return dateFormat;
    }

    public static SimpleDateFormat newShortMilsecFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(PATTERN_SHORT_MILSEC, Locale.US);
        dateFormat.setTimeZone(UTCtimeZone);
        return dateFormat;
    }

    public static SimpleDateFormat newRfc1123ShortFormat() {
        return new SimpleDateFormat(PATTERN_RFC1123_SHORT, Locale.US);
    }

    public static SimpleDateFormat newAnsicFormat() {
        return new SimpleDateFormat(PATTERN_ANSIC, Locale.US);
    }

    public static SimpleDateFormat newSimpleDateFormat() {
        return new SimpleDateFormat(PATTERN_SIMPLE, Locale.US);
    }

    public GenericFormatter(SimpleDateFormat dateFormat, long maxCacheDiff) {
        this.dateFormat = (SimpleDateFormat)dateFormat.clone();
        this.last_time = 0L;
        this.last_format = "";
        this.maxCacheDiff = maxCacheDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return this.dateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format() {
        if (Math.abs(System.currentTimeMillis() - this.last_time) < this.maxCacheDiff) {
            return this.last_format;
        }
        long time = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            if (Math.abs(time - this.last_time) < this.maxCacheDiff) {
                return this.last_format;
            }
            this.last_format = this.dateFormat.format(new Date(time));
        }
        this.last_time = time;
        return this.last_format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Calendar parse(String timeString, int timezoneOffset) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            Calendar cal = Calendar.getInstance(UTCtimeZone);
            cal.setTime(this.dateFormat.parse(timeString));
            cal.add(12, timezoneOffset);
            return cal;
        }
    }

    public Calendar parse(String timeString, String UTCOffset) throws ParseException {
        if (timeString == null || timeString.isEmpty()) {
            return Calendar.getInstance(UTCtimeZone);
        }
        if (UTCOffset == null || UTCOffset.isEmpty()) {
            return Calendar.getInstance(UTCtimeZone);
        }
        return this.parse(timeString, GenericFormatter.UTCDiff(UTCOffset));
    }

    private static int UTCDiff(String diffString) {
        if (diffString.length() != 5) {
            throw new IllegalArgumentException("UTC String malformed (wrong size):" + diffString);
        }
        boolean ahead = true;
        if (diffString.length() > 0 && diffString.charAt(0) == '+') {
            ahead = true;
        } else if (diffString.length() > 0 && diffString.charAt(0) == '-') {
            ahead = false;
        } else {
            throw new IllegalArgumentException("UTC String malformed (wrong sign):" + diffString);
        }
        int oh = NumberTools.parseIntDecSubstring(diffString, 1, 3);
        int om = NumberTools.parseIntDecSubstring(diffString, 3);
        return (ahead ? 1 : -1) * (oh * 60 + om);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long UTCDiff() {
        Calendar calendar = testCalendar;
        synchronized (calendar) {
            testCalendar.setTimeInMillis(System.currentTimeMillis());
            long zoneOffsetHours = testCalendar.get(15);
            long DSTOffsetHours = testCalendar.get(16);
            return zoneOffsetHours + DSTOffsetHours;
        }
    }

    public static String UTCDiffString() {
        long offsetHours = GenericFormatter.UTCDiff();
        StringBuilder sb = new StringBuilder(5);
        if (offsetHours < 0L) {
            sb.append('-');
        } else {
            sb.append('+');
        }
        sb.append(D2.format(Math.abs((int)(offsetHours / 3600000L))));
        sb.append(D2.format(Math.abs((int)(offsetHours / 60000L)) % 60));
        return sb.toString();
    }

    public static String formatSafely(long time, DateTimeFormatter formatter) {
        String res;
        try {
            res = GenericFormatter.formatSafely(Instant.ofEpochMilli(time), formatter);
        }
        catch (DateTimeException e) {
            res = String.valueOf(time);
        }
        return res;
    }

    public static String formatSafely(Instant instant, DateTimeFormatter formatter) {
        String res;
        if (instant == null) {
            res = "";
        } else {
            try {
                res = formatter != null ? formatter.format(instant) : instant.toString();
            }
            catch (DateTimeException e) {
                res = instant.toString();
            }
        }
        return res;
    }

    public static void main(String[] args) {
        System.out.println(GenericFormatter.UTCDiffString());
    }
}

