/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.yacy.ai.OpenAIClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OllamaClient {
    public static String OLLAMA_API_HOST = "http://localhost:11434";
    private final String hoststub;

    public OllamaClient(String hoststub) {
        this.hoststub = hoststub;
    }

    public LinkedHashMap<String, Long> listOllamaModels() {
        LinkedHashMap<String, Long> sortedMap = new LinkedHashMap<String, Long>();
        try {
            String response = OpenAIClient.sendGetRequest(this.hoststub + "/api/tags");
            JSONObject responseObject = new JSONObject(response);
            JSONArray models = responseObject.getJSONArray("models");
            ArrayList<AbstractMap.SimpleEntry<String, Long>> list2 = new ArrayList<AbstractMap.SimpleEntry<String, Long>>();
            for (int i = 0; i < models.length(); ++i) {
                JSONObject jSONObject = models.getJSONObject(i);
                String name = jSONObject.optString("name", "");
                long size = jSONObject.optLong("size", 0L);
                list2.add(new AbstractMap.SimpleEntry<String, Long>(name, size));
            }
            list2.sort((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue()));
            for (Map.Entry entry2 : list2) {
                sortedMap.put((String)entry2.getKey(), (Long)entry2.getValue());
            }
        }
        catch (IOException | URISyntaxException | JSONException e) {
            e.printStackTrace();
        }
        return sortedMap;
    }

    public boolean ollamaModelExists(String name) {
        JSONObject data = new JSONObject();
        try {
            data.put("name", name);
            OpenAIClient.sendPostRequest(this.hoststub + "/api/show", data);
            return true;
        }
        catch (IOException | URISyntaxException | JSONException e) {
            return false;
        }
    }

    public boolean pullOllamaModel(String name) {
        JSONObject data = new JSONObject();
        try {
            data.put("name", name);
            data.put("stream", false);
            String response = OpenAIClient.sendPostRequest(this.hoststub + "/api/pull", data);
            JSONObject responseObject = new JSONObject(response);
            String status = responseObject.optString("status", "");
            return status.equals("success");
        }
        catch (IOException | URISyntaxException | JSONException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        OllamaClient oc = new OllamaClient(OLLAMA_API_HOST);
        LinkedHashMap<String, Long> models = oc.listOllamaModels();
        System.out.println(models.toString());
        String model = "phi3:3.8b";
        if (oc.ollamaModelExists("phi3:3.8b")) {
            System.out.println("model phi3:3.8b exists");
        } else {
            System.out.println("model phi3:3.8b does not exist");
        }
        boolean success = oc.pullOllamaModel("phi3:3.8b");
        System.out.println("pulled model + phi3:3.8b: " + success);
    }
}

