/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SplittableRandom;
import org.apache.lucene.index.KnnGraphValues;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.hnsw.BoundsChecker;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.NeighborQueue;

public final class HnswGraph
extends KnnGraphValues {
    private final int maxConn;
    private final List<NeighborArray> graph = new ArrayList<NeighborArray>();
    private int upto;
    private NeighborArray cur;

    HnswGraph(int maxConn) {
        this.graph.add(new NeighborArray(Math.max(32, maxConn / 4)));
        this.maxConn = maxConn;
    }

    public static NeighborQueue search(float[] query, int topK, int numSeed, RandomAccessVectorValues vectors, VectorSimilarityFunction similarityFunction, KnnGraphValues graphValues, Bits acceptOrds, SplittableRandom random) throws IOException {
        int size = graphValues.size();
        NeighborQueue results = new NeighborQueue(numSeed, similarityFunction.reversed);
        NeighborQueue candidates = new NeighborQueue(numSeed, !similarityFunction.reversed);
        SparseFixedBitSet visited = new SparseFixedBitSet(size);
        int boundedNumSeed = Math.min(numSeed, 2 * size);
        for (int i = 0; i < boundedNumSeed; ++i) {
            int entryPoint = random.nextInt(size);
            if (visited.getAndSet(entryPoint)) continue;
            float score = similarityFunction.compare(query, vectors.vectorValue(entryPoint));
            candidates.add(entryPoint, score);
            if (acceptOrds != null && !acceptOrds.get(entryPoint)) continue;
            results.add(entryPoint, score);
        }
        BoundsChecker bound = BoundsChecker.create(similarityFunction.reversed);
        bound.set(results.topScore());
        while (candidates.size() > 0) {
            int friendOrd;
            float topCandidateScore = candidates.topScore();
            if (results.size() >= topK && bound.check(topCandidateScore)) break;
            int topCandidateNode = candidates.pop();
            graphValues.seek(topCandidateNode);
            while ((friendOrd = graphValues.nextNeighbor()) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (visited.getAndSet(friendOrd)) continue;
                float score = similarityFunction.compare(query, vectors.vectorValue(friendOrd));
                if (results.size() >= numSeed && bound.check(score)) continue;
                candidates.add(friendOrd, score);
                if (acceptOrds != null && !acceptOrds.get(friendOrd)) continue;
                results.insertWithOverflow(friendOrd, score);
                bound.set(results.topScore());
            }
        }
        while (results.size() > topK) {
            results.pop();
        }
        results.setVisitedCount(visited.approximateCardinality());
        return results;
    }

    public NeighborArray getNeighbors(int node) {
        return this.graph.get(node);
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    int addNode() {
        this.graph.add(new NeighborArray(this.maxConn + 1));
        return this.graph.size() - 1;
    }

    @Override
    public void seek(int targetNode) {
        this.cur = this.getNeighbors(targetNode);
        this.upto = -1;
    }

    @Override
    public int nextNeighbor() {
        if (++this.upto < this.cur.size()) {
            return this.cur.node[this.upto];
        }
        return Integer.MAX_VALUE;
    }
}

