/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;

public abstract class NumericComparator<T extends Number>
extends FieldComparator<T> {
    protected final T missingValue;
    protected final String field;
    protected final boolean reverse;
    private final int bytesCount;
    private final ArrayUtil.ByteArrayComparator bytesComparator;
    protected boolean topValueSet;
    protected boolean singleSort;
    protected boolean hitsThresholdReached;
    protected boolean queueFull;
    private boolean canSkipDocuments;

    protected NumericComparator(String field, T missingValue, boolean reverse, int sortPos, int bytesCount) {
        this.field = field;
        this.missingValue = missingValue;
        this.reverse = reverse;
        this.canSkipDocuments = sortPos == 0;
        this.bytesCount = bytesCount;
        this.bytesComparator = ArrayUtil.getUnsignedComparator(bytesCount);
    }

    @Override
    public void setTopValue(T value) {
        this.topValueSet = true;
    }

    @Override
    public void setSingleSort() {
        this.singleSort = true;
    }

    @Override
    public void disableSkipping() {
        this.canSkipDocuments = false;
    }

    public abstract class NumericLeafComparator
    implements LeafFieldComparator {
        protected final NumericDocValues docValues;
        private final PointValues pointValues;
        private final boolean enableSkipping;
        private final int maxDoc;
        private final byte[] minValueAsBytes;
        private final byte[] maxValueAsBytes;
        private DocIdSetIterator competitiveIterator;
        private long iteratorCost;
        private int maxDocVisited = -1;
        private int updateCounter = 0;

        public NumericLeafComparator(LeafReaderContext context) throws IOException {
            this.docValues = this.getNumericDocValues(context, NumericComparator.this.field);
            PointValues pointValues = this.pointValues = NumericComparator.this.canSkipDocuments ? this.getPointValues(context, NumericComparator.this.field) : null;
            if (this.pointValues != null) {
                FieldInfo info = context.reader().getFieldInfos().fieldInfo(NumericComparator.this.field);
                if (info == null || info.getPointDimensionCount() == 0) {
                    throw new IllegalStateException("Field " + NumericComparator.this.field + " doesn't index points according to FieldInfos yet returns non-null PointValues");
                }
                if (info.getPointDimensionCount() > 1) {
                    throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with multiple dimensions, sorting is not supported");
                }
                if (info.getPointNumBytes() != NumericComparator.this.bytesCount) {
                    throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with " + info.getPointNumBytes() + " bytes per dimension, but " + NumericComparator.this + " expected " + NumericComparator.this.bytesCount);
                }
                this.enableSkipping = true;
                this.maxDoc = context.reader().maxDoc();
                Object object = !NumericComparator.this.reverse ? new byte[NumericComparator.this.bytesCount] : (this.maxValueAsBytes = (Object)(NumericComparator.this.topValueSet ? new byte[NumericComparator.this.bytesCount] : null));
                this.minValueAsBytes = NumericComparator.this.reverse ? new byte[NumericComparator.this.bytesCount] : (byte[])(NumericComparator.this.topValueSet ? new byte[NumericComparator.this.bytesCount] : null);
                this.competitiveIterator = DocIdSetIterator.all(this.maxDoc);
                this.iteratorCost = this.maxDoc;
            } else {
                this.enableSkipping = false;
                this.maxDoc = 0;
                this.maxValueAsBytes = null;
                this.minValueAsBytes = null;
            }
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return DocValues.getNumeric(context.reader(), field);
        }

        protected PointValues getPointValues(LeafReaderContext context, String field) throws IOException {
            return context.reader().getPointValues(field);
        }

        @Override
        public void setBottom(int slot) throws IOException {
            NumericComparator.this.queueFull = true;
            this.updateCompetitiveIterator();
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.maxDocVisited = doc;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (scorer instanceof Scorer) {
                this.iteratorCost = ((Scorer)scorer).iterator().cost();
                this.updateCompetitiveIterator();
            }
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            NumericComparator.this.hitsThresholdReached = true;
            this.updateCompetitiveIterator();
        }

        private void updateCompetitiveIterator() throws IOException {
            if (!(this.enableSkipping && NumericComparator.this.hitsThresholdReached && NumericComparator.this.queueFull)) {
                return;
            }
            if (this.pointValues.getDocCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                return;
            }
            ++this.updateCounter;
            if (this.updateCounter > 256 && (this.updateCounter & 0x1F) != 31) {
                return;
            }
            if (!NumericComparator.this.reverse) {
                this.encodeBottom(this.maxValueAsBytes);
                if (NumericComparator.this.topValueSet) {
                    this.encodeTop(this.minValueAsBytes);
                }
            } else {
                this.encodeBottom(this.minValueAsBytes);
                if (NumericComparator.this.topValueSet) {
                    this.encodeTop(this.maxValueAsBytes);
                }
            }
            final DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){
                DocIdSetBuilder.BulkAdder adder;

                @Override
                public void grow(int count) {
                    this.adder = result.grow(count);
                }

                @Override
                public void visit(int docID) {
                    if (docID <= NumericLeafComparator.this.maxDocVisited) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public void visit(int docID, byte[] packedValue) {
                    int cmp;
                    if (docID <= NumericLeafComparator.this.maxDocVisited) {
                        return;
                    }
                    if (NumericLeafComparator.this.maxValueAsBytes != null && ((cmp = NumericComparator.this.bytesComparator.compare(packedValue, 0, NumericLeafComparator.this.maxValueAsBytes, 0)) > 0 || NumericComparator.this.singleSort && cmp == 0)) {
                        return;
                    }
                    if (NumericLeafComparator.this.minValueAsBytes != null && ((cmp = NumericComparator.this.bytesComparator.compare(packedValue, 0, NumericLeafComparator.this.minValueAsBytes, 0)) < 0 || NumericComparator.this.singleSort && cmp == 0)) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    int cmp;
                    if (NumericLeafComparator.this.maxValueAsBytes != null && ((cmp = NumericComparator.this.bytesComparator.compare(minPackedValue, 0, NumericLeafComparator.this.maxValueAsBytes, 0)) > 0 || NumericComparator.this.singleSort && cmp == 0)) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (NumericLeafComparator.this.minValueAsBytes != null && ((cmp = NumericComparator.this.bytesComparator.compare(maxPackedValue, 0, NumericLeafComparator.this.minValueAsBytes, 0)) < 0 || NumericComparator.this.singleSort && cmp == 0)) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (NumericLeafComparator.this.maxValueAsBytes != null && NumericComparator.this.bytesComparator.compare(maxPackedValue, 0, NumericLeafComparator.this.maxValueAsBytes, 0) > 0 || NumericLeafComparator.this.minValueAsBytes != null && NumericComparator.this.bytesComparator.compare(minPackedValue, 0, NumericLeafComparator.this.minValueAsBytes, 0) < 0) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            };
            long threshold = this.iteratorCost >>> 3;
            long estimatedNumberOfMatches = this.pointValues.estimatePointCount(visitor);
            if (estimatedNumberOfMatches >= threshold) {
                return;
            }
            this.pointValues.intersect(visitor);
            this.competitiveIterator = result.build().iterator();
            this.iteratorCost = this.competitiveIterator.cost();
        }

        @Override
        public DocIdSetIterator competitiveIterator() {
            if (!this.enableSkipping) {
                return null;
            }
            return new DocIdSetIterator(){
                private int docID;
                {
                    this.docID = NumericLeafComparator.this.competitiveIterator.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.docID + 1);
                }

                @Override
                public int docID() {
                    return this.docID;
                }

                @Override
                public long cost() {
                    return NumericLeafComparator.this.competitiveIterator.cost();
                }

                @Override
                public int advance(int target) throws IOException {
                    this.docID = NumericLeafComparator.this.competitiveIterator.advance(target);
                    return this.docID;
                }
            };
        }

        protected abstract boolean isMissingValueCompetitive();

        protected abstract void encodeBottom(byte[] var1);

        protected abstract void encodeTop(byte[] var1);
    }
}

