/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public class VariableGapTermsIndexReader
extends TermsIndexReaderBase {
    private final PositiveIntOutputs fstOutputs;
    final HashMap<String, FieldIndexData> fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableGapTermsIndexReader(SegmentReadState state) throws IOException {
        block7: {
            IndexInput in;
            block6: {
                this.fstOutputs = PositiveIntOutputs.getSingleton();
                this.fields = new HashMap();
                String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"tiv");
                in = state.directory.openInput(fileName, new IOContext(state.context, true));
                boolean success = false;
                try {
                    CodecUtil.checkIndexHeader((DataInput)in, (String)"VariableGapTermsIndex", (int)3, (int)3, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    CodecUtil.checksumEntireFile((IndexInput)in);
                    this.seekDir(in);
                    int numFields = in.readVInt();
                    if (numFields < 0) {
                        throw new CorruptIndexException("invalid numFields: " + numFields, (DataInput)in);
                    }
                    for (int i = 0; i < numFields; ++i) {
                        int field = in.readVInt();
                        long indexStart = in.readVLong();
                        FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                        FieldIndexData previous = this.fields.put(fieldInfo.name, new FieldIndexData(in, fieldInfo, indexStart));
                        if (previous == null) continue;
                        throw new CorruptIndexException("duplicate field: " + fieldInfo.name, (DataInput)in);
                    }
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
    }

    @Override
    public boolean supportsOrd() {
        return false;
    }

    @Override
    public TermsIndexReaderBase.FieldIndexEnum getFieldEnum(FieldInfo fieldInfo) {
        FieldIndexData fieldData = this.fields.get(fieldInfo.name);
        if (fieldData.fst == null) {
            return null;
        }
        return new IndexEnum(fieldData.fst);
    }

    @Override
    public void close() throws IOException {
    }

    private void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        long dirOffset = input.readLong();
        input.seek(dirOffset);
    }

    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        for (FieldIndexData entry : this.fields.values()) {
            sizeInBytes += entry.ramBytesUsed();
        }
        return sizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"field", this.fields);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
    }

    private final class FieldIndexData
    implements Accountable {
        private final FST<Long> fst;

        public FieldIndexData(IndexInput in, FieldInfo fieldInfo, long indexStart) throws IOException {
            IndexInput clone = in.clone();
            clone.seek(indexStart);
            this.fst = new FST((DataInput)clone, (DataInput)clone, (Outputs)VariableGapTermsIndexReader.this.fstOutputs);
            clone.close();
        }

        public long ramBytesUsed() {
            return this.fst == null ? 0L : this.fst.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            if (this.fst == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Accountables.namedAccountable((String)"index data", this.fst));
        }

        public String toString() {
            return "VarGapTermIndex";
        }
    }

    private static class IndexEnum
    extends TermsIndexReaderBase.FieldIndexEnum {
        private final BytesRefFSTEnum<Long> fstEnum;
        private BytesRefFSTEnum.InputOutput<Long> current;

        public IndexEnum(FST<Long> fst) {
            this.fstEnum = new BytesRefFSTEnum(fst);
        }

        @Override
        public BytesRef term() {
            if (this.current == null) {
                return null;
            }
            return this.current.input;
        }

        @Override
        public long seek(BytesRef target) throws IOException {
            this.current = this.fstEnum.seekFloor(target);
            return (Long)this.current.output;
        }

        @Override
        public long next() throws IOException {
            this.current = this.fstEnum.next();
            if (this.current == null) {
                return -1L;
            }
            return (Long)this.current.output;
        }

        @Override
        public long ord() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long seek(long ord) {
            throw new UnsupportedOperationException();
        }
    }
}

