/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.reference.PictureTypes;

public class MetadataBlockDataPicture
implements MetadataBlockData,
TagField {
    public static final String IMAGE_IS_URL = "-->";
    private int pictureType;
    private String mimeType = "";
    private String description;
    private int width;
    private int height;
    private int colourDepth;
    private int indexedColouredCount;
    private byte[] imageData;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac.MetadataBlockDataPicture");

    private void initFromByteBuffer(ByteBuffer rawdata) throws IOException, InvalidFrameException {
        this.pictureType = rawdata.getInt();
        if (this.pictureType >= PictureTypes.getInstanceOf().getSize()) {
            throw new InvalidFrameException("PictureType was:" + this.pictureType + "but the maximum allowed is " + (PictureTypes.getInstanceOf().getSize() - 1));
        }
        int mimeTypeSize = rawdata.getInt();
        this.mimeType = this.getString(rawdata, mimeTypeSize, StandardCharsets.ISO_8859_1.name());
        int descriptionSize = rawdata.getInt();
        this.description = this.getString(rawdata, descriptionSize, StandardCharsets.UTF_8.name());
        this.width = rawdata.getInt();
        this.height = rawdata.getInt();
        this.colourDepth = rawdata.getInt();
        this.indexedColouredCount = rawdata.getInt();
        int rawdataSize = rawdata.getInt();
        this.imageData = new byte[rawdataSize];
        rawdata.get(this.imageData);
        logger.config("Read image:" + this.toString());
    }

    public MetadataBlockDataPicture(ByteBuffer rawdata) throws IOException, InvalidFrameException {
        this.initFromByteBuffer(rawdata);
    }

    public MetadataBlockDataPicture(MetadataBlockHeader header, RandomAccessFile raf) throws IOException, InvalidFrameException {
        ByteBuffer rawdata = ByteBuffer.allocate(header.getDataLength());
        int bytesRead = raf.getChannel().read(rawdata);
        if (bytesRead < header.getDataLength()) {
            throw new IOException("Unable to read required number of databytes read:" + bytesRead + ":required:" + header.getDataLength());
        }
        rawdata.rewind();
        this.initFromByteBuffer(rawdata);
    }

    public MetadataBlockDataPicture(byte[] imageData, int pictureType, String mimeType, String description, int width, int height, int colourDepth, int indexedColouredCount) {
        this.pictureType = pictureType;
        if (mimeType != null) {
            this.mimeType = mimeType;
        }
        this.description = description;
        this.width = width;
        this.height = height;
        this.colourDepth = colourDepth;
        this.indexedColouredCount = indexedColouredCount;
        this.imageData = imageData;
    }

    private String getString(ByteBuffer rawdata, int length, String charset) throws IOException {
        byte[] tempbuffer = new byte[length];
        rawdata.get(tempbuffer);
        return new String(tempbuffer, charset);
    }

    @Override
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(Utils.getSizeBEInt32(this.pictureType));
            baos.write(Utils.getSizeBEInt32(this.mimeType.length()));
            baos.write(this.mimeType.getBytes(StandardCharsets.ISO_8859_1));
            baos.write(Utils.getSizeBEInt32(this.description.length()));
            baos.write(this.description.getBytes(StandardCharsets.UTF_8));
            baos.write(Utils.getSizeBEInt32(this.width));
            baos.write(Utils.getSizeBEInt32(this.height));
            baos.write(Utils.getSizeBEInt32(this.colourDepth));
            baos.write(Utils.getSizeBEInt32(this.indexedColouredCount));
            baos.write(Utils.getSizeBEInt32(this.imageData.length));
            baos.write(this.imageData);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    @Override
    public int getLength() {
        return this.getBytes().length;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColourDepth() {
        return this.colourDepth;
    }

    public int getIndexedColourCount() {
        return this.indexedColouredCount;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public boolean isImageUrl() {
        return this.getMimeType().equals(IMAGE_IS_URL);
    }

    public String getImageUrl() {
        if (this.isImageUrl()) {
            return new String(this.getImageData(), 0, this.getImageData().length, StandardCharsets.ISO_8859_1);
        }
        return "";
    }

    @Override
    public String toString() {
        return PictureTypes.getInstanceOf().getValueForId(this.pictureType) + ":" + this.mimeType + ":" + this.description + ":width:" + this.width + ":height:" + this.height + ":colourdepth:" + this.colourDepth + ":indexedColourCount:" + this.indexedColouredCount + ":image size in bytes:" + this.imageData.length;
    }

    @Override
    public void copyContent(TagField field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return FieldKey.COVER_ART.name();
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        return this.getBytes();
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public void isBinary(boolean b) {
    }

    @Override
    public boolean isCommon() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

