/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterState
implements JSONWriter.Writable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, CollectionRef> collectionStates;
    private final Map<String, CollectionRef> immutableCollectionStates;
    private Set<String> liveNodes;
    private Set<String> hostAllowList;
    private static final ReplicaStatesProvider EMPTYSTATEPROVIDER = new ReplicaStatesProvider(){

        @Override
        public Optional<ReplicaStatesProvider> get() {
            return Optional.empty();
        }

        @Override
        public PerReplicaStates getStates() {
            throw new RuntimeException("Invalid operation");
        }
    };
    private static ThreadLocal<ReplicaStatesProvider> REPLICASTATES_PROVIDER = new ThreadLocal();

    public ClusterState(Set<String> liveNodes, Map<String, DocCollection> collectionStates) {
        this(ClusterState.getRefMap(collectionStates), liveNodes);
    }

    private static Map<String, CollectionRef> getRefMap(Map<String, DocCollection> collectionStates) {
        LinkedHashMap<String, CollectionRef> collRefs = new LinkedHashMap<String, CollectionRef>(collectionStates.size());
        for (Map.Entry<String, DocCollection> entry : collectionStates.entrySet()) {
            DocCollection c = entry.getValue();
            collRefs.put(entry.getKey(), new CollectionRef(c));
        }
        return collRefs;
    }

    public ClusterState(Map<String, CollectionRef> collectionStates, Set<String> liveNodes) {
        this.liveNodes = new HashSet<String>(liveNodes.size());
        this.liveNodes.addAll(liveNodes);
        this.collectionStates = new LinkedHashMap<String, CollectionRef>(collectionStates);
        this.immutableCollectionStates = Collections.unmodifiableMap(collectionStates);
    }

    public ClusterState copyWith(String collectionName, DocCollection collection) {
        ClusterState result = new ClusterState(new LinkedHashMap<String, CollectionRef>(this.collectionStates), this.liveNodes);
        if (collection == null) {
            result.collectionStates.remove(collectionName);
        } else {
            result.collectionStates.put(collectionName, new CollectionRef(collection));
        }
        return result;
    }

    public boolean hasCollection(String collectionName) {
        return this.getCollectionOrNull(collectionName) != null;
    }

    public DocCollection getCollection(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection : " + collection);
        }
        return coll;
    }

    public CollectionRef getCollectionRef(String coll) {
        return this.collectionStates.get(coll);
    }

    public DocCollection getCollectionOrNull(String collectionName) {
        return this.getCollectionOrNull(collectionName, false);
    }

    public DocCollection getCollectionOrNull(String collectionName, boolean allowCached) {
        CollectionRef ref = this.collectionStates.get(collectionName);
        return ref == null ? null : ref.get(allowCached);
    }

    public Map<String, DocCollection> getCollectionsMap() {
        HashMap<String, DocCollection> result = new HashMap<String, DocCollection>(this.collectionStates.size());
        for (Map.Entry<String, CollectionRef> entry : this.collectionStates.entrySet()) {
            DocCollection collection = entry.getValue().get();
            if (collection == null) continue;
            result.put(entry.getKey(), collection);
        }
        return result;
    }

    public Set<String> getLiveNodes() {
        return Collections.unmodifiableSet(this.liveNodes);
    }

    public String getShardId(String nodeName, String coreName) {
        return this.getShardId(null, nodeName, coreName);
    }

    public String getShardId(String collectionName, String nodeName, String coreName) {
        CollectionRef c;
        Collection<CollectionRef> states = this.collectionStates.values();
        if (collectionName != null && (c = this.collectionStates.get(collectionName)) != null) {
            states = Collections.singletonList(c);
        }
        for (CollectionRef ref : states) {
            DocCollection coll = ref.get();
            if (coll == null) continue;
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    String rnodeName = replica.getStr("node_name");
                    String rcore = replica.getStr("core");
                    if (!nodeName.equals(rnodeName) || !coreName.equals(rcore)) continue;
                    return slice.getName();
                }
            }
        }
        return null;
    }

    public boolean liveNodesContain(String name) {
        return this.liveNodes.contains(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("live nodes:").append(this.liveNodes);
        sb.append("\n");
        sb.append("collections:").append(this.collectionStates);
        return sb.toString();
    }

    public static ClusterState createFromJson(int version, byte[] bytes, Set<String> liveNodes) {
        if (bytes == null || bytes.length == 0) {
            return new ClusterState(liveNodes, Collections.emptyMap());
        }
        Map stateMap = (Map)Utils.fromJSON(bytes);
        return ClusterState.createFromCollectionMap(version, stateMap, liveNodes);
    }

    @Deprecated
    public static ClusterState createFromJsonSupportingLegacyConfigName(int version, byte[] bytes, Set<String> liveNodes, String coll, SolrZkClient zkClient) {
        if (bytes == null || bytes.length == 0) {
            return new ClusterState(liveNodes, Collections.emptyMap());
        }
        Map stateMap = (Map)Utils.fromJSON(bytes);
        Map props = (Map)stateMap.get(coll);
        if (props != null && !props.containsKey("configName")) {
            try {
                String path = "/collections/" + coll;
                byte[] data = zkClient.getData(path, null, null, true);
                if (data != null && data.length > 0) {
                    ZkNodeProps configProp = ZkNodeProps.load(data);
                    String configName = configProp.getStr("configName");
                    if (configName != null) {
                        props.put("configName", configName);
                        stateMap.put(coll, props);
                    } else {
                        log.warn("configName is null, not found on {}", (Object)path);
                    }
                }
            }
            catch (InterruptedException | KeeperException throwable) {
                // empty catch block
            }
        }
        return ClusterState.createFromCollectionMap(version, stateMap, liveNodes);
    }

    public static ClusterState createFromCollectionMap(int version, Map<String, Object> stateMap, Set<String> liveNodes) {
        LinkedHashMap<String, CollectionRef> collections = new LinkedHashMap<String, CollectionRef>(stateMap.size());
        for (Map.Entry<String, Object> entry : stateMap.entrySet()) {
            String collectionName = entry.getKey();
            DocCollection coll = ClusterState.collectionFromObjects(collectionName, (Map)entry.getValue(), version);
            collections.put(collectionName, new CollectionRef(coll));
        }
        return new ClusterState(collections, liveNodes);
    }

    private static DocCollection collectionFromObjects(String name, Map<String, Object> objs, int version) {
        DocRouter router;
        Map<String, Object> props;
        Map<String, Slice> slices;
        Map sliceObjs;
        if (Boolean.parseBoolean(String.valueOf(objs.get("perReplicaState")))) {
            ReplicaStatesProvider rsp;
            if (log.isDebugEnabled()) {
                log.debug("a collection {} has per-replica state", (Object)name);
            }
            if ((rsp = REPLICASTATES_PROVIDER.get()) instanceof StatesProvider) {
                ((StatesProvider)rsp).isPerReplicaState = true;
            }
        }
        if ((sliceObjs = (Map)objs.get("shards")) == null) {
            slices = Slice.loadAllFromMap(name, objs);
            props = Collections.emptyMap();
        } else {
            slices = Slice.loadAllFromMap(name, sliceObjs);
            props = new HashMap<String, Object>(objs);
            objs.remove("shards");
        }
        Object routerObj = props.get("router");
        if (routerObj == null) {
            router = DocRouter.DEFAULT;
        } else if (routerObj instanceof String) {
            router = DocRouter.getDocRouter((String)routerObj);
        } else {
            Map routerProps = (Map)routerObj;
            router = DocRouter.getDocRouter((String)routerProps.get("name"));
        }
        return new DocCollection(name, slices, props, router, version);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        LinkedHashMap<String, DocCollection> map = new LinkedHashMap<String, DocCollection>();
        for (Map.Entry<String, CollectionRef> e : this.collectionStates.entrySet()) {
            if (e.getValue().getClass() != CollectionRef.class) continue;
            DocCollection coll = e.getValue().get();
            map.put(coll.getName(), coll);
        }
        jsonWriter.write(map);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.liveNodes == null ? 0 : this.liveNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterState other = (ClusterState)obj;
        if (this.liveNodes == null) {
            return other.liveNodes == null;
        }
        return this.liveNodes.equals(other.liveNodes);
    }

    void setLiveNodes(Set<String> liveNodes) {
        this.liveNodes = liveNodes;
    }

    public Map<String, CollectionRef> getCollectionStates() {
        return this.immutableCollectionStates;
    }

    public Set<String> getHostAllowList() {
        if (this.hostAllowList == null) {
            this.hostAllowList = this.getLiveNodes().stream().map(liveNode -> liveNode.substring(0, liveNode.indexOf(95))).collect(Collectors.toSet());
        }
        return this.hostAllowList;
    }

    public void forEachCollection(Consumer<DocCollection> consumer) {
        this.collectionStates.forEach((s, collectionRef) -> {
            block3: {
                try {
                    DocCollection collection = collectionRef.get();
                    if (collection != null) {
                        consumer.accept(collection);
                    }
                }
                catch (SolrException e) {
                    if (e.getCause() instanceof KeeperException.NoNodeException) break block3;
                    throw e;
                }
            }
        });
    }

    public int size() {
        return this.collectionStates.size();
    }

    public static ReplicaStatesProvider getReplicaStatesProvider() {
        return REPLICASTATES_PROVIDER.get() == null ? EMPTYSTATEPROVIDER : REPLICASTATES_PROVIDER.get();
    }

    public static void initReplicaStateProvider(Supplier<PerReplicaStates> replicaStatesSupplier) {
        REPLICASTATES_PROVIDER.set(new StatesProvider(replicaStatesSupplier));
    }

    public static void clearReplicaStateProvider() {
        REPLICASTATES_PROVIDER.remove();
    }

    private static class StatesProvider
    implements ReplicaStatesProvider {
        private final Supplier<PerReplicaStates> replicaStatesSupplier;
        private PerReplicaStates perReplicaStates;
        private boolean isPerReplicaState = false;

        public StatesProvider(Supplier<PerReplicaStates> replicaStatesSupplier) {
            this.replicaStatesSupplier = replicaStatesSupplier;
        }

        @Override
        public Optional<ReplicaStatesProvider> get() {
            return this.isPerReplicaState ? Optional.of(this) : Optional.empty();
        }

        @Override
        public PerReplicaStates getStates() {
            if (this.perReplicaStates == null) {
                this.perReplicaStates = this.replicaStatesSupplier.get();
            }
            return this.perReplicaStates;
        }
    }

    static interface ReplicaStatesProvider {
        public Optional<ReplicaStatesProvider> get();

        public PerReplicaStates getStates();
    }

    public static class CollectionRef {
        protected final AtomicInteger gets = new AtomicInteger();
        private final DocCollection coll;

        public int getCount() {
            return this.gets.get();
        }

        public CollectionRef(DocCollection coll) {
            this.coll = coll;
        }

        public DocCollection get() {
            return this.get(false);
        }

        public DocCollection get(boolean allowCached) {
            this.gets.incrementAndGet();
            return this.coll;
        }

        public boolean isLazilyLoaded() {
            return false;
        }

        public String toString() {
            if (this.coll != null) {
                return this.coll.toString();
            }
            return "null DocCollection ref";
        }
    }
}

