/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.Mp4AtomTree;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4FreeBox;
import org.jaudiotagger.audio.mp4.atom.Mp4HdlrBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.Mp4TagCreator;
import org.jaudiotagger.utils.tree.DefaultMutableTreeNode;

public class Mp4TagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    private Mp4TagCreator tc = new Mp4TagCreator();

    private void writeMetadataSameSize(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader ilstHeader, ByteBuffer newIlstData, Mp4BoxHeader tagsHeader) throws CannotWriteException, IOException {
        logger.config("Writing:Option 1:Same Size");
        fileReadChannel.position(0L);
        fileWriteChannel.transferFrom(fileReadChannel, 0L, ilstHeader.getFilePos());
        fileWriteChannel.position(ilstHeader.getFilePos());
        fileWriteChannel.write(newIlstData);
        fileReadChannel.position(ilstHeader.getFileEndPos());
        this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, tagsHeader);
    }

    private void writeNeroData(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader tagsHeader) throws IOException, CannotWriteException {
        long writeBetweenIlstAndTags = tagsHeader.getFilePos() - fileReadChannel.position();
        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), writeBetweenIlstAndTags);
        fileWriteChannel.position(fileWriteChannel.position() + writeBetweenIlstAndTags);
        this.convertandWriteTagsAtomToFreeAtom(fileWriteChannel, tagsHeader);
        fileReadChannel.position(tagsHeader.getFileEndPos());
        this.writeDataInChunks(fileReadChannel, fileWriteChannel);
    }

    private void adjustSizeOfMoovHeader(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader) throws IOException {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
        if (udtaHeader != null) {
            udtaHeader.setLength(udtaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(udtaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(udtaHeader.getHeaderData());
        }
        if (metaHeader != null) {
            metaHeader.setLength(metaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(metaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(metaHeader.getHeaderData());
        }
    }

    private void createMetadataAtoms(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader) throws IOException {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
    }

    private void writeOldMetadataLargerThanNewMetadata(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader moovHeader, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader, Mp4BoxHeader ilstHeader, Mp4BoxHeader mdatHeader, Mp4BoxHeader neroTagsHeader, ByteBuffer moovBuffer, ByteBuffer newIlstData, Mp4StcoBox stco, int sizeOfExistingMetaLevelFreeAtom) throws IOException, CannotWriteException {
        logger.config("Writing:Option 1:Smaller Size");
        int ilstPositionRelativeToAfterMoovHeader = (int)(ilstHeader.getFilePos() - (moovHeader.getFilePos() + 8L));
        int sizeRequiredByNewIlstAtom = newIlstData.limit();
        if (sizeOfExistingMetaLevelFreeAtom > 0) {
            logger.config("Writing:Option 2:Smaller Size have free atom:" + ilstHeader.getLength() + ":" + sizeRequiredByNewIlstAtom);
            this.writeDataUptoIncludingIlst(fileReadChannel, fileWriteChannel, ilstHeader, newIlstData);
            int newFreeSize = sizeOfExistingMetaLevelFreeAtom + (ilstHeader.getLength() - sizeRequiredByNewIlstAtom);
            Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
            fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
            fileWriteChannel.write(newFreeBox.getData());
            fileReadChannel.position(fileReadChannel.position() + (long)sizeOfExistingMetaLevelFreeAtom);
            this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, neroTagsHeader);
        } else {
            int newFreeSize = ilstHeader.getLength() - sizeRequiredByNewIlstAtom - 8;
            if (newFreeSize > 0) {
                logger.config("Writing:Option 3:Smaller Size can create free atom");
                this.writeDataUptoIncludingIlst(fileReadChannel, fileWriteChannel, ilstHeader, newIlstData);
                Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize);
                fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                fileWriteChannel.write(newFreeBox.getData());
                this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, neroTagsHeader);
            } else {
                logger.config("Writing:Option 4:Smaller Size <=8 cannot create free atoms");
                int sizeReducedBy = ilstHeader.getLength() - sizeRequiredByNewIlstAtom;
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, moovHeader.getFilePos());
                fileWriteChannel.position(moovHeader.getFilePos());
                if (mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                    stco.adjustOffsets(-sizeReducedBy);
                }
                this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, -sizeReducedBy, udtaHeader, metaHeader);
                fileWriteChannel.write(moovHeader.getHeaderData());
                moovBuffer.rewind();
                moovBuffer.limit(ilstPositionRelativeToAfterMoovHeader);
                fileWriteChannel.write(moovBuffer);
                fileWriteChannel.write(newIlstData);
                fileReadChannel.position(ilstHeader.getFileEndPos());
                this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, neroTagsHeader);
            }
        }
    }

    private void writeNewMetadataLargerButCanUseFreeAtom(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader ilstHeader, Mp4BoxHeader neroTagsHeader, int sizeOfExistingMetaLevelFreeAtom, ByteBuffer newIlstData, int additionalSpaceRequiredForMetadata) throws IOException, CannotWriteException {
        int newFreeSize = sizeOfExistingMetaLevelFreeAtom - additionalSpaceRequiredForMetadata;
        logger.config("Writing:Option 5;Larger Size can use meta free atom need extra:" + newFreeSize + "bytes");
        this.writeDataUptoIncludingIlst(fileReadChannel, fileWriteChannel, ilstHeader, newIlstData);
        Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
        fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
        fileWriteChannel.write(newFreeBox.getData());
        fileReadChannel.position(fileReadChannel.position() + (long)sizeOfExistingMetaLevelFreeAtom);
        this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, neroTagsHeader);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        int positionOfNewIlstAtomRelativeToMoovAtom;
        int positionInExistingFileOfWhereNewIlstAtomShouldBeWritten;
        Mp4AtomTree atomTree;
        logger.config("Started writing tag data");
        FileChannel fileReadChannel = raf.getChannel();
        FileChannel fileWriteChannel = rafTemp.getChannel();
        int sizeOfExistingIlstAtom = 0;
        long endOfMoov = 0L;
        try {
            atomTree = new Mp4AtomTree(raf, false);
        }
        catch (CannotReadException cre) {
            throw new CannotWriteException(cre.getMessage());
        }
        Mp4BoxHeader mdatHeader = atomTree.getBoxHeader(atomTree.getMdatNode());
        if (mdatHeader == null) {
            throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_CANNOT_FIND_AUDIO.getMsg());
        }
        ByteBuffer newIlstData = this.tc.convert(tag);
        newIlstData.rewind();
        int sizeRequiredByNewIlstAtom = newIlstData.limit();
        Mp4BoxHeader moovHeader = atomTree.getBoxHeader(atomTree.getMoovNode());
        Mp4StcoBox stco = atomTree.getStco();
        Mp4BoxHeader ilstHeader = atomTree.getBoxHeader(atomTree.getIlstNode());
        Mp4BoxHeader udtaHeader = atomTree.getBoxHeader(atomTree.getUdtaNode());
        Mp4BoxHeader metaHeader = atomTree.getBoxHeader(atomTree.getMetaNode());
        Mp4BoxHeader hdlrMetaHeader = atomTree.getBoxHeader(atomTree.getHdlrWithinMetaNode());
        Mp4BoxHeader neroTagsHeader = atomTree.getBoxHeader(atomTree.getTagsNode());
        Mp4BoxHeader trakHeader = atomTree.getBoxHeader(atomTree.getTrakNodes().get(0));
        ByteBuffer moovBuffer = atomTree.getMoovBuffer();
        if (udtaHeader != null) {
            if (metaHeader != null) {
                if (ilstHeader != null) {
                    sizeOfExistingIlstAtom = ilstHeader.getLength();
                    positionInExistingFileOfWhereNewIlstAtomShouldBeWritten = (int)ilstHeader.getFilePos();
                    positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionInExistingFileOfWhereNewIlstAtomShouldBeWritten - (moovHeader.getFilePos() + 8L));
                } else if (hdlrMetaHeader != null) {
                    positionInExistingFileOfWhereNewIlstAtomShouldBeWritten = (int)hdlrMetaHeader.getFileEndPos();
                    positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionInExistingFileOfWhereNewIlstAtomShouldBeWritten - (moovHeader.getFilePos() + 8L));
                } else {
                    positionInExistingFileOfWhereNewIlstAtomShouldBeWritten = (int)metaHeader.getFilePos() + 8 + 4;
                    positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionInExistingFileOfWhereNewIlstAtomShouldBeWritten - (moovHeader.getFilePos() + 8L));
                }
            } else {
                positionOfNewIlstAtomRelativeToMoovAtom = moovHeader.getLength() - 8;
                positionInExistingFileOfWhereNewIlstAtomShouldBeWritten = (int)moovHeader.getFileEndPos();
            }
        } else if (metaHeader != null) {
            positionInExistingFileOfWhereNewIlstAtomShouldBeWritten = (int)trakHeader.getFileEndPos();
            positionOfNewIlstAtomRelativeToMoovAtom = (int)((long)positionInExistingFileOfWhereNewIlstAtomShouldBeWritten - (moovHeader.getFilePos() + 8L));
        } else {
            positionInExistingFileOfWhereNewIlstAtomShouldBeWritten = (int)moovHeader.getFileEndPos();
            positionOfNewIlstAtomRelativeToMoovAtom = moovHeader.getLength() - 8;
        }
        int sizeOfExistingMetaLevelFreeAtom = this.getMetaLevelFreeAtomSize(atomTree);
        int positionOfTopLevelFreeAtom = 0;
        int sizeOfExistingTopLevelFreeAtom = 0;
        boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = true;
        for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)freeNode.getParent();
            if (!parentNode.isRoot()) continue;
            Mp4BoxHeader topLevelFreeHeader = (Mp4BoxHeader)freeNode.getUserObject();
            sizeOfExistingTopLevelFreeAtom = topLevelFreeHeader.getLength();
            positionOfTopLevelFreeAtom = (int)topLevelFreeHeader.getFilePos();
            break;
        }
        if (sizeOfExistingTopLevelFreeAtom > 0) {
            if ((long)positionOfTopLevelFreeAtom > mdatHeader.getFilePos()) {
                topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = false;
            } else if ((long)positionOfTopLevelFreeAtom < moovHeader.getFilePos()) {
                topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = false;
            }
        } else {
            positionOfTopLevelFreeAtom = (int)mdatHeader.getFilePos();
        }
        logger.config("Read header successfully ready for writing");
        if (sizeOfExistingIlstAtom == sizeRequiredByNewIlstAtom) {
            this.writeMetadataSameSize(fileReadChannel, fileWriteChannel, ilstHeader, newIlstData, neroTagsHeader);
        } else if (sizeOfExistingIlstAtom > sizeRequiredByNewIlstAtom) {
            this.writeOldMetadataLargerThanNewMetadata(fileReadChannel, fileWriteChannel, moovHeader, udtaHeader, metaHeader, ilstHeader, mdatHeader, neroTagsHeader, moovBuffer, newIlstData, stco, sizeOfExistingMetaLevelFreeAtom);
        } else {
            int additionalSpaceRequiredForMetadata = sizeRequiredByNewIlstAtom - sizeOfExistingIlstAtom;
            if (additionalSpaceRequiredForMetadata <= sizeOfExistingMetaLevelFreeAtom - 8) {
                this.writeNewMetadataLargerButCanUseFreeAtom(fileReadChannel, fileWriteChannel, ilstHeader, neroTagsHeader, sizeOfExistingMetaLevelFreeAtom, newIlstData, additionalSpaceRequiredForMetadata);
            } else {
                int additionalMetaSizeThatWontFitWithinMetaAtom = additionalSpaceRequiredForMetadata - sizeOfExistingMetaLevelFreeAtom;
                this.writeUpToMoovHeader(fileReadChannel, fileWriteChannel, moovHeader);
                if (udtaHeader == null) {
                    this.writeNoExistingUdtaAtom(fileReadChannel, fileWriteChannel, newIlstData, moovHeader, moovBuffer, mdatHeader, stco, sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, neroTagsHeader, sizeOfExistingMetaLevelFreeAtom, positionInExistingFileOfWhereNewIlstAtomShouldBeWritten, sizeOfExistingIlstAtom, positionOfTopLevelFreeAtom, additionalMetaSizeThatWontFitWithinMetaAtom);
                } else if (metaHeader == null) {
                    this.writeNoExistingMetaAtom(udtaHeader, fileReadChannel, fileWriteChannel, newIlstData, moovHeader, moovBuffer, mdatHeader, stco, sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, neroTagsHeader, sizeOfExistingMetaLevelFreeAtom, positionInExistingFileOfWhereNewIlstAtomShouldBeWritten, sizeOfExistingIlstAtom, positionOfTopLevelFreeAtom, additionalMetaSizeThatWontFitWithinMetaAtom);
                } else {
                    this.writeHaveExistingMetadata(udtaHeader, metaHeader, fileReadChannel, fileWriteChannel, positionOfNewIlstAtomRelativeToMoovAtom, moovHeader, moovBuffer, mdatHeader, stco, additionalMetaSizeThatWontFitWithinMetaAtom, sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, newIlstData, neroTagsHeader, sizeOfExistingMetaLevelFreeAtom, positionInExistingFileOfWhereNewIlstAtomShouldBeWritten, sizeOfExistingIlstAtom);
                }
            }
        }
        fileReadChannel.close();
        raf.close();
        this.checkFileWrittenCorrectly(rafTemp, mdatHeader, fileWriteChannel, stco);
    }

    private void writeUpToMoovHeader(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader moovHeader) throws IOException, CannotWriteException {
        fileReadChannel.position(0L);
        fileWriteChannel.transferFrom(fileReadChannel, 0L, moovHeader.getFilePos());
        fileWriteChannel.position(moovHeader.getFilePos());
    }

    private void writeDataInChunks(FileChannel fileReadChannel, FileChannel fileWriteChannel) throws IOException, CannotWriteException {
        long amountToBeWritten = fileReadChannel.size() - fileReadChannel.position();
        long written = 0L;
        long chunksize = TagOptionSingleton.getInstance().getWriteChunkSize();
        long count = amountToBeWritten / chunksize;
        long mod = amountToBeWritten % chunksize;
        int i = 0;
        while ((long)i < count) {
            written += fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), chunksize);
            fileWriteChannel.position(fileWriteChannel.position() + chunksize);
            ++i;
        }
        if ((written += fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), mod)) != amountToBeWritten) {
            throw new CannotWriteException("Was meant to write " + amountToBeWritten + " bytes but only written " + written + " bytes");
        }
    }

    private void convertandWriteTagsAtomToFreeAtom(FileChannel fileWriteChannel, Mp4BoxHeader tagsHeader) throws IOException {
        Mp4FreeBox freeBox = new Mp4FreeBox(tagsHeader.getDataLength());
        fileWriteChannel.write(freeBox.getHeader().getHeaderData());
        fileWriteChannel.write(freeBox.getData());
    }

    private void writeDataUptoIncludingIlst(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader ilstHeader, ByteBuffer newIlstAtomData) throws IOException {
        fileReadChannel.position(0L);
        fileWriteChannel.transferFrom(fileReadChannel, 0L, ilstHeader.getFilePos());
        fileWriteChannel.position(ilstHeader.getFilePos());
        fileWriteChannel.write(newIlstAtomData);
        fileReadChannel.position(ilstHeader.getFileEndPos());
    }

    private void writeDataAfterIlst(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader tagsHeader) throws IOException, CannotWriteException {
        if (tagsHeader != null) {
            this.writeNeroData(fileReadChannel, fileWriteChannel, tagsHeader);
        } else {
            this.writeDataInChunks(fileReadChannel, fileWriteChannel);
        }
    }

    private int getMetaLevelFreeAtomSize(Mp4AtomTree atomTree) {
        int oldMetaLevelFreeAtomSize = 0;
        for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)freeNode.getParent();
            DefaultMutableTreeNode brotherNode = freeNode.getPreviousSibling();
            if (parentNode.isRoot()) continue;
            Mp4BoxHeader parentHeader = (Mp4BoxHeader)parentNode.getUserObject();
            Mp4BoxHeader freeHeader = (Mp4BoxHeader)freeNode.getUserObject();
            if (brotherNode == null) continue;
            Mp4BoxHeader brotherHeader = (Mp4BoxHeader)brotherNode.getUserObject();
            if (!parentHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) || !brotherHeader.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) continue;
            oldMetaLevelFreeAtomSize = freeHeader.getLength();
            break;
        }
        return oldMetaLevelFreeAtomSize;
    }

    private void checkFileWrittenCorrectly(RandomAccessFile rafTemp, Mp4BoxHeader mdatHeader, FileChannel fileWriteChannel, Mp4StcoBox stco) throws CannotWriteException, IOException {
        logger.config("Checking file has been written correctly");
        try {
            Mp4AtomTree newAtomTree = new Mp4AtomTree(rafTemp, false);
            Mp4BoxHeader newMdatHeader = newAtomTree.getBoxHeader(newAtomTree.getMdatNode());
            if (newMdatHeader == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_DATA.getMsg());
            }
            if (newMdatHeader.getLength() != mdatHeader.getLength()) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_DATA_CORRUPT.getMsg());
            }
            Mp4BoxHeader newUdtaHeader = newAtomTree.getBoxHeader(newAtomTree.getUdtaNode());
            if (newUdtaHeader == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
            }
            Mp4BoxHeader newMetaHeader = newAtomTree.getBoxHeader(newAtomTree.getMetaNode());
            if (newMetaHeader == null) {
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
            }
            Mp4StcoBox newStco = newAtomTree.getStco();
            logger.finer("stco:Original First Offset" + stco.getFirstOffSet());
            logger.finer("stco:Original Diff" + (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos()));
            logger.finer("stco:Original Mdat Pos" + mdatHeader.getFilePos());
            logger.finer("stco:New First Offset" + newStco.getFirstOffSet());
            logger.finer("stco:New Diff" + (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos()));
            logger.finer("stco:New Mdat Pos" + newMdatHeader.getFilePos());
            int diff = (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos());
            if ((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() != (long)diff) {
                int discrepancy = (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() - (long)diff);
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_INCORRECT_OFFSETS.getMsg(discrepancy));
            }
        }
        catch (Exception e) {
            if (e instanceof CannotWriteException) {
                throw (CannotWriteException)e;
            }
            e.printStackTrace();
            throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED.getMsg() + ":" + e.getMessage());
        }
        finally {
            rafTemp.close();
            fileWriteChannel.close();
        }
        logger.config("File has been written correctly");
    }

    public void delete(RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        Mp4Tag tag = new Mp4Tag();
        try {
            this.write(tag, raf, rafTemp);
        }
        catch (CannotWriteException cwe) {
            throw new IOException(cwe.getMessage());
        }
    }

    private void writeNoExistingUdtaAtom(FileChannel fileReadChannel, FileChannel fileWriteChannel, ByteBuffer newIlstData, Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, Mp4BoxHeader mdatHeader, Mp4StcoBox stco, int sizeOfExistingTopLevelFreeAtom, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, Mp4BoxHeader neroTagsHeader, int sizeOfExistingMetaLevelFreeAtom, int positionInExistingFileOfWhereNewIlstAtomShouldBeWritten, int existingSizeOfIlstData, int topLevelFreeSize, int additionalMetaSizeThatWontFitWithinMetaAtom) throws IOException, CannotWriteException {
        logger.severe("Writing:Option 5.1;No udta atom");
        long endOfMoov = moovHeader.getFileEndPos();
        Mp4HdlrBox hdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
        Mp4MetaBox metaBox = Mp4MetaBox.createiTunesStyleMetaBox(hdlrBox.getHeader().getLength() + newIlstData.limit());
        Mp4BoxHeader udtaHeader = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
        udtaHeader.setLength(8 + metaBox.getHeader().getLength());
        boolean isMdatDataMoved = this.adjustStcoIfNoSuitableTopLevelAtom(sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, udtaHeader.getLength(), stco, moovHeader, mdatHeader);
        moovHeader.setLength(moovHeader.getLength() + udtaHeader.getLength());
        fileWriteChannel.write(moovHeader.getHeaderData());
        moovBuffer.rewind();
        fileWriteChannel.write(moovBuffer);
        fileWriteChannel.write(udtaHeader.getHeaderData());
        fileWriteChannel.write(metaBox.getHeader().getHeaderData());
        fileWriteChannel.write(metaBox.getData());
        fileWriteChannel.write(hdlrBox.getHeader().getHeaderData());
        fileWriteChannel.write(hdlrBox.getData());
        fileWriteChannel.write(newIlstData);
        fileReadChannel.position(positionInExistingFileOfWhereNewIlstAtomShouldBeWritten + existingSizeOfIlstData + sizeOfExistingMetaLevelFreeAtom);
        if (neroTagsHeader != null) {
            this.writeFromEndOfIlstToNeroTagsAndMakeNeroFree(endOfMoov, fileReadChannel, fileWriteChannel, neroTagsHeader);
        } else {
            long extraData = endOfMoov - fileReadChannel.position();
            fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraData);
            fileWriteChannel.position(fileWriteChannel.position() + extraData);
        }
        if (!isMdatDataMoved) {
            this.adjustFreeAtom(fileReadChannel, fileWriteChannel, topLevelFreeSize, additionalMetaSizeThatWontFitWithinMetaAtom);
        } else {
            logger.config("Writing:Option 9;Top Level Free comes after Mdat or before Metadata or not large enough");
        }
        this.writeDataInChunks(fileReadChannel, fileWriteChannel);
    }

    private void writeNoExistingMetaAtom(Mp4BoxHeader udtaHeader, FileChannel fileReadChannel, FileChannel fileWriteChannel, ByteBuffer newIlstData, Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, Mp4BoxHeader mdatHeader, Mp4StcoBox stco, int sizeOfExistingTopLevelFreeAtom, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, Mp4BoxHeader neroTagsHeader, int sizeOfExistingMetaLevelFreeAtom, int positionInExistingFileOfWhereNewIlstAtomShouldBeWritten, int existingSizeOfIlstData, int topLevelFreeSize, int additionalMetaSizeThatWontFitWithinMetaAtom) throws IOException, CannotWriteException {
        logger.severe("Writing:Option 5.2;No meta atom");
        long endOfMoov = moovHeader.getFileEndPos();
        int newIlstDataSize = newIlstData.limit();
        int existingMoovHeaderDataLength = moovHeader.getDataLength();
        int existingUdtaLength = udtaHeader.getLength();
        int existingUdtaDataLength = udtaHeader.getDataLength();
        Mp4HdlrBox hdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
        Mp4MetaBox metaBox = Mp4MetaBox.createiTunesStyleMetaBox(hdlrBox.getHeader().getLength() + newIlstDataSize);
        udtaHeader = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
        udtaHeader.setLength(8 + metaBox.getHeader().getLength() + existingUdtaDataLength);
        int increaseInSizeOfUdtaAtom = udtaHeader.getDataLength() - existingUdtaDataLength;
        boolean isMdatDataMoved = this.adjustStcoIfNoSuitableTopLevelAtom(sizeOfExistingTopLevelFreeAtom, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, increaseInSizeOfUdtaAtom, stco, moovHeader, mdatHeader);
        moovHeader.setLength(moovHeader.getLength() + increaseInSizeOfUdtaAtom);
        fileWriteChannel.write(moovHeader.getHeaderData());
        moovBuffer.rewind();
        moovBuffer.limit(existingMoovHeaderDataLength - existingUdtaLength);
        fileWriteChannel.write(moovBuffer);
        fileWriteChannel.write(udtaHeader.getHeaderData());
        if (moovBuffer.position() + 8 < moovBuffer.capacity()) {
            moovBuffer.limit(moovBuffer.capacity());
            moovBuffer.position(moovBuffer.position() + 8);
            fileWriteChannel.write(moovBuffer);
        }
        fileWriteChannel.write(metaBox.getHeader().getHeaderData());
        fileWriteChannel.write(metaBox.getData());
        fileWriteChannel.write(hdlrBox.getHeader().getHeaderData());
        fileWriteChannel.write(hdlrBox.getData());
        fileWriteChannel.write(newIlstData);
        fileReadChannel.position(positionInExistingFileOfWhereNewIlstAtomShouldBeWritten + existingSizeOfIlstData + sizeOfExistingMetaLevelFreeAtom);
        if (neroTagsHeader != null) {
            this.writeFromEndOfIlstToNeroTagsAndMakeNeroFree(endOfMoov, fileReadChannel, fileWriteChannel, neroTagsHeader);
        } else {
            long extraData = endOfMoov - fileReadChannel.position();
            fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraData);
            fileWriteChannel.position(fileWriteChannel.position() + extraData);
        }
        if (!isMdatDataMoved) {
            this.adjustFreeAtom(fileReadChannel, fileWriteChannel, topLevelFreeSize, additionalMetaSizeThatWontFitWithinMetaAtom);
        } else {
            logger.config("Writing:Option 9;Top Level Free comes after Mdat or before Metadata or not large enough");
        }
        this.writeDataInChunks(fileReadChannel, fileWriteChannel);
    }

    private void writeHaveExistingMetadata(Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader, FileChannel fileReadChannel, FileChannel fileWriteChannel, int positionOfNewIlstAtomRelativeToMoovAtom, Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, Mp4BoxHeader mdatHeader, Mp4StcoBox stco, int additionalMetaSizeThatWontFitWithinMetaAtom, int topLevelFreeSize, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, ByteBuffer newIlstData, Mp4BoxHeader neroTagsHeader, int sizeOfExistingMetaLevelFreeAtom, int positionInExistingFileOfWhereNewIlstAtomShouldBeWritten, int existingSizeOfIlstData) throws IOException, CannotWriteException {
        logger.config("Writing:Option 5.3;udta and meta atom exists");
        boolean isMdatDataMoved = this.adjustStcoIfNoSuitableTopLevelAtom(topLevelFreeSize, topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, additionalMetaSizeThatWontFitWithinMetaAtom, stco, moovHeader, mdatHeader);
        long endOfMoov = moovHeader.getFileEndPos();
        this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom, udtaHeader, metaHeader);
        fileWriteChannel.write(moovHeader.getHeaderData());
        moovBuffer.rewind();
        moovBuffer.limit(positionOfNewIlstAtomRelativeToMoovAtom);
        fileWriteChannel.write(moovBuffer);
        fileWriteChannel.write(newIlstData);
        fileReadChannel.position(positionInExistingFileOfWhereNewIlstAtomShouldBeWritten + existingSizeOfIlstData + sizeOfExistingMetaLevelFreeAtom);
        if (neroTagsHeader != null) {
            this.writeFromEndOfIlstToNeroTagsAndMakeNeroFree(endOfMoov, fileReadChannel, fileWriteChannel, neroTagsHeader);
        } else {
            long extraData = endOfMoov - fileReadChannel.position();
            fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraData);
            fileWriteChannel.position(fileWriteChannel.position() + extraData);
        }
        if (!isMdatDataMoved) {
            this.adjustFreeAtom(fileReadChannel, fileWriteChannel, topLevelFreeSize, additionalMetaSizeThatWontFitWithinMetaAtom);
        } else {
            logger.config("Writing:Option 9;Top Level Free comes after Mdat or before Metadata or not large enough");
        }
        this.writeDataInChunks(fileReadChannel, fileWriteChannel);
    }

    private void writeFromEndOfIlstToNeroTagsAndMakeNeroFree(long endOfMoov, FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader neroTagsHeader) throws IOException {
        long writeBetweenIlstAndTags = neroTagsHeader.getFilePos() - fileReadChannel.position();
        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), writeBetweenIlstAndTags);
        fileWriteChannel.position(fileWriteChannel.position() + writeBetweenIlstAndTags);
        this.convertandWriteTagsAtomToFreeAtom(fileWriteChannel, neroTagsHeader);
        fileReadChannel.position(neroTagsHeader.getFileEndPos());
        long extraData = endOfMoov - fileReadChannel.position();
        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraData);
    }

    private void adjustFreeAtom(FileChannel fileReadChannel, FileChannel fileWriteChannel, int topLevelFreeSize, int additionalMetaSizeThatWontFitWithinMetaAtom) throws IOException, CannotWriteException {
        if (topLevelFreeSize - 8 >= additionalMetaSizeThatWontFitWithinMetaAtom) {
            logger.config("Writing:Option 6;Larger Size can use top free atom");
            Mp4FreeBox freeBox = new Mp4FreeBox(topLevelFreeSize - 8 - additionalMetaSizeThatWontFitWithinMetaAtom);
            fileWriteChannel.write(freeBox.getHeader().getHeaderData());
            fileWriteChannel.write(freeBox.getData());
            fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
        } else if (topLevelFreeSize == additionalMetaSizeThatWontFitWithinMetaAtom) {
            logger.config("Writing:Option 7;Larger Size uses top free atom including header");
            fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
        }
    }

    private boolean adjustStcoIfNoSuitableTopLevelAtom(int topLevelFreeSize, boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata, int additionalSizeRequired, Mp4StcoBox stco, Mp4BoxHeader moovHeader, Mp4BoxHeader mdatHeader) {
        if (mdatHeader.getFilePos() > moovHeader.getFilePos() && (!topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata || topLevelFreeSize - 8 < additionalSizeRequired && topLevelFreeSize != additionalSizeRequired)) {
            stco.adjustOffsets(additionalSizeRequired);
            return true;
        }
        return false;
    }
}

