/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.rrd4j.core.RrdRandomAccessFileBackend;
import org.rrd4j.core.RrdSyncThreadPool;
import sun.nio.ch.DirectBuffer;

public class RrdNioBackend
extends RrdRandomAccessFileBackend {
    private MappedByteBuffer byteBuffer;
    private final Runnable syncRunnable = new Runnable(){

        @Override
        public void run() {
            RrdNioBackend.this.sync();
        }
    };
    private ScheduledFuture<?> syncRunnableHandle = null;

    protected RrdNioBackend(String path, boolean readOnly, RrdSyncThreadPool threadPool, int syncPeriod) throws IOException {
        super(path, readOnly);
        try {
            this.mapFile();
        }
        catch (IOException ioe) {
            super.close();
            throw ioe;
        }
        catch (RuntimeException rte) {
            super.close();
            throw rte;
        }
        try {
            if (!readOnly) {
                this.syncRunnableHandle = threadPool.scheduleWithFixedDelay(this.syncRunnable, syncPeriod, syncPeriod, TimeUnit.SECONDS);
            }
        }
        catch (RuntimeException rte) {
            this.unmapFile();
            super.close();
            throw rte;
        }
    }

    private void mapFile() throws IOException {
        long length = this.getLength();
        if (length > 0L) {
            FileChannel.MapMode mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.rafile.getChannel().map(mapMode, 0L, length);
        }
    }

    private void unmapFile() {
        if (this.byteBuffer != null) {
            if (this.byteBuffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)this.byteBuffer)).cleaner().clean();
            }
            this.byteBuffer = null;
        }
    }

    @Override
    protected synchronized void setLength(long newLength) throws IOException {
        this.unmapFile();
        super.setLength(newLength);
        this.mapFile();
    }

    @Override
    protected synchronized void write(long offset, byte[] b) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.put(b);
    }

    @Override
    protected synchronized void read(long offset, byte[] b) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.get(b);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (!this.readOnly) {
                this.syncRunnableHandle.cancel(false);
                this.sync();
            }
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
    }
}

