/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import net.yacy.visualization.RasterPlotter;

public class PrintTool {
    private static long[] font = new long[]{0L, 0x300C03000030L, 0xCC3300000000L, 0xCCFFCCCFFCCCL, 844202395095038L, 215294090137356L, 840989741474540L, 0x300C00000000L, 3313579866115L, 845181046423552L, 219775250432L, 0xC0FC0C000L, 50512064L, 0xFC00000L, 48L, 0x30383838380L, 278055968779516L, 53034306552060L, 278051014018047L, 278050829643004L, 207512417611788L, 1125626098495484L, 278040075447548L, 1124849846108208L, 278051616075004L, 278051618303228L, 0xC0000C000L, 0xC0002C0C0L, 0xE0E0E00E00EL, 0xFFC00FFC00L, 0x2C02C02C2C2C0L, 277124225171504L, 843312465314044L, 203116397985539L, 1117976764624892L, 278039809097980L, 1122339114463228L, 1125626086687743L, 1125626086687488L, 278039875038460L, 848552393445123L, 1124851985204223L, 1124803620515068L, 857392494195467L, 845250369946623L, 848771365506819L, 989530328710923L, 278051623415036L, 1122339375547136L, 278051682171131L, 1122339375592203L, 280238290382588L, 1124851985203248L, 848552129342716L, 848552271261744L, 848552162946252L, 0x38BBB8B8BBB8BL, 848494604632112L, 1124849981031423L, 69320822538303L, 985952885454859L, 1108359310787568L, 0xB8BBB8B00000L, 1023L, 246479583182848L, 805178623L, 845250634199036L, 0xFFE00FFL, 3302024416511L, 816896205055L, 66031091499056L, 204249165820L, 845250569416579L, 0x30000300C030L, 52776608645344L, 845250419483439L, 0x300C0300C030L, 248442675L, 265170691L, 265170172L, 1096034546432L, 274747096067L, 47303409712L, 197898156L, 53047191453744L, 809381116L, 0x38BBB8B8L, 0x333EECECL, 247652588L, 247652400L, 267576316L, 16542259525647L, 0x300C0300C030L, 1056321630340032L, 791275419648L, 1125629059403775L};
    private static final int arcDist = 8;

    private static void print(RasterPlotter matrix, int x, int y, int angle, char letter, int intensity) {
        int index2 = letter - 32;
        if (index2 >= font.length) {
            return;
        }
        long character = font[index2];
        int i2 = intensity / 2;
        int i3 = intensity / 3;
        int i5 = intensity / 5;
        for (int i = 0; i < 5; ++i) {
            long c;
            int j;
            long row = character & 0x3FFL;
            character >>= 10;
            if (angle == 0) {
                for (j = 0; j < 5; ++j) {
                    c = row & 3L;
                    if (c == 3L) {
                        matrix.plot(x + 5 - j, y, intensity);
                    } else if (c == 2L) {
                        matrix.plot(x + 5 - j, y, i3);
                    }
                    row >>= 2;
                }
                --y;
            }
            if (angle == 90) {
                for (j = 0; j < 5; ++j) {
                    c = row & 3L;
                    if (c == 3L) {
                        matrix.plot(x, y - 5 + j, intensity);
                    } else if (c == 2L) {
                        matrix.plot(x, y - 5 + j, i3);
                    }
                    row >>= 2;
                }
                --x;
            }
            if (angle != 315) continue;
            for (j = 0; j < 5; ++j) {
                c = row & 3L;
                if (c == 3L) {
                    matrix.plot(x + 5 - j, y + 5 - j, intensity);
                    matrix.plot(x + 6 - j, y + 5 - j, i2);
                    matrix.plot(x + 5 - j, y + 6 - j, i2);
                } else if (c == 2L) {
                    matrix.plot(x + 5 - j, y + 5 - j, i3);
                    matrix.plot(x + 6 - j, y + 5 - j, i5);
                    matrix.plot(x + 5 - j, y + 6 - j, i5);
                }
                row >>= 2;
            }
            ++x;
            --y;
        }
    }

    public static void print(RasterPlotter matrix, int x, int y, int angle, String message2, int align, int intensity) {
        int xx = 0;
        int yy = 0;
        if (angle == 0) {
            xx = align == -1 ? x : (align == 1 ? x - 6 * message2.length() : x - 3 * message2.length());
            yy = y;
        } else if (angle == 90) {
            xx = x;
            yy = align == -1 ? y : (align == 1 ? y + 6 * message2.length() : y + 3 * message2.length());
        } else if (angle == 315) {
            int n = align == -1 ? x : (xx = align == 1 ? x - 6 * message2.length() : x - 3 * message2.length());
            yy = align == -1 ? y : (align == 1 ? y - 6 * message2.length() : y - 3 * message2.length());
        }
        for (int i = 0; i < message2.length(); ++i) {
            PrintTool.print(matrix, xx, yy, angle, message2.charAt(i), intensity);
            if (angle == 0) {
                xx += 6;
                continue;
            }
            if (angle == 90) {
                yy -= 6;
                continue;
            }
            if (angle != 315) continue;
            xx += 6;
            yy += 6;
        }
    }

    public static void arcPrint(RasterPlotter matrix, int cx, int cy, int radius, double angle, String message2, int intensity) {
        int x = cx + (int)((double)(radius + 1) * Math.cos(Math.PI / 180 * angle));
        int y = cy - (int)((double)(radius + 1) * Math.sin(Math.PI / 180 * angle));
        int yp = y + 3;
        if (angle > 8.0 && angle < 172.0) {
            yp = y;
        }
        if (angle > 188.0 && angle < 352.0) {
            yp = y + 6;
        }
        if (angle > 82.0 && angle < 98.0) {
            yp -= 6;
        }
        if (angle > 262.0 && angle < 278.0) {
            yp += 6;
        }
        int xp = x - 3 * message2.length();
        if (angle > 98.0 && angle < 262.0) {
            xp = x - 6 * message2.length();
        }
        if (angle < 82.0 || angle > 278.0) {
            xp = x;
        }
        PrintTool.print(matrix, xp, yp, 0, message2, -1, intensity);
    }
}

