/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.visualization.AnimationPlotter;
import net.yacy.visualization.CircleTool;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class HexGridPlotter
extends RasterPlotter {
    private final int cellwidth1;
    private final int cellwidth2;
    private final int cellwidth12;
    private final int gwidth;
    private final int gheight;

    public HexGridPlotter(int width, int height, RasterPlotter.DrawMode drawMode, String backgroundColor, int cellwidth) {
        super(width, height, drawMode, backgroundColor);
        this.cellwidth1 = cellwidth;
        this.cellwidth2 = cellwidth >> 1;
        this.cellwidth12 = this.cellwidth1 + this.cellwidth2;
        this.gwidth = (this.width - this.cellwidth2) / this.cellwidth12;
        this.gheight = (this.height - this.cellwidth2) / this.cellwidth2;
    }

    private int projectionX(int x, int y) {
        return (x + 1) * this.cellwidth12 - this.cellwidth2 + ((x & 1) == 0 ? ((y & 1) == 0 ? 0 : this.cellwidth2) : ((y & 1) == 0 ? this.cellwidth2 : 0));
    }

    private int projectionY(int y) {
        return (y + 1) * this.cellwidth2;
    }

    public int gridWidth() {
        return this.gwidth;
    }

    public int gridHeight() {
        return this.gheight;
    }

    public void drawGrid(String colorNaming) {
        int y1;
        int x1;
        int j;
        int y0;
        int x0;
        int i;
        this.setColor(Long.parseLong(colorNaming, 16));
        for (i = 0; i < this.gwidth; ++i) {
            x0 = this.projectionX(i, -1);
            y0 = this.projectionY(-1);
            for (j = -1; j <= this.gheight + 1; ++j) {
                x1 = this.projectionX(i, j);
                y1 = this.projectionY(j);
                super.line(x0, y0, x1, y1, 40);
                x0 = x1;
                y0 = y1;
            }
        }
        for (i = -1; i <= this.gwidth; i += 2) {
            for (j = 0; j <= this.gheight; j += 2) {
                x0 = this.projectionX(i, j);
                y0 = this.projectionY(j);
                x1 = this.projectionX(i + 1, j);
                y1 = this.projectionY(j);
                super.line(x0 + 1, y0, x1 - 1, y1, 30);
                x0 = this.projectionX(i + 1, j + 1);
                y0 = this.projectionY(j + 1);
                x1 = this.projectionX(i + 2, j + 1);
                y1 = this.projectionY(j + 1);
                super.line(x0 + 1, y0, x1 - 1, y1, 30);
            }
        }
    }

    public void gridDot(int x, int y, int radius, boolean filled, int intensity) {
        this.dot(this.projectionX(x, y), this.projectionY(y), radius, filled, intensity);
    }

    public void gridDot(int x, int y, int radius, int fromArc, int toArc) {
        CircleTool.circle(this, this.projectionX(x, y), this.projectionY(y), radius, fromArc, toArc);
    }

    public void gridPrint(int x, int y, int radius, String messageHigh, String messageLow, int align, int intensity) {
        if (messageHigh != null && messageHigh.length() > 0) {
            PrintTool.print(this, this.projectionX(x, y) - align * radius, this.projectionY(y) - (this.cellwidth2 >> 2) - (align == 0 ? radius : 0), 0, messageHigh, align, intensity);
        }
        if (messageLow != null && messageLow.length() > 0) {
            PrintTool.print(this, this.projectionX(x, y) - align * radius, this.projectionY(y) + (this.cellwidth2 >> 2) + 4 + (align == 0 ? radius : 0), 0, messageLow, align, intensity);
        }
    }

    public void gridPrint315(int x, int y, int radius, String message315, int intensity) {
        if (message315 != null && message315.length() > 0) {
            PrintTool.print(this, this.projectionX(x, y) + (radius >> 1), this.projectionY(y) + (this.cellwidth2 >> 2) + 4, 315, message315, -1, intensity);
        }
    }

    public void gridLine(int Ax, int Ay, int Bx, int By) {
        this.gridLine(Ax, Ay, Bx, By, null, 100, null, 100, -1, -1, -1, false);
    }

    public void gridLine(int Ax, int Ay, int Bx, int By, String colorLine, int intensityLine, String colorDot, int intensityDot, int dotDist, int dotPos, int dotRadius, boolean dotFilled) {
        Long colorDot_l;
        int x0 = this.projectionX(Ax, Ay);
        int y0 = this.projectionY(Ay);
        int x1 = this.projectionX(Bx, By);
        int y1 = this.projectionY(By);
        int dotc = 0;
        Long colorLine_l = colorLine == null ? null : Long.valueOf(Long.parseLong(colorLine, 16));
        Long l = colorDot_l = colorDot == null ? null : Long.valueOf(Long.parseLong(colorDot, 16));
        while (x1 != x0 || y1 != y0) {
            int horizontal = 0;
            if (x1 > x0) {
                --x1;
                ++horizontal;
            } else if (x1 < x0) {
                ++x1;
                ++horizontal;
            }
            if (y1 > y0) {
                --y1;
                ++horizontal;
            } else if (y1 < y0) {
                ++y1;
                ++horizontal;
            }
            if (colorLine != null) {
                this.setColor(colorLine_l);
            }
            this.plot(x1, y1, horizontal == 2 ? intensityLine : intensityLine * 8 / 10);
            if (dotc == dotPos) {
                if (colorDot != null) {
                    this.setColor(colorDot_l);
                }
                if (dotRadius == 0) {
                    this.plot(x1, y1, intensityDot);
                } else if (dotRadius > 0) {
                    this.dot(x1, y1, dotRadius, dotFilled, intensityDot);
                }
            }
            if (++dotc != dotDist) continue;
            dotc = 0;
        }
    }

    private static HexGridPlotter testImage0(int width, int height, String bgcolor, String gridcolor, String dotcolor) {
        int i;
        HexGridPlotter picture = new HexGridPlotter(width, height, bgcolor.equals("000000") ? RasterPlotter.DrawMode.MODE_ADD : RasterPlotter.DrawMode.MODE_SUB, bgcolor, 18);
        picture.drawGrid(gridcolor);
        long dotcolori = Long.parseLong(dotcolor, 16);
        picture.setColor(dotcolori);
        picture.gridDot(0, 0, 5, true, 100);
        picture.gridPrint(0, 0, 5, "", "0,0", -1, 100);
        for (i = 1; i < picture.gridHeight() - 1; ++i) {
            picture.setColor(dotcolori);
            picture.gridDot(0, i, 3, true, 100);
            picture.setColor(dotcolori);
            picture.gridPrint(0, i, 3, "", "0," + i, -1, 100);
        }
        for (i = 1; i < picture.gridWidth() - 1; ++i) {
            picture.setColor(dotcolori);
            picture.gridDot(i, 0, 3, true, 100);
            picture.setColor(dotcolori);
            picture.gridPrint315(i, 0, 3, i + ",0", 100);
        }
        picture.setColor(dotcolori);
        picture.gridDot(0, picture.gheight - 1, 5, true, 100);
        picture.gridPrint(0, picture.gheight - 1, 5, "0, grid.gheight - 1", "", -1, 100);
        picture.gridDot(picture.gwidth - 1, 0, 5, true, 100);
        picture.gridPrint(picture.gwidth - 1, 0, 5, "", "grid.gwidth - 1, 0", -1, 100);
        picture.gridDot(picture.gwidth - 1, picture.gheight - 1, 5, true, 100);
        picture.gridPrint(picture.gwidth - 1, picture.gheight - 1, 5, "grid.gwidth - 1, grid.gheight - 1", "", 1, 100);
        picture.gridDot(3, 3, 20, 0, 360);
        picture.gridDot(7, 5, 5, 0, 360);
        picture.gridPrint(7, 5, 8, "COMMUNICATION TEST", "TRANSFER 64KBIT", -1, 100);
        picture.gridDot(14, 8, 5, true, 100);
        picture.gridLine(7, 5, 14, 8);
        picture.gridPrint315(14, 8, 8, "NULL", 100);
        picture.gridDot(4, 28, 5, 0, 360);
        picture.gridPrint(4, 28, 8, "REVERSE", "ESREVER", -1, 100);
        picture.gridLine(4, 28, 14, 8);
        picture.gridDot(picture.gwidth - 1, picture.gheight - 4, 5, 0, 360);
        picture.gridPrint(picture.gwidth - 1, picture.gheight - 4, 5, "INTERNET", "END", 1, 100);
        picture.gridDot(picture.gwidth / 2, picture.gheight / 2, 5, 0, 360);
        picture.gridPrint(picture.gwidth / 2, picture.gheight / 2, 5, "HOME PEER", "ANON_23", 0, 100);
        picture.gridLine(picture.gwidth / 2, picture.gheight / 2, picture.gwidth - 1, picture.gheight - 4);
        return picture;
    }

    public static void main(String[] args) {
        AnimationPlotter animation = new AnimationPlotter();
        for (int i = 640; i < 700; ++i) {
            animation.addFrame(HexGridPlotter.testImage0(i, 480, "000000", "555555", "33ff33").getImage(), 10);
        }
        animation.show();
        HexGridPlotter picture = HexGridPlotter.testImage0(640, 480, "FFFFFF", "555555", "33ff33");
        File file = new File("/Users/admin/Desktop/testimage.png");
        try {
            picture.save(file, "png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ConcurrentLog.shutdown();
        if (!System.getProperty("java.awt.headless", "false").equals("true")) {
            picture.show();
        }
    }
}

