/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class ChartPlotter
extends RasterPlotter {
    public static final int DIMENSION_RIGHT = 0;
    public static final int DIMENSION_TOP = 1;
    public static final int DIMENSION_LEFT = 2;
    public static final int DIMENSION_BOTTOM = 3;
    public static final int DIMENSION_ANOT0 = 4;
    public static final int DIMENSION_ANOT1 = 5;
    public static final int DIMENSION_ANOT2 = 6;
    public static final int DIMENSION_ANOT3 = 7;
    private final int leftborder;
    private final int rightborder;
    private final int topborder;
    private final int bottomborder;
    private final int[] scales = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] pixels = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] offsets = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private final Long[] colnames = new Long[]{0xFFFFFFL, 0xFFFFFFL, 0xFFFFFFL, 0xFFFFFFL, 0xFFFFFFL, 0xFFFFFFL, 0xFFFFFFL, 0xFFFFFFL};
    private final Long[] colscale = new Long[]{null, null, null, null, null, null, null, null};
    private final String[] tablenames = new String[]{"", "", "", "", "", "", "", ""};

    public ChartPlotter(int width, int height, Long backgroundColor, Long foregroundColor, Long lightColor, int leftborder, int rightborder, int topborder, int bottomborder, String name, String subline) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, backgroundColor);
        this.leftborder = leftborder;
        this.rightborder = rightborder;
        this.topborder = topborder;
        this.bottomborder = bottomborder;
        if (name != null) {
            if (foregroundColor != null) {
                this.setColor(foregroundColor);
            }
            PrintTool.print(this, width / 2 - name.length() * 3, 6, 0, name, -1, 100);
        }
        if (subline != null) {
            if (lightColor != null) {
                this.setColor(lightColor);
            }
            PrintTool.print(this, width / 2 - subline.length() * 3, 14, 0, subline, -1, 100);
        }
    }

    public void declareDimension(int dimensionType, int scale, int pixelperscale, int offset, Long colorNaming, Long colorScale, String name) {
        this.scales[dimensionType] = Math.max(1, scale);
        this.pixels[dimensionType] = pixelperscale;
        this.offsets[dimensionType] = offset;
        this.colnames[dimensionType] = colorNaming;
        this.colscale[dimensionType] = colorScale;
        this.tablenames[dimensionType] = name;
        if (dimensionType == 2 || dimensionType == 0) {
            this.drawVerticalScale(dimensionType == 2, scale, pixelperscale, offset, colorNaming, colorScale, name);
        }
        if (dimensionType == 1 || dimensionType == 3) {
            this.drawHorizontalScale(dimensionType == 1, scale, pixelperscale, offset, colorNaming, colorScale, name);
        }
    }

    public void chartDot(int dimension_x, int dimension_y, float coord_x, int coord_y, int dotsize, String anot, int anotAngle) {
        int x = (int)((coord_x - (float)this.offsets[dimension_x]) * (float)this.pixels[dimension_x] / (float)this.scales[dimension_x]);
        assert (this.scales[dimension_y] != 0);
        int y = (int)((long)(coord_y - this.offsets[dimension_y]) * (long)this.pixels[dimension_y] / (long)this.scales[dimension_y]);
        if (dotsize == 1) {
            this.plot(this.leftborder + x, this.height - this.bottomborder - y, 100);
        } else {
            this.dot(this.leftborder + x, this.height - this.bottomborder - y, dotsize, true, 100);
        }
        if (anot != null) {
            PrintTool.print(this, this.leftborder + x + dotsize + 2 + (anotAngle == 315 ? -9 : 0), this.height - this.bottomborder - y + (anotAngle == 315 ? -3 : 0), anotAngle, anot, anotAngle == 0 ? (anot.length() * 6 + x > this.width ? 1 : -1) : (anotAngle == 315 ? 1 : 0), 100);
        }
    }

    public void chartLine(int dimension_x, int dimension_y, float coord_x1, int coord_y1, float coord_x2, int coord_y2) {
        int x1 = (int)((coord_x1 - (float)this.offsets[dimension_x]) * (float)this.pixels[dimension_x] / (float)this.scales[dimension_x]);
        int y1 = (int)((long)(coord_y1 - this.offsets[dimension_y]) * (long)this.pixels[dimension_y] / (long)this.scales[dimension_y]);
        int x2 = (int)((coord_x2 - (float)this.offsets[dimension_x]) * (float)this.pixels[dimension_x] / (float)this.scales[dimension_x]);
        int y2 = (int)((long)(coord_y2 - this.offsets[dimension_y]) * (long)this.pixels[dimension_y] / (long)this.scales[dimension_y]);
        this.line(this.leftborder + x1, this.height - this.bottomborder - y1, this.leftborder + x2, this.height - this.bottomborder - y2, 100);
    }

    private void drawHorizontalScale(boolean top, int scale, int pixelperscale, int offset, Long colorNaming, Long colorScale, String name) {
        int y = top ? this.topborder : this.height - this.bottomborder;
        int x = this.leftborder;
        int s = offset;
        while (x < this.width - this.rightborder) {
            if (colorScale != null && x > this.leftborder && x < this.width - this.rightborder) {
                this.setColor(colorScale);
                this.line(x, this.topborder, x, this.height - this.bottomborder, 100);
            }
            this.setColor(colorNaming);
            this.line(x, y - 3, x, y + 3, 100);
            PrintTool.print(this, x, top ? y - 3 : y + 9, 0, Integer.toString(s), -1, 80);
            x += pixelperscale;
            s += scale;
        }
        this.setColor(colorNaming);
        PrintTool.print(this, this.width - this.rightborder, top ? y - 9 : y + 15, 0, name, 1, 80);
        this.line(this.leftborder - 4, y, this.width - this.rightborder + 4, y, 100);
    }

    private void drawVerticalScale(boolean left, int scale, int pixelperscale, int offset, Long colorNaming, Long colorScale, String name) {
        assert (pixelperscale > 0);
        assert (scale > 0);
        if (pixelperscale <= 0) {
            return;
        }
        int x = left ? this.leftborder : this.width - this.rightborder;
        int y = this.height - this.bottomborder;
        int s = offset;
        int s1max = 0;
        while (y > this.topborder) {
            String s1;
            if (colorScale != null && y > this.topborder && y < this.height - this.bottomborder) {
                this.setColor(colorScale);
                this.line(this.leftborder, y, this.width - this.rightborder, y, 100);
            }
            this.setColor(colorNaming);
            this.line(x - 3, y, x + 3, y, 100);
            Object object = s >= 1000000 && s % 1000000 == 0 ? Integer.toString(s / 1000000) + "M" : (s1 = s >= 1000 && s % 1000 == 0 ? Integer.toString(s / 1000) + "K" : Integer.toString(s));
            if (s1.length() > s1max) {
                s1max = s1.length();
            }
            PrintTool.print(this, left ? this.leftborder - 4 : this.width - this.rightborder + 4, y, 0, s1, left ? 1 : -1, 80);
            y -= pixelperscale;
            s += scale;
        }
        this.setColor(colorNaming);
        PrintTool.print(this, left ? Math.max(6, x - s1max * 6 - 6) : x + s1max * 6 + 9, this.height - this.bottomborder, 90, name, -1, 80);
        this.line(x, this.topborder - 4, x, this.height - this.bottomborder + 4, 100);
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        long bg = 0xFFFFFFL;
        long fg = 0L;
        long scale = 0xCCCCCCL;
        long green = 34816L;
        long blue = 255L;
        ChartPlotter ip = new ChartPlotter(660, 240, 0xFFFFFFL, 0L, 0L, 30, 30, 20, 20, "PEER PERFORMANCE GRAPH: PAGES/MINUTE and USED MEMORY", "");
        ip.declareDimension(3, 60, 60, -600, 0L, 0xCCCCCCL, "TIME/SECONDS");
        ip.declareDimension(2, 50, 40, 0, 34816L, 0xCCCCCCL, "PPM [PAGES/MINUTE]");
        ip.declareDimension(0, 100, 20, 0, 255L, 0xCCCCCCL, "MEMORY/MEGABYTE");
        ip.setColor(34816L);
        int width = 600;
        int maxPPM = 240;
        int steps = 10;
        int x = -600;
        int ppm = 24;
        int ppmStep = (int)(216.0 / (double)steps);
        for (int step = 0; step < steps; ++step) {
            ip.chartDot(3, 2, x, ppm, 5, null, 0);
            ip.chartLine(3, 2, x, ppm, x + 600 / steps, ppm + ppmStep);
            ppm += ppmStep;
            x += 600 / steps;
        }
        ip.setColor(255L);
        steps = 20;
        int maxMBytes = 800;
        int mBytes = 640;
        int mBytesStep = (int)(480.0 / (double)steps);
        x = -600;
        for (int step = 0; step < steps; ++step) {
            ip.chartDot(3, 0, x, mBytes, 5, null, 0);
            ip.chartLine(3, 0, x, mBytes, x + 600 / steps, mBytes - mBytesStep);
            mBytes -= mBytesStep;
            x += 600 / steps;
        }
        File file = new File(System.getProperty("java.io.tmpdir"), "testimage.png");
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(RasterPlotter.exportImage(ip.getImage(), "png").getBytes());
            System.out.println("CharPlotter test file written at " + file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConcurrentLog.shutdown();
    }
}

