/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.Translator;
import net.yacy.search.Switchboard;
import net.yacy.server.serverCore;
import net.yacy.utils.translation.TranslatorXliff;

public class TranslationManager
extends TranslatorXliff {
    protected Map<String, Map<String, String>> mainTransLists;
    protected String loadedLng;

    public TranslationManager() {
    }

    public TranslationManager(File langfile) {
        this.mainTransLists = this.loadTranslationsLists(langfile);
        int pos = langfile.getName().indexOf(46);
        if (pos >= 0) {
            this.loadedLng = langfile.getName().substring(0, pos);
        }
    }

    public boolean addTranslation(String relFileName, String sourceLngTxt, String targetLngTxt) {
        assert (this.mainTransLists != null);
        return this.addTranslation(this.mainTransLists, relFileName, sourceLngTxt, targetLngTxt);
    }

    public boolean addTranslation(Map<String, Map<String, String>> translation, String relFileName, String sourceLngTxt, String targetLngTxt) {
        Map<Object, Object> transFile;
        boolean modified = false;
        if (translation.containsKey(relFileName)) {
            transFile = translation.get(relFileName);
        } else {
            transFile = new LinkedHashMap();
            translation.put(relFileName, transFile);
            modified = true;
        }
        String oldLngTxt = transFile.put(sourceLngTxt, targetLngTxt);
        if (oldLngTxt == null) {
            modified = targetLngTxt != null;
        } else if (!oldLngTxt.equals(targetLngTxt)) {
            modified = true;
        }
        return modified;
    }

    public Map<String, String> getTranslationForFile(String filename) {
        return this.mainTransLists.get(filename);
    }

    public String getTranslation(String filename, String source) {
        Map<String, String> tmp = this.mainTransLists.get(filename);
        if (tmp != null) {
            return tmp.get(source);
        }
        return null;
    }

    public boolean translateFile(String relFilepath) {
        Switchboard sb;
        assert (this.loadedLng != null);
        assert (this.mainTransLists != null);
        boolean result = false;
        if (this.mainTransLists.containsKey(relFilepath) && (sb = Switchboard.getSwitchboard()) != null) {
            String htRootPath = sb.getConfig("htRootPath", "htroot");
            File sourceDir = new File(sb.getAppPath(), htRootPath);
            File destDir = new File(sb.getDataPath("locale.translated_html", "DATA/LOCALE/htroot"), this.loadedLng);
            File sourceFile = new File(sourceDir, relFilepath);
            File destFile = new File(destDir, relFilepath);
            result = this.translateFile(sourceFile, destFile, this.mainTransLists.get(relFilepath));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMasterTranslationLists(File localesFolder, File masterOutputFile) throws IOException {
        this.mainTransLists = masterOutputFile.exists() ? this.loadTranslationsListsFromXliff(masterOutputFile) : new TreeMap<String, Map<String, String>>();
        List<String> lngFiles = Translator.langFiles(localesFolder);
        for (String filename : lngFiles) {
            ConcurrentLog.info("TRANSLATOR", "include translation file " + filename);
            Map<String, Map<String, String>> origTrans = this.loadTranslationsLists(new File(localesFolder, filename));
            for (String transfilename : origTrans.keySet()) {
                File checkfile = new File("htroot", transfilename);
                if (checkfile.exists()) {
                    StringBuilder content = new StringBuilder();
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(checkfile), StandardCharsets.UTF_8));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            content.append(line).append(serverCore.CRLF_STRING);
                        }
                    }
                    catch (IOException e) {
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (Exception e) {
                                ConcurrentLog.fine("TRANSLATOR", "Could not close buffered reader on file " + checkfile);
                            }
                        }
                    }
                    Map<String, String> origList = origTrans.get(transfilename);
                    for (String sourcetxt : origList.keySet()) {
                        String origVal;
                        if (content.indexOf(sourcetxt) < 0 || (origVal = origList.get(sourcetxt)) == null || origVal.isEmpty()) continue;
                        this.addTranslation(transfilename, sourcetxt, null);
                    }
                    continue;
                }
                ConcurrentLog.fine("TRANSLATOR", "skip file for translation " + transfilename + " (from " + filename + ")");
            }
        }
        this.saveAsXliff(null, masterOutputFile, this.mainTransLists);
    }

    public Map<String, Map<String, String>> joinMasterTranslationLists(File xlifmaster, File lngfile) throws IOException {
        String filename = lngfile.getName();
        this.mainTransLists = this.loadTranslationsListsFromXliff(xlifmaster);
        ConcurrentLog.info("TRANSLATOR", "join into master translation file " + filename);
        Map<String, Map<String, String>> origTrans = this.loadTranslationsLists(lngfile);
        for (String transfilename : origTrans.keySet()) {
            Map<String, String> origList = origTrans.get(transfilename);
            Map<String, String> masterList = this.mainTransLists.get(transfilename);
            for (String sourcetxt : origList.keySet()) {
                String origVal;
                if (masterList == null || !masterList.isEmpty() && !masterList.containsKey(sourcetxt) || (origVal = origList.get(sourcetxt)) == null || origVal.isEmpty()) continue;
                this.addTranslation(transfilename, sourcetxt, origVal);
            }
        }
        return this.mainTransLists;
    }

    public boolean saveXliff(String lng, File f) {
        return this.saveAsXliff(lng, f, this.mainTransLists);
    }

    public boolean saveLng(String lng, File f) {
        return this.saveAsLngFile(lng, f, this.mainTransLists);
    }

    public int size() {
        int i = 0;
        for (Map<String, String> trans : this.mainTransLists.values()) {
            i += trans.size();
        }
        return i;
    }
}

