/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.utils.Gzip;

public class cryptbig {
    private static long saltcounter = 0L;
    private static Random saltrandom = new Random(System.currentTimeMillis());
    public static final String vDATE = "20030925";
    public static final String copyright = "[ 'crypt' v20030925 by Michael Christen / www.anomic.de ]";
    public static final String magicString = "crypt|anomic.de|0";
    public static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ENGLISH);
    String cryptMethod;
    private static final String defaultMethod = "PBEWithMD5AndDES";
    Cipher ecipher;
    Cipher dcipher;

    public static String randomSalt() {
        long salt = (saltrandom.nextLong() & 0xFFFFFFFFFFFFL) + (System.currentTimeMillis() & 0xFFFFFFFFFFFFL) + (1001L * saltcounter & 0xFFFFFFFFFFFFL);
        ++saltcounter;
        return Base64Order.standardCoder.encodeLongSB(salt & 0xFFFFFFFFFFFFL, 8).toString();
    }

    public cryptbig(String pbe) {
        this(pbe, (pbe + "XXXXXXXX").substring(0, 8));
    }

    public cryptbig(String pbe, String salt) {
        this(pbe, salt, defaultMethod);
    }

    private cryptbig(String pbe, String salt, String method) {
        PBEKeySpec keySpec = new PBEKeySpec(pbe.toCharArray());
        try {
            if (salt.length() > 8) {
                salt = salt.substring(0, 8);
            }
            if (salt.length() < 8) {
                salt = (salt + "XXXXXXXX").substring(0, 8);
            }
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(method);
            SecretKey key = keyFactory.generateSecret(keySpec);
            PBEParameterSpec paramSpec = new PBEParameterSpec(UTF8.getBytes(salt), 1000);
            this.cryptMethod = method;
            this.ecipher = Cipher.getInstance(this.cryptMethod);
            this.dcipher = Cipher.getInstance(this.cryptMethod);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public String encryptString(String str) {
        try {
            byte[] utf = str.getBytes("UTF8");
            byte[] enc = this.encryptArray(utf);
            if (enc == null) {
                return null;
            }
            return Base64Order.standardCoder.encode(enc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String decryptString(String str) {
        byte[] b64dec = Base64Order.standardCoder.decode(str);
        if (b64dec == null) {
            return null;
        }
        byte[] dec = this.decryptArray(b64dec);
        if (dec == null) {
            return null;
        }
        return UTF8.String(dec);
    }

    public byte[] encryptArray(byte[] b) {
        if (b == null) {
            return null;
        }
        try {
            return this.ecipher.doFinal(b);
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        return null;
    }

    public byte[] decryptArray(byte[] b) {
        if (b == null) {
            return null;
        }
        try {
            return this.dcipher.doFinal(b);
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        return null;
    }

    public static Set<String> listCryptoMethods(String serviceType) {
        Provider[] providers;
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : providers = Security.getProviders()) {
            Set<Object> keys = provider.keySet();
            for (Object name : keys) {
                String key = (String)name;
                if ((key = CommonPattern.SPACE.split(key)[0]).startsWith(serviceType + ".")) {
                    result.add(key.substring(serviceType.length() + 1));
                    continue;
                }
                if (!key.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(key.substring(serviceType.length() + 11));
            }
        }
        return result;
    }

    public static void testCryptMethods(Set<String> methods) {
        for (String method : methods) {
            System.out.print(method + " : ");
            try {
                cryptbig crypter = new cryptbig("abrakadabra", method);
                String encrypted = crypter.encryptString("nicht verraten abc 1234567890");
                System.out.print(encrypted + "/");
                String decrypted = crypter.decryptString(encrypted);
                System.out.println(decrypted);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.getMessage());
                ConcurrentLog.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptFile(String inFileName, String outFileName) {
        InputStream fin = null;
        OutputStream fout = null;
        try {
            File inFile = new File(inFileName);
            String inFileDate = dateFormatter.format(new Date(inFile.lastModified()));
            String encryptionDate = dateFormatter.format(new Date());
            String inFileSize = Base64Order.standardCoder.encodeLongSB(inFile.length(), 11).toString();
            String flag = "1";
            String X = inFileDate + encryptionDate + inFileSize + "1" + inFileName;
            System.out.println("TEST: preserving inFileDate    : " + dateFormatter.parse(inFileDate, new ParsePosition(0)));
            System.out.println("TEST: preserving encryptionDate: " + dateFormatter.parse(encryptionDate, new ParsePosition(0)));
            System.out.println("TEST: preserving inFileLength  : " + inFile.length());
            System.out.println("TEST: preserving flag          : 1");
            System.out.println("TEST: preserving inFileName    : " + inFileName);
            System.out.println("TEST: preserving X-String      : " + X);
            fin = new CipherInputStream(new FileInputStream(inFile), this.ecipher);
            fout = new FileOutputStream(outFileName);
            try {
                String A = UTF8.String(this.ecipher.doFinal(X.getBytes("UTF8")));
                String B = UTF8.String(this.ecipher.doFinal(Base64Order.standardCoder.encodeLongSB(A.length(), 2).toString().getBytes("UTF8")));
                String C = Base64Order.standardCoder.encodeLongSB(B.length(), 1).toString();
                fout.write(UTF8.getBytes(magicString));
                fout.write(UTF8.getBytes(C));
                fout.write(UTF8.getBytes(B));
                fout.write(UTF8.getBytes(A));
                cryptbig.copy(fout, fin, 512);
            }
            catch (IllegalBlockSizeException e) {
                System.err.println("ERROR:" + e.getMessage());
            }
            catch (BadPaddingException e) {
                System.err.println("ERROR:" + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: file '" + inFileName + "' not found");
        }
        catch (IOException e) {
            System.err.println("ERROR: IO trouble");
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decryptFile(String inFileName, String outFileName) {
        InputStream fin = null;
        OutputStream fout = null;
        try {
            fin = new BufferedInputStream(new FileInputStream(inFileName), 4096);
            byte[] thisMagic = new byte[magicString.length()];
            fin.read(thisMagic);
            if (!UTF8.String(thisMagic).equals(magicString)) {
                fin.close();
                return;
            }
            byte[] C = new byte[1];
            fin.read(C);
            byte[] B = new byte[(int)Base64Order.standardCoder.decodeLong(UTF8.String(C))];
            fin.read(B);
            byte[] A = new byte[(int)Base64Order.standardCoder.decodeLong(UTF8.String(this.dcipher.doFinal(B)))];
            fin.read(A);
            String X = UTF8.String(this.dcipher.doFinal(A));
            System.out.println("TEST: detecting X-String      : " + X);
            Date inFileDate = dateFormatter.parse(X.substring(0, 17), new ParsePosition(0));
            Date encryptionDate = dateFormatter.parse(X.substring(17, 34), new ParsePosition(0));
            long inFileSize = Base64Order.standardCoder.decodeLong(X.substring(34, 45));
            String flag = X.substring(45, 46);
            String origFileName = X.substring(46);
            System.out.println("TEST: detecting inFileDate    : " + inFileDate);
            System.out.println("TEST: detecting encryptionDate: " + encryptionDate);
            System.out.println("TEST: detecting inFileLength  : " + inFileSize);
            System.out.println("TEST: detecting flag          : " + flag);
            System.out.println("TEST: detecting inFileName    : " + origFileName);
            fout = new BufferedOutputStream(new CipherOutputStream(new FileOutputStream(outFileName), this.dcipher), 4096);
            cryptbig.copy(fout, fin, 512);
        }
        catch (BadPaddingException e) {
            System.err.println("ERROR: decryption of '" + inFileName + "' not possible: " + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            System.err.println("ERROR: decryption of '" + inFileName + "' not possible: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: file '" + inFileName + "' not found");
        }
        catch (IOException e) {
            System.err.println("ERROR: IO trouble");
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private static void copy(OutputStream out, InputStream in, int bufferSize) throws IOException {
        int n;
        BufferedInputStream bIn = new BufferedInputStream(in, bufferSize);
        BufferedOutputStream bOut = new BufferedOutputStream(out, bufferSize);
        byte[] buf = new byte[bufferSize];
        while ((n = ((InputStream)bIn).read(buf)) > 0) {
            ((OutputStream)bOut).write(buf, 0, n);
        }
        ((InputStream)bIn).close();
        ((OutputStream)bOut).close();
    }

    public static String scrambleString(String key, String s) {
        String salt = cryptbig.randomSalt();
        cryptbig c = new cryptbig(key, salt);
        boolean gzFlag = true;
        byte[] gz = Gzip.gzipString(s);
        if (gz.length > s.length()) {
            try {
                gz = s.getBytes("UTF8");
                gzFlag = false;
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        if (gz == null) {
            return null;
        }
        byte[] enc = c.encryptArray(gz);
        if (enc == null) {
            return null;
        }
        return salt + (gzFlag ? "1" : "0") + Base64Order.enhancedCoder.encode(enc);
    }

    public static String descrambleString(String key, String s) {
        String salt = s.substring(0, 8);
        boolean gzFlag = s.charAt(8) == '1';
        s = s.substring(9);
        cryptbig c = new cryptbig(key, salt);
        byte[] b64dec = Base64Order.enhancedCoder.decode(s);
        if (b64dec == null) {
            return null;
        }
        byte[] dec = c.decryptArray(b64dec);
        if (dec == null) {
            return null;
        }
        if (gzFlag) {
            return Gzip.gunzipString(dec);
        }
        return UTF8.String(dec);
    }

    public static String simpleEncode(String content) {
        return cryptbig.simpleEncode(content, null, 'b');
    }

    public static String simpleEncode(String content, String key) {
        return cryptbig.simpleEncode(content, key, 'b');
    }

    public static String simpleEncode(String content, String key, char method) {
        if (key == null) {
            key = "NULL";
        }
        if (method == 'p') {
            return "p|" + content;
        }
        if (method == 'b') {
            return "b|" + Base64Order.enhancedCoder.encodeString(content);
        }
        if (method == 'z') {
            return "z|" + Base64Order.enhancedCoder.encode(Gzip.gzipString(content));
        }
        if (method == 'c') {
            return "c|" + cryptbig.scrambleString(key, content);
        }
        return null;
    }

    public static String simpleDecode(String encoded, String key) {
        if (encoded == null || encoded.length() < 3) {
            return null;
        }
        if (encoded.charAt(1) != '|') {
            return encoded;
        }
        char method = encoded.charAt(0);
        encoded = encoded.substring(2);
        if (method == 'p') {
            return encoded;
        }
        if (method == 'b') {
            return Base64Order.enhancedCoder.decodeString(encoded);
        }
        if (method == 'z') {
            return Gzip.gunzipString(Base64Order.enhancedCoder.decode(encoded));
        }
        if (method == 'c') {
            return cryptbig.descrambleString(key, encoded);
        }
        return null;
    }

    public static String oneWayEncryption(String key) {
        cryptbig crypter = new cryptbig(key);
        Object e = crypter.encryptString(key);
        if (((String)e).isEmpty()) {
            e = "0XXXX";
        }
        if (((String)e).length() % 2 != 0) {
            e = (String)e + "X";
        }
        while (((String)e).length() < 32) {
            e = (String)e + (String)e;
        }
        char[] r = new char[16];
        for (int i = 0; i < 16; ++i) {
            r[i] = ((String)e).charAt(2 * i + 1);
        }
        return new String(r);
    }

    private static void help() {
        System.out.println("AnomicCrypt (2003) by Michael Christen");
        System.out.println("Password-based encryption using the PBEWithMD5AndDES-method in standard java");
        System.out.println("usage: crypt -h | -help");
        System.out.println("       crypt -1 <passwd>");
        System.out.println("       crypt -md5 <file>");
        System.out.println("       crypt ( -es64 | -ds64 | -ec64 | -dc64 ) <string>");
        System.out.println("       crypt ( -e | -d ) <key> <string>");
        System.out.println("       crypt -enc <key> <file>  \\");
        System.out.println("                   [-o <target-file> | -preserveFilename]  \\");
        System.out.println("                   [-d <YYYYMMddHHmmSSsss> | -preserveDate] [-noZip]");
        System.out.println("       crypt -dec <key> <file>  \\");
        System.out.println("                   [-o <target-file> | -preserveFilename]  \\");
        System.out.println("                   [-d <YYYYMMddHHmmSSsss> | -preserveDate]");
        System.out.println("       crypt ( -info | -name | -size | -date | -edate )  \\");
        System.out.println("                   <key> <encrypted-file>");
    }

    private static void longhelp() {
        System.out.println("AnomicCrypt (2003) by Michael Christen");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -1 <passwd>");
        System.out.println("");
        System.out.println("   One-way encryption of the given password.");
        System.out.println("   The result is computed by encoding the word with the word as");
        System.out.println("   the password and repeating it until the length is greater");
        System.out.println("   than 32. Then every second character is taken to compose the");
        System.out.println("   result which has always the length of 16 characters.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -md5 <file>");
        System.out.println("");
        System.out.println("   MD5 digest according to RFC 1321. The resulting bytes are");
        System.out.println("   encoded as two-digit hex and concatenated to a single string.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -ec64 <cardinal>");
        System.out.println("");
        System.out.println("   Encoding of a cardianal (a positive long integer) with the");
        System.out.println("   built-in non-standard base-64 algorithm.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -dc64 <string>");
        System.out.println("");
        System.out.println("   Decoding of the given b64-coded string to a cardinal number.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -es64 <string>");
        System.out.println("");
        System.out.println("   Encoding of a given String to a b64 string.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -ds64 <string>");
        System.out.println("");
        System.out.println("   Decoding of a given b64-coded string to a normal string.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -e <key> <string>");
        System.out.println("");
        System.out.println("   Encryption of a given Unicode-String.");
        System.out.println("   The given string is first encoded to an UTF-8 byte stream, then");
        System.out.println("   encoded using a password based encryption and then finaly");
        System.out.println("   encoded to b64 to generate a printable form.");
        System.out.println("   The PBE method is PBEWithMD5AndDES.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -d <key> <string>");
        System.out.println("");
        System.out.println("   Decryption of a string.");
        System.out.println("   The string is b64-decoded, PBEWithMD5AndDES-decrypted, ");
        System.out.println("   and then transformed to an unicode string.");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -enc <key> <file>  \\");
        System.out.println("            [-o <target-file> | -preserveFilename]  \\");
        System.out.println("            [-d <target-date YYYYMMddHHmmSSsss> | -preserveDate] [-noZip]");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt -dec <key> <file>  \\");
        System.out.println("            [-o <target-file> | -preserveFilename]  \\");
        System.out.println("            [-d <target-date YYYYMMddHHmmSSsss> | -preserveDate]");
        System.out.println("");
        System.out.println("");
        System.out.println("crypt ( -info | -name | -size | -date | -edate ) <key> <encrypted-file>");
        System.out.println("");
        System.out.println("");
    }

    public static void main(String[] s) {
        Object target;
        if (s.length == 0) {
            cryptbig.help();
            System.exit(0);
        }
        if (s[0].equals("-h") || s[0].equals("-help")) {
            cryptbig.longhelp();
            System.exit(0);
        }
        if (s[0].equals("-tc")) {
            Set<String> methods = cryptbig.listCryptoMethods("Cipher");
            System.out.println(methods.size() + " crypt methods:" + methods.toString());
            cryptbig.testCryptMethods(methods);
            System.exit(0);
        }
        if (s[0].equals("-random")) {
            int count = s.length == 2 ? Integer.parseInt(s[1]) : 1;
            for (int i = 0; i < count; ++i) {
                System.out.println(cryptbig.randomSalt());
            }
            System.exit(0);
        }
        if (s[0].equals("-1")) {
            if (s.length != 2) {
                cryptbig.help();
                System.exit(-1);
            }
            System.out.println(cryptbig.oneWayEncryption(s[1]));
            System.exit(0);
        }
        if (s[0].equals("-ec64")) {
            if (s.length != 2) {
                cryptbig.help();
                System.exit(-1);
            }
            System.out.println(Base64Order.standardCoder.encodeLongSB(Long.parseLong(s[1]), 0).toString());
            System.exit(0);
        }
        if (s[0].equals("-dc64")) {
            if (s.length != 2) {
                cryptbig.help();
                System.exit(-1);
            }
            System.out.println(Base64Order.standardCoder.decodeLong(s[1]));
            System.exit(0);
        }
        if (s[0].equals("-es64")) {
            if (s.length != 2) {
                cryptbig.help();
                System.exit(-1);
            }
            System.out.println(Base64Order.standardCoder.encodeString(s[1]));
            System.exit(0);
        }
        if (s[0].equals("-ds64")) {
            if (s.length != 2) {
                cryptbig.help();
                System.exit(-1);
            }
            System.out.println(Base64Order.standardCoder.decodeString(s[1]));
            System.exit(0);
        }
        if (s[0].equals("-ess")) {
            if (s.length != 3) {
                cryptbig.help();
                System.exit(-1);
            }
            long t = System.currentTimeMillis();
            System.out.println(cryptbig.scrambleString(s[1], s[2]));
            System.out.println("Calculation time: " + (System.currentTimeMillis() - t) + " milliseconds");
            System.exit(0);
        }
        if (s[0].equals("-dss")) {
            if (s.length != 3) {
                cryptbig.help();
                System.exit(-1);
            }
            long t = System.currentTimeMillis();
            System.out.println(cryptbig.descrambleString(s[1], s[2]));
            System.out.println("Calculation time: " + (System.currentTimeMillis() - t) + " milliseconds");
            System.exit(0);
        }
        if (s[0].equals("-e")) {
            if (s.length != 3) {
                cryptbig.help();
                System.exit(-1);
            }
            System.out.println(new cryptbig(s[1]).encryptString(s[2]));
            System.exit(0);
        }
        if (s[0].equals("-d")) {
            if (s.length != 3) {
                cryptbig.help();
                System.exit(-1);
            }
            System.out.println(new cryptbig(s[1]).decryptString(s[2]));
            System.exit(0);
        }
        if (s[0].equals("-md5")) {
            if (s.length != 2) {
                cryptbig.help();
                System.exit(-1);
            }
            String md5s = "";
            try {
                md5s = Digest.encodeMD5Hex(new File(s[1]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println(md5s);
            System.exit(0);
        }
        if (s[0].equals("-enc")) {
            if (s.length < 3 || s.length > 4) {
                cryptbig.help();
                System.exit(-1);
            }
            target = s.length == 3 ? s[2] + ".crypt" : s[3];
            new cryptbig(s[1]).encryptFile(s[2], (String)target);
            System.exit(0);
        }
        if (s[0].equals("-dec")) {
            if (s.length < 3 || s.length > 4) {
                cryptbig.help();
                System.exit(-1);
            }
            target = s.length == 3 ? (s[2].endsWith(".crypt") ? s[2].substring(0, s[2].length() - 7) : s[2] + ".decoded") : s[3];
            new cryptbig(s[1]).decryptFile(s[2], (String)target);
            System.exit(0);
        }
        cryptbig.help();
        System.exit(-1);
    }
}

