/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ListDirs {
    private boolean isJar = false;
    private File FileObject = null;
    private JarFile JarFileObject = null;
    private final String uri;
    private String pathInJar;

    public ListDirs(String uri) throws IOException, URISyntaxException {
        this.uri = uri;
        if (uri.startsWith("jar:")) {
            this.isJar = true;
            this.JarFileObject = new JarFile(uri.substring(9, uri.indexOf(33)));
            this.pathInJar = uri.substring(uri.indexOf(33) + 2);
        } else {
            this.FileObject = new File(new URI(uri));
        }
    }

    public ArrayList<String> listFiles(String regex) {
        ArrayList<String> files = this.getAllFiles();
        ArrayList<String> classes = new ArrayList<String>();
        for (String file : files) {
            if (!file.matches(regex)) continue;
            classes.add(file);
        }
        return classes;
    }

    private ArrayList<String> getAllFiles() {
        ArrayList<String> files = new ArrayList<String>(50);
        if (this.isJar) {
            Enumeration<JarEntry> entries2 = this.JarFileObject.entries();
            while (entries2.hasMoreElements()) {
                JarEntry entry2 = entries2.nextElement();
                String entryname = entry2.getName();
                if (!entryname.startsWith(this.pathInJar) || entryname.charAt(entryname.length() - 1) == '/') continue;
                files.add(entryname);
            }
        } else {
            for (File file : this.getFilesRecursive(this.FileObject)) {
                files.add(file.toString());
            }
        }
        return files;
    }

    private ArrayList<File> getFilesRecursive(File start) {
        File[] fileList = start.listFiles();
        ArrayList<File> completeList = new ArrayList<File>();
        for (File file : fileList) {
            if (file.isDirectory()) {
                completeList.addAll(this.getFilesRecursive(file));
                continue;
            }
            completeList.add(file);
        }
        return completeList;
    }

    public String toString() {
        return this.uri;
    }
}

