/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ConcurrentLog;

public class Gzip {
    private static final ConcurrentLog logger = new ConcurrentLog("GZIP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gzipFile(String inFile, String outFile) {
        InputStream fin = null;
        OutputStream fout = null;
        try {
            fin = new BufferedInputStream(new FileInputStream(inFile));
            fout = new GZIPOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), 65536){
                {
                    this.def.setLevel(9);
                }
            };
            Gzip.copy(fout, fin, 1024);
        }
        catch (FileNotFoundException e) {
            logger.warn("ERROR: file '" + inFile + "' not found", e);
        }
        catch (IOException e) {
            logger.warn("ERROR: IO trouble ", e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.warn("ERROR: Could not close file " + inFile);
                }
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    logger.warn("ERROR: Could not close file " + outFile);
                }
            }
        }
    }

    public static File gunzipFile(File in) {
        assert (in.getName().endsWith(".gz"));
        String on = in.getName().substring(0, in.getName().length() - 3);
        File outf = new File(in.getParent(), on);
        Gzip.gunzipFile(in, outf);
        return outf;
    }

    public static void gunzipFile(File inFile, File outFile) {
        try (FileInputStream fileInStream = new FileInputStream(inFile);
             GZIPInputStream fin = new GZIPInputStream(new BufferedInputStream(fileInStream));
             FileOutputStream fileOutStream = new FileOutputStream(outFile);
             BufferedOutputStream fout = new BufferedOutputStream(fileOutStream);){
            Gzip.copy(fout, fin, 1024);
        }
        catch (FileNotFoundException e) {
            logger.warn("ERROR: file '" + inFile + "' not found", e);
        }
        catch (IOException e) {
            logger.warn("ERROR: IO trouble ", e);
        }
    }

    public static byte[] gzipString(String in) {
        return Gzip.gzip(UTF8.getBytes(in));
    }

    public static String gunzipString(byte[] in) {
        return UTF8.String(Gzip.gunzip(in));
    }

    public static byte[] gzip(byte[] b) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(b.length);
            GZIPOutputStream out = new GZIPOutputStream((OutputStream)baos, Math.min(65536, b.length)){
                {
                    this.def.setLevel(9);
                }
            };
            out.write(b, 0, b.length);
            out.finish();
            out.close();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] gunzip(byte[] b) {
        byte[] buffer = new byte[Math.min(22, b.length)];
        try {
            int l;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(b.length * 2);
            GZIPInputStream in = new GZIPInputStream((InputStream)new ByteArrayInputStream(b), Math.min(65536, b.length));
            while ((l = in.read(buffer)) > 0) {
                baos.write(buffer, 0, l);
            }
            in.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void copy(OutputStream out, InputStream in, int bufferSize) throws IOException {
        int n;
        BufferedInputStream bIn = new BufferedInputStream(in, bufferSize);
        BufferedOutputStream bOut = new BufferedOutputStream(out, bufferSize);
        byte[] buf = new byte[bufferSize];
        while ((n = ((InputStream)bIn).read(buf)) > 0) {
            ((OutputStream)bOut).write(buf, 0, n);
        }
        ((InputStream)bIn).close();
        ((OutputStream)bOut).close();
    }

    public static void saveGzip(File f, byte[] content) throws IOException {
        f.getParentFile().mkdirs();
        try (FileOutputStream fileOutStream = new FileOutputStream(f);
             GZIPOutputStream gzipout = new GZIPOutputStream((OutputStream)fileOutStream, 65536){
            {
                this.def.setLevel(9);
            }
        };){
            gzipout.write(content, 0, content.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadGzip(File f) throws IOException {
        GZIPInputStream gzipin = null;
        try {
            byte[] b;
            int last;
            gzipin = new GZIPInputStream(new FileInputStream(f));
            byte[] result = new byte[1024];
            byte[] buffer = new byte[512];
            int len = 0;
            while ((last = gzipin.read(buffer, 0, buffer.length)) > 0) {
                while (result.length - len < last) {
                    b = new byte[result.length * 2];
                    System.arraycopy(result, 0, b, 0, len);
                    result = b;
                    b = null;
                }
                System.arraycopy(buffer, 0, result, len, last);
                len += last;
            }
            gzipin.close();
            b = new byte[len];
            System.arraycopy(result, 0, b, 0, len);
            byte[] byArray = b;
            return byArray;
        }
        finally {
            if (gzipin != null) {
                try {
                    gzipin.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void help() {
        System.out.println("AnomicGzip (2004) by Michael Christen");
        System.out.println("usage: gzip [-u] <file> [<target-file>]");
    }

    public static void main(String[] s) {
        Object target;
        if (s.length == 0) {
            Gzip.help();
            System.exit(0);
        }
        if (s[0].equals("-h") || s[0].equals("-help")) {
            Gzip.help();
            System.exit(0);
        }
        if (s[0].equals("-u")) {
            if (s.length < 2 || s.length > 3) {
                Gzip.help();
                System.exit(-1);
            }
            target = s.length == 2 ? (s[1].endsWith(".gz") ? s[1].substring(0, s[1].length() - 3) : s[1] + ".gunzip") : s[2];
            Gzip.gunzipFile(new File(s[1]), new File((String)target));
            System.exit(0);
        }
        if (s.length < 1 || s.length > 2) {
            Gzip.help();
            System.exit(-1);
        }
        target = s.length == 1 ? s[0] + ".gz" : s[1];
        Gzip.gzipFile(s[0], (String)target);
        System.exit(0);
    }
}

