/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.ranking;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.sorting.ConcurrentScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.LargeNumberCache;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceVars;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.search.ranking.RankingProfile;

public class ReferenceOrder {
    private static int cores = Runtime.getRuntime().availableProcessors();
    private int maxdomcount;
    private WordReferenceVars min = null;
    private WordReferenceVars max = null;
    private final ConcurrentScoreMap<String> doms;
    private final RankingProfile ranking;
    private final String language;

    public ReferenceOrder(RankingProfile profile2, String language) {
        this.ranking = profile2;
        this.doms = new ConcurrentScoreMap();
        this.maxdomcount = 0;
        this.language = language;
    }

    public BlockingQueue<WordReferenceVars> normalizeWith(ReferenceContainer<WordReference> container, long maxtime, boolean local) {
        LinkedBlockingQueue<WordReferenceVars> out = new LinkedBlockingQueue<WordReferenceVars>();
        int threads = cores;
        if (container.size() < 100) {
            threads = 2;
        }
        NormalizeDistributor distributor = new NormalizeDistributor(container, out, threads, maxtime, local);
        distributor.start();
        return out;
    }

    public int authority(String hostHash) {
        assert (hostHash.length() == 6);
        return (this.doms.get(hostHash) << 8) / (1 + this.maxdomcount);
    }

    public long cardinal(WordReference t) {
        assert (this.min != null);
        assert (this.max != null);
        assert (t != null);
        assert (this.ranking != null);
        Bitfield flags = t.flags();
        long tf = this.max.termFrequency() == this.min.termFrequency() ? 0 : (int)((t.termFrequency() - this.min.termFrequency()) * 256.0 / (this.max.termFrequency() - this.min.termFrequency())) << this.ranking.coeff_termfrequency;
        long r = (long)((256 - DigestURL.domLengthNormalized(t.urlhash()) << this.ranking.coeff_domlength) + (this.max.urlcomps() == this.min.urlcomps() ? 0 : 256 - (t.urlcomps() - this.min.urlcomps() << 8) / (this.max.urlcomps() - this.min.urlcomps()) << this.ranking.coeff_urlcomps) + (this.max.urllength() == this.min.urllength() ? 0 : 256 - (t.urllength() - this.min.urllength() << 8) / (this.max.urllength() - this.min.urllength()) << this.ranking.coeff_urllength) + (this.max.posintext() == this.min.posintext() ? 0 : 256 - (t.posintext() - this.min.posintext() << 8) / (this.max.posintext() - this.min.posintext()) << this.ranking.coeff_posintext) + (this.max.posofphrase() == this.min.posofphrase() ? 0 : 256 - (t.posofphrase() - this.min.posofphrase() << 8) / (this.max.posofphrase() - this.min.posofphrase()) << this.ranking.coeff_posofphrase) + (this.max.posinphrase() == this.min.posinphrase() ? 0 : 256 - (t.posinphrase() - this.min.posinphrase() << 8) / (this.max.posinphrase() - this.min.posinphrase()) << this.ranking.coeff_posinphrase) + (this.max.distance() == this.min.distance() ? 0 : 256 - (t.distance() - this.min.distance() << 8) / (this.max.distance() - this.min.distance()) << this.ranking.coeff_worddistance) + (this.max.virtualAge() == this.min.virtualAge() ? 0 : (t.virtualAge() - this.min.virtualAge() << 8) / (this.max.virtualAge() - this.min.virtualAge()) << this.ranking.coeff_date) + (this.max.wordsintitle() == this.min.wordsintitle() ? 0 : (t.wordsintitle() - this.min.wordsintitle() << 8) / (this.max.wordsintitle() - this.min.wordsintitle()) << this.ranking.coeff_wordsintitle) + (this.max.wordsintext() == this.min.wordsintext() ? 0 : (t.wordsintext() - this.min.wordsintext() << 8) / (this.max.wordsintext() - this.min.wordsintext()) << this.ranking.coeff_wordsintext) + (this.max.phrasesintext() == this.min.phrasesintext() ? 0 : (t.phrasesintext() - this.min.phrasesintext() << 8) / (this.max.phrasesintext() - this.min.phrasesintext()) << this.ranking.coeff_phrasesintext) + (this.max.llocal() == this.min.llocal() ? 0 : (t.llocal() - this.min.llocal() << 8) / (this.max.llocal() - this.min.llocal()) << this.ranking.coeff_llocal) + (this.max.lother() == this.min.lother() ? 0 : (t.lother() - this.min.lother() << 8) / (this.max.lother() - this.min.lother()) << this.ranking.coeff_lother) + (this.max.hitcount() == this.min.hitcount() ? 0 : (t.hitcount() - this.min.hitcount() << 8) / (this.max.hitcount() - this.min.hitcount()) << this.ranking.coeff_hitcount)) + tf + (long)(this.ranking.coeff_authority > 12 ? this.authority(t.hosthash()) << this.ranking.coeff_authority : 0) + (long)(flags.get(28) ? 255 << this.ranking.coeff_appurl : 0) + (long)(flags.get(25) ? 255 << this.ranking.coeff_app_dc_title : 0) + (long)(flags.get(26) ? 255 << this.ranking.coeff_app_dc_creator : 0) + (long)(flags.get(27) ? 255 << this.ranking.coeff_app_dc_subject : 0) + (long)(flags.get(24) ? 255 << this.ranking.coeff_app_dc_description : 0) + (long)(flags.get(29) ? 255 << this.ranking.coeff_appemph : 0) + (long)(flags.get(0) ? 255 << this.ranking.coeff_catindexof : 0) + (long)(flags.get(20) ? 255 << this.ranking.coeff_cathasimage : 0) + (long)(flags.get(21) ? 255 << this.ranking.coeff_cathasaudio : 0) + (long)(flags.get(22) ? 255 << this.ranking.coeff_cathasvideo : 0) + (long)(flags.get(23) ? 255 << this.ranking.coeff_cathasapp : 0) + (long)(Arrays.equals(t.getLanguage(), ASCII.getBytes(this.language)) ? 255 << this.ranking.coeff_language : 0);
        return r;
    }

    public long cardinal(URIMetadataNode t) {
        assert (t != null);
        assert (this.ranking != null);
        Bitfield flags = t.flags();
        long r = (256 - DigestURL.domLengthNormalized(t.hash()) << this.ranking.coeff_domlength) + (t.virtualAge() << this.ranking.coeff_date) + (t.wordsintitle() << this.ranking.coeff_wordsintitle) + (t.wordCount() << this.ranking.coeff_wordsintext) + (t.llocal() << this.ranking.coeff_llocal) + (t.lother() << this.ranking.coeff_lother) + (this.ranking.coeff_authority > 12 ? this.authority(t.hosthash()) << this.ranking.coeff_authority : 0) + (flags.get(28) ? 255 << this.ranking.coeff_appurl : 0) + (flags.get(25) ? 255 << this.ranking.coeff_app_dc_title : 0) + (flags.get(26) ? 255 << this.ranking.coeff_app_dc_creator : 0) + (flags.get(27) ? 255 << this.ranking.coeff_app_dc_subject : 0) + (flags.get(24) ? 255 << this.ranking.coeff_app_dc_description : 0) + (flags.get(29) ? 255 << this.ranking.coeff_appemph : 0) + (flags.get(0) ? 255 << this.ranking.coeff_catindexof : 0) + (flags.get(20) ? 255 << this.ranking.coeff_cathasimage : 0) + (flags.get(21) ? 255 << this.ranking.coeff_cathasaudio : 0) + (flags.get(22) ? 255 << this.ranking.coeff_cathasvideo : 0) + (flags.get(23) ? 255 << this.ranking.coeff_cathasapp : 0) + (this.language.equals(t.language()) ? 255 << this.ranking.coeff_language : 0);
        return r;
    }

    private final class NormalizeDistributor
    extends Thread {
        ReferenceContainer<WordReference> container;
        LinkedBlockingQueue<WordReferenceVars> out;
        private final int threads;
        private final long maxtime;
        private final boolean local;

        public NormalizeDistributor(ReferenceContainer<WordReference> container, LinkedBlockingQueue<WordReferenceVars> out, int threads, long maxtime, boolean local) {
            super("ReferenceOrder.NormalizeDistributor");
            this.container = container;
            this.out = out;
            this.threads = threads;
            this.maxtime = maxtime;
            this.local = local;
        }

        @Override
        public void run() {
            int i;
            BlockingQueue<WordReferenceVars> vars = WordReferenceVars.transform(this.container, this.maxtime, this.local);
            Semaphore termination = new Semaphore(this.threads);
            NormalizeWorker[] worker = new NormalizeWorker[this.threads];
            for (int i2 = 0; i2 < this.threads; ++i2) {
                worker[i2] = new NormalizeWorker(this.out, termination, this.maxtime);
                worker[i2].start();
            }
            int p = 0;
            long timeout = this.maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + this.maxtime;
            try {
                WordReferenceVars iEntry;
                while ((iEntry = vars.take()) != WordReferenceVars.poison) {
                    worker[p % this.threads].add(iEntry);
                    ++p;
                    if (System.currentTimeMillis() <= timeout) continue;
                    ConcurrentLog.warn("NormalizeDistributor", "adding of decoded rows to workers ended with timeout = " + this.maxtime);
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (i = 0; i < this.threads; ++i) {
                worker[i].add(WordReferenceVars.poison);
            }
            for (i = 0; i < this.threads; ++i) {
                try {
                    worker[i].join(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class NormalizeWorker
    extends Thread {
        private final BlockingQueue<WordReferenceVars> out;
        private final Semaphore termination;
        private final BlockingQueue<WordReferenceVars> decodedEntries;
        private final long maxtime;

        public NormalizeWorker(BlockingQueue<WordReferenceVars> out, Semaphore termination, long maxtime) {
            super("ReferenceOrder.NormalizeWorker");
            this.out = out;
            this.termination = termination;
            this.decodedEntries = new LinkedBlockingQueue<WordReferenceVars>();
            this.maxtime = maxtime;
        }

        public void add(WordReferenceVars entry2) {
            try {
                this.decodedEntries.put(entry2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WordReferenceVars iEntry;
                long timeout;
                HashMap<String, Integer> doms0 = new HashMap<String, Integer>();
                Integer int1 = 1;
                long l = timeout = this.maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + this.maxtime;
                while ((iEntry = this.decodedEntries.take()) != WordReferenceVars.poison) {
                    if (ReferenceOrder.this.min == null) {
                        ReferenceOrder.this.min = iEntry.clone();
                    } else {
                        ReferenceOrder.this.min.min(iEntry);
                    }
                    if (ReferenceOrder.this.max == null) {
                        ReferenceOrder.this.max = iEntry.clone();
                    } else {
                        ReferenceOrder.this.max.max(iEntry);
                    }
                    this.out.put(iEntry);
                    String dom = iEntry.hosthash();
                    Integer count = (Integer)doms0.get(dom);
                    if (count == null) {
                        doms0.put(dom, int1);
                    } else {
                        doms0.put(dom, LargeNumberCache.valueOf(count + 1));
                    }
                    if (System.currentTimeMillis() <= timeout) continue;
                    ConcurrentLog.warn("NormalizeWorker", "normlization of decoded rows ended with timeout = " + this.maxtime);
                    break;
                }
                for (Map.Entry entry2 : doms0.entrySet()) {
                    ReferenceOrder.this.doms.inc((String)entry2.getKey(), (Integer)entry2.getValue());
                }
                if (!ReferenceOrder.this.doms.isEmpty()) {
                    ReferenceOrder.this.maxdomcount = ReferenceOrder.this.doms.getMaxScore();
                }
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            finally {
                try {
                    this.termination.acquire();
                    if (this.termination.availablePermits() == 0) {
                        this.out.put(WordReferenceVars.poison);
                    }
                }
                catch (InterruptedException e) {}
            }
        }
    }
}

