/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.index;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.connector.AbstractSolrConnector;
import net.yacy.cora.federate.solr.connector.EmbeddedSolrConnector;
import net.yacy.cora.federate.solr.connector.RemoteSolrConnector;
import net.yacy.cora.federate.solr.connector.ShardSelection;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.federate.solr.instance.EmbeddedInstance;
import net.yacy.cora.federate.solr.instance.InstanceMirror;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.federate.solr.instance.ShardInstance;
import net.yacy.cora.federate.solr.responsewriter.EnhancedXMLResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.FlatJSONResponseWriter;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.sorting.WeakPriorityBlockingQueue;
import net.yacy.cora.storage.ZIPReader;
import net.yacy.cora.storage.ZIPWriter;
import net.yacy.cora.util.CRIgnoreWriter;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.data.word.WordReferenceVars;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.schema.WebgraphConfiguration;
import net.yacy.search.schema.WebgraphSchema;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrConfig;

public final class Fulltext {
    private static final String SOLR_PATH = "solr_8_11_2";
    private static final String[] SOLR_OLD_PATH = new String[]{"solr_36", "solr_40", "solr_44", "solr_45", "solr_46", "solr_47", "solr_4_9", "solr_4_10", "solr_5_2", "solr_5_5", "solr_6_6", "solr_8_8_1"};
    private final File segmentPath;
    private final File archivePath;
    private Export exportthread;
    private InstanceMirror solrInstances;
    private final ReentrantLock solrInstancesLock;
    private final CollectionConfiguration collectionConfiguration;
    private final WebgraphConfiguration webgraphConfiguration;
    private boolean writeWebgraph;
    private long collectionSizeLastAccess = 0L;
    private long collectionSizeLastValue = 0L;
    private long lastCommit = 0L;
    public static final String yacy_dump_prefix = "yacy_dump_";
    private static final Set<String> minified_keys = new HashSet<String>();

    protected Fulltext(File segmentPath, File archivePath, CollectionConfiguration collectionConfiguration, WebgraphConfiguration webgraphConfiguration) {
        this.segmentPath = segmentPath;
        this.archivePath = archivePath;
        this.exportthread = null;
        this.solrInstances = new InstanceMirror();
        this.solrInstancesLock = new ReentrantLock();
        this.collectionConfiguration = collectionConfiguration;
        this.webgraphConfiguration = webgraphConfiguration;
        this.writeWebgraph = false;
    }

    public void setUseWebgraph(boolean check) {
        this.writeWebgraph = check;
    }

    public boolean useWebgraph() {
        return this.writeWebgraph;
    }

    public CollectionConfiguration getDefaultConfiguration() {
        return this.collectionConfiguration;
    }

    public WebgraphConfiguration getWebgraphConfiguration() {
        return this.webgraphConfiguration;
    }

    public boolean connectedLocalSolr() {
        return this.solrInstances.isConnectedEmbedded();
    }

    public void connectLocalSolr() throws IOException {
        File solrLocation = new File(this.segmentPath, SOLR_PATH);
        for (String oldVersion : SOLR_OLD_PATH) {
            File oldLocation = new File(this.segmentPath, oldVersion);
            if (!oldLocation.exists() || oldLocation.renameTo(solrLocation)) continue;
            ConcurrentLog.severe("Fulltext", "Failed renaming old Solr location (" + oldLocation.getAbsolutePath() + ") to new location : " + solrLocation.getAbsolutePath());
        }
        EmbeddedInstance localCollectionInstance = new EmbeddedInstance(new File(new File(Switchboard.getSwitchboard().appPath, "defaults"), "solr"), solrLocation, "collection1", new String[]{"collection1", "webgraph"});
        SolrConfig config = localCollectionInstance.getDefaultCore().getSolrConfig();
        Version luceneVersion = config.luceneMatchVersion;
        String lvn = luceneVersion.major + "_" + luceneVersion.minor + "_" + luceneVersion.bugfix;
        assert (SOLR_PATH.endsWith(lvn)) : "luceneVersion = " + lvn + ", solrPath = solr_8_11_2, check defaults/solr/solrconfig.xml";
        ConcurrentLog.info("Fulltext", "using lucene version " + lvn);
        ConcurrentLog.info("Fulltext", "connected solr in " + solrLocation.toString() + ", lucene version " + lvn);
        this.solrInstances.connectEmbedded(localCollectionInstance);
    }

    public void disconnectLocalSolr() {
        this.solrInstances.disconnectEmbedded();
    }

    public boolean connectedRemoteSolr() {
        return this.solrInstances.isConnectedRemote();
    }

    public void connectRemoteSolr(ArrayList<RemoteInstance> instances, ShardSelection.Method shardMethod, boolean writeEnabled) {
        this.solrInstances.connectRemote(new ShardInstance(instances, shardMethod, writeEnabled));
    }

    public void disconnectRemoteSolr() {
        this.solrInstances.disconnectRemote();
    }

    public EmbeddedSolrConnector getDefaultEmbeddedConnector() {
        return this.solrInstances.getDefaultEmbeddedConnector();
    }

    public EmbeddedSolrConnector getEmbeddedConnector(String corename) {
        return this.solrInstances.getEmbeddedConnector(corename);
    }

    public SolrConnector getConnectorForRead(String corename) {
        if (this.solrInstances.isConnectedRemote()) {
            return this.solrInstances.getRemoteConnector(corename);
        }
        if (this.solrInstances.isConnectedEmbedded()) {
            return this.solrInstances.getEmbeddedConnector(corename);
        }
        return null;
    }

    public RemoteSolrConnector getDefaultRemoteSolrConnector() {
        try {
            boolean useBinaryResponseWriter = true;
            if (Switchboard.getSwitchboard() != null) {
                useBinaryResponseWriter = Switchboard.getSwitchboard().getConfigBool("remote.solr.binaryResponse.enabled", true);
            }
            return this.solrInstances.getDefaultRemoteConnector(useBinaryResponseWriter);
        }
        catch (IOException e) {
            return null;
        }
    }

    public EmbeddedInstance getEmbeddedInstance() {
        this.solrInstancesLock.lock();
        try {
            if (this.solrInstances.isConnectedEmbedded()) {
                EmbeddedInstance embeddedInstance = this.solrInstances.getEmbedded();
                return embeddedInstance;
            }
            EmbeddedInstance embeddedInstance = null;
            return embeddedInstance;
        }
        finally {
            this.solrInstancesLock.unlock();
        }
    }

    public SolrConnector getDefaultConnector() {
        this.solrInstancesLock.lock();
        try {
            SolrConnector solrConnector = this.solrInstances.getDefaultMirrorConnector();
            return solrConnector;
        }
        finally {
            this.solrInstancesLock.unlock();
        }
    }

    public SolrConnector getWebgraphConnector() {
        if (!this.writeWebgraph) {
            return null;
        }
        this.solrInstancesLock.lock();
        try {
            SolrConnector solrConnector = this.solrInstances.getGenericMirrorConnector("webgraph");
            return solrConnector;
        }
        finally {
            this.solrInstancesLock.unlock();
        }
    }

    public int bufferSize() {
        return this.solrInstances.bufferSize();
    }

    public void clearCaches() {
        this.solrInstances.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLocalSolr() throws IOException {
        if (this.exportthread != null) {
            this.exportthread.interrupt();
        }
        this.solrInstancesLock.lock();
        try {
            EmbeddedInstance instance = this.solrInstances.getEmbedded();
            if (instance != null) {
                for (String name : instance.getCoreNames()) {
                    this.solrInstances.getEmbeddedConnector(name).clear();
                }
                this.commit(false);
            }
            this.solrInstances.clearCaches();
        }
        finally {
            this.solrInstancesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRemoteSolr() throws IOException {
        this.solrInstancesLock.lock();
        try {
            ShardInstance instance = this.solrInstances.getRemote();
            if (instance != null) {
                for (String name : instance.getCoreNames()) {
                    this.solrInstances.getRemoteConnector(name).clear();
                }
            }
            this.solrInstances.clearCaches();
        }
        finally {
            this.solrInstancesLock.unlock();
        }
    }

    public long collectionSize() {
        long t = System.currentTimeMillis();
        if (t - this.collectionSizeLastAccess < 1000L) {
            return this.collectionSizeLastValue;
        }
        SolrConnector sc = this.getDefaultConnector();
        if (sc == null) {
            return 0L;
        }
        long size = sc.getSize();
        this.collectionSizeLastAccess = t;
        this.collectionSizeLastValue = size;
        return size;
    }

    public long webgraphSize() {
        return this.writeWebgraph ? this.getWebgraphConnector().getSize() : 0L;
    }

    public void close() {
        try {
            this.solrInstances.close();
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
        }
    }

    public void commit(boolean softCommit) {
        long t = System.currentTimeMillis();
        if (this.lastCommit + 10000L > t) {
            return;
        }
        this.lastCommit = t;
        this.getDefaultConnector().commit(softCommit);
        if (this.writeWebgraph) {
            this.getWebgraphConnector().commit(softCommit);
        }
    }

    public URIMetadataNode getMetadata(WeakPriorityBlockingQueue.Element<WordReferenceVars> element) {
        if (element == null) {
            return null;
        }
        WordReferenceVars wre = element.getElement();
        if (wre == null) {
            return null;
        }
        long score = element.getWeight();
        URIMetadataNode node = this.getMetadata(wre.urlhash(), wre, score);
        return node;
    }

    public URIMetadataNode getMetadata(byte[] urlHash) {
        if (urlHash == null) {
            return null;
        }
        return this.getMetadata(urlHash, null, 0L);
    }

    private URIMetadataNode getMetadata(byte[] urlHash, WordReferenceVars wre, long score) {
        String u = ASCII.String(urlHash);
        try {
            SolrDocument doc = this.getDefaultConnector().getDocumentById(u, new String[0]);
            if (doc != null) {
                return new URIMetadataNode(doc, wre, score);
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return null;
    }

    public void putDocument(SolrInputDocument doc) throws IOException {
        SolrConnector connector = this.getDefaultConnector();
        if (connector == null || connector.isClosed()) {
            return;
        }
        String id = (String)doc.getFieldValue(CollectionSchema.id.getSolrFieldName());
        String url = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
        assert (url != null && url.length() < 30000);
        ConcurrentLog.info("Fulltext", "indexing: " + id + " " + url);
        try {
            connector.add(doc);
        }
        catch (SolrException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (MemoryControl.shortStatus()) {
            this.clearCaches();
        }
    }

    public void putEdges(Collection<SolrInputDocument> edges) throws IOException {
        if (!this.useWebgraph()) {
            return;
        }
        if (edges == null || edges.size() == 0) {
            return;
        }
        try {
            this.getWebgraphConnector().add(edges);
        }
        catch (SolrException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (MemoryControl.shortStatus()) {
            this.clearCaches();
        }
    }

    public void putMetadata(URIMetadataNode entry2) throws IOException {
        byte[] idb = entry2.hash();
        String id = ASCII.String(idb);
        try {
            SolrDocument doc = this.getDefaultConnector().getDocumentById(id, CollectionSchema.collection_sxt.getSolrFieldName());
            if (doc == null || !doc.containsKey((Object)CollectionSchema.collection_sxt.getSolrFieldName())) {
                this.putDocument(this.getDefaultConfiguration().metadata2solr(entry2));
            } else {
                Collection collections = doc.getFieldValues(CollectionSchema.collection_sxt.getSolrFieldName());
                if (!collections.contains("dht")) {
                    return;
                }
                this.putDocument(this.getDefaultConfiguration().metadata2solr(entry2));
            }
        }
        catch (SolrException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (MemoryControl.shortStatus()) {
            this.clearCaches();
        }
    }

    public void deleteStaleDomainHashes(Set<String> hosthashes, Date freshdate) {
        Date now = new Date();
        Fulltext.deleteDomainWithConstraint(this.getDefaultConnector(), CollectionSchema.host_id_s.getSolrFieldName(), hosthashes, freshdate == null || freshdate.after(now) ? null : CollectionSchema.load_date_dt.getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(freshdate) + "]");
        if (this.writeWebgraph) {
            Fulltext.deleteDomainWithConstraint(this.getWebgraphConnector(), WebgraphSchema.source_host_id_s.getSolrFieldName(), hosthashes, freshdate == null || freshdate.after(now) ? null : WebgraphSchema.load_date_dt.getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(freshdate) + "]");
        }
    }

    public void deleteStaleDomainNames(Set<String> hostnames, Date freshdate) {
        Date now = new Date();
        Fulltext.deleteDomainWithConstraint(this.getDefaultConnector(), CollectionSchema.host_s.getSolrFieldName(), hostnames, freshdate == null || freshdate.after(now) ? null : CollectionSchema.load_date_dt.getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(freshdate) + "]");
        if (this.writeWebgraph) {
            Fulltext.deleteDomainWithConstraint(this.getWebgraphConnector(), WebgraphSchema.source_host_s.getSolrFieldName(), hostnames, freshdate == null || freshdate.after(now) ? null : WebgraphSchema.load_date_dt.getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(freshdate) + "]");
        }
    }

    public void deleteDomainErrors(Set<String> hosthashes) {
        Fulltext.deleteDomainWithConstraint(this.getDefaultConnector(), CollectionSchema.host_id_s.getSolrFieldName(), hosthashes, CollectionSchema.failreason_s.getSolrFieldName() + ":[* TO *]");
    }

    private static void deleteDomainWithConstraint(SolrConnector connector, String fieldname, Set<String> hosthashes, String constraintQuery) {
        if (hosthashes == null || hosthashes.size() == 0) {
            return;
        }
        int subsetscount = 1 + hosthashes.size() / 255;
        int c = 0;
        List[] subsets = (List[])Array.newInstance(ArrayList.class, subsetscount);
        for (int i = 0; i < subsetscount; ++i) {
            subsets[i] = new ArrayList();
        }
        for (String hosthash : hosthashes) {
            subsets[c++ % subsetscount].add(hosthash);
        }
        for (List subset : subsets) {
            try {
                StringBuilder query2 = new StringBuilder();
                for (String hosthash : subset) {
                    if (query2.length() > 0) {
                        query2.append(" OR ");
                    }
                    query2.append("({!cache=false raw f=").append(fieldname).append('}').append(hosthash).append(")");
                }
                if (constraintQuery == null) {
                    connector.deleteByQuery(query2.toString());
                    continue;
                }
                connector.deleteByQuery("(" + query2.toString() + ") AND " + constraintQuery);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void deleteOldDocuments(long deltaToNow, boolean loaddate) {
        Date deleteageDate = new Date(System.currentTimeMillis() - deltaToNow);
        String collection1Query = (loaddate ? CollectionSchema.load_date_dt : CollectionSchema.last_modified).getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(deleteageDate) + "]";
        String webgraphQuery = (loaddate ? WebgraphSchema.load_date_dt : WebgraphSchema.last_modified).getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(deleteageDate) + "]";
        try {
            this.getDefaultConnector().deleteByQuery(collection1Query);
            if (this.getWebgraphConnector() != null) {
                this.getWebgraphConnector().deleteByQuery(webgraphQuery);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int remove(String basepath, Date freshdate) {
        DigestURL uri;
        try {
            uri = new DigestURL(basepath);
        }
        catch (MalformedURLException e) {
            return 0;
        }
        String host = uri.getHost();
        String collectionQuery = CollectionSchema.host_s.getSolrFieldName() + ":\"" + host + "\"" + (String)(freshdate != null && freshdate.before(new Date()) ? " AND " + CollectionSchema.load_date_dt.getSolrFieldName() + ":[* TO " + ISO8601Formatter.FORMATTER.format(freshdate) + "]" : "");
        AtomicInteger count = new AtomicInteger(0);
        BlockingQueue<SolrDocument> docs = this.getDefaultConnector().concurrentDocumentsByQuery(collectionQuery, null, 0, 1000000, Long.MAX_VALUE, 100, 1, false, CollectionSchema.id.getSolrFieldName(), CollectionSchema.sku.getSolrFieldName());
        try {
            SolrDocument doc;
            HashSet<String> deleteIDs = new HashSet<String>();
            while ((doc = docs.take()) != AbstractSolrConnector.POISON_DOCUMENT) {
                String u = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                if (!u.startsWith(basepath)) continue;
                deleteIDs.add((String)doc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                count.incrementAndGet();
            }
            this.remove(deleteIDs);
            if (count.get() > 0) {
                this.commit(true);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return count.get();
    }

    public void remove(Collection<String> deleteIDs) {
        if (deleteIDs == null || deleteIDs.size() == 0) {
            return;
        }
        try {
            this.getDefaultConnector().deleteByIds(deleteIDs);
            if (this.writeWebgraph) {
                for (String id : deleteIDs) {
                    this.getWebgraphConnector().deleteByQuery(WebgraphSchema.source_id_s.name() + ":\"" + id + "\"");
                }
            }
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
        }
    }

    public boolean remove(byte[] urlHash) {
        if (urlHash == null) {
            return false;
        }
        try {
            String id = ASCII.String(urlHash);
            this.getDefaultConnector().deleteById(id);
            if (this.writeWebgraph) {
                this.getWebgraphConnector().deleteByQuery(WebgraphSchema.source_id_s + ":\"" + id + "\"");
            }
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
        }
        return false;
    }

    public String getURL(String urlHash) throws IOException {
        if (urlHash == null || this.getDefaultConnector() == null) {
            return null;
        }
        return this.getDefaultConnector().getURL(urlHash);
    }

    public boolean exists(String id) {
        return this.getDefaultConnector().exists(id);
    }

    public List<File> dumpFiles() {
        EmbeddedInstance esc = this.solrInstances.getEmbedded();
        ArrayList<File> zips = new ArrayList<File>();
        if (esc == null) {
            ConcurrentLog.warn("Fulltext", "HOT DUMP selected solr0 == NULL, no dump list!");
            return zips;
        }
        if (esc.getContainerPath() == null) {
            ConcurrentLog.warn("Fulltext", "HOT DUMP selected solr0.getStoragePath() == NULL, no dump list!");
            return zips;
        }
        if (this.archivePath == null) {
            ConcurrentLog.warn("Fulltext", "HOT DUMP selected esc.getStoragePath().getParentFile() == NULL, no dump list!");
            return zips;
        }
        ConcurrentLog.info("Fulltext", "HOT DUMP dump path = " + this.archivePath.toString());
        for (String p : this.archivePath.list()) {
            if (!p.endsWith("zip")) continue;
            zips.add(new File(this.archivePath, p));
        }
        return zips;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File dumpEmbeddedSolr() throws SolrException {
        EmbeddedInstance esc = this.solrInstances.getEmbedded();
        if (esc == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No embedded Solr available.");
        }
        File storagePath = esc.getContainerPath();
        File zipOut = new File(this.archivePath, storagePath.getName() + "_" + GenericFormatter.SHORT_DAY_FORMATTER.format() + ".zip");
        this.solrInstancesLock.lock();
        try {
            this.disconnectLocalSolr();
            try {
                ZIPWriter.zip(storagePath, zipOut);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            finally {
                try {
                    this.connectLocalSolr();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        finally {
            this.solrInstancesLock.unlock();
        }
        return zipOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreEmbeddedSolr(File solrDumpZipFile) {
        EmbeddedInstance esc = this.solrInstances.getEmbedded();
        if (esc == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No embedded Solr available.");
        }
        File storagePath = esc.getContainerPath();
        this.solrInstancesLock.lock();
        try {
            this.solrInstances.close();
            try {
                ZIPReader.unzip(solrDumpZipFile, storagePath);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            finally {
                this.solrInstances = new InstanceMirror();
                try {
                    this.connectLocalSolr();
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        finally {
            this.solrInstancesLock.unlock();
        }
    }

    public void optimize(int size) {
        if (size < 1) {
            return;
        }
        this.getDefaultConnector().optimize(size);
        if (this.writeWebgraph) {
            this.getWebgraphConnector().optimize(size);
        }
    }

    public void rebootEmbeddedLocalSolr() {
        this.solrInstancesLock.lock();
        try {
            this.disconnectLocalSolr();
            this.solrInstances = new InstanceMirror();
            try {
                this.connectLocalSolr();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        finally {
            this.solrInstancesLock.unlock();
        }
    }

    public Export export(ExportFormat format, String filter, String query2, int maxseconds, File path, boolean dom, boolean text, long maxChunkSize, boolean minified) throws IOException {
        Date lastdate;
        Date firstdate;
        long doccount;
        long now = System.currentTimeMillis();
        if (maxseconds > 0) {
            long from = now - (long)maxseconds * 1000L;
            String nowstr = new Date(now).toInstant().toString();
            String fromstr = new Date(from).toInstant().toString();
            String dateq = CollectionSchema.load_date_dt.getSolrFieldName() + ":[" + fromstr + " TO " + nowstr + "]";
            query2 = query2 == null || "*:*".equals(query2) ? dateq : (String)query2 + " AND " + dateq;
        } else {
            query2 = query2 == null ? "*:*" : query2;
        }
        SolrDocumentList firstdoclist = this.getDefaultConnector().getDocumentListByQuery((String)query2, CollectionSchema.load_date_dt.getSolrFieldName() + " asc", 0, 1, CollectionSchema.load_date_dt.getSolrFieldName());
        SolrDocumentList lastdoclist = this.getDefaultConnector().getDocumentListByQuery((String)query2, CollectionSchema.load_date_dt.getSolrFieldName() + " desc", 0, 1, CollectionSchema.load_date_dt.getSolrFieldName());
        if (firstdoclist.size() == 0 || lastdoclist.size() == 0) {
            doccount = this.getDefaultConnector().getCountByQuery((String)query2);
            if (doccount == 0L) {
                throw new IOException("number of exported documents == 0");
            }
            firstdate = new Date(0L);
            lastdate = new Date(0L);
        } else {
            doccount = firstdoclist.getNumFound();
            SolrDocument firstdoc = (SolrDocument)firstdoclist.get(0);
            SolrDocument lastdoc = (SolrDocument)lastdoclist.get(0);
            Object firstdateobject = firstdoc.getFieldValue(CollectionSchema.load_date_dt.getSolrFieldName());
            Object lastdateobject = lastdoc.getFieldValue(CollectionSchema.load_date_dt.getSolrFieldName());
            if (firstdateobject instanceof Date) {
                firstdate = (Date)firstdateobject;
            } else {
                ConcurrentLog.warn("Fulltext", "The required field " + CollectionSchema.load_date_dt.getSolrFieldName() + " is empty on document with id : " + firstdoc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                firstdate = new Date(0L);
            }
            if (lastdateobject instanceof Date) {
                lastdate = (Date)lastdateobject;
            } else {
                ConcurrentLog.warn("Fulltext", "The required field " + CollectionSchema.load_date_dt.getSolrFieldName() + " is empty on document with id : " + lastdoc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                lastdate = new Date(0L);
            }
        }
        String filename = "yacy_dump_f" + GenericFormatter.SHORT_MINUTE_FORMATTER.format(firstdate) + "_l" + GenericFormatter.SHORT_MINUTE_FORMATTER.format(lastdate) + "_n" + GenericFormatter.SHORT_MINUTE_FORMATTER.format(new Date(now)) + "_c" + String.format("%1$012d", doccount) + "_tc";
        return this.export(path, filename, format.getExt(), filter, (String)query2, format, dom, text, maxChunkSize, minified);
    }

    public Export export(File path, String filename, String fileext, String filter, String query2, ExportFormat format, boolean dom, boolean text, long maxChunkSize, boolean minified) {
        if (this.exportthread != null && this.exportthread.isAlive()) {
            ConcurrentLog.warn("LURL-EXPORT", "cannot start another export thread, already one running");
            return this.exportthread;
        }
        this.exportthread = new Export(path, filename, fileext, filter, query2, format, dom, text, maxChunkSize, minified);
        this.exportthread.start();
        return this.exportthread;
    }

    public static void main(String[] args) {
        Date firstdate = null;
        System.out.println(GenericFormatter.SHORT_MINUTE_FORMATTER.format(firstdate));
    }

    public Export export() {
        return this.exportthread;
    }

    static {
        minified_keys.add(CollectionSchema.sku.getSolrFieldName());
        minified_keys.add(CollectionSchema.title.getSolrFieldName());
        minified_keys.add(CollectionSchema.description_txt.getSolrFieldName());
        minified_keys.add(CollectionSchema.last_modified.getSolrFieldName());
        minified_keys.add(CollectionSchema.text_t.getSolrFieldName());
    }

    public class Export
    extends Thread {
        private final File path;
        private final String filename;
        private final String fileext;
        private final Pattern pattern;
        private String failure;
        private final String query;
        private final ExportFormat format;
        private final boolean dom;
        private final boolean text;
        private int docCount;
        private int chunkSize;
        private int chunkCount;
        private final long maxChunkSize;
        private final boolean minified;

        private Export(File path, String filename, String fileext, String filter, String query2, ExportFormat format, boolean dom, boolean text, long maxChunkSize, boolean minified) {
            super("Fulltext.Export");
            this.path = path;
            this.filename = filename;
            this.fileext = fileext;
            this.pattern = filter == null ? null : Pattern.compile(filter);
            this.query = query2 == null ? "*:*" : query2;
            this.failure = null;
            this.format = format;
            this.dom = dom;
            this.text = text;
            this.docCount = 0;
            this.chunkSize = 0;
            this.chunkCount = 0;
            this.maxChunkSize = maxChunkSize;
            this.minified = minified;
        }

        private void printHead(PrintWriter pw) {
            if (this.format == ExportFormat.html) {
                pw.println("<html><head></head><body>");
            }
            if (this.format == ExportFormat.rss) {
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.println("<?xml-stylesheet type='text/xsl' href='/yacysearch.xsl' version='1.0'?>");
                pw.println("<rss version=\"2.0\" xmlns:yacy=\"http://www.yacy.net/\" xmlns:opensearch=\"http://a9.com/-/spec/opensearch/1.1/\" xmlns:atom=\"http://www.w3.org/2005/Atom\">");
                pw.println("<channel>");
                pw.println("<title>YaCy Peer-to-Peer - Web-Search URL Export</title>");
                pw.println("<description></description>");
                pw.println("<link>http://yacy.net</link>");
            }
            if (this.format == ExportFormat.solr) {
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.println("<response>");
                pw.println("<lst name=\"responseHeader\">");
                pw.println(" <str format=\"yacy.index.export.solr.xml\"/>");
                pw.println(" <lst name=\"params\">");
                pw.println("  <str name=\"q\">" + this.query + "</str>");
                pw.println(" </lst>");
                pw.println("</lst>");
                pw.println("<result>");
            }
        }

        private void printTail(PrintWriter pw) {
            if (this.format == ExportFormat.html) {
                pw.println("</body></html>");
            }
            if (this.format == ExportFormat.rss) {
                pw.println("</channel>");
                pw.println("</rss>");
            }
            if (this.format == ExportFormat.solr) {
                pw.println("</result>");
                pw.println("</response>");
            }
        }

        @Override
        public void run() {
            try {
                if (this.path != null) {
                    this.path.mkdirs();
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                this.failure = e.getMessage();
                return;
            }
            try {
                this.docCount = 0;
                this.chunkSize = 0;
                this.chunkCount = 0;
                PrintWriter pw = this.getWriter();
                this.printHead(pw);
                if (this.dom) {
                    LinkedHashMap<String, ReversibleScoreMap<String>> scores = Fulltext.this.getDefaultConnector().getFacets(this.query + " AND " + CollectionSchema.httpstatus_i.getSolrFieldName() + ":200", 100000000, CollectionSchema.host_s.getSolrFieldName());
                    ReversibleScoreMap stats = (ReversibleScoreMap)scores.get(CollectionSchema.host_s.getSolrFieldName());
                    for (String host : stats) {
                        if (this.pattern != null && !this.pattern.matcher(host).matches()) continue;
                        if (this.format == ExportFormat.text) {
                            pw.println(host);
                        }
                        if (this.format == ExportFormat.html) {
                            pw.println("<a href=\"http://" + host + "\">" + host + "</a><br>");
                        }
                        ++this.docCount;
                        ++this.chunkSize;
                    }
                } else if (this.format == ExportFormat.solr || this.format == ExportFormat.elasticsearch || this.text && this.format == ExportFormat.text) {
                    SolrDocument doc;
                    BlockingQueue<SolrDocument> docs = Fulltext.this.getDefaultConnector().concurrentDocumentsByQuery(this.query + " AND " + CollectionSchema.httpstatus_i.getSolrFieldName() + ":200", null, 0, 100000000, Long.MAX_VALUE, 100, 1, true, new String[0]);
                    while ((doc = docs.take()) != AbstractSolrConnector.POISON_DOCUMENT) {
                        String url = this.getStringFrom(doc.getFieldValue(CollectionSchema.sku.getSolrFieldName()));
                        if (this.pattern != null && !this.pattern.matcher(url).matches()) continue;
                        if (this.minified) {
                            Iterator i = doc.iterator();
                            while (i.hasNext()) {
                                if (minified_keys.contains(((Map.Entry)i.next()).getKey())) continue;
                                i.remove();
                            }
                        }
                        CRIgnoreWriter sw = new CRIgnoreWriter();
                        if (this.text) {
                            sw.write((String)doc.getFieldValue(CollectionSchema.text_t.getSolrFieldName()));
                        }
                        if (this.format == ExportFormat.solr) {
                            EnhancedXMLResponseWriter.writeDoc((Writer)sw, doc);
                        }
                        if (this.format == ExportFormat.elasticsearch) {
                            FlatJSONResponseWriter.writeDoc(sw, doc);
                        }
                        sw.close();
                        if (this.format == ExportFormat.elasticsearch) {
                            pw.println("{\"index\":{}}");
                        }
                        String d = sw.toString();
                        pw.println(d);
                        ++this.docCount;
                        ++this.chunkSize;
                        if ((long)this.chunkSize < this.maxChunkSize) continue;
                        this.printTail(pw);
                        pw.close();
                        ++this.chunkCount;
                        pw = this.getWriter();
                        this.printHead(pw);
                        this.chunkSize = 0;
                    }
                } else {
                    SolrDocument doc;
                    BlockingQueue<SolrDocument> docs = Fulltext.this.getDefaultConnector().concurrentDocumentsByQuery(this.query + " AND " + CollectionSchema.httpstatus_i.getSolrFieldName() + ":200", null, 0, 100000000, Long.MAX_VALUE, 100, 1, true, CollectionSchema.id.getSolrFieldName(), CollectionSchema.sku.getSolrFieldName(), CollectionSchema.title.getSolrFieldName(), CollectionSchema.author.getSolrFieldName(), CollectionSchema.description_txt.getSolrFieldName(), CollectionSchema.size_i.getSolrFieldName(), CollectionSchema.last_modified.getSolrFieldName());
                    while ((doc = docs.take()) != AbstractSolrConnector.POISON_DOCUMENT) {
                        String hash = this.getStringFrom(doc.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                        String url = this.getStringFrom(doc.getFieldValue(CollectionSchema.sku.getSolrFieldName()));
                        String title = this.getStringFrom(doc.getFieldValue(CollectionSchema.title.getSolrFieldName()));
                        String author = this.getStringFrom(doc.getFieldValue(CollectionSchema.author.getSolrFieldName()));
                        String description = this.getStringFrom(doc.getFieldValue(CollectionSchema.description_txt.getSolrFieldName()));
                        Integer size = (Integer)doc.getFieldValue(CollectionSchema.size_i.getSolrFieldName());
                        Date date = (Date)doc.getFieldValue(CollectionSchema.last_modified.getSolrFieldName());
                        if (this.pattern != null && !this.pattern.matcher(url).matches()) continue;
                        if (this.format == ExportFormat.text) {
                            pw.println(url);
                        }
                        if (this.format == ExportFormat.html && title != null) {
                            pw.println("<a href=\"" + MultiProtocolURL.escape(url) + "\">" + CharacterCoding.unicode2xml(title, true) + "</a>");
                        }
                        if (this.format == ExportFormat.rss) {
                            pw.println("<item>");
                            if (title != null) {
                                pw.println("<title>" + CharacterCoding.unicode2xml(title, true) + "</title>");
                            }
                            pw.println("<link>" + MultiProtocolURL.escape(url) + "</link>");
                            if (author != null && !author.isEmpty()) {
                                pw.println("<author>" + CharacterCoding.unicode2xml(author, true) + "</author>");
                            }
                            if (description != null && !description.isEmpty()) {
                                pw.println("<description>" + CharacterCoding.unicode2xml(description, true) + "</description>");
                            }
                            if (date != null) {
                                pw.println("<pubDate>" + HeaderFramework.formatRFC1123(date) + "</pubDate>");
                            }
                            if (size != null) {
                                pw.println("<yacy:size>" + size + "</yacy:size>");
                            }
                            pw.println("<guid isPermaLink=\"false\">" + hash + "</guid>");
                            pw.println("</item>");
                        }
                        ++this.docCount;
                        ++this.chunkSize;
                        if ((long)this.chunkSize < this.maxChunkSize) continue;
                        this.printTail(pw);
                        pw.close();
                        ++this.chunkCount;
                        pw = this.getWriter();
                        this.printHead(pw);
                        this.chunkSize = 0;
                    }
                }
                this.printTail(pw);
                pw.close();
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                this.failure = e.getMessage();
            }
        }

        public File file() {
            File f = new File(this.path, this.filename + "_" + this.chunkcount(this.chunkCount) + "." + this.fileext);
            return f;
        }

        private PrintWriter getWriter() throws IOException {
            File f = this.file();
            FileOutputStream os = new FileOutputStream(this.format == ExportFormat.solr ? new File(f.getAbsolutePath() + ".gz") : f);
            PrintWriter pw = new PrintWriter(new BufferedOutputStream(this.format == ExportFormat.solr ? new GZIPOutputStream(os, 65536){
                {
                    this.def.setLevel(9);
                }
            } : os));
            return pw;
        }

        private String chunkcount(int count) {
            if (count < 10) {
                return "000" + count;
            }
            if (count < 100) {
                return "00" + count;
            }
            if (count < 1000) {
                return "0" + count;
            }
            return "" + count;
        }

        public File path() {
            return this.path;
        }

        public String filename() {
            return this.filename;
        }

        public String fileext() {
            return this.fileext;
        }

        public String failed() {
            return this.failure;
        }

        public int docCount() {
            return this.docCount;
        }

        public int chunkCount() {
            return this.chunkCount;
        }

        private String getStringFrom(Object o) {
            if (o == null) {
                return "";
            }
            if (o instanceof ArrayList) {
                return (String)((ArrayList)o).get(0);
            }
            return (String)o;
        }
    }

    public static enum ExportFormat {
        text("txt"),
        html("html"),
        rss("rss"),
        solr("xml"),
        elasticsearch("flatjson");

        private final String ext;

        private ExportFormat(String ext) {
            this.ext = ext;
        }

        public String getExt() {
            return this.ext;
        }
    }
}

