/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Memory;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.Network;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SecondarySearchSuperviser;
import org.apache.solr.client.solrj.SolrQuery;

public class RemoteSearch
extends Thread {
    private static final ThreadGroup ysThreadGroup = new ThreadGroup("yacySearchThreadGroup");
    public static final ConcurrentLog log = new ConcurrentLog("DHT");
    private final SearchEvent event;
    private final String wordhashes;
    private final String excludehashes;
    private final Classification.ContentDomain contentdom;
    private final boolean strictContentDom;
    private final int partitions;
    private final SecondarySearchSuperviser secondarySearchSuperviser;
    private final Blacklist blacklist;
    private final Seed targetPeer;
    private int urls;
    private final int count;
    private final int maxDistance;
    private final long time;
    private final String language;

    public RemoteSearch(SearchEvent event, String wordhashes, String excludehashes, String language, Classification.ContentDomain contentdom, boolean strictContentDom, int count, long time, int maxDistance, int partitions, Seed targetPeer, SecondarySearchSuperviser secondarySearchSuperviser, Blacklist blacklist) {
        super(ysThreadGroup, "yacySearch_" + targetPeer.getName());
        this.event = event;
        this.wordhashes = wordhashes;
        this.excludehashes = excludehashes;
        this.language = language;
        this.contentdom = contentdom;
        this.strictContentDom = strictContentDom;
        this.partitions = partitions;
        this.secondarySearchSuperviser = secondarySearchSuperviser;
        this.blacklist = blacklist;
        this.targetPeer = targetPeer;
        this.urls = -1;
        this.count = count;
        this.time = time;
        this.maxDistance = maxDistance;
    }

    @Override
    public void run() {
        this.event.oneFeederStarted();
        try {
            this.urls = Protocol.primarySearch(this.event, this.wordhashes, this.excludehashes, this.language, this.contentdom, this.strictContentDom, this.count, this.time, this.maxDistance, this.partitions, this.targetPeer, this.secondarySearchSuperviser, this.blacklist);
            if (this.urls >= 0) {
                this.event.peers.mySeed().incRI(this.urls);
                this.event.peers.mySeed().incRU(this.urls);
            } else {
                Network.log.info("REMOTE SEARCH - no answer from remote peer " + this.targetPeer.hash + ":" + this.targetPeer.getName());
            }
        }
        catch (InterruptedException e) {
            Network.log.info("REMOTE SEARCH - interrupted search to remote peer " + this.targetPeer.hash + ":" + this.targetPeer.getName());
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
        finally {
            this.event.oneFeederTerminated();
        }
    }

    public static String set2string(HandleSet hashes) {
        StringBuilder wh = new StringBuilder(hashes.size() * 12);
        Iterator<byte[]> iter = hashes.iterator();
        while (iter.hasNext()) {
            wh.append(ASCII.String(iter.next()));
        }
        return wh.toString();
    }

    public Seed target() {
        return this.targetPeer;
    }

    public static void primaryRemoteSearches(SearchEvent event, int start, int count, long time, Blacklist blacklist, SortedSet<byte[]> clusterselection) {
        Switchboard sb = Switchboard.getSwitchboard();
        boolean shortmem = MemoryControl.shortStatus();
        int indexingQueueSize = event.query.getSegment().fulltext().bufferSize();
        int redundancy = event.peers.redundancy();
        StringBuilder healthMessage = new StringBuilder(50);
        if (indexingQueueSize > 0) {
            redundancy = Math.max(1, redundancy - 1);
            healthMessage.append(", indexingQueueSize > 0");
        }
        if (indexingQueueSize > 10) {
            redundancy = Math.max(1, redundancy - 1);
            healthMessage.append(", indexingQueueSize > 10");
        }
        if (indexingQueueSize > 50) {
            redundancy = Math.max(1, redundancy - 1);
            healthMessage.append(", indexingQueueSize > 50");
        }
        if (Memory.getSystemLoadAverage() > 2.0) {
            redundancy = Math.max(1, redundancy - 1);
            healthMessage.append(", load() > 2.0");
        }
        if (Memory.cores() < 4L) {
            redundancy = Math.max(1, redundancy - 1);
            healthMessage.append(", cores() < 4");
        }
        if (Memory.cores() == 1L) {
            redundancy = 1;
            healthMessage.append(", cores() == 1");
        }
        int minage = 3;
        boolean minRWIWordCount = true;
        int robinsoncount = event.peers.scheme.verticalPartitions() * redundancy / 2;
        if (indexingQueueSize > 0) {
            robinsoncount = Math.max(1, robinsoncount / 2);
        }
        if (indexingQueueSize > 10) {
            robinsoncount = Math.max(1, robinsoncount / 2);
        }
        if (indexingQueueSize > 50) {
            robinsoncount = Math.max(1, robinsoncount / 2);
        }
        if (shortmem) {
            redundancy = 1;
            robinsoncount = Math.max(1, robinsoncount / 2);
            healthMessage.append(", shortmem");
        }
        Random random = new Random(System.currentTimeMillis());
        Collection<Seed> dhtPeers = null;
        if (clusterselection != null) {
            dhtPeers = DHTSelection.selectClusterPeers(event.peers, clusterselection);
        } else if (event.query.getQueryGoal().isCatchall() || event.query.getQueryGoal().getIncludeHashes().has(Segment.catchallHash)) {
            if (event.query.modifier.sitehost != null && event.query.modifier.sitehost.length() > 0) {
                String newGoal = Domains.getSmartSLD(event.query.modifier.sitehost);
                dhtPeers = DHTSelection.selectDHTSearchTargets(event.peers, QueryParams.hashes2Set(ASCII.String(Word.word2hash(newGoal))), 3, 1, redundancy, event.peers.redundancy(), random);
            } else {
                dhtPeers = DHTSelection.seedsByAge(event.peers, false, event.peers.redundancy(), 1).values();
            }
        } else {
            dhtPeers = DHTSelection.selectDHTSearchTargets(event.peers, event.query.getQueryGoal().getIncludeHashes(), 3, 1, redundancy, event.peers.redundancy(), random);
            long targetSize = 1 + redundancy * event.peers.scheme.verticalPartitions();
            if ((long)dhtPeers.size() > targetSize) {
                ArrayList<Seed> pa = new ArrayList<Seed>(dhtPeers.size());
                pa.addAll(dhtPeers);
                dhtPeers.clear();
                int i = 0;
                while ((long)i < targetSize) {
                    dhtPeers.add((Seed)pa.remove(random.nextInt(pa.size())));
                    ++i;
                }
            }
        }
        if (dhtPeers == null) {
            dhtPeers = new HashSet<Seed>();
        }
        Collection<Seed> robinsonPeers = DHTSelection.selectExtraTargets(event.peers, event.query.getQueryGoal().getIncludeHashes(), 3, dhtPeers, robinsoncount, random);
        if (event.peers != null) {
            if (sb.getConfigBool("debug.search.remote.dht.testlocal", false)) {
                dhtPeers.clear();
                dhtPeers.add(event.peers.mySeed());
            }
            if (sb.getConfigBool("debug.search.remote.solr.testlocal", false)) {
                robinsonPeers.clear();
                robinsonPeers.add(event.peers.mySeed());
            }
        }
        log.info("preparing remote search: shortmem=" + (shortmem ? "true" : "false") + ", indexingQueueSize=" + indexingQueueSize + ", redundancy=" + redundancy + ", minage=3, dhtPeers=" + dhtPeers.size() + ", robinsonpeers=" + robinsonPeers.size() + ", health: " + (healthMessage.length() > 0 ? healthMessage.substring(2) : "perfect"));
        boolean useFacets = false;
        int targets = dhtPeers.size() + robinsonPeers.size();
        if (!sb.getConfigBool("debug.search.remote.solr.off", false)) {
            SolrQuery solrQuery = event.query.solrQuery(event.getQuery().contentdom, event.query.isStrictContentDom(), false, event.excludeintext_image);
            for (Seed s : robinsonPeers) {
                if (MemoryControl.shortStatus() || Memory.getSystemLoadAverage() > (double)sb.getConfigFloat("remotesearch.maxload.solr", 4.0f)) continue;
                Thread t = RemoteSearch.solrRemoteSearch(event, solrQuery, start, count, s, targets, blacklist, false, true);
                event.nodeSearchThreads.add(t);
            }
        }
        if (!sb.getConfigBool("debug.search.remote.dht.off", false)) {
            for (Seed dhtPeer : dhtPeers) {
                if (dhtPeer == null || dhtPeer.hash == null || MemoryControl.shortStatus() || Memory.getSystemLoadAverage() > (double)sb.getConfigFloat("remotesearch.maxload.rwi", 8.0f)) continue;
                try {
                    RemoteSearch rs = new RemoteSearch(event, QueryParams.hashSet2hashString(event.query.getQueryGoal().getIncludeHashes()), QueryParams.hashSet2hashString(event.query.getQueryGoal().getExcludeHashes()), event.query.targetlang == null ? "" : event.query.targetlang, event.query.contentdom == null ? Classification.ContentDomain.ALL : event.query.contentdom, event.query.isStrictContentDom(), count, time, event.query.maxDistance, targets, dhtPeer, event.secondarySearchSuperviser, blacklist);
                    rs.start();
                    event.primarySearchThreadsL.add(rs);
                }
                catch (OutOfMemoryError e) {
                    ConcurrentLog.logException(e);
                    break;
                }
            }
        }
    }

    public static Thread secondaryRemoteSearch(final SearchEvent event, final Set<String> wordhashes, final String urlhashes, final long time, String targethash, final Blacklist blacklist) {
        if (event.peers.mySeed() == null || event.peers.mySeed().getIPs().size() == 0) {
            return null;
        }
        assert (urlhashes != null);
        assert (urlhashes.length() > 0);
        final Seed targetPeer = event.peers.getConnected(targethash);
        if (targetPeer == null || targetPeer.hash == null) {
            return null;
        }
        Thread secondary = new Thread("RemoteSearch.secondaryRemoteSearch(" + wordhashes + " to " + targethash + ")"){

            @Override
            public void run() {
                event.oneFeederStarted();
                try {
                    int urls2 = Protocol.secondarySearch(event, QueryParams.hashSet2hashString(wordhashes), urlhashes, Classification.ContentDomain.ALL, false, 20, time, 999, 0, targetPeer, blacklist);
                    if (urls2 >= 0) {
                        if (urlhashes != null && urlhashes.length() > 0) {
                            Network.log.info("SECONDARY REMOTE SEARCH - remote peer " + targetPeer.hash + ":" + targetPeer.getName() + " contributed " + urls2 + " links for word hash " + wordhashes);
                        }
                        event.peers.mySeed().incRI(urls2);
                        event.peers.mySeed().incRU(urls2);
                    } else {
                        Network.log.info("REMOTE SEARCH - no answer from remote peer " + targetPeer.hash + ":" + targetPeer.getName());
                    }
                }
                catch (InterruptedException e) {
                    Network.log.info("REMOTE SEARCH - interrupted search to remote peer " + targetPeer.hash + ":" + targetPeer.getName());
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
                finally {
                    event.oneFeederTerminated();
                }
            }
        };
        secondary.start();
        return secondary;
    }

    public static Thread solrRemoteSearch(final SearchEvent event, final SolrQuery solrQuery, final int start, final int count, final Seed targetPeer, final int partitions, final Blacklist blacklist, final boolean useSolrFacets, final boolean incrementNavigators) {
        assert (solrQuery != null);
        if (event.peers.mySeed() == null) {
            return null;
        }
        Thread solr = new Thread("RemoteSearch.solrRemoteSearch(" + solrQuery.getQuery() + " to " + (targetPeer == null ? "myself" : targetPeer.hash) + ")"){

            @Override
            public void run() {
                int urls2 = 0;
                try {
                    event.oneFeederStarted();
                    urls2 = Protocol.solrQuery(event, solrQuery, start, count, targetPeer == null ? event.peers.mySeed() : targetPeer, partitions, blacklist, useSolrFacets, incrementNavigators);
                    if (urls2 >= 0) {
                        event.peers.mySeed().incRI(urls2);
                        event.peers.mySeed().incRU(urls2);
                    } else if (targetPeer != null) {
                        Network.log.info("REMOTE SEARCH - no answer from remote peer " + targetPeer.hash + ":" + targetPeer.getName());
                    }
                }
                catch (InterruptedException e) {
                    Network.log.info("REMOTE SEARCH - interrupted search to remote peer " + targetPeer.hash + ":" + targetPeer.getName());
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
                finally {
                    event.oneFeederTerminated();
                }
            }
        };
        solr.start();
        return solr;
    }

    public static int remainingWaiting(RemoteSearch[] searchThreads) {
        if (searchThreads == null) {
            return 0;
        }
        int alive = 0;
        for (RemoteSearch searchThread : searchThreads) {
            if (!searchThread.isAlive()) continue;
            ++alive;
        }
        return alive;
    }

    public static int collectedLinks(RemoteSearch[] searchThreads) {
        int links = 0;
        for (RemoteSearch searchThread : searchThreads) {
            if (searchThread.isAlive() || searchThread.urls <= 0) continue;
            links += searchThread.urls;
        }
        return links;
    }

    public static void interruptAlive(RemoteSearch[] searchThreads) {
        for (RemoteSearch searchThread : searchThreads) {
            if (!searchThread.isAlive()) continue;
            searchThread.interrupt();
        }
    }
}

