/*
 * Decompiled with CFR 0.152.
 */
package net.yacy;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.protocol.TimeoutRequest;
import net.yacy.cora.storage.Configuration;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.TextParser;
import net.yacy.document.parser.audioTagParser;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.search.Switchboard;
import net.yacy.search.index.ReindexSolrBusyThread;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.LukeResponse;

public class migration {
    public static final double TAGDB_WITH_TAGHASH = 0.43101635;
    public static final double NEW_OVERLAYS = 0.56504422;
    public static final double IDX_HOST_VER = 0.99007724;
    public static final double SSLPORT_CFG = 1.67009578;
    public static final double NEW_IPPATTERNS = 1.92109489;
    public static final double ADDITIONAL_AUDIO_TAG_FORMATS = 1.92109589;

    public static void migrate(Switchboard sb, double fromVer, double toVer) {
        if (fromVer < toVer) {
            if (fromVer < 0.43101635) {
                migration.migrateBookmarkTagsDB(sb);
            }
            if (fromVer < 0.56504422) {
                migration.migrateDefaultFiles(sb);
            }
            if (fromVer < 1.92109489) {
                migration.migrateServerClientSetting(sb);
            }
            if (fromVer < 1.92109589) {
                migration.migrateDisabledAudioFormats(sb);
            }
            ConcurrentLog.info("MIGRATION", "Migrating from " + String.format(Locale.US, "%.8f", fromVer) + " to " + String.format(Locale.US, "%.8f", toVer));
            if (fromVer < 0.47) {
                migration.presetPasswords(sb);
                migration.migrateSwitchConfigSettings(sb);
                migration.migrateWorkFiles(sb);
            }
        }
        migration.installSkins(sb);
        if (sb.getConfigBool("server.https", false)) {
            int sslport = 8443;
            if (fromVer > 1.67009578) {
                sslport = sb.getConfigInt("port.ssl", 8443);
            }
            if (TimeoutRequest.ping("127.0.0.1", sslport, 3000)) {
                sb.setConfig("server.https", false);
                ConcurrentLog.config("MIGRATION", "disabled https support (reason: port already used)");
            }
        }
    }

    public static void migrateDefaultFiles(Switchboard sb) {
        File file = new File(sb.htDocsPath, "share/dir.html");
        if (file.exists()) {
            migration.delete(file);
        }
        if ((file = new File(sb.htDocsPath, "share/dir.class")).exists()) {
            migration.delete(file);
        }
        if ((file = new File(sb.htDocsPath, "share/dir.java")).exists()) {
            migration.delete(file);
        }
        if ((file = new File(sb.htDocsPath, "www/welcome.html")).exists()) {
            migration.delete(file);
        }
        if ((file = new File(sb.htDocsPath, "www/welcome.java")).exists()) {
            migration.delete(file);
        }
        if ((file = new File(sb.htDocsPath, "www/welcome.class")).exists()) {
            migration.delete(file);
        }
    }

    public static void installSkins(Switchboard sb) {
        String skin;
        File skinsPath = sb.getDataPath("skinPath", "DATA/SKINS");
        File defaultSkinsPath = new File(sb.getAppPath(), "skins");
        if (defaultSkinsPath.exists()) {
            List<String> skinFiles = FileUtils.getDirListing(defaultSkinsPath.getAbsolutePath());
            migration.mkdirs(skinsPath);
            for (String string : skinFiles) {
                if (!string.endsWith(".css")) continue;
                File from = new File(defaultSkinsPath, string);
                File to = new File(skinsPath, string);
                if (from.lastModified() <= to.lastModified()) continue;
                try {
                    Files.copy((File)from, (File)to);
                }
                catch (IOException iOException) {}
            }
        }
        if ((skin = sb.getConfig("currentSkin", "default")).equals("")) {
            skin = "default";
        }
        File skinsDir = sb.getDataPath("skinPath", "DATA/SKINS");
        File file = new File(skinsDir, skin + ".css");
        File htdocsPath = new File(sb.getDataPath("htDocsPath", "htroot"), "env");
        File styleFile = new File(htdocsPath, "style.css");
        if (!file.exists()) {
            if (styleFile.exists()) {
                ConcurrentLog.info("MIGRATION", "Skin " + skin + " not found. Keeping old skin.");
            } else {
                ConcurrentLog.severe("MIGRATION", "Skin " + skin + " and no existing Skin found.");
            }
        } else {
            try {
                migration.mkdirs(styleFile.getParentFile());
                Files.copy((File)file, (File)styleFile);
                ConcurrentLog.info("MIGRATION", "copied new Skinfile");
            }
            catch (IOException e) {
                ConcurrentLog.severe("MIGRATION", "Cannot copy skinfile.");
            }
        }
    }

    private static void mkdirs(File path) {
        if (!path.exists() && !path.mkdirs()) {
            ConcurrentLog.warn("MIGRATION", "could not create directories for " + path);
        }
    }

    public static void migrateBookmarkTagsDB(Switchboard sb) {
        File tagsDBFile;
        if (sb.bookmarksDB != null) {
            sb.bookmarksDB.close();
        }
        if ((tagsDBFile = new File(sb.workPath, "bookmarkTags.db")).exists()) {
            migration.delete(tagsDBFile);
            ConcurrentLog.info("MIGRATION", "Migrating bookmarkTags.db to use wordhashs as keys.");
        }
        try {
            sb.initBookmarks();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    private static void delete(File filename) {
        if (!filename.delete()) {
            ConcurrentLog.warn("MIGRATION", "could not delete " + filename);
        }
    }

    public static void migrateWorkFiles(Switchboard sb) {
        File file2;
        File file = new File(sb.getDataPath(), "DATA/SETTINGS/wiki.db");
        if (file.exists()) {
            ConcurrentLog.info("MIGRATION", "Migrating wiki.db to " + sb.workPath);
            sb.wikiDB.close();
            file2 = new File(sb.workPath, "wiki.db");
            try {
                Files.copy((File)file, (File)file2);
                file.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file = new File(sb.getDataPath(), "DATA/SETTINGS/wiki-bkp.db");
            if (file.exists()) {
                ConcurrentLog.info("MIGRATION", "Migrating wiki-bkp.db to " + sb.workPath);
                file2 = new File(sb.workPath, "wiki-bkp.db");
                try {
                    Files.copy((File)file, (File)file2);
                    file.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                sb.initWiki();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if ((file = new File(sb.getDataPath(), "DATA/SETTINGS/message.db")).exists()) {
            ConcurrentLog.info("MIGRATION", "Migrating message.db to " + sb.workPath);
            sb.messageDB.close();
            file2 = new File(sb.workPath, "message.db");
            try {
                Files.copy((File)file, (File)file2);
                file.delete();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                sb.initMessages();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    public static void presetPasswords(Switchboard sb) {
        String acc = sb.getConfig("adminAccount", "");
        if (acc.length() > 0) {
            sb.setConfig("adminAccountBase64MD5", Digest.encodeMD5Hex(Base64Order.standardCoder.encodeString(acc)));
        }
        if ((acc = sb.getConfig("proxyAccountBase64", "")).length() > 0) {
            sb.setConfig("proxyAccountBase64MD5", Digest.encodeMD5Hex(acc));
            sb.setConfig("proxyAccountBase64", "");
        }
        if ((acc = sb.getConfig("uploadAccountBase64", "")).length() > 0) {
            sb.setConfig("uploadAccountBase64MD5", Digest.encodeMD5Hex(acc));
            sb.setConfig("uploadAccountBase64", "");
        }
        if ((acc = sb.getConfig("downloadAccountBase64", "")).length() > 0) {
            sb.setConfig("downloadAccountBase64MD5", Digest.encodeMD5Hex(acc));
            sb.setConfig("downloadAccountBase64", "");
        }
    }

    public static void migrateSwitchConfigSettings(Switchboard sb) {
        String value = "";
        if (sb.getConfig("locale.translated_html", "DATA/LOCALE/htroot").equals("htroot/locale")) {
            sb.setConfig("locale.translated_html", "DATA/LOCALE/htroot");
        }
        if ((value = sb.getConfig("proxyBlackListsActive", "")).length() > 0) {
            sb.setConfig("proxy.BlackLists", value);
            sb.setConfig("crawler.BlackLists", value);
            sb.setConfig("dht.BlackLists", value);
            sb.setConfig("search.BlackLists", value);
            sb.setConfig("surftips.BlackLists", value);
            sb.setConfig("BlackLists.Shared", sb.getConfig("proxyBlackListsShared", ""));
            sb.setConfig("proxyBlackListsActive", "");
        }
        if ((value = sb.getConfig("crawler.acceptLanguage", "")).length() > 0) {
            sb.setConfig("crawler.http.acceptEncoding", sb.getConfig("crawler.acceptEncoding", "gzip,deflate"));
            sb.setConfig("crawler.http.acceptLanguage", sb.getConfig("crawler.acceptLanguage", "en-us,en;q=0.5"));
            sb.setConfig("crawler.http.acceptCharset", sb.getConfig("crawler.acceptCharset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7"));
        }
        if ((value = sb.getConfig("update.blacklist", "")).equals("....[123]")) {
            value = "";
            sb.setConfig("update.blacklist", value);
        }
    }

    public static void migrateServerClientSetting(Switchboard sb) {
        StringBuilder migrated;
        boolean hasDeprecated;
        String patternSeparator = ",";
        String white = sb.getConfig("serverClient", "*");
        if (!white.equals("*") && (hasDeprecated = migration.migrateIPAddressPatterns(",", white, migrated = new StringBuilder()))) {
            sb.setConfig("serverClient", migrated.toString());
            ConcurrentLog.info("MIGRATION", "Migrated serverClient setting from " + white + " to " + migrated);
        }
    }

    protected static boolean migrateIPAddressPatterns(String patternSeparator, String patterns, StringBuilder migrated) {
        StringTokenizer st = new StringTokenizer(patterns, patternSeparator);
        boolean hasDeprecated = false;
        while (st.hasMoreTokens()) {
            String path;
            int idx2;
            String pattern = st.nextToken();
            if (pattern.indexOf(124) > 0) {
                idx2 = pattern.indexOf(124);
            } else {
                idx2 = pattern.indexOf(47);
                if (idx2 >= 0) {
                    String intPart = pattern.substring(idx2 + 1);
                    try {
                        int intValue = Integer.parseInt(intPart);
                        if (intValue >= 0 && intValue <= 128) {
                            idx2 = -1;
                        } else {
                            hasDeprecated = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        hasDeprecated = true;
                    }
                }
            }
            String addr = idx2 > 0 ? pattern.substring(0, idx2) : pattern;
            String string = path = idx2 > 0 ? pattern.substring(idx2) : "/*";
            if (addr.endsWith(".")) {
                int i;
                hasDeprecated = true;
                String[] parts = addr.split("\\.");
                StringBuilder migratedAddr = new StringBuilder(addr.substring(0, addr.length() - 1));
                for (i = parts.length; i < 4; ++i) {
                    migratedAddr.append(".0");
                }
                migratedAddr.append("-").append(addr.substring(0, addr.length() - 1));
                for (i = parts.length; i < 4; ++i) {
                    migratedAddr.append(".255");
                }
                addr = migratedAddr.toString();
            }
            if (path.startsWith("|") || path.startsWith("/*.")) {
                path = path.substring(1);
            }
            if (migrated.length() > 0) {
                migrated.append(patternSeparator);
            }
            migrated.append(addr);
            if ("/*".equals(path)) continue;
            migrated.append("|").append(path);
        }
        return hasDeprecated;
    }

    public static void migrateDisabledAudioFormats(Switchboard sb) {
        HashSet oldAudioExtensions = new HashSet();
        Collections.addAll(oldAudioExtensions, "mp3", "ogg", "oga", "m4a", "m4p", "flac", "wma");
        HashSet oldAudioMediaTypes = new HashSet();
        Collections.addAll(oldAudioMediaTypes, "audio/mpeg", "audio/MPA", "audio/mpa-robust", "audio/mp4", "audio/flac", "audio/x-flac", "audio/x-ms-wma", "audio/x-ms-asf");
        Set<String> deniedExtensions = sb.getConfigSet("parser.extensions.deny");
        Set<String> deniedMediaTypes = sb.getConfigSet("parser.mime.deny");
        if (deniedExtensions.containsAll(oldAudioExtensions) && deniedMediaTypes.containsAll(oldAudioMediaTypes)) {
            deniedExtensions.addAll(audioTagParser.SupportedAudioFormat.getAllFileExtensions());
            sb.setConfig("parser.extensions.deny", deniedExtensions);
            deniedMediaTypes.addAll(audioTagParser.SupportedAudioFormat.getAllMediaTypes());
            sb.setConfig("parser.mime.deny", deniedMediaTypes);
            TextParser.setDenyMime(sb.getConfig("parser.mime.deny", ""));
            TextParser.setDenyExtension(sb.getConfig("parser.extensions.deny", ""));
        }
    }

    public static int reindexToschema(Switchboard sb) {
        BusyThread bt = sb.getThread("reindexSolr");
        if (bt != null) {
            return bt.getJobCount();
        }
        boolean lukeCheckok = false;
        HashSet<String> omitFields = new HashSet<String>(4);
        omitFields.add(CollectionSchema.author_sxt.getSolrFieldName());
        omitFields.add(CollectionSchema.coordinate_p_0_coordinate.getSolrFieldName());
        omitFields.add(CollectionSchema.coordinate_p_1_coordinate.getSolrFieldName());
        omitFields.add("_version_");
        CollectionConfiguration colcfg = Switchboard.getSwitchboard().index.fulltext().getDefaultConfiguration();
        ReindexSolrBusyThread reidx = new ReindexSolrBusyThread(null);
        try {
            Collection<LukeResponse.FieldInfo> solrfields = Switchboard.getSwitchboard().index.fulltext().getDefaultEmbeddedConnector().getFields();
            for (LukeResponse.FieldInfo solrfield : solrfields) {
                if (colcfg.contains(solrfield.getName()) || omitFields.contains(solrfield.getName()) || solrfield.getName().startsWith("vocabulary_")) continue;
                reidx.addSelectFieldname(solrfield.getName());
            }
            lukeCheckok = true;
        }
        catch (SolrServerException ex) {
            ConcurrentLog.logException(ex);
        }
        if (!lukeCheckok) {
            Iterator<Configuration.Entry> itcol = colcfg.entryIterator();
            while (itcol.hasNext()) {
                Configuration.Entry etr = itcol.next();
                if (etr.enabled() || omitFields.contains(etr.key())) continue;
                reidx.addSelectFieldname(etr.key());
            }
            reidx.addSelectFieldname("author_s");
            reidx.addSelectFieldname("css_tag_txt");
            reidx.addSelectFieldname("css_url_txt");
            reidx.addSelectFieldname("scripts_txt");
            reidx.addSelectFieldname("images_tag_txt");
            reidx.addSelectFieldname("images_urlstub_txt");
            reidx.addSelectFieldname("canonical_t");
            reidx.addSelectFieldname("frames_txt");
            reidx.addSelectFieldname("iframes_txt");
            reidx.addSelectFieldname("inboundlinks_tag_txt");
            reidx.addSelectFieldname("inboundlinks_relflags_val");
            reidx.addSelectFieldname("inboundlinks_name_txt");
            reidx.addSelectFieldname("inboundlinks_rel_sxt");
            reidx.addSelectFieldname("inboundlinks_text_txt");
            reidx.addSelectFieldname("inboundlinks_text_chars_val");
            reidx.addSelectFieldname("inboundlinks_text_words_val");
            reidx.addSelectFieldname("inboundlinks_alttag_txt");
            reidx.addSelectFieldname("outboundlinks_tag_txt");
            reidx.addSelectFieldname("outboundlinks_relflags_val");
            reidx.addSelectFieldname("outboundlinks_name_txt");
            reidx.addSelectFieldname("outboundlinks_rel_sxt");
            reidx.addSelectFieldname("outboundlinks_text_txt");
            reidx.addSelectFieldname("outboundlinks_text_chars_val");
            reidx.addSelectFieldname("outboundlinks_text_words_val");
            reidx.addSelectFieldname("outboundlinks_alttag_txt");
        }
        sb.deployThread("reindexSolr", "Reindex Solr", "reindex documents with obsolete fields in embedded Solr index", "/IndexReIndexMonitor_p.html", reidx, 0L);
        return 0;
    }
}

