/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.workflow;

import java.net.SocketException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Memory;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.workflow.AbstractThread;
import net.yacy.kelondro.workflow.BusyThread;

public abstract class AbstractBusyThread
extends AbstractThread
implements BusyThread {
    private static final ConcurrentLog log = new ConcurrentLog("BusyThread");
    private long startup = 0L;
    private long intermission = 0L;
    private long idlePause = 0L;
    private long busyPause = 0L;
    private long idletime = 0L;
    private long memprereq = 0L;
    private long idleCycles = 0L;
    private long busyCycles = 0L;
    private long outofmemoryCycles = 0L;
    private long highCPUCycles = 0L;
    private double loadprereq = 9.0;
    private boolean intermissionObedient = true;
    private final Object syncObject = new Object();
    private final long idleSleep;
    private final long busySleep;

    public AbstractBusyThread(long minidleSleep, long minbusySleep) {
        this.idleSleep = minidleSleep;
        this.busySleep = minbusySleep;
        this.idlePause = minidleSleep;
        this.busyPause = minbusySleep;
    }

    @Override
    public final void setStartupSleep(long milliseconds) {
        this.startup = milliseconds;
    }

    @Override
    public final long setIdleSleep(long milliseconds) {
        this.idlePause = Math.max(this.idleSleep, milliseconds);
        return this.idlePause;
    }

    @Override
    public final long getIdleSleep() {
        return this.idlePause;
    }

    @Override
    public final long setBusySleep(long milliseconds) {
        this.busyPause = Math.max(this.busySleep, milliseconds);
        return this.busyPause;
    }

    @Override
    public final long getBusySleep() {
        return this.busyPause;
    }

    @Override
    public void setMemPreReqisite(long freeBytes) {
        this.memprereq = freeBytes;
    }

    @Override
    public double setLoadPreReqisite(double load) {
        this.loadprereq = load;
        return load;
    }

    @Override
    public void setObeyIntermission(boolean obey) {
        this.intermissionObedient = obey;
    }

    @Override
    public final long getIdleCycles() {
        return this.idleCycles;
    }

    @Override
    public final long getBusyCycles() {
        return this.busyCycles;
    }

    @Override
    public long getOutOfMemoryCycles() {
        return this.outofmemoryCycles;
    }

    @Override
    public long getHighCPUCycles() {
        return this.highCPUCycles;
    }

    @Override
    public final long getSleepTime() {
        return this.idletime;
    }

    @Override
    public void intermission(long pause) {
        this.intermission = pause == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + pause;
    }

    @Override
    public void run() {
        if (this.startup > 0L) {
            this.logSystem("thread '" + this.getName() + "' deployed, delaying start-up.");
            this.ratz(this.startup);
            if (!this.running) {
                return;
            }
        }
        this.open();
        if (log != null) {
            if (this.startup > 0L) {
                this.logSystem("thread '" + this.getName() + "' delayed, " + (this.busyPause < 0L ? "starting now job." : "starting now loop."));
            } else {
                this.logSystem("thread '" + this.getName() + "' deployed, " + (this.busyPause < 0L ? "starting job." : "starting loop."));
            }
        }
        while (this.running) {
            long timestamp;
            if (this.intermissionObedient && this.intermission > 0L && this.intermission != Long.MAX_VALUE) {
                long itime = this.intermission - System.currentTimeMillis();
                if (itime > 0L) {
                    if (itime > this.idlePause) {
                        itime = this.idlePause;
                    }
                    this.logSystem("thread '" + this.getName() + "' breaks for intermission: " + itime / 1000L + " seconds");
                    this.ratz(itime);
                }
                this.intermission = 0L;
            }
            if (this.intermission == Long.MAX_VALUE) {
                this.logSystem("thread '" + this.getName() + "' paused");
                timestamp = System.currentTimeMillis();
                this.ratz(this.idlePause);
                this.idletime += System.currentTimeMillis() - timestamp;
                continue;
            }
            if (Memory.getSystemLoadAverage() > this.loadprereq) {
                this.logSystem("Thread '" + this.getName() + "' runs high load cycle. current: " + Memory.getSystemLoadAverage() + " max.: " + this.loadprereq);
                timestamp = System.currentTimeMillis();
                this.ratz(this.idlePause);
                ++this.highCPUCycles;
                this.idletime += System.currentTimeMillis() - timestamp;
                continue;
            }
            if (MemoryControl.request(this.memprereq, false)) {
                try {
                    timestamp = System.currentTimeMillis();
                    long memstamp0 = MemoryControl.used();
                    boolean isBusy = this.job();
                    if (isBusy) {
                        long memstamp1 = MemoryControl.used();
                        if (memstamp1 >= memstamp0) {
                            this.memuse += memstamp1 - memstamp0;
                        } else if (this.busyCycles > 0L) {
                            this.memuse += this.memuse / this.busyCycles;
                        }
                        this.busytime += System.currentTimeMillis() - timestamp;
                        ++this.busyCycles;
                    } else {
                        ++this.idleCycles;
                    }
                    if (!this.running || this.isInterrupted() || this.idlePause < 0L || this.busyPause < 0L) break;
                    timestamp = System.currentTimeMillis();
                    this.ratz(isBusy ? this.busyPause : this.idlePause);
                    this.idletime += System.currentTimeMillis() - timestamp;
                }
                catch (SocketException e) {
                    log.fine("socket-job interrupted: " + e.getMessage());
                }
                catch (Exception e) {
                    this.jobExceptionHandler(e);
                    ++this.busyCycles;
                }
                continue;
            }
            log.warn("Thread '" + this.getName() + "' runs short memory cycle. Free mem: " + MemoryControl.available() / 1024L + " KB, needed: " + this.memprereq / 1024L + " KB");
            timestamp = System.currentTimeMillis();
            this.freemem();
            this.ratz(this.idlePause + 1000L * (this.outofmemoryCycles++ % 15L));
            this.idletime += System.currentTimeMillis() - timestamp;
        }
        this.close();
        this.logSystem("thread '" + this.getName() + "' terminated.");
    }

    private void ratz(long millis) {
        block2: {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                if (log == null) break block2;
                log.config("thread '" + this.getName() + "' interrupted because of shutdown.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThread() {
        if (this.syncObject != null) {
            Object object = this.syncObject;
            synchronized (object) {
                if (log != null && log.isFine()) {
                    log.fine("thread '" + this.getName() + "' has received a notification from thread '" + Thread.currentThread().getName() + "'.");
                }
                this.syncObject.notifyAll();
            }
        }
    }

    private void logSystem(String text) {
        if (log == null) {
            ConcurrentLog.config("THREAD-CONTROL", text);
        } else {
            log.config(text);
        }
    }
}

