/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.storage.Files;
import net.yacy.cora.util.ConcurrentLog;
import org.apache.commons.lang.StringUtils;
import org.mozilla.intl.chardet.nsDetector;

public final class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String[] unescaped_strings_in = new String[]{"\r\n", "\r", "\n", "=", "\\"};
    private static final String[] escaped_strings_out = new String[]{"\\n", "\\n", "\\n", "\\=", "\\\\"};
    private static final String[] escaped_strings_in = new String[]{"\\\\", "\\n", "\\="};
    private static final String[] unescaped_strings_out = new String[]{"\\", "\n", "="};
    private static final char LF = '\n';
    private static final char CR = '\r';

    public static long copy(InputStream source, OutputStream dest) throws IOException {
        return FileUtils.copy(source, dest, -1L);
    }

    public static long copy(InputStream source, OutputStream dest, long count) throws IOException {
        int c;
        assert (count < 0L || count > 0L) : "precondition violated: count == " + count + " (nothing to copy)";
        if (count == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[1024];
        int chunkSize = (int)(count > 0L ? Math.min(count, 1024L) : 1024L);
        long total = 0L;
        long remaining = count > 0L ? count : Long.MAX_VALUE;
        while ((c = source.read(buffer, 0, remaining < (long)chunkSize ? (int)remaining : chunkSize)) > 0) {
            dest.write(buffer, 0, c);
            dest.flush();
            remaining -= (long)c;
            if (count <= 0L || count != (total += (long)c)) continue;
        }
        dest.flush();
        return total;
    }

    public static int copy(InputStream source, Writer dest) throws IOException {
        InputStreamReader reader = new InputStreamReader(source);
        return FileUtils.copy(reader, dest);
    }

    public static int copy(InputStream source, Writer dest, Charset inputCharset) throws IOException {
        InputStreamReader reader = new InputStreamReader(source, inputCharset);
        return FileUtils.copy(reader, dest);
    }

    public static int copy(String source, Writer dest) throws IOException {
        dest.write(source);
        dest.flush();
        return source.length();
    }

    public static int copy(Reader source, Writer dest) throws IOException {
        assert (source != null);
        assert (dest != null);
        if (source == null) {
            throw new IOException("source is null");
        }
        if (dest == null) {
            throw new IOException("dest is null");
        }
        char[] buffer = new char[1024];
        int count = 0;
        int n = 0;
        try {
            while (-1 != (n = source.read(buffer))) {
                dest.write(buffer, 0, n);
                count += n;
            }
            dest.flush();
        }
        catch (Exception e) {
            assert (e != null);
            throw new IOException(e == null ? "null" : (e.getMessage() == null ? e.toString() : e.getMessage()), e);
        }
        return count;
    }

    public static void copy(InputStream source, File dest) throws IOException {
        FileUtils.copy(source, dest, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream source, File dest, long count) throws IOException {
        String path = dest.getParent();
        if (path != null && path.length() > 0) {
            new File(path).mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest);
            long l = FileUtils.copy(source, fos, count);
            return l;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("FileUtils", "cannot close FileOutputStream for " + dest + "! " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyRange(File source, OutputStream dest, int start) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            long skipped = ((InputStream)fis).skip(start);
            if (skipped != (long)start) {
                throw new IllegalStateException("Unable to skip '" + start + "' bytes. Only '" + skipped + "' bytes skipped.");
            }
            FileUtils.copy((InputStream)fis, dest, -1L);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("FileUtils", "Could not close input stream on file " + source);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, OutputStream dest) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            FileUtils.copy((InputStream)fis, dest, -1L);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("FileUtils", "Could not close input stream on file " + source);
                }
            }
        }
    }

    public static void copy(byte[] source, OutputStream dest) throws IOException {
        dest.write(source, 0, source.length);
        dest.flush();
    }

    public static void copy(byte[] source, File dest) throws IOException {
        FileUtils.copy((InputStream)new ByteArrayInputStream(source), dest);
    }

    public static byte[] read(InputStream source) throws IOException {
        byte[] content;
        try {
            content = FileUtils.read(source, -1);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
        return content;
    }

    public static byte[] read(InputStream source, int count) throws IOException {
        if (count == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        FileUtils.copy(source, baos, (long)count);
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File source) throws IOException {
        byte[] buffer = new byte[(int)source.length()];
        FileInputStream fis = null;
        try {
            int c;
            fis = new FileInputStream(source);
            int p = 0;
            while ((c = ((InputStream)fis).read(buffer, p, buffer.length - p)) > 0) {
                p += c;
            }
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("FileUtils", "Could not close input stream on file " + source);
                }
            }
            fis = null;
        }
        return buffer;
    }

    public static byte[] uncompressGZipArray(byte[] source) throws IOException {
        block5: {
            if (source == null) {
                return null;
            }
            if (source.length > 1 && (source[1] << 8 | source[0] & 0xFF) == 35615) {
                System.out.println("DEBUG: uncompressGZipArray - uncompressing source");
                try {
                    ByteArrayInputStream byteInput = new ByteArrayInputStream(source);
                    ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(source.length / 5);
                    GZIPInputStream zippedContent = new GZIPInputStream(byteInput);
                    byte[] data = new byte[1024];
                    int read = 0;
                    while ((read = zippedContent.read(data, 0, 1024)) != -1) {
                        byteOutput.write(data, 0, read);
                    }
                    zippedContent.close();
                    byteOutput.close();
                    source = byteOutput.toByteArray();
                }
                catch (Exception e) {
                    if (e.getMessage().equals("Not in GZIP format")) break block5;
                    throw new IOException(e.getMessage());
                }
            }
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<String> loadList(File file) {
        HashSet<String> set = new HashSet<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                set.add(line.trim().toLowerCase());
            }
        }
        catch (IOException e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("FileUtils", "Could not close input stream on file " + file);
                }
            }
        }
        return set;
    }

    public static ConcurrentHashMap<String, String> loadMap(File f) {
        try {
            byte[] b = FileUtils.read(f);
            return FileUtils.table(FileUtils.strings(b));
        }
        catch (IOException e2) {
            ConcurrentLog.severe("FileUtils", f.toString() + " not found", e2);
            return null;
        }
    }

    public static ConcurrentHashMap<String, byte[]> loadMapB(File f) {
        ConcurrentHashMap<String, String> m = FileUtils.loadMap(f);
        if (m == null) {
            return null;
        }
        ConcurrentHashMap<String, byte[]> mb = new ConcurrentHashMap<String, byte[]>();
        for (Map.Entry<String, String> e : m.entrySet()) {
            mb.put(e.getKey(), UTF8.getBytes(e.getValue()));
        }
        return mb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMap(File file, Map<String, String> props, String comment) {
        boolean err = false;
        PrintWriter pw = null;
        File tf = new File(file.toString() + "." + System.currentTimeMillis() % 1000L);
        try {
            pw = new PrintWriter(tf, StandardCharsets.UTF_8.name());
            pw.println("# " + comment);
            for (Map.Entry<String, String> entry2 : props.entrySet()) {
                String value;
                String key = entry2.getKey();
                if (key != null) {
                    key = StringUtils.replaceEach((String)key, (String[])unescaped_strings_in, (String[])escaped_strings_out);
                }
                if (entry2.getValue() == null) {
                    value = "";
                } else {
                    value = entry2.getValue();
                    value = StringUtils.replaceEach((String)value, (String[])unescaped_strings_in, (String[])escaped_strings_out);
                }
                pw.println(key + "=" + value);
            }
            pw.println("# EOF");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            ConcurrentLog.warn("FileUtils", e.getMessage(), e);
            err = true;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            pw = null;
        }
        if (!err) {
            try {
                FileUtils.forceMove(tf, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void saveMapB(File file, Map<String, byte[]> props, String comment) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Map.Entry<String, byte[]> e : props.entrySet()) {
            m.put(e.getKey(), UTF8.String(e.getValue()));
        }
        FileUtils.saveMap(file, m, comment);
    }

    public static ConcurrentHashMap<String, String> table(Reader r) {
        BufferedReader br = new BufferedReader(r);
        return FileUtils.table(new StringsIterator(br));
    }

    public static ConcurrentHashMap<String, String> table(Iterator<String> li) {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>();
        while (li.hasNext()) {
            int pos = 0;
            String line = li.next().trim();
            if (!line.isEmpty() && line.charAt(0) == '#') continue;
            while ((pos = line.indexOf(61, pos + 1)) > 0 && line.charAt(pos - 1) == '\\') {
            }
            if (pos <= 0) continue;
            try {
                String key = StringUtils.replaceEach((String)line.substring(0, pos).trim(), (String[])escaped_strings_in, (String[])unescaped_strings_out);
                String value = StringUtils.replaceEach((String)line.substring(pos + 1).trim(), (String[])escaped_strings_in, (String[])unescaped_strings_out);
                props.put(key, value);
            }
            catch (IndexOutOfBoundsException e) {
                ConcurrentLog.logException(e);
            }
        }
        return props;
    }

    public static Map<String, String> table(byte[] a) {
        if (a == null) {
            return new ConcurrentHashMap<String, String>();
        }
        return FileUtils.table(FileUtils.strings(a));
    }

    public static Iterator<String> strings(byte[] a) {
        if (a == null) {
            return new ArrayList().iterator();
        }
        return new StringsIterator(new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(a), StandardCharsets.UTF_8)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getListArray(File listFile) {
        ArrayList<String> list2 = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(listFile), StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                list2.add(line);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("FileUtils", "Could not close input stream on file " + listFile);
                }
            }
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeList(File listFile, String out) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new PrintWriter(new FileWriter(listFile)));
            bw.write(out);
            bw.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getListString(File listFile, boolean withcomments) {
        StringBuilder temp = new StringBuilder(300);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(listFile)));
            temp.ensureCapacity((int)listFile.length());
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' && !withcomments) continue;
                temp.append(line).append('\r').append('\n');
            }
        }
        catch (IOException e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    ConcurrentLog.warn("FileUtils", "Could not close input stream on file " + listFile);
                }
            }
        }
        return new String(temp);
    }

    public static List<String> getDirListing(String dirname) {
        return FileUtils.getDirListing(dirname, null);
    }

    public static List<String> getDirListing(String dirname, String filter) {
        return FileUtils.getDirListing(new File(dirname), filter);
    }

    public static List<String> getDirListing(File dir) {
        return FileUtils.getDirListing(dir, null);
    }

    public static List<String> getDirListing(File dir, String filter) {
        LinkedList<String> ret = new LinkedList<String>();
        if (dir != null) {
            if (!dir.exists()) {
                dir.mkdir();
            }
            File[] fileList = dir.listFiles();
            for (int i = 0; i <= fileList.length - 1; ++i) {
                if (filter != null && !fileList[i].getName().matches(filter)) continue;
                ret.add(fileList[i].getName());
            }
            return ret;
        }
        return null;
    }

    public static ArrayList<File> getDirsRecursive(File dir, String notdir) {
        return FileUtils.getDirsRecursive(dir, notdir, true);
    }

    public static List<File> getFilesRecursive(File sourceDir, String notdir, FilenameFilter fileNameFilter) {
        ArrayList<File> dirList = FileUtils.getDirsRecursive(sourceDir, notdir);
        dirList.add(sourceDir);
        ArrayList<File> files = new ArrayList<File>();
        for (File dir : dirList) {
            Collections.addAll(files, dir.listFiles(fileNameFilter));
        }
        return files;
    }

    private static ArrayList<File> getDirsRecursive(File dir, String notdir, boolean excludeDotfiles) {
        File[] dirList = dir.listFiles();
        ArrayList<File> resultList = new ArrayList<File>();
        for (int i = 0; i < dirList.length; ++i) {
            if (!dirList[i].isDirectory() || excludeDotfiles && dirList[i].getName().startsWith(".") || dirList[i].getName().equals(notdir)) continue;
            resultList.add(dirList[i]);
            ArrayList<File> recursive = FileUtils.getDirsRecursive(dirList[i], notdir, excludeDotfiles);
            Iterator<File> iter = recursive.iterator();
            while (iter.hasNext()) {
                resultList.add(iter.next());
            }
        }
        return resultList;
    }

    public static boolean writeList(File listFile, String[] list2) {
        StringBuilder out = new StringBuilder(list2.length * 40 + 1);
        for (String element : list2) {
            out.append(element).append('\r').append('\n');
        }
        return FileUtils.writeList(listFile, new String(out));
    }

    private static void forceMove(File from, File to) throws IOException {
        if (!to.delete() || !from.renameTo(to)) {
            Files.copy(from, to);
            FileUtils.deletedelete(from);
        }
    }

    public static final File createTempFile(Class<?> classObj, String name) throws IOException {
        String parserClassName = classObj.getName();
        int idx2 = parserClassName.lastIndexOf(46);
        if (idx2 != -1) {
            parserClassName = parserClassName.substring(idx2 + 1);
        }
        String fileName = (idx2 = name.lastIndexOf(47)) != -1 ? name.substring(idx2 + 1) : name;
        idx2 = fileName.lastIndexOf(46);
        String fileExt = idx2 > -1 ? fileName.substring(idx2 + 1) : "";
        File tempFile = File.createTempFile(parserClassName + "_" + (idx2 > -1 ? fileName.substring(0, idx2) : fileName), (String)(!fileExt.isEmpty() ? "." + fileExt : fileExt));
        return tempFile;
    }

    public static void deletedelete(File path) {
        String[] list2;
        if (path == null || !path.exists()) {
            return;
        }
        if (path.isDirectory() && (list2 = path.list()) != null) {
            for (String s : list2) {
                FileUtils.deletedelete(new File(path, s));
            }
        }
        if (path.exists()) {
            path.delete();
        }
        if (path.exists()) {
            path.deleteOnExit();
            String p = "";
            try {
                p = path.getCanonicalPath();
            }
            catch (IOException e1) {
                ConcurrentLog.logException(e1);
            }
            if (System.getProperties().getProperty("os.name", "").toLowerCase().startsWith("windows")) {
                try {
                    String command = "cmd /C del /F /Q \"" + p + "\"";
                    Process r = Runtime.getRuntime().exec(command);
                    if (r == null) {
                        ConcurrentLog.severe("FileUtils", "cannot execute command: " + command);
                    } else {
                        byte[] response = FileUtils.read(r.getInputStream());
                        ConcurrentLog.info("FileUtils", "deletedelete: " + UTF8.String(response));
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            if (path.exists()) {
                ConcurrentLog.severe("FileUtils", "cannot delete file " + p);
            }
        }
    }

    public static boolean isInDirectory(File file, File directory) {
        boolean inDirectory;
        try {
            inDirectory = directory != null && directory.isDirectory() && file != null && file.isFile() && directory.getCanonicalPath().equalsIgnoreCase(file.getParentFile().getCanonicalPath());
        }
        catch (IOException e) {
            inDirectory = false;
        }
        return inDirectory;
    }

    public static List<String> detectCharset(InputStream inStream) throws IOException {
        int len;
        nsDetector det = new nsDetector(0);
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        while ((len = inStream.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        ArrayList<String> result = new ArrayList<String>();
        if (isAscii) {
            result.add(StandardCharsets.US_ASCII.name());
        } else {
            for (String c : det.getProbableCharsets()) {
                result.add(c);
            }
        }
        return result;
    }

    public static void checkCharset(final File file, final String givenCharset, boolean concurrent) {
        Thread t = new Thread("FileUtils.checkCharset"){

            @Override
            public void run() {
                try (FileInputStream fileStream = new FileInputStream(file);
                     BufferedInputStream imp = new BufferedInputStream(fileStream);){
                    List<String> charsets = FileUtils.detectCharset(imp);
                    if (charsets.contains(givenCharset)) {
                        ConcurrentLog.info("checkCharset", "appropriate charset '" + givenCharset + "' for import of " + file + ", is part one detected " + charsets);
                    } else {
                        ConcurrentLog.warn("checkCharset", "possibly wrong charset '" + givenCharset + "' for import of " + file + ", use one of " + charsets);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        if (concurrent) {
            t.start();
        } else {
            t.run();
        }
    }

    private static class StringsIterator
    implements Iterator<String> {
        private BufferedReader reader;
        private String nextLine;

        private StringsIterator(BufferedReader reader) {
            this.reader = reader;
            this.nextLine = null;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public String next() {
            String line = this.nextLine;
            if (this.reader != null) {
                try {
                    while ((this.nextLine = this.reader.readLine()) != null) {
                        this.nextLine = this.nextLine.trim();
                        if (this.nextLine.isEmpty()) continue;
                        break;
                    }
                }
                catch (IOException e) {
                    this.nextLine = null;
                }
                catch (OutOfMemoryError e) {
                    ConcurrentLog.logException(e);
                    this.nextLine = null;
                }
            }
            if (this.nextLine == null && this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.reader = null;
                }
            }
            return line;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

