/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.sorting.Rating;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.HeapWriter;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.AbstractIndex;
import net.yacy.kelondro.rwi.Index;
import net.yacy.kelondro.rwi.IndexReader;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceFactory;
import net.yacy.kelondro.util.FileUtils;

public final class ReferenceContainerCache<ReferenceType extends Reference>
extends AbstractIndex<ReferenceType>
implements Index<ReferenceType>,
IndexReader<ReferenceType>,
Iterable<ReferenceContainer<ReferenceType>> {
    private static final ConcurrentLog log = new ConcurrentLog("ReferenceContainerCache");
    private final int termSize;
    private final ByteOrder termOrder;
    private final ContainerOrder<ReferenceType> containerOrder;
    private ConcurrentHashMap<ByteArray, ReferenceContainer<ReferenceType>> cache;

    public ReferenceContainerCache(ReferenceFactory<ReferenceType> factory, ByteOrder termOrder, int termSize) {
        super(factory);
        assert (termOrder != null);
        this.termOrder = termOrder;
        this.termSize = termSize;
        this.containerOrder = new ContainerOrder(this.termOrder);
        this.cache = new ConcurrentHashMap();
    }

    public Row rowdef() {
        return this.factory.getRow();
    }

    @Override
    public int termKeyLength() {
        return this.termSize;
    }

    @Override
    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public synchronized void close() {
        this.cache = null;
    }

    public Iterator<ByteArray> keys() {
        return ((ConcurrentHashMap.KeySetView)this.cache.keySet()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(File heapFile, int writeBuffer, boolean destructive) {
        HeapWriter dump;
        assert (this.cache != null);
        if (this.cache == null) {
            return;
        }
        log.info("creating rwi heap dump '" + heapFile.getName() + "', " + this.cache.size() + " rwi's");
        if (heapFile.exists()) {
            FileUtils.deletedelete(heapFile);
        }
        File tmpFile = new File(heapFile.getParentFile(), heapFile.getName() + ".prt");
        try {
            dump = new HeapWriter(tmpFile, heapFile, this.termSize, this.termOrder, writeBuffer);
        }
        catch (IOException e1) {
            ConcurrentLog.logException(e1);
            return;
        }
        long startTime = System.currentTimeMillis();
        List<ReferenceContainer<ReferenceType>> cachecopy = this.sortedClone();
        long wordcount = 0L;
        long urlcount = 0L;
        byte[] term = null;
        assert (this.termKeyOrdering() != null);
        for (ReferenceContainer<ReferenceType> container : cachecopy) {
            byte[] lwh = term;
            term = container.getTermHash();
            if (term == null) continue;
            assert (lwh == null || this.termKeyOrdering().compare(term, lwh) > 0);
            if (container != null && term.length == this.termSize) {
                try {
                    dump.add(term, container.exportCollection());
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
                if (destructive) {
                    container.clear();
                }
                urlcount += (long)container.size();
            }
            ++wordcount;
        }
        try {
            dump.close(true);
            log.info("finished rwi heap dump: " + wordcount + " terms, " + urlcount + " term/data relations in " + (System.currentTimeMillis() - startTime) + " milliseconds");
        }
        catch (IOException e) {
            log.severe("failed rwi heap dump: " + e.getMessage(), e);
        }
        finally {
            dump = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceContainer<ReferenceType>> sortedClone() {
        ArrayList<ReferenceContainer<ReferenceType>> cachecopy = new ArrayList<ReferenceContainer<ReferenceType>>(this.cache.size());
        ConcurrentHashMap<ByteArray, ReferenceContainer<ReferenceType>> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            for (Map.Entry<ByteArray, ReferenceContainer<ReferenceType>> entry2 : this.cache.entrySet()) {
                if (entry2.getValue() == null || entry2.getValue().getTermHash() == null) continue;
                cachecopy.add(entry2.getValue());
            }
        }
        Collections.sort(cachecopy, this.containerOrder);
        return cachecopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Rating<ByteArray>> ratingList() {
        ArrayList<Rating<ByteArray>> list2 = new ArrayList<Rating<ByteArray>>(this.cache.size());
        ConcurrentHashMap<ByteArray, ReferenceContainer<ReferenceType>> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            for (Map.Entry<ByteArray, ReferenceContainer<ReferenceType>> entry2 : this.cache.entrySet()) {
                if (entry2.getValue() == null || entry2.getValue().getTermHash() == null) continue;
                list2.add(new Rating<ByteArray>(entry2.getKey(), entry2.getValue().size()));
            }
        }
        return list2;
    }

    @Override
    public int size() {
        return this.cache == null ? 0 : this.cache.size();
    }

    public long usedMemory() {
        if (this.cache == null) {
            return 0L;
        }
        long b = 0L;
        for (Map.Entry<ByteArray, ReferenceContainer<ReferenceType>> e : this.cache.entrySet()) {
            b += e.getKey().usedMemory();
            b += e.getValue().mem();
        }
        return b;
    }

    public boolean isEmpty() {
        if (this.cache == null) {
            return true;
        }
        return this.cache.isEmpty();
    }

    public int maxReferences() {
        int max = 0;
        for (ReferenceContainer<ReferenceType> container : this.cache.values()) {
            if (container.size() <= max) continue;
            max = container.size();
        }
        return max;
    }

    @Override
    public Iterator<ReferenceContainer<ReferenceType>> iterator() {
        return this.referenceContainerIterator(null, false, false);
    }

    @Override
    public synchronized CloneableIterator<ReferenceContainer<ReferenceType>> referenceContainerIterator(byte[] startWordHash, boolean rot, boolean excludePrivate) {
        return new ReferenceContainerIterator(startWordHash, rot, excludePrivate);
    }

    @Override
    public CloneableIterator<Rating<byte[]>> referenceCountIterator(byte[] startHash, boolean rot, boolean excludePrivate) {
        return new ReferenceCountIterator(startHash, rot, excludePrivate);
    }

    @Override
    public boolean has(byte[] key) {
        return this.cache.containsKey(new ByteArray(key));
    }

    @Override
    public ReferenceContainer<ReferenceType> get(byte[] key, HandleSet urlselection) {
        if (this.cache == null) {
            return null;
        }
        ReferenceContainer<ReferenceType> c = this.cache.get(new ByteArray(key));
        if (urlselection == null) {
            return c;
        }
        if (c == null) {
            return null;
        }
        try {
            ReferenceContainer c1 = new ReferenceContainer(this.factory, c.getTermHash(), c.size());
            Iterator<ReferenceType> e = c.entries();
            while (e.hasNext()) {
                Reference ee = (Reference)e.next();
                if (!urlselection.has(ee.urlhash())) continue;
                c1.add(ee);
            }
            return c1;
        }
        catch (SpaceExceededException e2) {
            ConcurrentLog.logException(e2);
            return null;
        }
    }

    @Override
    public int count(byte[] key) {
        ReferenceContainer<ReferenceType> c = this.cache.get(new ByteArray(key));
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    public ReferenceContainer<ReferenceType> remove(byte[] termHash) {
        assert (this.cache != null);
        if (this.cache == null) {
            return null;
        }
        return this.cache.remove(new ByteArray(termHash));
    }

    @Override
    public void delete(byte[] termHash) {
        assert (this.cache != null);
        if (this.cache == null) {
            return;
        }
        this.cache.remove(new ByteArray(termHash));
    }

    @Override
    public void removeDelayed(byte[] termHash, byte[] urlHashBytes) {
        this.remove(termHash, urlHashBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(byte[] termHash, byte[] urlHashBytes) {
        assert (this.cache != null);
        if (this.cache == null) {
            return false;
        }
        ByteArray tha = new ByteArray(termHash);
        ConcurrentHashMap<ByteArray, ReferenceContainer<ReferenceType>> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            ReferenceContainer<ReferenceType> c = this.cache.get(tha);
            if (c != null && c.delete(urlHashBytes)) {
                if (c.isEmpty()) {
                    this.delete(termHash);
                } else {
                    this.cache.put(tha, c);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(byte[] termHash, HandleSet urlHashes) {
        assert (this.cache != null);
        if (this.cache == null) {
            return 0;
        }
        if (urlHashes.isEmpty()) {
            return 0;
        }
        ByteArray tha = new ByteArray(termHash);
        ConcurrentHashMap<ByteArray, ReferenceContainer<ReferenceType>> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            int count;
            ReferenceContainer<ReferenceType> c = this.cache.get(tha);
            if (c != null && (count = c.removeEntries(urlHashes)) > 0) {
                if (c.isEmpty()) {
                    this.delete(termHash);
                } else {
                    this.cache.put(tha, c);
                }
                return count;
            }
        }
        return 0;
    }

    @Override
    public void removeDelayed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ReferenceContainer<ReferenceType> container) throws SpaceExceededException {
        if (this.cache == null || container == null || container.isEmpty()) {
            return;
        }
        ByteArray tha = new ByteArray(container.getTermHash());
        int added = 0;
        ConcurrentHashMap<ByteArray, ReferenceContainer<ReferenceType>> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            ReferenceContainer<ReferenceType> entries2 = this.cache.get(tha);
            if (entries2 == null) {
                entries2 = container.topLevelClone();
                added = entries2.size();
            } else {
                added = entries2.putAllRecent(container);
            }
            if (added > 0) {
                this.cache.put(tha, entries2);
            }
            entries2 = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(byte[] termHash, ReferenceType newEntry) throws SpaceExceededException {
        assert (this.cache != null);
        if (this.cache == null) {
            return;
        }
        ByteArray tha = new ByteArray(termHash);
        ReferenceContainer<ReferenceType> container = this.cache.remove(tha);
        if (container == null) {
            container = new ReferenceContainer(this.factory, termHash, 1);
        }
        container.put((Reference)newEntry);
        ReferenceContainer<ReferenceType> container0 = this.cache.put(tha, container);
        if (container0 != null) {
            ConcurrentHashMap<ByteArray, ReferenceContainer<ReferenceType>> concurrentHashMap = this.cache;
            synchronized (concurrentHashMap) {
                ReferenceContainer<ReferenceType> containerNew = this.cache.put(tha, container0);
                if (containerNew == null) {
                    return;
                }
                if (container0 == containerNew) {
                    return;
                }
                if (container0.size() >= containerNew.size()) {
                    container0.putAllRecent(containerNew);
                    this.cache.put(tha, container0);
                } else {
                    containerNew.putAllRecent(container0);
                    this.cache.put(tha, containerNew);
                }
            }
        }
    }

    @Override
    public int minMem() {
        return 0;
    }

    @Override
    public ByteOrder termKeyOrdering() {
        return this.termOrder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.cache.size() * 13 + 2);
        sb.append('[');
        for (ByteArray k : this.cache.keySet()) {
            sb.append(ASCII.String(k.asBytes())).append(',');
        }
        if (sb.length() == 1) {
            sb.append(']');
        } else {
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }

    public static class ContainerOrder<ReferenceType extends Reference>
    implements Comparator<ReferenceContainer<ReferenceType>> {
        private final ByteOrder o;

        public ContainerOrder(ByteOrder order) {
            this.o = order;
        }

        @Override
        public int compare(ReferenceContainer<ReferenceType> arg0, ReferenceContainer<ReferenceType> arg1) {
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return this.o.compare(arg0.getTermHash(), arg1.getTermHash());
        }
    }

    public class ReferenceContainerIterator
    implements CloneableIterator<ReferenceContainer<ReferenceType>>,
    Iterable<ReferenceContainer<ReferenceType>> {
        private final boolean rot;
        private final boolean excludePrivate;
        private final List<ReferenceContainer<ReferenceType>> cachecopy;
        private int p;
        private byte[] latestTermHash;

        public ReferenceContainerIterator(byte[] startWordHash, boolean rot, boolean excludePrivate) {
            this.rot = rot;
            this.excludePrivate = excludePrivate;
            if (startWordHash != null && startWordHash.length == 0) {
                startWordHash = null;
            }
            this.cachecopy = ReferenceContainerCache.this.sortedClone();
            assert (this.cachecopy != null);
            assert (ReferenceContainerCache.this.termOrder != null);
            this.p = 0;
            if (startWordHash != null) {
                byte[] b;
                while (!(this.p >= this.cachecopy.size() || ReferenceContainerCache.this.termOrder.compare(b = this.cachecopy.get(this.p).getTermHash(), startWordHash) >= 0 || excludePrivate && Word.isPrivate(b))) {
                    ++this.p;
                }
            }
            this.latestTermHash = null;
        }

        public ReferenceContainerIterator clone(Object secondWordHash) {
            return new ReferenceContainerIterator((byte[])secondWordHash, this.rot, this.excludePrivate);
        }

        @Override
        public boolean hasNext() {
            if (this.rot) {
                return !this.cachecopy.isEmpty();
            }
            return this.p < this.cachecopy.size();
        }

        @Override
        public ReferenceContainer<ReferenceType> next() {
            ReferenceContainer c;
            while (this.p < this.cachecopy.size()) {
                c = this.cachecopy.get(this.p++);
                this.latestTermHash = c.getTermHash();
                if (this.excludePrivate && Word.isPrivate(this.latestTermHash)) continue;
                try {
                    return c.topLevelClone();
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    return null;
                }
            }
            if (!this.rot) {
                return null;
            }
            if (this.cachecopy.isEmpty()) {
                return null;
            }
            this.p = 0;
            while (this.p < this.cachecopy.size()) {
                c = this.cachecopy.get(this.p++);
                this.latestTermHash = c.getTermHash();
                if (this.excludePrivate && Word.isPrivate(this.latestTermHash)) continue;
                try {
                    return c.topLevelClone();
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    return null;
                }
            }
            return null;
        }

        @Override
        public void remove() {
            System.arraycopy(this.cachecopy, this.p, this.cachecopy, this.p - 1, this.cachecopy.size() - this.p);
            ReferenceContainerCache.this.cache.remove(new ByteArray(this.latestTermHash));
        }

        @Override
        public Iterator<ReferenceContainer<ReferenceType>> iterator() {
            return this;
        }

        @Override
        public void close() {
        }
    }

    public class ReferenceCountIterator
    implements CloneableIterator<Rating<byte[]>>,
    Iterable<Rating<byte[]>> {
        private final boolean rot;
        private final boolean excludePrivate;
        private final List<Rating<ByteArray>> cachecounts;
        private int p;
        private byte[] latestTermHash;

        public ReferenceCountIterator(byte[] startWordHash, boolean rot, boolean excludePrivate) {
            this.rot = rot;
            this.excludePrivate = excludePrivate;
            if (startWordHash != null && startWordHash.length == 0) {
                startWordHash = null;
            }
            this.cachecounts = ReferenceContainerCache.this.ratingList();
            assert (this.cachecounts != null);
            assert (ReferenceContainerCache.this.termOrder != null);
            this.p = 0;
            if (startWordHash != null) {
                byte[] b;
                while (!(this.p >= this.cachecounts.size() || ReferenceContainerCache.this.termOrder.compare(b = this.cachecounts.get(this.p).getObject().asBytes(), startWordHash) >= 0 || excludePrivate && Word.isPrivate(b))) {
                    ++this.p;
                }
            }
            this.latestTermHash = null;
        }

        public ReferenceCountIterator clone(Object secondWordHash) {
            return new ReferenceCountIterator((byte[])secondWordHash, this.rot, this.excludePrivate);
        }

        @Override
        public boolean hasNext() {
            if (this.rot) {
                return !this.cachecounts.isEmpty();
            }
            return this.p < this.cachecounts.size();
        }

        @Override
        public Rating<byte[]> next() {
            Rating<ByteArray> c;
            while (this.p < this.cachecounts.size()) {
                c = this.cachecounts.get(this.p++);
                this.latestTermHash = c.getObject().asBytes();
                if (this.excludePrivate && Word.isPrivate(this.latestTermHash)) continue;
                return new Rating<byte[]>(c.getObject().asBytes(), c.getScore());
            }
            if (!this.rot) {
                return null;
            }
            if (this.cachecounts.isEmpty()) {
                return null;
            }
            this.p = 0;
            while (this.p < this.cachecounts.size()) {
                c = this.cachecounts.get(this.p++);
                this.latestTermHash = c.getObject().asBytes();
                if (this.excludePrivate && Word.isPrivate(this.latestTermHash)) continue;
                return new Rating<byte[]>(c.getObject().asBytes(), c.getScore());
            }
            return null;
        }

        @Override
        public void remove() {
            System.arraycopy(this.cachecounts, this.p, this.cachecounts, this.p - 1, this.cachecounts.size() - this.p);
            ReferenceContainerCache.this.cache.remove(new ByteArray(this.latestTermHash));
        }

        @Override
        public Iterator<Rating<byte[]>> iterator() {
            return this;
        }

        @Override
        public void close() {
        }
    }
}

