/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.util.Iterator;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.rwi.Reference;

public abstract class AbstractReference
implements Reference {
    @Override
    public int distance() {
        if (this.positions() == null || this.positions().isEmpty()) {
            return 0;
        }
        int d = 0;
        Iterator<Integer> i = this.positions().iterator();
        int s0 = this.posintext();
        while (i.hasNext()) {
            int s1 = i.next();
            if (s0 > 0) {
                d += Math.abs(s0 - s1);
            }
            s0 = s1;
        }
        try {
            return d == 0 ? 0 : d / this.positions().size();
        }
        catch (ArithmeticException ex) {
            ConcurrentLog.fine("AbstractReference", "word distance calculation:" + ex.getMessage());
            return 0;
        }
    }

    @Override
    public boolean isOlder(Reference other) {
        if (other == null) {
            return false;
        }
        return this.lastModified() < other.lastModified();
    }
}

