/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public final class SimpleLogFormatter
extends SimpleFormatter {
    public static final int LOGLEVEL_ZERO = Level.OFF.intValue();
    public static final int LOGLEVEL_SEVERE = Level.SEVERE.intValue();
    public static final int LOGLEVEL_WARNING = Level.WARNING.intValue();
    public static final int LOGLEVEL_CONFIG = Level.CONFIG.intValue();
    public static final int LOGLEVEL_INFO = Level.INFO.intValue();
    public static final int LOGLEVEL_FINE = Level.FINE.intValue();
    public static final int LOGLEVEL_FINER = Level.FINER.intValue();
    public static final int LOGLEVEL_FINEST = Level.FINEST.intValue();
    public static final char LOGTOKEN_ZERO = 'Z';
    public static final char LOGTOKEN_SEVERE = 'E';
    public static final char LOGTOKEN_WARNING = 'W';
    public static final char LOGTOKEN_CONFIG = 'S';
    public static final char LOGTOKEN_INFO = 'I';
    public static final char LOGTOKEN_FINE = 'D';
    public static final char LOGTOKEN_FINER = 'D';
    public static final char LOGTOKEN_FINEST = 'D';
    private final Date date = new Date();
    private final FieldPosition position = new FieldPosition(0);
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US);
    private final StringBuffer buffer = new StringBuffer(80);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized String format(LogRecord record) {
        StringBuffer stringBuffer = this.buffer;
        stringBuffer.setLength(0);
        int logLevel = record.getLevel().intValue();
        if (logLevel == LOGLEVEL_SEVERE) {
            this.buffer.append('E');
        } else if (logLevel == LOGLEVEL_WARNING) {
            this.buffer.append('W');
        } else if (logLevel == LOGLEVEL_CONFIG) {
            this.buffer.append('S');
        } else if (logLevel == LOGLEVEL_INFO) {
            this.buffer.append('I');
        } else if (logLevel == LOGLEVEL_FINE) {
            this.buffer.append('D');
        } else if (logLevel == LOGLEVEL_FINER) {
            this.buffer.append('D');
        } else if (logLevel == LOGLEVEL_FINEST) {
            this.buffer.append('D');
        } else {
            this.buffer.append('D');
        }
        this.buffer.append(' ');
        this.date.setTime(record.getMillis());
        this.position.setBeginIndex(0);
        this.formatter.format(this.date, this.buffer, this.position);
        stringBuffer.append(' ');
        stringBuffer.append(record.getLoggerName());
        stringBuffer.append(' ');
        stringBuffer.append(this.formatMessage(record));
        stringBuffer.append(System.getProperty("line.separator"));
        if (record.getThrown() != null) {
            StringWriter writer = null;
            try {
                writer = new StringWriter();
                PrintWriter printer = new PrintWriter(writer);
                record.getThrown().printStackTrace(printer);
                stringBuffer.append(writer.toString());
            }
            catch (Exception e) {
                stringBuffer.append("Failed to get stack trace: ").append(e.getMessage());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return stringBuffer.toString();
    }
}

