/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.logging;

import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import net.yacy.kelondro.logging.LogParser;

public final class LogalizerHandler
extends Handler {
    private static boolean enabled;
    private static boolean debug;

    public LogalizerHandler() {
        LogManager manager = LogManager.getLogManager();
        String className = this.getClass().getName();
        enabled = "true".equalsIgnoreCase(manager.getProperty(className + ".enabled"));
        debug = "true".equalsIgnoreCase(manager.getProperty(className + ".debug"));
    }

    @Override
    public final void publish(LogRecord record) {
        LogParser temp;
        if (enabled && (temp = new LogParser()) != null) {
            try {
                int returnV = temp.parse(record.getLevel().toString(), record.getMessage());
                if (debug) {
                    System.out.println("Logalizertest: " + returnV + " --- " + record.getLevel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.flush();
    }

    public static final Map<String, Object> getParserResults(LogParser parsername) {
        return parsername == null ? null : parsername.getResults();
    }

    @Override
    public final void close() throws SecurityException {
    }

    @Override
    public final void flush() {
    }
}

