/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.OnDemandOpenFileIndex;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.util.MergeIterator;

public class BufferedObjectIndex
implements Index,
Iterable<Row.Entry> {
    private final Index backend;
    private final RowSet buffer;
    private final int buffersize;
    private final Row.EntryComparator entryComparator;

    public BufferedObjectIndex(Index backend, int buffersize) {
        this.backend = backend;
        this.buffersize = buffersize;
        this.buffer = new RowSet(backend.row());
        this.entryComparator = new Row.EntryComparator(backend.row().objectOrder);
    }

    public boolean isOnDemand() {
        return this.backend instanceof OnDemandOpenFileIndex;
    }

    @Override
    public byte[] smallestKey() {
        if (this.buffer == null || this.buffer.isEmpty()) {
            return this.backend.smallestKey();
        }
        if (this.backend.isEmpty()) {
            return this.buffer.smallestKey();
        }
        return this.backend.row().getOrdering().smallest(this.buffer.smallestKey(), this.backend.smallestKey());
    }

    @Override
    public byte[] largestKey() {
        if (this.buffer == null || this.buffer.isEmpty()) {
            return this.backend.largestKey();
        }
        if (this.backend.isEmpty()) {
            return this.buffer.largestKey();
        }
        return this.backend.row().getOrdering().largest(this.buffer.largestKey(), this.backend.largestKey());
    }

    private final void flushBuffer() throws IOException, SpaceExceededException {
        if (!this.buffer.isEmpty()) {
            if (this.backend instanceof OnDemandOpenFileIndex) {
                ((OnDemandOpenFileIndex)this.backend).put(this.buffer);
            } else {
                for (Row.Entry e : this.buffer) {
                    this.backend.put(e);
                }
            }
            this.buffer.clear();
        }
    }

    @Override
    public void optimize() {
        this.backend.optimize();
        this.buffer.optimize();
    }

    @Override
    public long mem() {
        return this.backend.mem() + this.buffer.mem();
    }

    private final void checkBuffer() throws IOException, SpaceExceededException {
        if (this.buffer.size() >= this.buffersize) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnique(Row.Entry row) throws SpaceExceededException, IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            this.checkBuffer();
            this.buffer.put(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            this.backend.clear();
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Index index2 = this.backend;
        synchronized (index2) {
            try {
                this.flushBuffer();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
            this.backend.close();
        }
    }

    @Override
    public void deleteOnExit() {
        this.backend.deleteOnExit();
    }

    @Override
    public String filename() {
        return this.backend.filename();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Index index2 = this.backend;
        synchronized (index2) {
            return this.buffer.size() + this.backend.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry get(byte[] key, boolean forcecopy) throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            Row.Entry entry2 = this.buffer.get(key, forcecopy);
            if (entry2 != null) {
                return entry2;
            }
            return this.backend.get(key, forcecopy);
        }
    }

    @Override
    public Map<byte[], Row.Entry> get(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(byte[] key) {
        Index index2 = this.backend;
        synchronized (index2) {
            return this.buffer.has(key) || this.backend.has(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Index index2 = this.backend;
        synchronized (index2) {
            return this.buffer.isEmpty() && this.backend.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Row.Entry row) throws IOException, SpaceExceededException {
        Index index2 = this.backend;
        synchronized (index2) {
            this.checkBuffer();
            return this.buffer.put(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry remove(byte[] key) throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            Row.Entry entry2 = this.buffer.remove(key);
            if (entry2 != null) {
                return entry2;
            }
            return this.backend.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(byte[] key) throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            boolean b = this.buffer.delete(key);
            if (b) {
                return true;
            }
            return this.backend.delete(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RowCollection> removeDoubles() throws IOException, SpaceExceededException {
        Index index2 = this.backend;
        synchronized (index2) {
            this.flushBuffer();
            return this.backend.removeDoubles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row.Entry> top(int count) throws IOException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        Index index2 = this.backend;
        synchronized (index2) {
            List<Row.Entry> list0 = this.buffer.top(count);
            list2.addAll(list0);
            list0 = this.backend.top(count - list2.size());
            list2.addAll(list0);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row.Entry> random(int count) throws IOException {
        List<Row.Entry> list1;
        List<Row.Entry> list0;
        Index index2 = this.backend;
        synchronized (index2) {
            list0 = this.buffer.random(Math.max(1, count / 2));
            list1 = this.backend.random(count - list0.size());
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        Iterator<Row.Entry> i0 = list0.iterator();
        Iterator<Row.Entry> i1 = list1.iterator();
        while (i0.hasNext() || i1.hasNext()) {
            if (i0.hasNext()) {
                list2.add(i0.next());
            }
            if (!i1.hasNext()) continue;
            list2.add(i1.next());
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry removeOne() throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            Row.Entry entry2;
            if (!this.buffer.isEmpty() && (entry2 = this.buffer.removeOne()) != null) {
                return entry2;
            }
            return this.backend.removeOne();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row.Entry replace(Row.Entry row) throws SpaceExceededException, IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            Row.Entry entry2 = this.buffer.replace(row);
            if (entry2 != null) {
                return entry2;
            }
            return this.backend.replace(row);
        }
    }

    @Override
    public Row row() {
        return this.buffer.row();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            CloneableIterator<byte[]> a = this.buffer.keys(up, firstKey);
            CloneableIterator<byte[]> b = this.backend.keys(up, firstKey);
            if (b == null) {
                return a;
            }
            if (a == null) {
                return b;
            }
            return new MergeIterator<byte[]>(a, b, this.buffer.rowdef.getOrdering(), MergeIterator.simpleMerge, up);
        }
    }

    @Override
    public Iterator<Row.Entry> iterator() {
        try {
            return this.rows();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            return new MergeIterator<Row.Entry>(this.buffer.rows(up, firstKey), this.backend.rows(up, firstKey), this.entryComparator, MergeIterator.simpleMerge, up);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneableIterator<Row.Entry> rows() throws IOException {
        Index index2 = this.backend;
        synchronized (index2) {
            return new MergeIterator<Row.Entry>(this.buffer.rows(), this.backend.rows(), this.entryComparator, MergeIterator.simpleMerge, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandleSet keysFromBuffer(int load) throws IOException {
        if (load > this.buffersize) {
            throw new IOException("buffer load size exceeded");
        }
        Index index2 = this.backend;
        synchronized (index2) {
            int missing = Math.min(this.backend.size(), load - this.buffer.size());
            while (missing-- > 0) {
                try {
                    this.buffer.put(this.backend.removeOne());
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    break;
                }
            }
            RowHandleSet handles = new RowHandleSet(this.buffer.row().primaryKeyLength, this.buffer.row().objectOrder, this.buffer.size());
            Iterator<byte[]> i = this.buffer.keys();
            while (i.hasNext()) {
                try {
                    handles.put(i.next());
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    break;
                }
            }
            handles.optimize();
            return handles;
        }
    }
}

