/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.word;

import java.util.Collection;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.yacy.cora.date.MicroDate;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.AbstractReference;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.workflow.WorkflowProcessor;

public class WordReferenceVars
extends AbstractReference
implements WordReference,
Reference,
Cloneable,
Comparable<WordReferenceVars>,
Comparator<WordReferenceVars> {
    public static final WordReferenceVars poison = new WordReferenceVars();
    protected static final byte[] default_language = UTF8.getBytes("en");
    private final Bitfield flags;
    private long lastModified;
    private final String language;
    public final byte[] urlHash;
    private String hostHash = null;
    private final char type;
    private int hitcount;
    private int llocal;
    private int lother;
    private int phrasesintext;
    private int posintext;
    private int posinphrase;
    private int posofphrase;
    private int urlcomps;
    private int urllength;
    private int wordsintext;
    private int wordsintitle;
    private int distance;
    private int virtualAge;
    private Queue<Integer> positions;
    private double termFrequency;
    private final boolean local;
    private int hashCache = Integer.MIN_VALUE;

    public WordReferenceVars(byte[] urlHash, int urlLength, int urlComps, int titleLength, int hitcount, int wordcount, int phrasecount, int posintext, Queue<Integer> ps, int posinphrase, int posofphrase, long lastmodified, String language, char doctype, int outlinksSame, int outlinksOther, Bitfield flags, double termfrequency) {
        this.flags = flags;
        this.lastModified = lastmodified;
        this.language = language;
        this.urlHash = urlHash;
        this.type = doctype;
        this.hitcount = hitcount;
        this.llocal = outlinksSame;
        this.lother = outlinksOther;
        this.phrasesintext = phrasecount;
        if (ps != null && !ps.isEmpty()) {
            this.positions = new LinkedBlockingQueue<Integer>();
            for (Integer i : ps) {
                this.positions.add(i);
            }
        } else {
            this.positions = null;
        }
        this.distance = 0;
        this.posinphrase = posinphrase;
        this.posintext = posintext;
        this.posofphrase = posofphrase;
        this.urlcomps = urlComps;
        this.urllength = urlLength;
        this.virtualAge = -1;
        this.wordsintext = wordcount;
        this.wordsintitle = titleLength;
        this.termFrequency = termfrequency;
        this.local = true;
    }

    public WordReferenceVars(WordReference e, boolean local) {
        this.flags = e.flags();
        this.lastModified = e.lastModified();
        this.language = ASCII.String(e.getLanguage());
        this.urlHash = e.urlhash();
        this.type = e.getType();
        this.hitcount = e.hitcount();
        this.llocal = e.llocal();
        this.lother = e.lother();
        this.phrasesintext = e.phrasesintext();
        if (e.positions() != null && !e.positions().isEmpty()) {
            this.positions = new LinkedBlockingQueue<Integer>();
            for (Integer i : e.positions()) {
                this.positions.add(i);
            }
        } else {
            this.positions = null;
        }
        this.distance = e.distance();
        this.posinphrase = e.posinphrase();
        this.posintext = e.posintext();
        this.posofphrase = e.posofphrase();
        this.urlcomps = e.urlcomps();
        this.urllength = e.urllength();
        this.virtualAge = e.virtualAge();
        this.wordsintext = e.wordsintext();
        this.wordsintitle = e.wordsintitle();
        this.termFrequency = e.termFrequency();
        this.local = local;
    }

    private WordReferenceVars() {
        this.flags = null;
        this.lastModified = 0L;
        this.language = null;
        this.urlHash = null;
        this.type = (char)32;
        this.hitcount = 0;
        this.llocal = 0;
        this.lother = 0;
        this.phrasesintext = 0;
        this.positions = null;
        this.distance = 0;
        this.posinphrase = 0;
        this.posintext = 0;
        this.posofphrase = 0;
        this.urlcomps = 0;
        this.urllength = 0;
        this.virtualAge = 0;
        this.wordsintext = 0;
        this.wordsintitle = 0;
        this.termFrequency = 0.0;
        this.local = true;
    }

    public WordReferenceVars clone() {
        WordReferenceVars c = new WordReferenceVars(this.urlHash, this.urllength, this.urlcomps, this.wordsintitle, this.hitcount, this.wordsintext, this.phrasesintext, this.posintext, this.positions, this.posinphrase, this.posofphrase, this.lastModified, this.language, this.type, this.llocal, this.lother, this.flags, this.termFrequency);
        return c;
    }

    @Override
    public Bitfield flags() {
        return this.flags;
    }

    @Override
    public byte[] getLanguage() {
        return ASCII.getBytes(this.language);
    }

    public String getLanguageString() {
        return this.language;
    }

    @Override
    public char getType() {
        return this.type;
    }

    @Override
    public int hitcount() {
        return this.hitcount;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public int llocal() {
        return this.llocal;
    }

    @Override
    public int lother() {
        return this.lother;
    }

    @Override
    public int phrasesintext() {
        return this.phrasesintext;
    }

    @Override
    public int posinphrase() {
        return this.posinphrase;
    }

    @Override
    public int posintext() {
        return this.posintext;
    }

    @Override
    public Collection<Integer> positions() {
        return this.positions;
    }

    @Override
    public int distance() {
        int value = super.distance();
        if (value == 0) {
            value = this.distance;
        }
        return value;
    }

    @Override
    public int posofphrase() {
        return this.posofphrase;
    }

    private WordReferenceRow toRowEntry() {
        return new WordReferenceRow(this.urlHash, this.urllength, this.urlcomps, this.wordsintitle, this.hitcount, this.wordsintext, this.phrasesintext, this.posintext, this.posinphrase, this.posofphrase, this.lastModified, System.currentTimeMillis(), ASCII.getBytes(this.language), this.type, this.llocal, this.lother, this.distance(), this.flags);
    }

    @Override
    public Row.Entry toKelondroEntry() {
        return this.toRowEntry().toKelondroEntry();
    }

    @Override
    public String toPropertyForm() {
        return this.toRowEntry().toPropertyForm();
    }

    @Override
    public byte[] urlhash() {
        return this.urlHash;
    }

    @Override
    public String hosthash() {
        if (this.hostHash != null) {
            return this.hostHash;
        }
        this.hostHash = ASCII.String(this.urlHash, 6, 6);
        return this.hostHash;
    }

    @Override
    public int urlcomps() {
        return this.urlcomps;
    }

    @Override
    public int urllength() {
        return this.urllength;
    }

    @Override
    public int virtualAge() {
        if (this.virtualAge > 0) {
            return this.virtualAge;
        }
        this.virtualAge = MicroDate.microDateDays(this.lastModified);
        return this.virtualAge;
    }

    @Override
    public int wordsintext() {
        return this.wordsintext;
    }

    @Override
    public int wordsintitle() {
        return this.wordsintitle;
    }

    @Override
    public double termFrequency() {
        if (this.termFrequency == 0.0) {
            this.termFrequency = (double)this.hitcount() / (double)(this.wordsintext() + this.wordsintitle() + 1);
        }
        return this.termFrequency;
    }

    public boolean local() {
        return this.local;
    }

    public final void min(WordReferenceVars other) {
        double d;
        long w;
        if (other == null) {
            return;
        }
        int v = other.hitcount;
        if (this.hitcount > v) {
            this.hitcount = v;
        }
        if (this.llocal > (v = other.llocal)) {
            this.llocal = v;
        }
        if (this.lother > (v = other.lother)) {
            this.lother = v;
        }
        v = other.virtualAge();
        if (this.virtualAge() > v) {
            this.virtualAge = v;
        }
        if (this.wordsintext > (v = other.wordsintext)) {
            this.wordsintext = v;
        }
        if (this.phrasesintext > (v = other.phrasesintext)) {
            this.phrasesintext = v;
        }
        if (this.posintext > (v = other.posintext)) {
            this.posintext = v;
        }
        if (this.distance() > 0 || other.distance() > 0) {
            int odist = other.distance();
            int dist = this.distance();
            if (odist > 0 && odist < dist) {
                if (this.positions == null) {
                    this.positions = new LinkedBlockingQueue<Integer>();
                } else {
                    this.positions.clear();
                }
                this.positions.add(this.posintext + odist);
            }
        }
        if (this.posinphrase > (v = other.posinphrase)) {
            this.posinphrase = v;
        }
        if (this.posofphrase > (v = other.posofphrase)) {
            this.posofphrase = v;
        }
        if (this.lastModified > (w = other.lastModified)) {
            this.lastModified = w;
        }
        if (this.urllength > (v = other.urllength)) {
            this.urllength = v;
        }
        if (this.urlcomps > (v = other.urlcomps)) {
            this.urlcomps = v;
        }
        if (this.wordsintitle > (v = other.wordsintitle)) {
            this.wordsintitle = v;
        }
        double d2 = other.termFrequency;
        if (this.termFrequency > d) {
            this.termFrequency = d2;
        }
    }

    public final void max(WordReferenceVars other) {
        double d;
        long w;
        if (other == null) {
            return;
        }
        int v = other.hitcount;
        if (this.hitcount < v) {
            this.hitcount = v;
        }
        if (this.llocal < (v = other.llocal)) {
            this.llocal = v;
        }
        if (this.lother < (v = other.lother)) {
            this.lother = v;
        }
        v = other.virtualAge();
        if (this.virtualAge() < v) {
            this.virtualAge = v;
        }
        if (this.wordsintext < (v = other.wordsintext)) {
            this.wordsintext = v;
        }
        if (this.phrasesintext < (v = other.phrasesintext)) {
            this.phrasesintext = v;
        }
        if (this.posintext < (v = other.posintext)) {
            this.posintext = v;
        }
        if (this.distance() > 0 || other.distance() > 0) {
            int odist = other.distance();
            int dist = this.distance();
            if (odist > 0 && odist > dist) {
                if (this.positions == null) {
                    this.positions = new LinkedBlockingQueue<Integer>();
                } else {
                    this.positions.clear();
                }
                this.positions.add(this.posintext + odist);
            }
        }
        if (this.posinphrase < (v = other.posinphrase)) {
            this.posinphrase = v;
        }
        if (this.posofphrase < (v = other.posofphrase)) {
            this.posofphrase = v;
        }
        if (this.lastModified < (w = other.lastModified)) {
            this.lastModified = w;
        }
        if (this.urllength < (v = other.urllength)) {
            this.urllength = v;
        }
        if (this.urlcomps < (v = other.urlcomps)) {
            this.urlcomps = v;
        }
        if (this.wordsintitle < (v = other.wordsintitle)) {
            this.wordsintitle = v;
        }
        double d2 = other.termFrequency;
        if (this.termFrequency < d) {
            this.termFrequency = d2;
        }
    }

    @Override
    public void join(Reference r) {
        WordReference oe = (WordReference)r;
        if (this.posintext > 0 && oe.posintext() > 0) {
            if (this.posintext > oe.posintext()) {
                this.addPosition(this.posintext);
                this.posintext = oe.posintext();
            } else {
                this.addPosition(oe.posintext());
            }
        } else if (this.posintext == 0) {
            this.posintext = oe.posintext();
        }
        int oePosofphrase = oe.posofphrase();
        if (this.posofphrase == oePosofphrase) {
            this.posinphrase = Math.min(this.posinphrase, oe.posinphrase());
        } else if (this.posofphrase > oePosofphrase) {
            this.posofphrase = oePosofphrase;
            this.posinphrase = oe.posinphrase();
        }
        this.termFrequency += oe.termFrequency();
        this.wordsintext = Math.max(this.wordsintext, oe.wordsintext());
        this.wordsintitle = Math.max(this.wordsintitle, oe.wordsintitle());
        this.phrasesintext = Math.max(this.phrasesintext, oe.phrasesintext());
        this.hitcount = Math.max(this.hitcount, oe.hitcount());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordReferenceVars)) {
            return false;
        }
        WordReferenceVars other = (WordReferenceVars)obj;
        return Base64Order.enhancedCoder.equal(this.urlHash, other.urlHash);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            this.hashCache = ByteArray.hashCode(this.urlHash);
        }
        return this.hashCache;
    }

    @Override
    public int compareTo(WordReferenceVars o) {
        return Base64Order.enhancedCoder.compare(this.urlHash, o.urlhash());
    }

    @Override
    public int compare(WordReferenceVars o1, WordReferenceVars o2) {
        return o1.compareTo(o2);
    }

    public void addPosition(int position) {
        if (this.positions == null && position > 0) {
            this.positions = new LinkedBlockingQueue<Integer>();
        }
        if (position > 0) {
            this.positions.add(position);
        }
    }

    public static BlockingQueue<WordReferenceVars> transform(ReferenceContainer<WordReference> container, long maxtime, boolean local) {
        LinkedBlockingQueue<WordReferenceVars> vars = new LinkedBlockingQueue<WordReferenceVars>();
        if (container.size() <= 100) {
            for (Row.Entry entry2 : container) {
                try {
                    vars.put(new WordReferenceVars(new WordReferenceRow(entry2), local));
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                vars.put(poison);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return vars;
        }
        TransformDistributor distributor = new TransformDistributor(container, vars, maxtime, local);
        distributor.start();
        return vars;
    }

    private static class TransformDistributor
    extends Thread {
        private ReferenceContainer<WordReference> container;
        private BlockingQueue<WordReferenceVars> out;
        private long maxtime;
        private final boolean local;

        private TransformDistributor(ReferenceContainer<WordReference> container, BlockingQueue<WordReferenceVars> out, long maxtime, boolean local) {
            super("WordReferenceVars.TransformDistributor");
            this.container = container;
            this.out = out;
            this.maxtime = maxtime;
            this.local = local;
        }

        @Override
        public void run() {
            int i;
            int cores0 = Math.min(WorkflowProcessor.availableCPU, this.container.size() / 100) + 1;
            TransformWorker[] worker = new TransformWorker[cores0];
            for (int i2 = 0; i2 < cores0; ++i2) {
                worker[i2] = new TransformWorker(this.out, this.maxtime, this.local);
                worker[i2].start();
            }
            long timeout = this.maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + this.maxtime;
            int p = this.container.size();
            while (p > 0) {
                worker[--p % cores0].add(this.container.get(p, false));
                if (p % 100 != 0 || System.currentTimeMillis() <= timeout) continue;
                ConcurrentLog.warn("TransformDistributor", "distribution of WordReference entries to worker queues ended with timeout = " + this.maxtime);
                break;
            }
            for (i = 0; i < cores0; ++i) {
                worker[i].add(WordReferenceRow.poisonRowEntry);
            }
            for (i = 0; i < cores0; ++i) {
                try {
                    worker[i].join();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.out.add(poison);
        }
    }

    private static class TransformWorker
    extends Thread {
        private BlockingQueue<Row.Entry> in = new LinkedBlockingQueue<Row.Entry>();
        private BlockingQueue<WordReferenceVars> out;
        private long maxtime;
        private final boolean local;

        private TransformWorker(BlockingQueue<WordReferenceVars> out, long maxtime, boolean local) {
            super("WordReferenceVars.TransformWorker");
            this.out = out;
            this.maxtime = maxtime;
            this.local = local;
        }

        private void add(Row.Entry entry2) {
            try {
                this.in.put(entry2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            long timeout = this.maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + this.maxtime;
            try {
                Row.Entry entry2;
                while ((entry2 = this.in.take()) != WordReferenceRow.poisonRowEntry) {
                    this.out.put(new WordReferenceVars(new WordReferenceRow(entry2), this.local));
                    if (System.currentTimeMillis() <= timeout) continue;
                    ConcurrentLog.warn("TransformWorker", "normalization of row entries from row to vars ended with timeout = " + this.maxtime);
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

