/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.word;

import java.util.Collection;
import java.util.Locale;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.ConcurrentARC;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.MemoryControl;

public class Word {
    public static final int commonHashLength = 12;
    public static final Base64Order commonHashOrder = Base64Order.enhancedCoder;
    private static final int hashCacheSize = Math.max(20000, Math.min(200000, (int)(MemoryControl.available() / 40000L)));
    private static ARC<String, byte[]> hashCache = null;
    public int count = 1;
    public int posInText;
    public int posInPhrase;
    public int numOfPhrase;
    public Bitfield flags;
    private static final byte lowByte;
    private static final byte highByte;
    public static final byte PRIVATE_TYPE_COPY = 67;
    public static final byte PRIVATE_TYPE_PHONETIC = 75;

    public Word(int handle, int pip, int nop) {
        this.posInText = handle;
        this.posInPhrase = pip;
        this.numOfPhrase = nop;
        this.flags = null;
    }

    public static void clearCache() {
        hashCache.clear();
    }

    public void inc() {
        ++this.count;
    }

    public int occurrences() {
        return this.count;
    }

    public String toString() {
        return "{count=" + this.count + ", posInText=" + this.posInText + ", posInPhrase=" + this.posInPhrase + ", numOfPhrase=" + this.numOfPhrase + "}";
    }

    public static byte[] word2hash(StringBuilder word) {
        return Word.word2hash(word.toString());
    }

    public static boolean isPrivate(byte[] hash) {
        return hash[0] == highByte && hash[1] == highByte && hash[2] == highByte && hash[3] == highByte && hash[4] == highByte;
    }

    public static final byte[] word2hash(String word) {
        String wordlc = word.toLowerCase(Locale.ENGLISH);
        byte[] h = hashCache.get(wordlc);
        if (h != null) {
            return h;
        }
        h = commonHashOrder.encodeSubstring(Digest.encodeMD5Raw(wordlc), 12);
        while (h[0] == highByte && h[1] == highByte && h[2] == highByte && h[3] == highByte && h[4] == highByte) {
            System.arraycopy(h, 1, h, 0, 11);
            h[11] = lowByte;
        }
        assert (h[2] != 64);
        if (MemoryControl.shortStatus()) {
            hashCache.clear();
        } else {
            hashCache.insertIfAbsent(wordlc, h);
        }
        return h;
    }

    public static final byte[] hash2private(byte[] hash, byte privateType) {
        byte[] p = new byte[12];
        p[0] = highByte;
        p[1] = highByte;
        p[2] = highByte;
        p[3] = highByte;
        p[4] = highByte;
        p[5] = privateType;
        System.arraycopy(hash, 0, p, 6, 6);
        return p;
    }

    public static final HandleSet words2hashesHandles(Collection<String> words) {
        RowHandleSet hashes = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, words.size());
        for (String word : words) {
            try {
                hashes.put(Word.word2hash(word));
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
                return hashes;
            }
        }
        hashes.optimize();
        return hashes;
    }

    public static final HandleSet words2hashesHandles(String[] words) {
        RowHandleSet hashes = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, words.length);
        for (String word : words) {
            try {
                hashes.put(Word.word2hash(word));
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
                return hashes;
            }
        }
        hashes.optimize();
        return hashes;
    }

    static {
        try {
            hashCache = new ConcurrentARC<String, byte[]>(hashCacheSize, Math.min(32, 2 * Runtime.getRuntime().availableProcessors()));
            ConcurrentLog.info("Word", "hashCache.size = " + hashCacheSize);
        }
        catch (OutOfMemoryError e) {
            hashCache = new ConcurrentARC<String, byte[]>(1000, Math.min(8, 1 + Runtime.getRuntime().availableProcessors()));
            ConcurrentLog.info("Word", "hashCache.size = 1000");
        }
        lowByte = Base64Order.alpha_enhanced[0];
        highByte = Base64Order.alpha_enhanced[Base64Order.alpha_enhanced.length - 1];
    }
}

