/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.ConcurrentARC;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.BLOB;
import net.yacy.kelondro.blob.Heap;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.RotateIterator;

public class MapHeap
implements Map<byte[], Map<String, String>> {
    private final BLOB blob;
    private final ARC<byte[], Map<String, String>> cache;
    private final char fillchar;
    public static final byte[] POISON_QUEUE_ENTRY = "POISON".getBytes();

    public MapHeap(File heapFile, int keylength, ByteOrder ordering, int buffermax, int cachesize, char fillchar) throws IOException {
        this.blob = new Heap(heapFile, keylength, ordering, buffermax);
        this.cache = new ConcurrentARC<byte[], Map<String, String>>(cachesize, Math.min(32, 2 * Runtime.getRuntime().availableProcessors()), ordering);
        this.fillchar = fillchar;
    }

    public int keylength() {
        return this.blob.keylength();
    }

    public ByteOrder ordering() {
        return this.blob.ordering();
    }

    @Override
    public synchronized void clear() {
        try {
            this.blob.clear();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        this.cache.clear();
    }

    private static String map2string(Map<String, String> map, String comment) {
        StringBuilder bb = new StringBuilder(map.size() * 40);
        bb.append("# ").append(comment).append('\r').append('\n');
        for (Map.Entry<String, String> entry2 : map.entrySet()) {
            if (entry2.getValue() == null) continue;
            bb.append(entry2.getKey());
            bb.append('=');
            bb.append(entry2.getValue());
            bb.append('\r').append('\n');
        }
        bb.append("# EOF\r\n");
        return bb.toString();
    }

    private static Map<String, String> bytes2map(byte[] b) throws IOException, SpaceExceededException {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(b)));){
            String line;
            while ((line = br.readLine()) != null) {
                int pos;
                if ((line = line.trim()).equals("# EOF")) {
                    ConcurrentHashMap<String, String> concurrentHashMap = map;
                    return concurrentHashMap;
                }
                if (line.isEmpty() || line.charAt(0) == '#' || (pos = line.indexOf(61)) < 0) continue;
                map.put(line.substring(0, pos), line.substring(pos + 1));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(byte[] key, Map<String, String> newMap) throws IOException, SpaceExceededException {
        String formattedTime;
        assert (key != null);
        assert (key.length > 0);
        assert (newMap != null);
        key = this.normalizeKey(key);
        try {
            formattedTime = GenericFormatter.FORMAT_SHORT_SECOND.format(Instant.now());
        }
        catch (DateTimeException e) {
            formattedTime = GenericFormatter.SHORT_SECOND_FORMATTER.format();
        }
        String s = MapHeap.map2string(newMap, "W" + formattedTime + " ");
        assert (s != null);
        byte[] sb = UTF8.getBytes(s);
        if (this.cache == null) {
            if (this.blob != null) {
                this.blob.insert(key, sb);
            }
        } else {
            MapHeap mapHeap = this;
            synchronized (mapHeap) {
                if (this.blob != null) {
                    this.blob.insert(key, sb);
                }
                if (MemoryControl.shortStatus()) {
                    this.cache.clear();
                } else {
                    this.cache.insert(key, newMap);
                }
            }
        }
    }

    @Override
    public Map<String, String> put(byte[] key, Map<String, String> newMap) {
        Map<String, String> v = null;
        try {
            v = this.get(key);
            this.insert(key, newMap);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] key) throws IOException {
        if (key == null) {
            return;
        }
        key = this.normalizeKey(key);
        MapHeap mapHeap = this;
        synchronized (mapHeap) {
            if (this.cache != null) {
                this.cache.remove(key);
            }
            if (this.blob != null) {
                this.blob.delete(key);
            }
        }
    }

    @Override
    public Map<String, String> remove(Object key) {
        Object v = null;
        try {
            v = this.get(key);
            this.delete((byte[])key);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object k) {
        boolean h;
        if (!(k instanceof byte[])) {
            return false;
        }
        assert (k != null);
        if (this.cache == null) {
            return false;
        }
        byte[] key = this.normalizeKey((byte[])k);
        MapHeap mapHeap = this;
        synchronized (mapHeap) {
            h = this.cache.containsKey(key) || this.blob.containsKey(key);
        }
        return h;
    }

    public Map<String, String> get(byte[] key) throws IOException, SpaceExceededException {
        if (key == null) {
            return null;
        }
        return this.get(key, true);
    }

    @Override
    public Map<String, String> get(Object key) {
        if (key == null) {
            return null;
        }
        try {
            if (key instanceof byte[]) {
                return this.get((byte[])key);
            }
            if (key instanceof String) {
                return this.get(UTF8.getBytes((String)key));
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return null;
    }

    private byte[] normalizeKey(byte[] key) {
        if (this.blob == null || key == null) {
            return key;
        }
        if (key.length > this.blob.keylength()) {
            byte[] b = new byte[this.blob.keylength()];
            System.arraycopy(key, 0, b, 0, this.blob.keylength());
            return b;
        }
        if (key.length < this.blob.keylength()) {
            byte[] b = new byte[this.blob.keylength()];
            System.arraycopy(key, 0, b, 0, key.length);
            for (int i = key.length; i < b.length; ++i) {
                b[i] = (byte)this.fillchar;
            }
            return b;
        }
        return key;
    }

    private byte[] removeFillchar(byte[] key) {
        int p;
        if (key == null) {
            return key;
        }
        for (p = key.length - 1; p >= 0 && key[p] == this.fillchar; --p) {
        }
        if (p == key.length - 1) {
            return key;
        }
        byte[] k = new byte[p + 1];
        System.arraycopy(key, 0, k, 0, k.length);
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> get(byte[] key, boolean storeCache) throws IOException, SpaceExceededException {
        Map<String, String> map;
        assert (key != null);
        if (this.cache == null) {
            return null;
        }
        key = this.normalizeKey(key);
        if (MemoryControl.shortStatus()) {
            this.cache.clear();
        }
        if ((map = this.cache.get(key)) != null) {
            return map;
        }
        if (storeCache) {
            MapHeap mapHeap = this;
            synchronized (mapHeap) {
                map = this.cache.get(key);
                if (map != null) {
                    return map;
                }
                byte[] b2 = this.blob.get(key);
                if (b2 == null) {
                    return null;
                }
                try {
                    map = MapHeap.bytes2map(b2);
                }
                catch (SpaceExceededException e) {
                    throw new IOException(e.getMessage());
                }
                this.cache.insert(key, map);
                return map;
            }
        }
        byte[] b = null;
        MapHeap b2 = this;
        synchronized (b2) {
            map = this.cache.get(key);
            if (map != null) {
                return map;
            }
            b = this.blob.get(key);
        }
        if (b == null) {
            return null;
        }
        try {
            return MapHeap.bytes2map(b);
        }
        catch (SpaceExceededException e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized CloneableIterator<byte[]> keys(boolean up, boolean rotating) throws IOException {
        return new KeyIterator(up, rotating, null, null);
    }

    public synchronized CloneableIterator<byte[]> keys(boolean up, boolean rotating, byte[] firstKey, byte[] secondKey) throws IOException {
        return new KeyIterator(up, rotating, firstKey, secondKey);
    }

    public synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        return this.blob.keys(up, firstKey);
    }

    public synchronized Iterator<Map.Entry<byte[], Map<String, String>>> entries(boolean up, boolean rotating) throws IOException {
        return new FullMapIterator(this.keys(up, rotating));
    }

    public synchronized Iterator<Map.Entry<byte[], Map<String, String>>> entries(boolean up, boolean rotating, byte[] firstKey, byte[] secondKey) throws IOException {
        return new FullMapIterator(this.keys(up, rotating, firstKey, secondKey));
    }

    @Override
    public int size() {
        return this.blob == null ? 0 : this.blob.size();
    }

    @Override
    public boolean isEmpty() {
        return this.blob == null ? true : this.blob.isEmpty();
    }

    public synchronized void close() {
        this.cache.clear();
        if (this.blob != null) {
            this.blob.close(true);
        }
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends Map<String, String>> map) {
        for (Map.Entry<? extends byte[], ? extends Map<String, String>> me : map.entrySet()) {
            try {
                this.insert(me.getKey(), me.getValue());
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    @Override
    public Set<byte[]> keySet() {
        TreeSet<byte[]> set = new TreeSet<byte[]>(this.blob.ordering());
        try {
            CloneableIterator<byte[]> i = this.blob.keys(true, false);
            while (i.hasNext()) {
                set.add((byte[])i.next());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return set;
    }

    public BlockingQueue<byte[]> keyQueue(int size) {
        final ArrayBlockingQueue<byte[]> set = new ArrayBlockingQueue<byte[]>(size);
        new Thread("MapHeap.keyQueue:" + size){

            @Override
            public void run() {
                try {
                    CloneableIterator<byte[]> i = MapHeap.this.blob.keys(true, false);
                    while (i.hasNext()) {
                        try {
                            set.put((byte[])i.next());
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    set.put(POISON_QUEUE_ENTRY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        return set;
    }

    @Override
    public Collection<Map<String, String>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<byte[], Map<String, String>>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        File f = new File("maptest");
        if (f.exists()) {
            FileUtils.deletedelete(f);
        }
        try {
            MapHeap map = new MapHeap(f, 12, NaturalOrder.naturalOrder, 0x100000, 1024, '_');
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("k", "000");
            map.insert("123".getBytes(), m);
            m.put("k", "111");
            map.insert("456".getBytes(), m);
            m.put("k", "222");
            map.insert("789".getBytes(), m);
            CloneableIterator<byte[]> i = map.keys(true, false);
            while (i.hasNext()) {
                System.out.println("key: " + UTF8.String((byte[])i.next()));
            }
            map.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
    }

    public class KeyIterator
    implements CloneableIterator<byte[]>,
    Iterator<byte[]> {
        private final boolean up;
        private final boolean rotating;
        private final byte[] firstKey;
        private final byte[] secondKey;
        private Iterator<byte[]> iterator;
        private final CloneableIterator<byte[]> blobkeys;

        public KeyIterator(boolean up, boolean rotating, byte[] firstKey, byte[] secondKey) throws IOException {
            this.up = up;
            this.rotating = rotating;
            this.firstKey = firstKey;
            this.secondKey = secondKey;
            this.blobkeys = MapHeap.this.blob.keys(up, firstKey);
            this.iterator = rotating ? new RotateIterator<byte[]>(this.blobkeys, secondKey, MapHeap.this.blob.size()) : this.blobkeys;
        }

        @Override
        public byte[] next() {
            assert (this.iterator != null);
            if (this.iterator == null) {
                return null;
            }
            return MapHeap.this.removeFillchar(this.iterator.next());
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public CloneableIterator<byte[]> clone(Object modifier) {
            try {
                return new KeyIterator(this.up, this.rotating, this.firstKey, this.secondKey);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public void close() {
            this.blobkeys.close();
        }
    }

    protected class FullMapIterator
    extends LookAheadIterator<Map.Entry<byte[], Map<String, String>>>
    implements Iterator<Map.Entry<byte[], Map<String, String>>> {
        private final Iterator<byte[]> keyIterator;

        FullMapIterator(Iterator<byte[]> keyIterator2) {
            this.keyIterator = keyIterator2;
        }

        @Override
        public Map.Entry<byte[], Map<String, String>> next0() {
            if (this.keyIterator == null) {
                return null;
            }
            while (this.keyIterator.hasNext()) {
                Map<String, String> map;
                byte[] nextKey = this.keyIterator.next();
                try {
                    map = MapHeap.this.get(nextKey, false);
                }
                catch (IOException e) {
                    ConcurrentLog.warn("MapDataMining", e.getMessage());
                    continue;
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                    continue;
                }
                if (map == null) continue;
                AbstractMap.SimpleImmutableEntry<byte[], Map<String, String>> entry2 = new AbstractMap.SimpleImmutableEntry<byte[], Map<String, String>>(nextKey, map);
                return entry2;
            }
            return null;
        }
    }
}

