/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.storage.HandleMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Gap;
import net.yacy.kelondro.blob.HeapReader;
import net.yacy.kelondro.index.RowHandleMap;
import net.yacy.kelondro.util.FileUtils;

public final class HeapWriter {
    private static final ConcurrentLog log = new ConcurrentLog("HeapWriter");
    public static final byte[] ZERO = new byte[]{0};
    private final int keylength;
    private HandleMap index;
    private final File heapFileTMP;
    private final File heapFileREADY;
    private DataOutputStream os;
    private long seek;

    public HeapWriter(File temporaryHeapFile, File readyHeapFile, int keylength, ByteOrder ordering, int outBuffer) throws IOException {
        this.heapFileTMP = temporaryHeapFile;
        this.heapFileREADY = readyHeapFile;
        this.keylength = keylength;
        this.index = new RowHandleMap(keylength, ordering, 8, 100000, readyHeapFile.getAbsolutePath());
        FileOutputStream fileStream = new FileOutputStream(temporaryHeapFile);
        try {
            try {
                this.os = new DataOutputStream(new BufferedOutputStream(fileStream, outBuffer));
            }
            catch (OutOfMemoryError e) {
                this.os = new DataOutputStream(fileStream);
            }
        }
        catch (Exception e) {
            try {
                fileStream.close();
            }
            catch (IOException ignored) {
                log.warn("Could not close output stream on file " + temporaryHeapFile);
            }
            throw e;
        }
        this.seek = 0L;
    }

    public synchronized void add(byte[] key, byte[] blob) throws IOException, SpaceExceededException {
        assert (blob.length > 0);
        key = HeapReader.normalizeKey(key, this.keylength);
        assert (key.length == this.keylength) : "key.length == " + key.length + ", this.keylength = " + this.keylength;
        assert (this.index.get(key) < 0L) : "index.get(key) = " + this.index.get(key) + ", index.size() = " + this.index.size() + ", file.length() = " + this.heapFileTMP.length() + ", key = " + UTF8.String(key);
        if (blob == null || blob.length == 0) {
            return;
        }
        this.index.putUnique(key, this.seek);
        int chunkl = this.keylength + blob.length;
        this.os.writeInt(chunkl);
        this.os.write(key);
        this.os.write(blob);
        this.seek += (long)(chunkl + 4);
    }

    public synchronized void close(boolean writeIDX) throws IOException {
        boolean renameok;
        try {
            this.os.flush();
        }
        catch (Exception e) {
            this.index.close();
            this.index = null;
            throw e;
        }
        finally {
            this.os.close();
        }
        this.os = null;
        if (this.heapFileREADY.exists()) {
            FileUtils.deletedelete(this.heapFileREADY);
        }
        if (!(renameok = this.heapFileTMP.renameTo(this.heapFileREADY))) {
            throw new IOException("cannot rename " + this.heapFileTMP + " to " + this.heapFileREADY);
        }
        if (!this.heapFileREADY.exists()) {
            throw new IOException("renaming of " + this.heapFileREADY.toString() + " failed: files still exists");
        }
        if (this.heapFileTMP.exists()) {
            throw new IOException("renaming to " + this.heapFileTMP.toString() + " failed: file does not exist");
        }
        if (writeIDX && this.index.size() > 3) {
            long start = System.currentTimeMillis();
            String fingerprint = HeapReader.fingerprintFileHash(this.heapFileREADY);
            if (fingerprint == null) {
                log.severe("cannot write a dump for " + this.heapFileREADY.getName() + ": fingerprint is null");
            } else {
                new Gap().dump(HeapWriter.fingerprintGapFile(this.heapFileREADY, fingerprint));
                this.index.dump(HeapWriter.fingerprintIndexFile(this.heapFileREADY, fingerprint));
                log.info("wrote a dump for the " + this.index.size() + " index entries of " + this.heapFileREADY.getName() + " in " + (System.currentTimeMillis() - start) + " milliseconds.");
            }
            this.index.close();
            this.index = null;
        } else {
            this.index.close();
            this.index = null;
        }
    }

    public static void delete(File f) {
        File p = f.getParentFile();
        String n = f.getName() + ".";
        String[] l = p.list();
        FileUtils.deletedelete(f);
        for (String s : l) {
            if (!s.startsWith(n) || !s.endsWith(".idx") && !s.endsWith(".gap")) continue;
            FileUtils.deletedelete(new File(p, s));
        }
    }

    protected static File fingerprintIndexFile(File f, String fingerprint) {
        assert (f != null);
        return new File(f.getParentFile(), f.getName() + "." + fingerprint + ".idx");
    }

    protected static File fingerprintGapFile(File f, String fingerprint) {
        assert (f != null);
        return new File(f.getParentFile(), f.getName() + "." + fingerprint + ".gap");
    }
}

