/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.Digest;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.storage.MapStore;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Heap;
import net.yacy.kelondro.blob.HeapReader;
import net.yacy.kelondro.util.BDecoder;
import net.yacy.kelondro.util.BEncoder;
import net.yacy.kelondro.util.FileUtils;

public class BEncodedHeap
implements MapStore {
    private Heap table;
    private final LinkedHashSet<String> columnames;

    public BEncodedHeap(File location, int keylength, ByteOrder ordering, int buffermax) throws IOException {
        this.table = new Heap(location, keylength, ordering, buffermax);
        this.columnames = new LinkedHashSet();
    }

    public BEncodedHeap(File location, int keylength) throws IOException {
        this.table = new Heap(location, keylength, NaturalOrder.naturalOrder, 100);
        this.columnames = new LinkedHashSet();
    }

    @Override
    public ByteOrder getOrdering() {
        return this.table.ordering;
    }

    @Override
    public CloneableIterator<byte[]> keyIterator() {
        try {
            return this.table.keys(true, false);
        }
        catch (IOException e) {
            ConcurrentLog.severe("BEncodedHeap", "returning empty iterator for failed key iteration: " + e.getMessage(), e);
            return new CloneableIterator<byte[]>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public byte[] next() {
                    return null;
                }

                @Override
                public void remove() {
                }

                @Override
                public CloneableIterator<byte[]> clone(Object modifier) {
                    return this;
                }

                @Override
                public void close() {
                }
            };
        }
    }

    public byte[] encodedKey(String key) {
        return Base64Order.enhancedCoder.encodeSubstring(Digest.encodeMD5Raw(key), this.table.keylength);
    }

    private static Map<String, byte[]> b2m(byte[] b) {
        if (b == null) {
            return null;
        }
        BDecoder decoder = new BDecoder(b);
        BDecoder.BObject bobj = decoder.parse();
        if (bobj == null || bobj.getType() != BDecoder.BType.dictionary) {
            return null;
        }
        Map<String, BDecoder.BObject> map = bobj.getMap();
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        for (Map.Entry<String, BDecoder.BObject> entry2 : map.entrySet()) {
            BDecoder.BObject ev = entry2.getValue();
            if (ev == null || ev.getType() != BDecoder.BType.string) continue;
            m.put(entry2.getKey(), ev.getString());
        }
        return m;
    }

    public File getFile() {
        return this.table.heapFile;
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    private boolean containsKey(byte[] pk) {
        return this.table.containsKey(pk);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof byte[]) {
            return this.containsKey((byte[])key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Map<String, byte[]> get(byte[] pk) throws IOException, SpaceExceededException {
        byte[] b = this.table.get(pk);
        if (b == null) {
            return null;
        }
        return BEncodedHeap.b2m(b);
    }

    @Override
    public Map<String, byte[]> get(Object key) {
        if (key instanceof byte[]) {
            try {
                return this.get((byte[])key);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return null;
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }
        return null;
    }

    public byte[] getProp(byte[] pk, String key) throws IOException, SpaceExceededException {
        byte[] b = this.table.get(pk);
        if (b == null) {
            return null;
        }
        Map<String, byte[]> map = BEncodedHeap.b2m(b);
        return map.get(key);
    }

    public Set<byte[]> select(String columnName, Pattern columnMatcher) {
        Iterator<Map.Entry<byte[], Map<String, byte[]>>> i = this.iterator();
        TreeSet<byte[]> pks = new TreeSet<byte[]>(this.table.ordering);
        while (i.hasNext()) {
            Map.Entry<byte[], Map<String, byte[]>> row = i.next();
            Map<String, byte[]> prop = row.getValue();
            byte[] val = prop.get(columnName);
            if (val == null || !columnMatcher.matcher(UTF8.String(val)).matches()) continue;
            pks.add(row.getKey());
        }
        return pks;
    }

    public Map.Entry<byte[], Map<String, byte[]>> selectOne(String columnName, Pattern columnMatcher) {
        for (Map.Entry<byte[], Map<String, byte[]>> row : this) {
            Map<String, byte[]> prop = row.getValue();
            byte[] val = prop.get(columnName);
            if (val == null || !columnMatcher.matcher(UTF8.String(val)).matches()) continue;
            return row;
        }
        return null;
    }

    public void insert(byte[] pk, Map<String, byte[]> map) throws SpaceExceededException, IOException {
        byte[] b = BEncoder.encode(BEncoder.transcode(map));
        this.table.insert(pk, b);
        this.columnames.addAll(map.keySet());
    }

    public void insert(byte[] pk, String key, byte[] value) throws IOException {
        byte[] b = BEncoder.encodeMap(key, value);
        this.table.insert(pk, b);
        this.columnames.add(key);
    }

    public void update(byte[] pk, Map<String, byte[]> map) throws SpaceExceededException, IOException {
        Map<String, byte[]> entry2 = this.get(pk);
        if (entry2 == null) {
            this.insert(pk, map);
        } else {
            entry2.putAll(map);
            this.insert(pk, entry2);
        }
    }

    public void update(byte[] pk, String key, byte[] value) throws SpaceExceededException, IOException {
        Map<String, byte[]> entry2 = this.get(pk);
        if (entry2 == null) {
            entry2 = new HashMap<String, byte[]>();
            entry2.put(key, value);
            this.insert(pk, entry2);
        } else {
            entry2.put(key, value);
            this.insert(pk, entry2);
        }
    }

    @Override
    public Map<String, byte[]> put(byte[] pk, Map<String, byte[]> map) {
        try {
            Map<String, byte[]> entry2 = this.get(pk);
            byte[] b = BEncoder.encode(BEncoder.transcode(map));
            this.table.insert(pk, b);
            this.columnames.addAll(map.keySet());
            return entry2;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public void delete(byte[] pk) throws IOException {
        this.table.delete(pk);
    }

    public Map<String, byte[]> remove(byte[] key) throws IOException, SpaceExceededException {
        Map<String, byte[]> value = this.get(key);
        this.delete(key);
        return value;
    }

    @Override
    public Map<String, byte[]> remove(Object key) {
        if (key instanceof byte[]) {
            try {
                return this.remove((byte[])key);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return null;
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends Map<String, byte[]>> map) {
        for (Map.Entry<? extends byte[], ? extends Map<String, byte[]>> me : map.entrySet()) {
            try {
                this.insert(me.getKey(), me.getValue());
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    @Override
    public void clear() {
        try {
            this.table.clear();
            this.columnames.clear();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    @Override
    public synchronized void close() {
        int s = this.size();
        File f = this.table.heapFile;
        this.table.close();
        if (s == 0) {
            f.delete();
        }
    }

    @Override
    public Set<byte[]> keySet() {
        TreeSet<byte[]> set = new TreeSet<byte[]>(this.table.ordering);
        try {
            CloneableIterator<byte[]> i = this.table.keys(true, false);
            while (i.hasNext()) {
                set.add((byte[])i.next());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return set;
    }

    public Iterator<byte[]> keys() throws IOException {
        return this.table.keys(true, false);
    }

    public Iterator<byte[]> keys(boolean up, boolean rotating) throws IOException {
        return this.table.keys(up, rotating);
    }

    @Override
    public Collection<Map<String, byte[]>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<byte[], Map<String, byte[]>>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<byte[], Map<String, byte[]>>> iterator() {
        File location = this.table.location();
        int keylen = this.table.keylength();
        try {
            this.table.flushBuffer();
            return new EntryIter(location, keylen);
        }
        catch (IOException e1) {
            ByteOrder order = this.table.ordering();
            int buffermax = this.table.getBuffermax();
            this.table.close();
            try {
                EntryIter iter = new EntryIter(location, keylen);
                this.table = new Heap(location, keylen, order, buffermax);
                return iter;
            }
            catch (IOException e) {
                ConcurrentLog.severe("PropertiesTable", e.getMessage(), e);
                return null;
            }
        }
    }

    public static Iterator<Map.Entry<byte[], Map<String, byte[]>>> iterator(File location, int keylen) throws IOException {
        return new EntryIter(location, keylen);
    }

    @Override
    public int hashCode() {
        return this.table.name().hashCode();
    }

    public ArrayList<String> columns() {
        if (this.columnames.isEmpty()) {
            for (Map.Entry<byte[], Map<String, byte[]>> row : this) {
                this.columnames.addAll(row.getValue().keySet());
            }
        }
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.columnames);
        return l;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            File f = new File(new File("maptest").getAbsolutePath());
            if (f.exists()) {
                FileUtils.deletedelete(f);
            }
            try {
                BEncodedHeap map = new BEncodedHeap(f, 4);
                HashMap<String, byte[]> m = new HashMap<String, byte[]>();
                m.put("k", "000".getBytes());
                map.insert("123".getBytes(), m);
                m.put("k", "111".getBytes());
                map.insert("456".getBytes(), m);
                m.put("k", "222".getBytes());
                map.insert("789".getBytes(), m);
                for (Map.Entry<byte[], Map<String, byte[]>> entry2 : map) {
                    System.out.println(ASCII.String(entry2.getKey()) + ": " + ASCII.String(entry2.getValue().values().iterator().next()));
                }
                map.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        } else {
            File f = new File(args[0]);
            try {
                BEncodedHeap map = new BEncodedHeap(f, 12);
                for (Map.Entry<byte[], Map<String, byte[]>> entry3 : map) {
                    System.out.println(ASCII.String(entry3.getKey()) + ": " + entry3.getValue());
                }
                map.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    private static class EntryIter
    implements Iterator<Map.Entry<byte[], Map<String, byte[]>>> {
        HeapReader.entries iter;

        public EntryIter(File location, int keylen) throws IOException {
            this.iter = new HeapReader.entries(location, keylen);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<byte[], Map<String, byte[]>> next() {
            Map.Entry entry2 = (Map.Entry)this.iter.next();
            Map<String, byte[]> map = BEncodedHeap.b2m((byte[])entry2.getValue());
            return new b2mEntry((byte[])entry2.getKey(), map);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class b2mEntry
    implements Map.Entry<byte[], Map<String, byte[]>> {
        private final byte[] s;
        private Map<String, byte[]> b;

        private b2mEntry(byte[] s, Map<String, byte[]> b) {
            this.s = s;
            this.b = b;
        }

        @Override
        public byte[] getKey() {
            return this.s;
        }

        @Override
        public Map<String, byte[]> getValue() {
            return this.b;
        }

        @Override
        public Map<String, byte[]> setValue(Map<String, byte[]> value) {
            Map<String, byte[]> b1 = this.b;
            this.b = value;
            return b1;
        }
    }
}

